/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an output field produced by a node during a flow execution.
 * </p>
 * <note>
 * <p>
 * Flow executions is in preview release for Amazon Bedrock and is subject to change.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NodeOutputField implements SdkPojo, Serializable, ToCopyableBuilder<NodeOutputField.Builder, NodeOutputField> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(NodeOutputField::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<NodeExecutionContent> CONTENT_FIELD = SdkField
            .<NodeExecutionContent> builder(MarshallingType.SDK_POJO).memberName("content")
            .getter(getter(NodeOutputField::content)).setter(setter(Builder::content)).constructor(NodeExecutionContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()).build();

    private static final SdkField<List<NodeOutputNext>> NEXT_FIELD = SdkField
            .<List<NodeOutputNext>> builder(MarshallingType.LIST)
            .memberName("next")
            .getter(getter(NodeOutputField::next))
            .setter(setter(Builder::next))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("next").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NodeOutputNext> builder(MarshallingType.SDK_POJO)
                                            .constructor(NodeOutputNext::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(NodeOutputField::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CONTENT_FIELD,
            NEXT_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final NodeExecutionContent content;

    private final List<NodeOutputNext> next;

    private final String type;

    private NodeOutputField(BuilderImpl builder) {
        this.name = builder.name;
        this.content = builder.content;
        this.next = builder.next;
        this.type = builder.type;
    }

    /**
     * <p>
     * The name of the output field as defined in the node's output schema.
     * </p>
     * 
     * @return The name of the output field as defined in the node's output schema.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The content of the output field, which can contain text or structured data.
     * </p>
     * 
     * @return The content of the output field, which can contain text or structured data.
     */
    public final NodeExecutionContent content() {
        return content;
    }

    /**
     * For responses, this returns true if the service returned a value for the Next property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasNext() {
        return next != null && !(next instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The next node that receives output data from this field.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNext} method.
     * </p>
     * 
     * @return The next node that receives output data from this field.
     */
    public final List<NodeOutputNext> next() {
        return next;
    }

    /**
     * <p>
     * The data type of the output field for compatibility validation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FlowNodeIODataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The data type of the output field for compatibility validation.
     * @see FlowNodeIODataType
     */
    public final FlowNodeIODataType type() {
        return FlowNodeIODataType.fromValue(type);
    }

    /**
     * <p>
     * The data type of the output field for compatibility validation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FlowNodeIODataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The data type of the output field for compatibility validation.
     * @see FlowNodeIODataType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(hasNext() ? next() : null);
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeOutputField)) {
            return false;
        }
        NodeOutputField other = (NodeOutputField) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(content(), other.content()) && hasNext() == other.hasNext()
                && Objects.equals(next(), other.next()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NodeOutputField").add("Name", name())
                .add("Content", content() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Next", next() == null ? null : "*** Sensitive Data Redacted ***").add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        case "next":
            return Optional.ofNullable(clazz.cast(next()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("content", CONTENT_FIELD);
        map.put("next", NEXT_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NodeOutputField, T> g) {
        return obj -> g.apply((NodeOutputField) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NodeOutputField> {
        /**
         * <p>
         * The name of the output field as defined in the node's output schema.
         * </p>
         * 
         * @param name
         *        The name of the output field as defined in the node's output schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The content of the output field, which can contain text or structured data.
         * </p>
         * 
         * @param content
         *        The content of the output field, which can contain text or structured data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(NodeExecutionContent content);

        /**
         * <p>
         * The content of the output field, which can contain text or structured data.
         * </p>
         * This is a convenience method that creates an instance of the {@link NodeExecutionContent.Builder} avoiding
         * the need to create one manually via {@link NodeExecutionContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NodeExecutionContent.Builder#build()} is called immediately and
         * its result is passed to {@link #content(NodeExecutionContent)}.
         * 
         * @param content
         *        a consumer that will call methods on {@link NodeExecutionContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #content(NodeExecutionContent)
         */
        default Builder content(Consumer<NodeExecutionContent.Builder> content) {
            return content(NodeExecutionContent.builder().applyMutation(content).build());
        }

        /**
         * <p>
         * The next node that receives output data from this field.
         * </p>
         * 
         * @param next
         *        The next node that receives output data from this field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder next(Collection<NodeOutputNext> next);

        /**
         * <p>
         * The next node that receives output data from this field.
         * </p>
         * 
         * @param next
         *        The next node that receives output data from this field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder next(NodeOutputNext... next);

        /**
         * <p>
         * The next node that receives output data from this field.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.NodeOutputNext.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.NodeOutputNext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.NodeOutputNext.Builder#build()} is called
         * immediately and its result is passed to {@link #next(List<NodeOutputNext>)}.
         * 
         * @param next
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.NodeOutputNext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #next(java.util.Collection<NodeOutputNext>)
         */
        Builder next(Consumer<NodeOutputNext.Builder>... next);

        /**
         * <p>
         * The data type of the output field for compatibility validation.
         * </p>
         * 
         * @param type
         *        The data type of the output field for compatibility validation.
         * @see FlowNodeIODataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowNodeIODataType
         */
        Builder type(String type);

        /**
         * <p>
         * The data type of the output field for compatibility validation.
         * </p>
         * 
         * @param type
         *        The data type of the output field for compatibility validation.
         * @see FlowNodeIODataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowNodeIODataType
         */
        Builder type(FlowNodeIODataType type);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private NodeExecutionContent content;

        private List<NodeOutputNext> next = DefaultSdkAutoConstructList.getInstance();

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeOutputField model) {
            name(model.name);
            content(model.content);
            next(model.next);
            type(model.type);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final NodeExecutionContent.Builder getContent() {
            return content != null ? content.toBuilder() : null;
        }

        public final void setContent(NodeExecutionContent.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(NodeExecutionContent content) {
            this.content = content;
            return this;
        }

        public final List<NodeOutputNext.Builder> getNext() {
            List<NodeOutputNext.Builder> result = NodeOutputNextListCopier.copyToBuilder(this.next);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNext(Collection<NodeOutputNext.BuilderImpl> next) {
            this.next = NodeOutputNextListCopier.copyFromBuilder(next);
        }

        @Override
        public final Builder next(Collection<NodeOutputNext> next) {
            this.next = NodeOutputNextListCopier.copy(next);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder next(NodeOutputNext... next) {
            next(Arrays.asList(next));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder next(Consumer<NodeOutputNext.Builder>... next) {
            next(Stream.of(next).map(c -> NodeOutputNext.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FlowNodeIODataType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public NodeOutputField build() {
            return new NodeOutputField(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
