/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure of the executor invoking the actions in custom orchestration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OrchestrationExecutor implements SdkPojo, Serializable,
        ToCopyableBuilder<OrchestrationExecutor.Builder, OrchestrationExecutor> {
    private static final SdkField<String> LAMBDA_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("lambda")
            .getter(getter(OrchestrationExecutor::lambda)).setter(setter(Builder::lambda))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambda").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAMBDA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String lambda;

    private final Type type;

    private OrchestrationExecutor(BuilderImpl builder) {
        this.lambda = builder.lambda;
        this.type = builder.type;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Lambda function containing the business logic that is carried out upon
     * invoking the action.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Lambda function containing the business logic that is carried out
     *         upon invoking the action.
     */
    public final String lambda() {
        return lambda;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lambda());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrchestrationExecutor)) {
            return false;
        }
        OrchestrationExecutor other = (OrchestrationExecutor) obj;
        return Objects.equals(lambda(), other.lambda());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OrchestrationExecutor").add("Lambda", lambda()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lambda":
            return Optional.ofNullable(clazz.cast(lambda()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #lambda()} initialized to the given value.
     *
     * <p>
     * The Amazon Resource Name (ARN) of the Lambda function containing the business logic that is carried out upon
     * invoking the action.
     * </p>
     * 
     * @param lambda
     *        The Amazon Resource Name (ARN) of the Lambda function containing the business logic that is carried out
     *        upon invoking the action.
     */
    public static OrchestrationExecutor fromLambda(String lambda) {
        return builder().lambda(lambda).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("lambda", LAMBDA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OrchestrationExecutor, T> g) {
        return obj -> g.apply((OrchestrationExecutor) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OrchestrationExecutor> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Lambda function containing the business logic that is carried out upon
         * invoking the action.
         * </p>
         * 
         * @param lambda
         *        The Amazon Resource Name (ARN) of the Lambda function containing the business logic that is carried
         *        out upon invoking the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambda(String lambda);
    }

    static final class BuilderImpl implements Builder {
        private String lambda;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(OrchestrationExecutor model) {
            lambda(model.lambda);
        }

        public final String getLambda() {
            return lambda;
        }

        public final void setLambda(String lambda) {
            Object oldValue = this.lambda;
            this.lambda = lambda;
            handleUnionValueChange(Type.LAMBDA, oldValue, this.lambda);
        }

        @Override
        public final Builder lambda(String lambda) {
            Object oldValue = this.lambda;
            this.lambda = lambda;
            handleUnionValueChange(Type.LAMBDA, oldValue, this.lambda);
            return this;
        }

        @Override
        public OrchestrationExecutor build() {
            return new OrchestrationExecutor(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see OrchestrationExecutor#type()
     */
    public enum Type {
        LAMBDA,

        UNKNOWN_TO_SDK_VERSION
    }
}
