/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the orchestration step, in which the agent determines the order in which actions are executed and which
 * knowledge bases are retrieved.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OrchestrationTrace implements SdkPojo, Serializable,
        ToCopyableBuilder<OrchestrationTrace.Builder, OrchestrationTrace> {
    private static final SdkField<Rationale> RATIONALE_FIELD = SdkField.<Rationale> builder(MarshallingType.SDK_POJO)
            .memberName("rationale").getter(getter(OrchestrationTrace::rationale)).setter(setter(Builder::rationale))
            .constructor(Rationale::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rationale").build()).build();

    private static final SdkField<InvocationInput> INVOCATION_INPUT_FIELD = SdkField
            .<InvocationInput> builder(MarshallingType.SDK_POJO).memberName("invocationInput")
            .getter(getter(OrchestrationTrace::invocationInput)).setter(setter(Builder::invocationInput))
            .constructor(InvocationInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invocationInput").build()).build();

    private static final SdkField<Observation> OBSERVATION_FIELD = SdkField.<Observation> builder(MarshallingType.SDK_POJO)
            .memberName("observation").getter(getter(OrchestrationTrace::observation)).setter(setter(Builder::observation))
            .constructor(Observation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("observation").build()).build();

    private static final SdkField<ModelInvocationInput> MODEL_INVOCATION_INPUT_FIELD = SdkField
            .<ModelInvocationInput> builder(MarshallingType.SDK_POJO).memberName("modelInvocationInput")
            .getter(getter(OrchestrationTrace::modelInvocationInput)).setter(setter(Builder::modelInvocationInput))
            .constructor(ModelInvocationInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelInvocationInput").build())
            .build();

    private static final SdkField<OrchestrationModelInvocationOutput> MODEL_INVOCATION_OUTPUT_FIELD = SdkField
            .<OrchestrationModelInvocationOutput> builder(MarshallingType.SDK_POJO).memberName("modelInvocationOutput")
            .getter(getter(OrchestrationTrace::modelInvocationOutput)).setter(setter(Builder::modelInvocationOutput))
            .constructor(OrchestrationModelInvocationOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelInvocationOutput").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RATIONALE_FIELD,
            INVOCATION_INPUT_FIELD, OBSERVATION_FIELD, MODEL_INVOCATION_INPUT_FIELD, MODEL_INVOCATION_OUTPUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Rationale rationale;

    private final InvocationInput invocationInput;

    private final Observation observation;

    private final ModelInvocationInput modelInvocationInput;

    private final OrchestrationModelInvocationOutput modelInvocationOutput;

    private final Type type;

    private OrchestrationTrace(BuilderImpl builder) {
        this.rationale = builder.rationale;
        this.invocationInput = builder.invocationInput;
        this.observation = builder.observation;
        this.modelInvocationInput = builder.modelInvocationInput;
        this.modelInvocationOutput = builder.modelInvocationOutput;
        this.type = builder.type;
    }

    /**
     * <p>
     * Details about the reasoning, based on the input, that the agent uses to justify carrying out an action group or
     * getting information from a knowledge base.
     * </p>
     * 
     * @return Details about the reasoning, based on the input, that the agent uses to justify carrying out an action
     *         group or getting information from a knowledge base.
     */
    public final Rationale rationale() {
        return rationale;
    }

    /**
     * <p>
     * Contains information pertaining to the action group or knowledge base that is being invoked.
     * </p>
     * 
     * @return Contains information pertaining to the action group or knowledge base that is being invoked.
     */
    public final InvocationInput invocationInput() {
        return invocationInput;
    }

    /**
     * <p>
     * Details about the observation (the output of the action group Lambda or knowledge base) made by the agent.
     * </p>
     * 
     * @return Details about the observation (the output of the action group Lambda or knowledge base) made by the
     *         agent.
     */
    public final Observation observation() {
        return observation;
    }

    /**
     * <p>
     * The input for the orchestration step.
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>type</code> is <code>ORCHESTRATION</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>text</code> contains the prompt.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>inferenceConfiguration</code>, <code>parserMode</code>, and <code>overrideLambda</code> values are set
     * in the <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html"
     * >PromptOverrideConfiguration</a> object that was set when the agent was created or updated.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The input for the orchestration step.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The <code>type</code> is <code>ORCHESTRATION</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The <code>text</code> contains the prompt.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The <code>inferenceConfiguration</code>, <code>parserMode</code>, and <code>overrideLambda</code> values
     *         are set in the <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html"
     *         >PromptOverrideConfiguration</a> object that was set when the agent was created or updated.
     *         </p>
     *         </li>
     */
    public final ModelInvocationInput modelInvocationInput() {
        return modelInvocationInput;
    }

    /**
     * <p>
     * Contains information pertaining to the output from the foundation model that is being invoked.
     * </p>
     * 
     * @return Contains information pertaining to the output from the foundation model that is being invoked.
     */
    public final OrchestrationModelInvocationOutput modelInvocationOutput() {
        return modelInvocationOutput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rationale());
        hashCode = 31 * hashCode + Objects.hashCode(invocationInput());
        hashCode = 31 * hashCode + Objects.hashCode(observation());
        hashCode = 31 * hashCode + Objects.hashCode(modelInvocationInput());
        hashCode = 31 * hashCode + Objects.hashCode(modelInvocationOutput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrchestrationTrace)) {
            return false;
        }
        OrchestrationTrace other = (OrchestrationTrace) obj;
        return Objects.equals(rationale(), other.rationale()) && Objects.equals(invocationInput(), other.invocationInput())
                && Objects.equals(observation(), other.observation())
                && Objects.equals(modelInvocationInput(), other.modelInvocationInput())
                && Objects.equals(modelInvocationOutput(), other.modelInvocationOutput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OrchestrationTrace")
                .add("Rationale", rationale() == null ? null : "*** Sensitive Data Redacted ***")
                .add("InvocationInput", invocationInput() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Observation", observation() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ModelInvocationInput", modelInvocationInput() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ModelInvocationOutput", modelInvocationOutput() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "rationale":
            return Optional.ofNullable(clazz.cast(rationale()));
        case "invocationInput":
            return Optional.ofNullable(clazz.cast(invocationInput()));
        case "observation":
            return Optional.ofNullable(clazz.cast(observation()));
        case "modelInvocationInput":
            return Optional.ofNullable(clazz.cast(modelInvocationInput()));
        case "modelInvocationOutput":
            return Optional.ofNullable(clazz.cast(modelInvocationOutput()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #rationale()} initialized to the given value.
     *
     * <p>
     * Details about the reasoning, based on the input, that the agent uses to justify carrying out an action group or
     * getting information from a knowledge base.
     * </p>
     * 
     * @param rationale
     *        Details about the reasoning, based on the input, that the agent uses to justify carrying out an action
     *        group or getting information from a knowledge base.
     */
    public static OrchestrationTrace fromRationale(Rationale rationale) {
        return builder().rationale(rationale).build();
    }

    /**
     * Create an instance of this class with {@link #rationale()} initialized to the given value.
     *
     * <p>
     * Details about the reasoning, based on the input, that the agent uses to justify carrying out an action group or
     * getting information from a knowledge base.
     * </p>
     * 
     * @param rationale
     *        Details about the reasoning, based on the input, that the agent uses to justify carrying out an action
     *        group or getting information from a knowledge base.
     */
    public static OrchestrationTrace fromRationale(Consumer<Rationale.Builder> rationale) {
        Rationale.Builder builder = Rationale.builder();
        rationale.accept(builder);
        return fromRationale(builder.build());
    }

    /**
     * Create an instance of this class with {@link #invocationInput()} initialized to the given value.
     *
     * <p>
     * Contains information pertaining to the action group or knowledge base that is being invoked.
     * </p>
     * 
     * @param invocationInput
     *        Contains information pertaining to the action group or knowledge base that is being invoked.
     */
    public static OrchestrationTrace fromInvocationInput(InvocationInput invocationInput) {
        return builder().invocationInput(invocationInput).build();
    }

    /**
     * Create an instance of this class with {@link #invocationInput()} initialized to the given value.
     *
     * <p>
     * Contains information pertaining to the action group or knowledge base that is being invoked.
     * </p>
     * 
     * @param invocationInput
     *        Contains information pertaining to the action group or knowledge base that is being invoked.
     */
    public static OrchestrationTrace fromInvocationInput(Consumer<InvocationInput.Builder> invocationInput) {
        InvocationInput.Builder builder = InvocationInput.builder();
        invocationInput.accept(builder);
        return fromInvocationInput(builder.build());
    }

    /**
     * Create an instance of this class with {@link #observation()} initialized to the given value.
     *
     * <p>
     * Details about the observation (the output of the action group Lambda or knowledge base) made by the agent.
     * </p>
     * 
     * @param observation
     *        Details about the observation (the output of the action group Lambda or knowledge base) made by the agent.
     */
    public static OrchestrationTrace fromObservation(Observation observation) {
        return builder().observation(observation).build();
    }

    /**
     * Create an instance of this class with {@link #observation()} initialized to the given value.
     *
     * <p>
     * Details about the observation (the output of the action group Lambda or knowledge base) made by the agent.
     * </p>
     * 
     * @param observation
     *        Details about the observation (the output of the action group Lambda or knowledge base) made by the agent.
     */
    public static OrchestrationTrace fromObservation(Consumer<Observation.Builder> observation) {
        Observation.Builder builder = Observation.builder();
        observation.accept(builder);
        return fromObservation(builder.build());
    }

    /**
     * Create an instance of this class with {@link #modelInvocationInput()} initialized to the given value.
     *
     * <p>
     * The input for the orchestration step.
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>type</code> is <code>ORCHESTRATION</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>text</code> contains the prompt.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>inferenceConfiguration</code>, <code>parserMode</code>, and <code>overrideLambda</code> values are set
     * in the <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html"
     * >PromptOverrideConfiguration</a> object that was set when the agent was created or updated.
     * </p>
     * </li>
     * </ul>
     * 
     * @param modelInvocationInput
     *        The input for the orchestration step.</p>
     *        <ul>
     *        <li>
     *        <p>
     *        The <code>type</code> is <code>ORCHESTRATION</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        The <code>text</code> contains the prompt.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        The <code>inferenceConfiguration</code>, <code>parserMode</code>, and <code>overrideLambda</code> values
     *        are set in the <a href=
     *        "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html"
     *        >PromptOverrideConfiguration</a> object that was set when the agent was created or updated.
     *        </p>
     *        </li>
     */
    public static OrchestrationTrace fromModelInvocationInput(ModelInvocationInput modelInvocationInput) {
        return builder().modelInvocationInput(modelInvocationInput).build();
    }

    /**
     * Create an instance of this class with {@link #modelInvocationInput()} initialized to the given value.
     *
     * <p>
     * The input for the orchestration step.
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>type</code> is <code>ORCHESTRATION</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>text</code> contains the prompt.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>inferenceConfiguration</code>, <code>parserMode</code>, and <code>overrideLambda</code> values are set
     * in the <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html"
     * >PromptOverrideConfiguration</a> object that was set when the agent was created or updated.
     * </p>
     * </li>
     * </ul>
     * 
     * @param modelInvocationInput
     *        The input for the orchestration step.</p>
     *        <ul>
     *        <li>
     *        <p>
     *        The <code>type</code> is <code>ORCHESTRATION</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        The <code>text</code> contains the prompt.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        The <code>inferenceConfiguration</code>, <code>parserMode</code>, and <code>overrideLambda</code> values
     *        are set in the <a href=
     *        "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html"
     *        >PromptOverrideConfiguration</a> object that was set when the agent was created or updated.
     *        </p>
     *        </li>
     */
    public static OrchestrationTrace fromModelInvocationInput(Consumer<ModelInvocationInput.Builder> modelInvocationInput) {
        ModelInvocationInput.Builder builder = ModelInvocationInput.builder();
        modelInvocationInput.accept(builder);
        return fromModelInvocationInput(builder.build());
    }

    /**
     * Create an instance of this class with {@link #modelInvocationOutput()} initialized to the given value.
     *
     * <p>
     * Contains information pertaining to the output from the foundation model that is being invoked.
     * </p>
     * 
     * @param modelInvocationOutput
     *        Contains information pertaining to the output from the foundation model that is being invoked.
     */
    public static OrchestrationTrace fromModelInvocationOutput(OrchestrationModelInvocationOutput modelInvocationOutput) {
        return builder().modelInvocationOutput(modelInvocationOutput).build();
    }

    /**
     * Create an instance of this class with {@link #modelInvocationOutput()} initialized to the given value.
     *
     * <p>
     * Contains information pertaining to the output from the foundation model that is being invoked.
     * </p>
     * 
     * @param modelInvocationOutput
     *        Contains information pertaining to the output from the foundation model that is being invoked.
     */
    public static OrchestrationTrace fromModelInvocationOutput(
            Consumer<OrchestrationModelInvocationOutput.Builder> modelInvocationOutput) {
        OrchestrationModelInvocationOutput.Builder builder = OrchestrationModelInvocationOutput.builder();
        modelInvocationOutput.accept(builder);
        return fromModelInvocationOutput(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("rationale", RATIONALE_FIELD);
        map.put("invocationInput", INVOCATION_INPUT_FIELD);
        map.put("observation", OBSERVATION_FIELD);
        map.put("modelInvocationInput", MODEL_INVOCATION_INPUT_FIELD);
        map.put("modelInvocationOutput", MODEL_INVOCATION_OUTPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OrchestrationTrace, T> g) {
        return obj -> g.apply((OrchestrationTrace) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OrchestrationTrace> {
        /**
         * <p>
         * Details about the reasoning, based on the input, that the agent uses to justify carrying out an action group
         * or getting information from a knowledge base.
         * </p>
         * 
         * @param rationale
         *        Details about the reasoning, based on the input, that the agent uses to justify carrying out an action
         *        group or getting information from a knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rationale(Rationale rationale);

        /**
         * <p>
         * Details about the reasoning, based on the input, that the agent uses to justify carrying out an action group
         * or getting information from a knowledge base.
         * </p>
         * This is a convenience method that creates an instance of the {@link Rationale.Builder} avoiding the need to
         * create one manually via {@link Rationale#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Rationale.Builder#build()} is called immediately and its result
         * is passed to {@link #rationale(Rationale)}.
         * 
         * @param rationale
         *        a consumer that will call methods on {@link Rationale.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rationale(Rationale)
         */
        default Builder rationale(Consumer<Rationale.Builder> rationale) {
            return rationale(Rationale.builder().applyMutation(rationale).build());
        }

        /**
         * <p>
         * Contains information pertaining to the action group or knowledge base that is being invoked.
         * </p>
         * 
         * @param invocationInput
         *        Contains information pertaining to the action group or knowledge base that is being invoked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationInput(InvocationInput invocationInput);

        /**
         * <p>
         * Contains information pertaining to the action group or knowledge base that is being invoked.
         * </p>
         * This is a convenience method that creates an instance of the {@link InvocationInput.Builder} avoiding the
         * need to create one manually via {@link InvocationInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InvocationInput.Builder#build()} is called immediately and its
         * result is passed to {@link #invocationInput(InvocationInput)}.
         * 
         * @param invocationInput
         *        a consumer that will call methods on {@link InvocationInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #invocationInput(InvocationInput)
         */
        default Builder invocationInput(Consumer<InvocationInput.Builder> invocationInput) {
            return invocationInput(InvocationInput.builder().applyMutation(invocationInput).build());
        }

        /**
         * <p>
         * Details about the observation (the output of the action group Lambda or knowledge base) made by the agent.
         * </p>
         * 
         * @param observation
         *        Details about the observation (the output of the action group Lambda or knowledge base) made by the
         *        agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder observation(Observation observation);

        /**
         * <p>
         * Details about the observation (the output of the action group Lambda or knowledge base) made by the agent.
         * </p>
         * This is a convenience method that creates an instance of the {@link Observation.Builder} avoiding the need to
         * create one manually via {@link Observation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Observation.Builder#build()} is called immediately and its result
         * is passed to {@link #observation(Observation)}.
         * 
         * @param observation
         *        a consumer that will call methods on {@link Observation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #observation(Observation)
         */
        default Builder observation(Consumer<Observation.Builder> observation) {
            return observation(Observation.builder().applyMutation(observation).build());
        }

        /**
         * <p>
         * The input for the orchestration step.
         * </p>
         * <ul>
         * <li>
         * <p>
         * The <code>type</code> is <code>ORCHESTRATION</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * The <code>text</code> contains the prompt.
         * </p>
         * </li>
         * <li>
         * <p>
         * The <code>inferenceConfiguration</code>, <code>parserMode</code>, and <code>overrideLambda</code> values are
         * set in the <a
         * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html"
         * >PromptOverrideConfiguration</a> object that was set when the agent was created or updated.
         * </p>
         * </li>
         * </ul>
         * 
         * @param modelInvocationInput
         *        The input for the orchestration step.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The <code>type</code> is <code>ORCHESTRATION</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The <code>text</code> contains the prompt.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The <code>inferenceConfiguration</code>, <code>parserMode</code>, and <code>overrideLambda</code>
         *        values are set in the <a href=
         *        "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html"
         *        >PromptOverrideConfiguration</a> object that was set when the agent was created or updated.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelInvocationInput(ModelInvocationInput modelInvocationInput);

        /**
         * <p>
         * The input for the orchestration step.
         * </p>
         * <ul>
         * <li>
         * <p>
         * The <code>type</code> is <code>ORCHESTRATION</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * The <code>text</code> contains the prompt.
         * </p>
         * </li>
         * <li>
         * <p>
         * The <code>inferenceConfiguration</code>, <code>parserMode</code>, and <code>overrideLambda</code> values are
         * set in the <a
         * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html"
         * >PromptOverrideConfiguration</a> object that was set when the agent was created or updated.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link ModelInvocationInput.Builder} avoiding
         * the need to create one manually via {@link ModelInvocationInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModelInvocationInput.Builder#build()} is called immediately and
         * its result is passed to {@link #modelInvocationInput(ModelInvocationInput)}.
         * 
         * @param modelInvocationInput
         *        a consumer that will call methods on {@link ModelInvocationInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelInvocationInput(ModelInvocationInput)
         */
        default Builder modelInvocationInput(Consumer<ModelInvocationInput.Builder> modelInvocationInput) {
            return modelInvocationInput(ModelInvocationInput.builder().applyMutation(modelInvocationInput).build());
        }

        /**
         * <p>
         * Contains information pertaining to the output from the foundation model that is being invoked.
         * </p>
         * 
         * @param modelInvocationOutput
         *        Contains information pertaining to the output from the foundation model that is being invoked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelInvocationOutput(OrchestrationModelInvocationOutput modelInvocationOutput);

        /**
         * <p>
         * Contains information pertaining to the output from the foundation model that is being invoked.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link OrchestrationModelInvocationOutput.Builder} avoiding the need to create one manually via
         * {@link OrchestrationModelInvocationOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OrchestrationModelInvocationOutput.Builder#build()} is called
         * immediately and its result is passed to {@link #modelInvocationOutput(OrchestrationModelInvocationOutput)}.
         * 
         * @param modelInvocationOutput
         *        a consumer that will call methods on {@link OrchestrationModelInvocationOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelInvocationOutput(OrchestrationModelInvocationOutput)
         */
        default Builder modelInvocationOutput(Consumer<OrchestrationModelInvocationOutput.Builder> modelInvocationOutput) {
            return modelInvocationOutput(OrchestrationModelInvocationOutput.builder().applyMutation(modelInvocationOutput)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Rationale rationale;

        private InvocationInput invocationInput;

        private Observation observation;

        private ModelInvocationInput modelInvocationInput;

        private OrchestrationModelInvocationOutput modelInvocationOutput;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(OrchestrationTrace model) {
            rationale(model.rationale);
            invocationInput(model.invocationInput);
            observation(model.observation);
            modelInvocationInput(model.modelInvocationInput);
            modelInvocationOutput(model.modelInvocationOutput);
        }

        public final Rationale.Builder getRationale() {
            return rationale != null ? rationale.toBuilder() : null;
        }

        public final void setRationale(Rationale.BuilderImpl rationale) {
            Object oldValue = this.rationale;
            this.rationale = rationale != null ? rationale.build() : null;
            handleUnionValueChange(Type.RATIONALE, oldValue, this.rationale);
        }

        @Override
        public final Builder rationale(Rationale rationale) {
            Object oldValue = this.rationale;
            this.rationale = rationale;
            handleUnionValueChange(Type.RATIONALE, oldValue, this.rationale);
            return this;
        }

        public final InvocationInput.Builder getInvocationInput() {
            return invocationInput != null ? invocationInput.toBuilder() : null;
        }

        public final void setInvocationInput(InvocationInput.BuilderImpl invocationInput) {
            Object oldValue = this.invocationInput;
            this.invocationInput = invocationInput != null ? invocationInput.build() : null;
            handleUnionValueChange(Type.INVOCATION_INPUT, oldValue, this.invocationInput);
        }

        @Override
        public final Builder invocationInput(InvocationInput invocationInput) {
            Object oldValue = this.invocationInput;
            this.invocationInput = invocationInput;
            handleUnionValueChange(Type.INVOCATION_INPUT, oldValue, this.invocationInput);
            return this;
        }

        public final Observation.Builder getObservation() {
            return observation != null ? observation.toBuilder() : null;
        }

        public final void setObservation(Observation.BuilderImpl observation) {
            Object oldValue = this.observation;
            this.observation = observation != null ? observation.build() : null;
            handleUnionValueChange(Type.OBSERVATION, oldValue, this.observation);
        }

        @Override
        public final Builder observation(Observation observation) {
            Object oldValue = this.observation;
            this.observation = observation;
            handleUnionValueChange(Type.OBSERVATION, oldValue, this.observation);
            return this;
        }

        public final ModelInvocationInput.Builder getModelInvocationInput() {
            return modelInvocationInput != null ? modelInvocationInput.toBuilder() : null;
        }

        public final void setModelInvocationInput(ModelInvocationInput.BuilderImpl modelInvocationInput) {
            Object oldValue = this.modelInvocationInput;
            this.modelInvocationInput = modelInvocationInput != null ? modelInvocationInput.build() : null;
            handleUnionValueChange(Type.MODEL_INVOCATION_INPUT, oldValue, this.modelInvocationInput);
        }

        @Override
        public final Builder modelInvocationInput(ModelInvocationInput modelInvocationInput) {
            Object oldValue = this.modelInvocationInput;
            this.modelInvocationInput = modelInvocationInput;
            handleUnionValueChange(Type.MODEL_INVOCATION_INPUT, oldValue, this.modelInvocationInput);
            return this;
        }

        public final OrchestrationModelInvocationOutput.Builder getModelInvocationOutput() {
            return modelInvocationOutput != null ? modelInvocationOutput.toBuilder() : null;
        }

        public final void setModelInvocationOutput(OrchestrationModelInvocationOutput.BuilderImpl modelInvocationOutput) {
            Object oldValue = this.modelInvocationOutput;
            this.modelInvocationOutput = modelInvocationOutput != null ? modelInvocationOutput.build() : null;
            handleUnionValueChange(Type.MODEL_INVOCATION_OUTPUT, oldValue, this.modelInvocationOutput);
        }

        @Override
        public final Builder modelInvocationOutput(OrchestrationModelInvocationOutput modelInvocationOutput) {
            Object oldValue = this.modelInvocationOutput;
            this.modelInvocationOutput = modelInvocationOutput;
            handleUnionValueChange(Type.MODEL_INVOCATION_OUTPUT, oldValue, this.modelInvocationOutput);
            return this;
        }

        @Override
        public OrchestrationTrace build() {
            return new OrchestrationTrace(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see OrchestrationTrace#type()
     */
    public enum Type {
        RATIONALE,

        INVOCATION_INPUT,

        OBSERVATION,

        MODEL_INVOCATION_INPUT,

        MODEL_INVOCATION_OUTPUT,

        UNKNOWN_TO_SDK_VERSION
    }
}
