/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies parameters that control how the service populates the agent prompt for an <code>InvokeAgent</code> or
 * <code>InvokeInlineAgent</code> request. You can control which aspects of previous invocations in the same agent
 * session the service uses to populate the agent prompt. This gives you more granular control over the contextual
 * history that is used to process the current request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PromptCreationConfigurations implements SdkPojo, Serializable,
        ToCopyableBuilder<PromptCreationConfigurations.Builder, PromptCreationConfigurations> {
    private static final SdkField<Integer> PREVIOUS_CONVERSATION_TURNS_TO_INCLUDE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("previousConversationTurnsToInclude")
            .getter(getter(PromptCreationConfigurations::previousConversationTurnsToInclude))
            .setter(setter(Builder::previousConversationTurnsToInclude))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("previousConversationTurnsToInclude")
                    .build()).build();

    private static final SdkField<Boolean> EXCLUDE_PREVIOUS_THINKING_STEPS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("excludePreviousThinkingSteps")
            .getter(getter(PromptCreationConfigurations::excludePreviousThinkingSteps))
            .setter(setter(Builder::excludePreviousThinkingSteps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("excludePreviousThinkingSteps")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PREVIOUS_CONVERSATION_TURNS_TO_INCLUDE_FIELD, EXCLUDE_PREVIOUS_THINKING_STEPS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer previousConversationTurnsToInclude;

    private final Boolean excludePreviousThinkingSteps;

    private PromptCreationConfigurations(BuilderImpl builder) {
        this.previousConversationTurnsToInclude = builder.previousConversationTurnsToInclude;
        this.excludePreviousThinkingSteps = builder.excludePreviousThinkingSteps;
    }

    /**
     * <p>
     * The number of previous conversations from the ongoing agent session to include in the conversation history of the
     * agent prompt, during the current invocation. This gives you more granular control over the context that the model
     * is made aware of, and helps the model remove older context which is no longer useful during the ongoing agent
     * session.
     * </p>
     * 
     * @return The number of previous conversations from the ongoing agent session to include in the conversation
     *         history of the agent prompt, during the current invocation. This gives you more granular control over the
     *         context that the model is made aware of, and helps the model remove older context which is no longer
     *         useful during the ongoing agent session.
     */
    public final Integer previousConversationTurnsToInclude() {
        return previousConversationTurnsToInclude;
    }

    /**
     * <p>
     * If <code>true</code>, the service removes any content between <code>&lt;thinking&gt;</code> tags from previous
     * conversations in an agent session. The service will only remove content from already processed turns. This helps
     * you remove content which might not be useful for current and subsequent invocations. This can reduce the input
     * token count and potentially save costs. The default value is <code>false</code>.
     * </p>
     * 
     * @return If <code>true</code>, the service removes any content between <code>&lt;thinking&gt;</code> tags from
     *         previous conversations in an agent session. The service will only remove content from already processed
     *         turns. This helps you remove content which might not be useful for current and subsequent invocations.
     *         This can reduce the input token count and potentially save costs. The default value is <code>false</code>
     *         .
     */
    public final Boolean excludePreviousThinkingSteps() {
        return excludePreviousThinkingSteps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(previousConversationTurnsToInclude());
        hashCode = 31 * hashCode + Objects.hashCode(excludePreviousThinkingSteps());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PromptCreationConfigurations)) {
            return false;
        }
        PromptCreationConfigurations other = (PromptCreationConfigurations) obj;
        return Objects.equals(previousConversationTurnsToInclude(), other.previousConversationTurnsToInclude())
                && Objects.equals(excludePreviousThinkingSteps(), other.excludePreviousThinkingSteps());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PromptCreationConfigurations")
                .add("PreviousConversationTurnsToInclude", previousConversationTurnsToInclude())
                .add("ExcludePreviousThinkingSteps", excludePreviousThinkingSteps()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "previousConversationTurnsToInclude":
            return Optional.ofNullable(clazz.cast(previousConversationTurnsToInclude()));
        case "excludePreviousThinkingSteps":
            return Optional.ofNullable(clazz.cast(excludePreviousThinkingSteps()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("previousConversationTurnsToInclude", PREVIOUS_CONVERSATION_TURNS_TO_INCLUDE_FIELD);
        map.put("excludePreviousThinkingSteps", EXCLUDE_PREVIOUS_THINKING_STEPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PromptCreationConfigurations, T> g) {
        return obj -> g.apply((PromptCreationConfigurations) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PromptCreationConfigurations> {
        /**
         * <p>
         * The number of previous conversations from the ongoing agent session to include in the conversation history of
         * the agent prompt, during the current invocation. This gives you more granular control over the context that
         * the model is made aware of, and helps the model remove older context which is no longer useful during the
         * ongoing agent session.
         * </p>
         * 
         * @param previousConversationTurnsToInclude
         *        The number of previous conversations from the ongoing agent session to include in the conversation
         *        history of the agent prompt, during the current invocation. This gives you more granular control over
         *        the context that the model is made aware of, and helps the model remove older context which is no
         *        longer useful during the ongoing agent session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previousConversationTurnsToInclude(Integer previousConversationTurnsToInclude);

        /**
         * <p>
         * If <code>true</code>, the service removes any content between <code>&lt;thinking&gt;</code> tags from
         * previous conversations in an agent session. The service will only remove content from already processed
         * turns. This helps you remove content which might not be useful for current and subsequent invocations. This
         * can reduce the input token count and potentially save costs. The default value is <code>false</code>.
         * </p>
         * 
         * @param excludePreviousThinkingSteps
         *        If <code>true</code>, the service removes any content between <code>&lt;thinking&gt;</code> tags from
         *        previous conversations in an agent session. The service will only remove content from already
         *        processed turns. This helps you remove content which might not be useful for current and subsequent
         *        invocations. This can reduce the input token count and potentially save costs. The default value is
         *        <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludePreviousThinkingSteps(Boolean excludePreviousThinkingSteps);
    }

    static final class BuilderImpl implements Builder {
        private Integer previousConversationTurnsToInclude;

        private Boolean excludePreviousThinkingSteps;

        private BuilderImpl() {
        }

        private BuilderImpl(PromptCreationConfigurations model) {
            previousConversationTurnsToInclude(model.previousConversationTurnsToInclude);
            excludePreviousThinkingSteps(model.excludePreviousThinkingSteps);
        }

        public final Integer getPreviousConversationTurnsToInclude() {
            return previousConversationTurnsToInclude;
        }

        public final void setPreviousConversationTurnsToInclude(Integer previousConversationTurnsToInclude) {
            this.previousConversationTurnsToInclude = previousConversationTurnsToInclude;
        }

        @Override
        public final Builder previousConversationTurnsToInclude(Integer previousConversationTurnsToInclude) {
            this.previousConversationTurnsToInclude = previousConversationTurnsToInclude;
            return this;
        }

        public final Boolean getExcludePreviousThinkingSteps() {
            return excludePreviousThinkingSteps;
        }

        public final void setExcludePreviousThinkingSteps(Boolean excludePreviousThinkingSteps) {
            this.excludePreviousThinkingSteps = excludePreviousThinkingSteps;
        }

        @Override
        public final Builder excludePreviousThinkingSteps(Boolean excludePreviousThinkingSteps) {
            this.excludePreviousThinkingSteps = excludePreviousThinkingSteps;
            return this;
        }

        @Override
        public PromptCreationConfigurations build() {
            return new PromptCreationConfigurations(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
