/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configurations for reranking.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RerankingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RerankingConfiguration.Builder, RerankingConfiguration> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(RerankingConfiguration::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<BedrockRerankingConfiguration> BEDROCK_RERANKING_CONFIGURATION_FIELD = SdkField
            .<BedrockRerankingConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("bedrockRerankingConfiguration")
            .getter(getter(RerankingConfiguration::bedrockRerankingConfiguration))
            .setter(setter(Builder::bedrockRerankingConfiguration))
            .constructor(BedrockRerankingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bedrockRerankingConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            BEDROCK_RERANKING_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final BedrockRerankingConfiguration bedrockRerankingConfiguration;

    private RerankingConfiguration(BuilderImpl builder) {
        this.type = builder.type;
        this.bedrockRerankingConfiguration = builder.bedrockRerankingConfiguration;
    }

    /**
     * <p>
     * The type of reranker that the configurations apply to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RerankingConfigurationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of reranker that the configurations apply to.
     * @see RerankingConfigurationType
     */
    public final RerankingConfigurationType type() {
        return RerankingConfigurationType.fromValue(type);
    }

    /**
     * <p>
     * The type of reranker that the configurations apply to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RerankingConfigurationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of reranker that the configurations apply to.
     * @see RerankingConfigurationType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Contains configurations for an Amazon Bedrock reranker.
     * </p>
     * 
     * @return Contains configurations for an Amazon Bedrock reranker.
     */
    public final BedrockRerankingConfiguration bedrockRerankingConfiguration() {
        return bedrockRerankingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(bedrockRerankingConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RerankingConfiguration)) {
            return false;
        }
        RerankingConfiguration other = (RerankingConfiguration) obj;
        return Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(bedrockRerankingConfiguration(), other.bedrockRerankingConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RerankingConfiguration").add("Type", typeAsString())
                .add("BedrockRerankingConfiguration", bedrockRerankingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "bedrockRerankingConfiguration":
            return Optional.ofNullable(clazz.cast(bedrockRerankingConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("bedrockRerankingConfiguration", BEDROCK_RERANKING_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RerankingConfiguration, T> g) {
        return obj -> g.apply((RerankingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RerankingConfiguration> {
        /**
         * <p>
         * The type of reranker that the configurations apply to.
         * </p>
         * 
         * @param type
         *        The type of reranker that the configurations apply to.
         * @see RerankingConfigurationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RerankingConfigurationType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of reranker that the configurations apply to.
         * </p>
         * 
         * @param type
         *        The type of reranker that the configurations apply to.
         * @see RerankingConfigurationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RerankingConfigurationType
         */
        Builder type(RerankingConfigurationType type);

        /**
         * <p>
         * Contains configurations for an Amazon Bedrock reranker.
         * </p>
         * 
         * @param bedrockRerankingConfiguration
         *        Contains configurations for an Amazon Bedrock reranker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bedrockRerankingConfiguration(BedrockRerankingConfiguration bedrockRerankingConfiguration);

        /**
         * <p>
         * Contains configurations for an Amazon Bedrock reranker.
         * </p>
         * This is a convenience method that creates an instance of the {@link BedrockRerankingConfiguration.Builder}
         * avoiding the need to create one manually via {@link BedrockRerankingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BedrockRerankingConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #bedrockRerankingConfiguration(BedrockRerankingConfiguration)}.
         * 
         * @param bedrockRerankingConfiguration
         *        a consumer that will call methods on {@link BedrockRerankingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bedrockRerankingConfiguration(BedrockRerankingConfiguration)
         */
        default Builder bedrockRerankingConfiguration(
                Consumer<BedrockRerankingConfiguration.Builder> bedrockRerankingConfiguration) {
            return bedrockRerankingConfiguration(BedrockRerankingConfiguration.builder()
                    .applyMutation(bedrockRerankingConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private BedrockRerankingConfiguration bedrockRerankingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(RerankingConfiguration model) {
            type(model.type);
            bedrockRerankingConfiguration(model.bedrockRerankingConfiguration);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RerankingConfigurationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final BedrockRerankingConfiguration.Builder getBedrockRerankingConfiguration() {
            return bedrockRerankingConfiguration != null ? bedrockRerankingConfiguration.toBuilder() : null;
        }

        public final void setBedrockRerankingConfiguration(BedrockRerankingConfiguration.BuilderImpl bedrockRerankingConfiguration) {
            this.bedrockRerankingConfiguration = bedrockRerankingConfiguration != null ? bedrockRerankingConfiguration.build()
                    : null;
        }

        @Override
        public final Builder bedrockRerankingConfiguration(BedrockRerankingConfiguration bedrockRerankingConfiguration) {
            this.bedrockRerankingConfiguration = bedrockRerankingConfiguration;
            return this;
        }

        @Override
        public RerankingConfiguration build() {
            return new RerankingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
