/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the data source location.
 * </p>
 * <p>
 * This data type is used in the following API operations:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href=
 * "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_ResponseSyntax"
 * >Retrieve response</a> – in the <code>location</code> field
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href=
 * "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_ResponseSyntax"
 * >RetrieveAndGenerate response</a> – in the <code>location</code> field
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href=
 * "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax"
 * >InvokeAgent response</a> – in the <code>location</code> field
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetrievalResultLocation implements SdkPojo, Serializable,
        ToCopyableBuilder<RetrievalResultLocation.Builder, RetrievalResultLocation> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(RetrievalResultLocation::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<RetrievalResultS3Location> S3_LOCATION_FIELD = SdkField
            .<RetrievalResultS3Location> builder(MarshallingType.SDK_POJO).memberName("s3Location")
            .getter(getter(RetrievalResultLocation::s3Location)).setter(setter(Builder::s3Location))
            .constructor(RetrievalResultS3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Location").build()).build();

    private static final SdkField<RetrievalResultWebLocation> WEB_LOCATION_FIELD = SdkField
            .<RetrievalResultWebLocation> builder(MarshallingType.SDK_POJO).memberName("webLocation")
            .getter(getter(RetrievalResultLocation::webLocation)).setter(setter(Builder::webLocation))
            .constructor(RetrievalResultWebLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("webLocation").build()).build();

    private static final SdkField<RetrievalResultConfluenceLocation> CONFLUENCE_LOCATION_FIELD = SdkField
            .<RetrievalResultConfluenceLocation> builder(MarshallingType.SDK_POJO).memberName("confluenceLocation")
            .getter(getter(RetrievalResultLocation::confluenceLocation)).setter(setter(Builder::confluenceLocation))
            .constructor(RetrievalResultConfluenceLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("confluenceLocation").build())
            .build();

    private static final SdkField<RetrievalResultSalesforceLocation> SALESFORCE_LOCATION_FIELD = SdkField
            .<RetrievalResultSalesforceLocation> builder(MarshallingType.SDK_POJO).memberName("salesforceLocation")
            .getter(getter(RetrievalResultLocation::salesforceLocation)).setter(setter(Builder::salesforceLocation))
            .constructor(RetrievalResultSalesforceLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("salesforceLocation").build())
            .build();

    private static final SdkField<RetrievalResultSharePointLocation> SHARE_POINT_LOCATION_FIELD = SdkField
            .<RetrievalResultSharePointLocation> builder(MarshallingType.SDK_POJO).memberName("sharePointLocation")
            .getter(getter(RetrievalResultLocation::sharePointLocation)).setter(setter(Builder::sharePointLocation))
            .constructor(RetrievalResultSharePointLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sharePointLocation").build())
            .build();

    private static final SdkField<RetrievalResultCustomDocumentLocation> CUSTOM_DOCUMENT_LOCATION_FIELD = SdkField
            .<RetrievalResultCustomDocumentLocation> builder(MarshallingType.SDK_POJO).memberName("customDocumentLocation")
            .getter(getter(RetrievalResultLocation::customDocumentLocation)).setter(setter(Builder::customDocumentLocation))
            .constructor(RetrievalResultCustomDocumentLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDocumentLocation").build())
            .build();

    private static final SdkField<RetrievalResultKendraDocumentLocation> KENDRA_DOCUMENT_LOCATION_FIELD = SdkField
            .<RetrievalResultKendraDocumentLocation> builder(MarshallingType.SDK_POJO).memberName("kendraDocumentLocation")
            .getter(getter(RetrievalResultLocation::kendraDocumentLocation)).setter(setter(Builder::kendraDocumentLocation))
            .constructor(RetrievalResultKendraDocumentLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kendraDocumentLocation").build())
            .build();

    private static final SdkField<RetrievalResultSqlLocation> SQL_LOCATION_FIELD = SdkField
            .<RetrievalResultSqlLocation> builder(MarshallingType.SDK_POJO).memberName("sqlLocation")
            .getter(getter(RetrievalResultLocation::sqlLocation)).setter(setter(Builder::sqlLocation))
            .constructor(RetrievalResultSqlLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sqlLocation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, S3_LOCATION_FIELD,
            WEB_LOCATION_FIELD, CONFLUENCE_LOCATION_FIELD, SALESFORCE_LOCATION_FIELD, SHARE_POINT_LOCATION_FIELD,
            CUSTOM_DOCUMENT_LOCATION_FIELD, KENDRA_DOCUMENT_LOCATION_FIELD, SQL_LOCATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final RetrievalResultS3Location s3Location;

    private final RetrievalResultWebLocation webLocation;

    private final RetrievalResultConfluenceLocation confluenceLocation;

    private final RetrievalResultSalesforceLocation salesforceLocation;

    private final RetrievalResultSharePointLocation sharePointLocation;

    private final RetrievalResultCustomDocumentLocation customDocumentLocation;

    private final RetrievalResultKendraDocumentLocation kendraDocumentLocation;

    private final RetrievalResultSqlLocation sqlLocation;

    private RetrievalResultLocation(BuilderImpl builder) {
        this.type = builder.type;
        this.s3Location = builder.s3Location;
        this.webLocation = builder.webLocation;
        this.confluenceLocation = builder.confluenceLocation;
        this.salesforceLocation = builder.salesforceLocation;
        this.sharePointLocation = builder.sharePointLocation;
        this.customDocumentLocation = builder.customDocumentLocation;
        this.kendraDocumentLocation = builder.kendraDocumentLocation;
        this.sqlLocation = builder.sqlLocation;
    }

    /**
     * <p>
     * The type of data source location.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RetrievalResultLocationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of data source location.
     * @see RetrievalResultLocationType
     */
    public final RetrievalResultLocationType type() {
        return RetrievalResultLocationType.fromValue(type);
    }

    /**
     * <p>
     * The type of data source location.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RetrievalResultLocationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of data source location.
     * @see RetrievalResultLocationType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The S3 data source location.
     * </p>
     * 
     * @return The S3 data source location.
     */
    public final RetrievalResultS3Location s3Location() {
        return s3Location;
    }

    /**
     * <p>
     * The web URL/URLs data source location.
     * </p>
     * 
     * @return The web URL/URLs data source location.
     */
    public final RetrievalResultWebLocation webLocation() {
        return webLocation;
    }

    /**
     * <p>
     * The Confluence data source location.
     * </p>
     * 
     * @return The Confluence data source location.
     */
    public final RetrievalResultConfluenceLocation confluenceLocation() {
        return confluenceLocation;
    }

    /**
     * <p>
     * The Salesforce data source location.
     * </p>
     * 
     * @return The Salesforce data source location.
     */
    public final RetrievalResultSalesforceLocation salesforceLocation() {
        return salesforceLocation;
    }

    /**
     * <p>
     * The SharePoint data source location.
     * </p>
     * 
     * @return The SharePoint data source location.
     */
    public final RetrievalResultSharePointLocation sharePointLocation() {
        return sharePointLocation;
    }

    /**
     * <p>
     * Specifies the location of a document in a custom data source.
     * </p>
     * 
     * @return Specifies the location of a document in a custom data source.
     */
    public final RetrievalResultCustomDocumentLocation customDocumentLocation() {
        return customDocumentLocation;
    }

    /**
     * <p>
     * The location of a document in Amazon Kendra.
     * </p>
     * 
     * @return The location of a document in Amazon Kendra.
     */
    public final RetrievalResultKendraDocumentLocation kendraDocumentLocation() {
        return kendraDocumentLocation;
    }

    /**
     * <p>
     * Specifies information about the SQL query used to retrieve the result.
     * </p>
     * 
     * @return Specifies information about the SQL query used to retrieve the result.
     */
    public final RetrievalResultSqlLocation sqlLocation() {
        return sqlLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3Location());
        hashCode = 31 * hashCode + Objects.hashCode(webLocation());
        hashCode = 31 * hashCode + Objects.hashCode(confluenceLocation());
        hashCode = 31 * hashCode + Objects.hashCode(salesforceLocation());
        hashCode = 31 * hashCode + Objects.hashCode(sharePointLocation());
        hashCode = 31 * hashCode + Objects.hashCode(customDocumentLocation());
        hashCode = 31 * hashCode + Objects.hashCode(kendraDocumentLocation());
        hashCode = 31 * hashCode + Objects.hashCode(sqlLocation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrievalResultLocation)) {
            return false;
        }
        RetrievalResultLocation other = (RetrievalResultLocation) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(s3Location(), other.s3Location())
                && Objects.equals(webLocation(), other.webLocation())
                && Objects.equals(confluenceLocation(), other.confluenceLocation())
                && Objects.equals(salesforceLocation(), other.salesforceLocation())
                && Objects.equals(sharePointLocation(), other.sharePointLocation())
                && Objects.equals(customDocumentLocation(), other.customDocumentLocation())
                && Objects.equals(kendraDocumentLocation(), other.kendraDocumentLocation())
                && Objects.equals(sqlLocation(), other.sqlLocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RetrievalResultLocation").add("Type", typeAsString()).add("S3Location", s3Location())
                .add("WebLocation", webLocation()).add("ConfluenceLocation", confluenceLocation())
                .add("SalesforceLocation", salesforceLocation()).add("SharePointLocation", sharePointLocation())
                .add("CustomDocumentLocation", customDocumentLocation()).add("KendraDocumentLocation", kendraDocumentLocation())
                .add("SqlLocation", sqlLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "s3Location":
            return Optional.ofNullable(clazz.cast(s3Location()));
        case "webLocation":
            return Optional.ofNullable(clazz.cast(webLocation()));
        case "confluenceLocation":
            return Optional.ofNullable(clazz.cast(confluenceLocation()));
        case "salesforceLocation":
            return Optional.ofNullable(clazz.cast(salesforceLocation()));
        case "sharePointLocation":
            return Optional.ofNullable(clazz.cast(sharePointLocation()));
        case "customDocumentLocation":
            return Optional.ofNullable(clazz.cast(customDocumentLocation()));
        case "kendraDocumentLocation":
            return Optional.ofNullable(clazz.cast(kendraDocumentLocation()));
        case "sqlLocation":
            return Optional.ofNullable(clazz.cast(sqlLocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("s3Location", S3_LOCATION_FIELD);
        map.put("webLocation", WEB_LOCATION_FIELD);
        map.put("confluenceLocation", CONFLUENCE_LOCATION_FIELD);
        map.put("salesforceLocation", SALESFORCE_LOCATION_FIELD);
        map.put("sharePointLocation", SHARE_POINT_LOCATION_FIELD);
        map.put("customDocumentLocation", CUSTOM_DOCUMENT_LOCATION_FIELD);
        map.put("kendraDocumentLocation", KENDRA_DOCUMENT_LOCATION_FIELD);
        map.put("sqlLocation", SQL_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RetrievalResultLocation, T> g) {
        return obj -> g.apply((RetrievalResultLocation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RetrievalResultLocation> {
        /**
         * <p>
         * The type of data source location.
         * </p>
         * 
         * @param type
         *        The type of data source location.
         * @see RetrievalResultLocationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetrievalResultLocationType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of data source location.
         * </p>
         * 
         * @param type
         *        The type of data source location.
         * @see RetrievalResultLocationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetrievalResultLocationType
         */
        Builder type(RetrievalResultLocationType type);

        /**
         * <p>
         * The S3 data source location.
         * </p>
         * 
         * @param s3Location
         *        The S3 data source location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Location(RetrievalResultS3Location s3Location);

        /**
         * <p>
         * The S3 data source location.
         * </p>
         * This is a convenience method that creates an instance of the {@link RetrievalResultS3Location.Builder}
         * avoiding the need to create one manually via {@link RetrievalResultS3Location#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetrievalResultS3Location.Builder#build()} is called immediately
         * and its result is passed to {@link #s3Location(RetrievalResultS3Location)}.
         * 
         * @param s3Location
         *        a consumer that will call methods on {@link RetrievalResultS3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Location(RetrievalResultS3Location)
         */
        default Builder s3Location(Consumer<RetrievalResultS3Location.Builder> s3Location) {
            return s3Location(RetrievalResultS3Location.builder().applyMutation(s3Location).build());
        }

        /**
         * <p>
         * The web URL/URLs data source location.
         * </p>
         * 
         * @param webLocation
         *        The web URL/URLs data source location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webLocation(RetrievalResultWebLocation webLocation);

        /**
         * <p>
         * The web URL/URLs data source location.
         * </p>
         * This is a convenience method that creates an instance of the {@link RetrievalResultWebLocation.Builder}
         * avoiding the need to create one manually via {@link RetrievalResultWebLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetrievalResultWebLocation.Builder#build()} is called immediately
         * and its result is passed to {@link #webLocation(RetrievalResultWebLocation)}.
         * 
         * @param webLocation
         *        a consumer that will call methods on {@link RetrievalResultWebLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #webLocation(RetrievalResultWebLocation)
         */
        default Builder webLocation(Consumer<RetrievalResultWebLocation.Builder> webLocation) {
            return webLocation(RetrievalResultWebLocation.builder().applyMutation(webLocation).build());
        }

        /**
         * <p>
         * The Confluence data source location.
         * </p>
         * 
         * @param confluenceLocation
         *        The Confluence data source location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confluenceLocation(RetrievalResultConfluenceLocation confluenceLocation);

        /**
         * <p>
         * The Confluence data source location.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RetrievalResultConfluenceLocation.Builder} avoiding the need to create one manually via
         * {@link RetrievalResultConfluenceLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetrievalResultConfluenceLocation.Builder#build()} is called
         * immediately and its result is passed to {@link #confluenceLocation(RetrievalResultConfluenceLocation)}.
         * 
         * @param confluenceLocation
         *        a consumer that will call methods on {@link RetrievalResultConfluenceLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #confluenceLocation(RetrievalResultConfluenceLocation)
         */
        default Builder confluenceLocation(Consumer<RetrievalResultConfluenceLocation.Builder> confluenceLocation) {
            return confluenceLocation(RetrievalResultConfluenceLocation.builder().applyMutation(confluenceLocation).build());
        }

        /**
         * <p>
         * The Salesforce data source location.
         * </p>
         * 
         * @param salesforceLocation
         *        The Salesforce data source location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder salesforceLocation(RetrievalResultSalesforceLocation salesforceLocation);

        /**
         * <p>
         * The Salesforce data source location.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RetrievalResultSalesforceLocation.Builder} avoiding the need to create one manually via
         * {@link RetrievalResultSalesforceLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetrievalResultSalesforceLocation.Builder#build()} is called
         * immediately and its result is passed to {@link #salesforceLocation(RetrievalResultSalesforceLocation)}.
         * 
         * @param salesforceLocation
         *        a consumer that will call methods on {@link RetrievalResultSalesforceLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #salesforceLocation(RetrievalResultSalesforceLocation)
         */
        default Builder salesforceLocation(Consumer<RetrievalResultSalesforceLocation.Builder> salesforceLocation) {
            return salesforceLocation(RetrievalResultSalesforceLocation.builder().applyMutation(salesforceLocation).build());
        }

        /**
         * <p>
         * The SharePoint data source location.
         * </p>
         * 
         * @param sharePointLocation
         *        The SharePoint data source location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharePointLocation(RetrievalResultSharePointLocation sharePointLocation);

        /**
         * <p>
         * The SharePoint data source location.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RetrievalResultSharePointLocation.Builder} avoiding the need to create one manually via
         * {@link RetrievalResultSharePointLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetrievalResultSharePointLocation.Builder#build()} is called
         * immediately and its result is passed to {@link #sharePointLocation(RetrievalResultSharePointLocation)}.
         * 
         * @param sharePointLocation
         *        a consumer that will call methods on {@link RetrievalResultSharePointLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sharePointLocation(RetrievalResultSharePointLocation)
         */
        default Builder sharePointLocation(Consumer<RetrievalResultSharePointLocation.Builder> sharePointLocation) {
            return sharePointLocation(RetrievalResultSharePointLocation.builder().applyMutation(sharePointLocation).build());
        }

        /**
         * <p>
         * Specifies the location of a document in a custom data source.
         * </p>
         * 
         * @param customDocumentLocation
         *        Specifies the location of a document in a custom data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDocumentLocation(RetrievalResultCustomDocumentLocation customDocumentLocation);

        /**
         * <p>
         * Specifies the location of a document in a custom data source.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RetrievalResultCustomDocumentLocation.Builder} avoiding the need to create one manually via
         * {@link RetrievalResultCustomDocumentLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetrievalResultCustomDocumentLocation.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #customDocumentLocation(RetrievalResultCustomDocumentLocation)}.
         * 
         * @param customDocumentLocation
         *        a consumer that will call methods on {@link RetrievalResultCustomDocumentLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customDocumentLocation(RetrievalResultCustomDocumentLocation)
         */
        default Builder customDocumentLocation(Consumer<RetrievalResultCustomDocumentLocation.Builder> customDocumentLocation) {
            return customDocumentLocation(RetrievalResultCustomDocumentLocation.builder().applyMutation(customDocumentLocation)
                    .build());
        }

        /**
         * <p>
         * The location of a document in Amazon Kendra.
         * </p>
         * 
         * @param kendraDocumentLocation
         *        The location of a document in Amazon Kendra.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kendraDocumentLocation(RetrievalResultKendraDocumentLocation kendraDocumentLocation);

        /**
         * <p>
         * The location of a document in Amazon Kendra.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RetrievalResultKendraDocumentLocation.Builder} avoiding the need to create one manually via
         * {@link RetrievalResultKendraDocumentLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetrievalResultKendraDocumentLocation.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #kendraDocumentLocation(RetrievalResultKendraDocumentLocation)}.
         * 
         * @param kendraDocumentLocation
         *        a consumer that will call methods on {@link RetrievalResultKendraDocumentLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kendraDocumentLocation(RetrievalResultKendraDocumentLocation)
         */
        default Builder kendraDocumentLocation(Consumer<RetrievalResultKendraDocumentLocation.Builder> kendraDocumentLocation) {
            return kendraDocumentLocation(RetrievalResultKendraDocumentLocation.builder().applyMutation(kendraDocumentLocation)
                    .build());
        }

        /**
         * <p>
         * Specifies information about the SQL query used to retrieve the result.
         * </p>
         * 
         * @param sqlLocation
         *        Specifies information about the SQL query used to retrieve the result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqlLocation(RetrievalResultSqlLocation sqlLocation);

        /**
         * <p>
         * Specifies information about the SQL query used to retrieve the result.
         * </p>
         * This is a convenience method that creates an instance of the {@link RetrievalResultSqlLocation.Builder}
         * avoiding the need to create one manually via {@link RetrievalResultSqlLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetrievalResultSqlLocation.Builder#build()} is called immediately
         * and its result is passed to {@link #sqlLocation(RetrievalResultSqlLocation)}.
         * 
         * @param sqlLocation
         *        a consumer that will call methods on {@link RetrievalResultSqlLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sqlLocation(RetrievalResultSqlLocation)
         */
        default Builder sqlLocation(Consumer<RetrievalResultSqlLocation.Builder> sqlLocation) {
            return sqlLocation(RetrievalResultSqlLocation.builder().applyMutation(sqlLocation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private RetrievalResultS3Location s3Location;

        private RetrievalResultWebLocation webLocation;

        private RetrievalResultConfluenceLocation confluenceLocation;

        private RetrievalResultSalesforceLocation salesforceLocation;

        private RetrievalResultSharePointLocation sharePointLocation;

        private RetrievalResultCustomDocumentLocation customDocumentLocation;

        private RetrievalResultKendraDocumentLocation kendraDocumentLocation;

        private RetrievalResultSqlLocation sqlLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(RetrievalResultLocation model) {
            type(model.type);
            s3Location(model.s3Location);
            webLocation(model.webLocation);
            confluenceLocation(model.confluenceLocation);
            salesforceLocation(model.salesforceLocation);
            sharePointLocation(model.sharePointLocation);
            customDocumentLocation(model.customDocumentLocation);
            kendraDocumentLocation(model.kendraDocumentLocation);
            sqlLocation(model.sqlLocation);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RetrievalResultLocationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final RetrievalResultS3Location.Builder getS3Location() {
            return s3Location != null ? s3Location.toBuilder() : null;
        }

        public final void setS3Location(RetrievalResultS3Location.BuilderImpl s3Location) {
            this.s3Location = s3Location != null ? s3Location.build() : null;
        }

        @Override
        public final Builder s3Location(RetrievalResultS3Location s3Location) {
            this.s3Location = s3Location;
            return this;
        }

        public final RetrievalResultWebLocation.Builder getWebLocation() {
            return webLocation != null ? webLocation.toBuilder() : null;
        }

        public final void setWebLocation(RetrievalResultWebLocation.BuilderImpl webLocation) {
            this.webLocation = webLocation != null ? webLocation.build() : null;
        }

        @Override
        public final Builder webLocation(RetrievalResultWebLocation webLocation) {
            this.webLocation = webLocation;
            return this;
        }

        public final RetrievalResultConfluenceLocation.Builder getConfluenceLocation() {
            return confluenceLocation != null ? confluenceLocation.toBuilder() : null;
        }

        public final void setConfluenceLocation(RetrievalResultConfluenceLocation.BuilderImpl confluenceLocation) {
            this.confluenceLocation = confluenceLocation != null ? confluenceLocation.build() : null;
        }

        @Override
        public final Builder confluenceLocation(RetrievalResultConfluenceLocation confluenceLocation) {
            this.confluenceLocation = confluenceLocation;
            return this;
        }

        public final RetrievalResultSalesforceLocation.Builder getSalesforceLocation() {
            return salesforceLocation != null ? salesforceLocation.toBuilder() : null;
        }

        public final void setSalesforceLocation(RetrievalResultSalesforceLocation.BuilderImpl salesforceLocation) {
            this.salesforceLocation = salesforceLocation != null ? salesforceLocation.build() : null;
        }

        @Override
        public final Builder salesforceLocation(RetrievalResultSalesforceLocation salesforceLocation) {
            this.salesforceLocation = salesforceLocation;
            return this;
        }

        public final RetrievalResultSharePointLocation.Builder getSharePointLocation() {
            return sharePointLocation != null ? sharePointLocation.toBuilder() : null;
        }

        public final void setSharePointLocation(RetrievalResultSharePointLocation.BuilderImpl sharePointLocation) {
            this.sharePointLocation = sharePointLocation != null ? sharePointLocation.build() : null;
        }

        @Override
        public final Builder sharePointLocation(RetrievalResultSharePointLocation sharePointLocation) {
            this.sharePointLocation = sharePointLocation;
            return this;
        }

        public final RetrievalResultCustomDocumentLocation.Builder getCustomDocumentLocation() {
            return customDocumentLocation != null ? customDocumentLocation.toBuilder() : null;
        }

        public final void setCustomDocumentLocation(RetrievalResultCustomDocumentLocation.BuilderImpl customDocumentLocation) {
            this.customDocumentLocation = customDocumentLocation != null ? customDocumentLocation.build() : null;
        }

        @Override
        public final Builder customDocumentLocation(RetrievalResultCustomDocumentLocation customDocumentLocation) {
            this.customDocumentLocation = customDocumentLocation;
            return this;
        }

        public final RetrievalResultKendraDocumentLocation.Builder getKendraDocumentLocation() {
            return kendraDocumentLocation != null ? kendraDocumentLocation.toBuilder() : null;
        }

        public final void setKendraDocumentLocation(RetrievalResultKendraDocumentLocation.BuilderImpl kendraDocumentLocation) {
            this.kendraDocumentLocation = kendraDocumentLocation != null ? kendraDocumentLocation.build() : null;
        }

        @Override
        public final Builder kendraDocumentLocation(RetrievalResultKendraDocumentLocation kendraDocumentLocation) {
            this.kendraDocumentLocation = kendraDocumentLocation;
            return this;
        }

        public final RetrievalResultSqlLocation.Builder getSqlLocation() {
            return sqlLocation != null ? sqlLocation.toBuilder() : null;
        }

        public final void setSqlLocation(RetrievalResultSqlLocation.BuilderImpl sqlLocation) {
            this.sqlLocation = sqlLocation != null ? sqlLocation.build() : null;
        }

        @Override
        public final Builder sqlLocation(RetrievalResultSqlLocation sqlLocation) {
            this.sqlLocation = sqlLocation;
            return this;
        }

        @Override
        public RetrievalResultLocation build() {
            return new RetrievalResultLocation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
