/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetrieveAndGenerateStreamRequest extends BedrockAgentRuntimeRequest implements
        ToCopyableBuilder<RetrieveAndGenerateStreamRequest.Builder, RetrieveAndGenerateStreamRequest> {
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(RetrieveAndGenerateStreamRequest::sessionId))
            .setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()).build();

    private static final SdkField<RetrieveAndGenerateInput> INPUT_FIELD = SdkField
            .<RetrieveAndGenerateInput> builder(MarshallingType.SDK_POJO).memberName("input")
            .getter(getter(RetrieveAndGenerateStreamRequest::input)).setter(setter(Builder::input))
            .constructor(RetrieveAndGenerateInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()).build();

    private static final SdkField<RetrieveAndGenerateConfiguration> RETRIEVE_AND_GENERATE_CONFIGURATION_FIELD = SdkField
            .<RetrieveAndGenerateConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("retrieveAndGenerateConfiguration")
            .getter(getter(RetrieveAndGenerateStreamRequest::retrieveAndGenerateConfiguration))
            .setter(setter(Builder::retrieveAndGenerateConfiguration))
            .constructor(RetrieveAndGenerateConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retrieveAndGenerateConfiguration")
                    .build()).build();

    private static final SdkField<RetrieveAndGenerateSessionConfiguration> SESSION_CONFIGURATION_FIELD = SdkField
            .<RetrieveAndGenerateSessionConfiguration> builder(MarshallingType.SDK_POJO).memberName("sessionConfiguration")
            .getter(getter(RetrieveAndGenerateStreamRequest::sessionConfiguration)).setter(setter(Builder::sessionConfiguration))
            .constructor(RetrieveAndGenerateSessionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ID_FIELD, INPUT_FIELD,
            RETRIEVE_AND_GENERATE_CONFIGURATION_FIELD, SESSION_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String sessionId;

    private final RetrieveAndGenerateInput input;

    private final RetrieveAndGenerateConfiguration retrieveAndGenerateConfiguration;

    private final RetrieveAndGenerateSessionConfiguration sessionConfiguration;

    private RetrieveAndGenerateStreamRequest(BuilderImpl builder) {
        super(builder);
        this.sessionId = builder.sessionId;
        this.input = builder.input;
        this.retrieveAndGenerateConfiguration = builder.retrieveAndGenerateConfiguration;
        this.sessionConfiguration = builder.sessionConfiguration;
    }

    /**
     * <p>
     * The unique identifier of the session. When you first make a <code>RetrieveAndGenerate</code> request, Amazon
     * Bedrock automatically generates this value. You must reuse this value for all subsequent requests in the same
     * conversational session. This value allows Amazon Bedrock to maintain context and knowledge from previous
     * interactions. You can't explicitly set the <code>sessionId</code> yourself.
     * </p>
     * 
     * @return The unique identifier of the session. When you first make a <code>RetrieveAndGenerate</code> request,
     *         Amazon Bedrock automatically generates this value. You must reuse this value for all subsequent requests
     *         in the same conversational session. This value allows Amazon Bedrock to maintain context and knowledge
     *         from previous interactions. You can't explicitly set the <code>sessionId</code> yourself.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * Contains the query to be made to the knowledge base.
     * </p>
     * 
     * @return Contains the query to be made to the knowledge base.
     */
    public final RetrieveAndGenerateInput input() {
        return input;
    }

    /**
     * <p>
     * Contains configurations for the knowledge base query and retrieval process. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html">Query configurations</a>.
     * </p>
     * 
     * @return Contains configurations for the knowledge base query and retrieval process. For more information, see <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html">Query configurations</a>.
     */
    public final RetrieveAndGenerateConfiguration retrieveAndGenerateConfiguration() {
        return retrieveAndGenerateConfiguration;
    }

    /**
     * <p>
     * Contains details about the session with the knowledge base.
     * </p>
     * 
     * @return Contains details about the session with the knowledge base.
     */
    public final RetrieveAndGenerateSessionConfiguration sessionConfiguration() {
        return sessionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(input());
        hashCode = 31 * hashCode + Objects.hashCode(retrieveAndGenerateConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(sessionConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrieveAndGenerateStreamRequest)) {
            return false;
        }
        RetrieveAndGenerateStreamRequest other = (RetrieveAndGenerateStreamRequest) obj;
        return Objects.equals(sessionId(), other.sessionId()) && Objects.equals(input(), other.input())
                && Objects.equals(retrieveAndGenerateConfiguration(), other.retrieveAndGenerateConfiguration())
                && Objects.equals(sessionConfiguration(), other.sessionConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RetrieveAndGenerateStreamRequest").add("SessionId", sessionId())
                .add("Input", input() == null ? null : "*** Sensitive Data Redacted ***")
                .add("RetrieveAndGenerateConfiguration", retrieveAndGenerateConfiguration())
                .add("SessionConfiguration", sessionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "input":
            return Optional.ofNullable(clazz.cast(input()));
        case "retrieveAndGenerateConfiguration":
            return Optional.ofNullable(clazz.cast(retrieveAndGenerateConfiguration()));
        case "sessionConfiguration":
            return Optional.ofNullable(clazz.cast(sessionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("input", INPUT_FIELD);
        map.put("retrieveAndGenerateConfiguration", RETRIEVE_AND_GENERATE_CONFIGURATION_FIELD);
        map.put("sessionConfiguration", SESSION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RetrieveAndGenerateStreamRequest, T> g) {
        return obj -> g.apply((RetrieveAndGenerateStreamRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentRuntimeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, RetrieveAndGenerateStreamRequest> {
        /**
         * <p>
         * The unique identifier of the session. When you first make a <code>RetrieveAndGenerate</code> request, Amazon
         * Bedrock automatically generates this value. You must reuse this value for all subsequent requests in the same
         * conversational session. This value allows Amazon Bedrock to maintain context and knowledge from previous
         * interactions. You can't explicitly set the <code>sessionId</code> yourself.
         * </p>
         * 
         * @param sessionId
         *        The unique identifier of the session. When you first make a <code>RetrieveAndGenerate</code> request,
         *        Amazon Bedrock automatically generates this value. You must reuse this value for all subsequent
         *        requests in the same conversational session. This value allows Amazon Bedrock to maintain context and
         *        knowledge from previous interactions. You can't explicitly set the <code>sessionId</code> yourself.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * Contains the query to be made to the knowledge base.
         * </p>
         * 
         * @param input
         *        Contains the query to be made to the knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(RetrieveAndGenerateInput input);

        /**
         * <p>
         * Contains the query to be made to the knowledge base.
         * </p>
         * This is a convenience method that creates an instance of the {@link RetrieveAndGenerateInput.Builder}
         * avoiding the need to create one manually via {@link RetrieveAndGenerateInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetrieveAndGenerateInput.Builder#build()} is called immediately
         * and its result is passed to {@link #input(RetrieveAndGenerateInput)}.
         * 
         * @param input
         *        a consumer that will call methods on {@link RetrieveAndGenerateInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #input(RetrieveAndGenerateInput)
         */
        default Builder input(Consumer<RetrieveAndGenerateInput.Builder> input) {
            return input(RetrieveAndGenerateInput.builder().applyMutation(input).build());
        }

        /**
         * <p>
         * Contains configurations for the knowledge base query and retrieval process. For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html">Query configurations</a>.
         * </p>
         * 
         * @param retrieveAndGenerateConfiguration
         *        Contains configurations for the knowledge base query and retrieval process. For more information, see
         *        <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html">Query
         *        configurations</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retrieveAndGenerateConfiguration(RetrieveAndGenerateConfiguration retrieveAndGenerateConfiguration);

        /**
         * <p>
         * Contains configurations for the knowledge base query and retrieval process. For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html">Query configurations</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link RetrieveAndGenerateConfiguration.Builder}
         * avoiding the need to create one manually via {@link RetrieveAndGenerateConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetrieveAndGenerateConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #retrieveAndGenerateConfiguration(RetrieveAndGenerateConfiguration)}.
         * 
         * @param retrieveAndGenerateConfiguration
         *        a consumer that will call methods on {@link RetrieveAndGenerateConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retrieveAndGenerateConfiguration(RetrieveAndGenerateConfiguration)
         */
        default Builder retrieveAndGenerateConfiguration(
                Consumer<RetrieveAndGenerateConfiguration.Builder> retrieveAndGenerateConfiguration) {
            return retrieveAndGenerateConfiguration(RetrieveAndGenerateConfiguration.builder()
                    .applyMutation(retrieveAndGenerateConfiguration).build());
        }

        /**
         * <p>
         * Contains details about the session with the knowledge base.
         * </p>
         * 
         * @param sessionConfiguration
         *        Contains details about the session with the knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionConfiguration(RetrieveAndGenerateSessionConfiguration sessionConfiguration);

        /**
         * <p>
         * Contains details about the session with the knowledge base.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RetrieveAndGenerateSessionConfiguration.Builder} avoiding the need to create one manually via
         * {@link RetrieveAndGenerateSessionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetrieveAndGenerateSessionConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #sessionConfiguration(RetrieveAndGenerateSessionConfiguration)}.
         * 
         * @param sessionConfiguration
         *        a consumer that will call methods on {@link RetrieveAndGenerateSessionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sessionConfiguration(RetrieveAndGenerateSessionConfiguration)
         */
        default Builder sessionConfiguration(Consumer<RetrieveAndGenerateSessionConfiguration.Builder> sessionConfiguration) {
            return sessionConfiguration(RetrieveAndGenerateSessionConfiguration.builder().applyMutation(sessionConfiguration)
                    .build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentRuntimeRequest.BuilderImpl implements Builder {
        private String sessionId;

        private RetrieveAndGenerateInput input;

        private RetrieveAndGenerateConfiguration retrieveAndGenerateConfiguration;

        private RetrieveAndGenerateSessionConfiguration sessionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(RetrieveAndGenerateStreamRequest model) {
            super(model);
            sessionId(model.sessionId);
            input(model.input);
            retrieveAndGenerateConfiguration(model.retrieveAndGenerateConfiguration);
            sessionConfiguration(model.sessionConfiguration);
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final RetrieveAndGenerateInput.Builder getInput() {
            return input != null ? input.toBuilder() : null;
        }

        public final void setInput(RetrieveAndGenerateInput.BuilderImpl input) {
            this.input = input != null ? input.build() : null;
        }

        @Override
        public final Builder input(RetrieveAndGenerateInput input) {
            this.input = input;
            return this;
        }

        public final RetrieveAndGenerateConfiguration.Builder getRetrieveAndGenerateConfiguration() {
            return retrieveAndGenerateConfiguration != null ? retrieveAndGenerateConfiguration.toBuilder() : null;
        }

        public final void setRetrieveAndGenerateConfiguration(
                RetrieveAndGenerateConfiguration.BuilderImpl retrieveAndGenerateConfiguration) {
            this.retrieveAndGenerateConfiguration = retrieveAndGenerateConfiguration != null ? retrieveAndGenerateConfiguration
                    .build() : null;
        }

        @Override
        public final Builder retrieveAndGenerateConfiguration(RetrieveAndGenerateConfiguration retrieveAndGenerateConfiguration) {
            this.retrieveAndGenerateConfiguration = retrieveAndGenerateConfiguration;
            return this;
        }

        public final RetrieveAndGenerateSessionConfiguration.Builder getSessionConfiguration() {
            return sessionConfiguration != null ? sessionConfiguration.toBuilder() : null;
        }

        public final void setSessionConfiguration(RetrieveAndGenerateSessionConfiguration.BuilderImpl sessionConfiguration) {
            this.sessionConfiguration = sessionConfiguration != null ? sessionConfiguration.build() : null;
        }

        @Override
        public final Builder sessionConfiguration(RetrieveAndGenerateSessionConfiguration sessionConfiguration) {
            this.sessionConfiguration = sessionConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RetrieveAndGenerateStreamRequest build() {
            return new RetrieveAndGenerateStreamRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
