/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information to return from the action group that the agent has predicted to invoke.
 * </p>
 * <p>
 * This data type is used in the following API operations:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href=
 * "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax"
 * >InvokeAgent response</a>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public class ReturnControlPayload implements SdkPojo, Serializable,
        ToCopyableBuilder<ReturnControlPayload.Builder, ReturnControlPayload>, ResponseStream {
    private static final SdkField<List<InvocationInputMember>> INVOCATION_INPUTS_FIELD = SdkField
            .<List<InvocationInputMember>> builder(MarshallingType.LIST)
            .memberName("invocationInputs")
            .getter(getter(ReturnControlPayload::invocationInputs))
            .setter(setter(Builder::invocationInputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invocationInputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InvocationInputMember> builder(MarshallingType.SDK_POJO)
                                            .constructor(InvocationInputMember::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> INVOCATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("invocationId").getter(getter(ReturnControlPayload::invocationId)).setter(setter(Builder::invocationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invocationId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVOCATION_INPUTS_FIELD,
            INVOCATION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<InvocationInputMember> invocationInputs;

    private final String invocationId;

    protected ReturnControlPayload(BuilderImpl builder) {
        this.invocationInputs = builder.invocationInputs;
        this.invocationId = builder.invocationId;
    }

    /**
     * For responses, this returns true if the service returned a value for the InvocationInputs property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInvocationInputs() {
        return invocationInputs != null && !(invocationInputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of objects that contain information about the parameters and inputs that need to be sent into the API
     * operation or function, based on what the agent determines from its session with the user.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInvocationInputs} method.
     * </p>
     * 
     * @return A list of objects that contain information about the parameters and inputs that need to be sent into the
     *         API operation or function, based on what the agent determines from its session with the user.
     */
    public final List<InvocationInputMember> invocationInputs() {
        return invocationInputs;
    }

    /**
     * <p>
     * The identifier of the action group invocation.
     * </p>
     * 
     * @return The identifier of the action group invocation.
     */
    public final String invocationId() {
        return invocationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasInvocationInputs() ? invocationInputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(invocationId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReturnControlPayload)) {
            return false;
        }
        ReturnControlPayload other = (ReturnControlPayload) obj;
        return hasInvocationInputs() == other.hasInvocationInputs()
                && Objects.equals(invocationInputs(), other.invocationInputs())
                && Objects.equals(invocationId(), other.invocationId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReturnControlPayload")
                .add("InvocationInputs", hasInvocationInputs() ? invocationInputs() : null).add("InvocationId", invocationId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "invocationInputs":
            return Optional.ofNullable(clazz.cast(invocationInputs()));
        case "invocationId":
            return Optional.ofNullable(clazz.cast(invocationId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final ReturnControlPayload copy(Consumer<? super Builder> modifier) {
        return ToCopyableBuilder.super.copy(modifier);
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("invocationInputs", INVOCATION_INPUTS_FIELD);
        map.put("invocationId", INVOCATION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReturnControlPayload, T> g) {
        return obj -> g.apply((ReturnControlPayload) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    /**
     * Calls the appropriate visit method depending on the subtype of {@link ReturnControlPayload}.
     *
     * @param visitor
     *        Visitor to invoke.
     */
    @Override
    public void accept(InvokeAgentResponseHandler.Visitor visitor) {
        throw new UnsupportedOperationException();
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReturnControlPayload> {
        /**
         * <p>
         * A list of objects that contain information about the parameters and inputs that need to be sent into the API
         * operation or function, based on what the agent determines from its session with the user.
         * </p>
         * 
         * @param invocationInputs
         *        A list of objects that contain information about the parameters and inputs that need to be sent into
         *        the API operation or function, based on what the agent determines from its session with the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationInputs(Collection<InvocationInputMember> invocationInputs);

        /**
         * <p>
         * A list of objects that contain information about the parameters and inputs that need to be sent into the API
         * operation or function, based on what the agent determines from its session with the user.
         * </p>
         * 
         * @param invocationInputs
         *        A list of objects that contain information about the parameters and inputs that need to be sent into
         *        the API operation or function, based on what the agent determines from its session with the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationInputs(InvocationInputMember... invocationInputs);

        /**
         * <p>
         * A list of objects that contain information about the parameters and inputs that need to be sent into the API
         * operation or function, based on what the agent determines from its session with the user.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.InvocationInputMember.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.InvocationInputMember#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.InvocationInputMember.Builder#build()} is
         * called immediately and its result is passed to {@link #invocationInputs(List<InvocationInputMember>)}.
         * 
         * @param invocationInputs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.InvocationInputMember.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #invocationInputs(java.util.Collection<InvocationInputMember>)
         */
        Builder invocationInputs(Consumer<InvocationInputMember.Builder>... invocationInputs);

        /**
         * <p>
         * The identifier of the action group invocation.
         * </p>
         * 
         * @param invocationId
         *        The identifier of the action group invocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationId(String invocationId);
    }

    protected static class BuilderImpl implements Builder {
        private List<InvocationInputMember> invocationInputs = DefaultSdkAutoConstructList.getInstance();

        private String invocationId;

        protected BuilderImpl() {
        }

        protected BuilderImpl(ReturnControlPayload model) {
            invocationInputs(model.invocationInputs);
            invocationId(model.invocationId);
        }

        public final List<InvocationInputMember.Builder> getInvocationInputs() {
            List<InvocationInputMember.Builder> result = InvocationInputsCopier.copyToBuilder(this.invocationInputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInvocationInputs(Collection<InvocationInputMember.BuilderImpl> invocationInputs) {
            this.invocationInputs = InvocationInputsCopier.copyFromBuilder(invocationInputs);
        }

        @Override
        public final Builder invocationInputs(Collection<InvocationInputMember> invocationInputs) {
            this.invocationInputs = InvocationInputsCopier.copy(invocationInputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invocationInputs(InvocationInputMember... invocationInputs) {
            invocationInputs(Arrays.asList(invocationInputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invocationInputs(Consumer<InvocationInputMember.Builder>... invocationInputs) {
            invocationInputs(Stream.of(invocationInputs).map(c -> InvocationInputMember.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getInvocationId() {
            return invocationId;
        }

        public final void setInvocationId(String invocationId) {
            this.invocationId = invocationId;
        }

        @Override
        public final Builder invocationId(String invocationId) {
            this.invocationId = invocationId;
            return this;
        }

        @Override
        public ReturnControlPayload build() {
            return new ReturnControlPayload(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
