/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockdataautomation.model.BlueprintStage;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BlueprintSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BlueprintSummary> {
    private static final SdkField<String> BLUEPRINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("blueprintArn").getter(BlueprintSummary.getter(BlueprintSummary::blueprintArn)).setter(BlueprintSummary.setter(Builder::blueprintArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprintArn").build()}).build();
    private static final SdkField<String> BLUEPRINT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("blueprintVersion").getter(BlueprintSummary.getter(BlueprintSummary::blueprintVersion)).setter(BlueprintSummary.setter(Builder::blueprintVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprintVersion").build()}).build();
    private static final SdkField<String> BLUEPRINT_STAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("blueprintStage").getter(BlueprintSummary.getter(BlueprintSummary::blueprintStageAsString)).setter(BlueprintSummary.setter(Builder::blueprintStage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprintStage").build()}).build();
    private static final SdkField<String> BLUEPRINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("blueprintName").getter(BlueprintSummary.getter(BlueprintSummary::blueprintName)).setter(BlueprintSummary.setter(Builder::blueprintName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprintName").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(BlueprintSummary.getter(BlueprintSummary::creationTime)).setter(BlueprintSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedTime").getter(BlueprintSummary.getter(BlueprintSummary::lastModifiedTime)).setter(BlueprintSummary.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLUEPRINT_ARN_FIELD, BLUEPRINT_VERSION_FIELD, BLUEPRINT_STAGE_FIELD, BLUEPRINT_NAME_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("blueprintArn", BLUEPRINT_ARN_FIELD);
            this.put("blueprintVersion", BLUEPRINT_VERSION_FIELD);
            this.put("blueprintStage", BLUEPRINT_STAGE_FIELD);
            this.put("blueprintName", BLUEPRINT_NAME_FIELD);
            this.put("creationTime", CREATION_TIME_FIELD);
            this.put("lastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String blueprintArn;
    private final String blueprintVersion;
    private final String blueprintStage;
    private final String blueprintName;
    private final Instant creationTime;
    private final Instant lastModifiedTime;

    private BlueprintSummary(BuilderImpl builder) {
        this.blueprintArn = builder.blueprintArn;
        this.blueprintVersion = builder.blueprintVersion;
        this.blueprintStage = builder.blueprintStage;
        this.blueprintName = builder.blueprintName;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    public final String blueprintArn() {
        return this.blueprintArn;
    }

    public final String blueprintVersion() {
        return this.blueprintVersion;
    }

    public final BlueprintStage blueprintStage() {
        return BlueprintStage.fromValue(this.blueprintStage);
    }

    public final String blueprintStageAsString() {
        return this.blueprintStage;
    }

    public final String blueprintName() {
        return this.blueprintName;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.blueprintArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.blueprintVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.blueprintStageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.blueprintName());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlueprintSummary)) {
            return false;
        }
        BlueprintSummary other = (BlueprintSummary)obj;
        return Objects.equals(this.blueprintArn(), other.blueprintArn()) && Objects.equals(this.blueprintVersion(), other.blueprintVersion()) && Objects.equals(this.blueprintStageAsString(), other.blueprintStageAsString()) && Objects.equals(this.blueprintName(), other.blueprintName()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime());
    }

    public final String toString() {
        return ToString.builder((String)"BlueprintSummary").add("BlueprintArn", (Object)this.blueprintArn()).add("BlueprintVersion", (Object)this.blueprintVersion()).add("BlueprintStage", (Object)this.blueprintStageAsString()).add("BlueprintName", (Object)(this.blueprintName() == null ? null : "*** Sensitive Data Redacted ***")).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "blueprintArn": {
                return Optional.ofNullable(clazz.cast(this.blueprintArn()));
            }
            case "blueprintVersion": {
                return Optional.ofNullable(clazz.cast(this.blueprintVersion()));
            }
            case "blueprintStage": {
                return Optional.ofNullable(clazz.cast(this.blueprintStageAsString()));
            }
            case "blueprintName": {
                return Optional.ofNullable(clazz.cast(this.blueprintName()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "lastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BlueprintSummary, T> g) {
        return obj -> g.apply((BlueprintSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String blueprintArn;
        private String blueprintVersion;
        private String blueprintStage;
        private String blueprintName;
        private Instant creationTime;
        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(BlueprintSummary model) {
            this.blueprintArn(model.blueprintArn);
            this.blueprintVersion(model.blueprintVersion);
            this.blueprintStage(model.blueprintStage);
            this.blueprintName(model.blueprintName);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
        }

        public final String getBlueprintArn() {
            return this.blueprintArn;
        }

        public final void setBlueprintArn(String blueprintArn) {
            this.blueprintArn = blueprintArn;
        }

        @Override
        public final Builder blueprintArn(String blueprintArn) {
            this.blueprintArn = blueprintArn;
            return this;
        }

        public final String getBlueprintVersion() {
            return this.blueprintVersion;
        }

        public final void setBlueprintVersion(String blueprintVersion) {
            this.blueprintVersion = blueprintVersion;
        }

        @Override
        public final Builder blueprintVersion(String blueprintVersion) {
            this.blueprintVersion = blueprintVersion;
            return this;
        }

        public final String getBlueprintStage() {
            return this.blueprintStage;
        }

        public final void setBlueprintStage(String blueprintStage) {
            this.blueprintStage = blueprintStage;
        }

        @Override
        public final Builder blueprintStage(String blueprintStage) {
            this.blueprintStage = blueprintStage;
            return this;
        }

        @Override
        public final Builder blueprintStage(BlueprintStage blueprintStage) {
            this.blueprintStage(blueprintStage == null ? null : blueprintStage.toString());
            return this;
        }

        public final String getBlueprintName() {
            return this.blueprintName;
        }

        public final void setBlueprintName(String blueprintName) {
            this.blueprintName = blueprintName;
        }

        @Override
        public final Builder blueprintName(String blueprintName) {
            this.blueprintName = blueprintName;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public BlueprintSummary build() {
            return new BlueprintSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BlueprintSummary> {
        public Builder blueprintArn(String var1);

        public Builder blueprintVersion(String var1);

        public Builder blueprintStage(String var1);

        public Builder blueprintStage(BlueprintStage var1);

        public Builder blueprintName(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);
    }
}

