/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockdataautomation.model.BedrockDataAutomationRequest;
import software.amazon.awssdk.services.bedrockdataautomation.model.BlueprintStage;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateBlueprintRequest
extends BedrockDataAutomationRequest
implements ToCopyableBuilder<Builder, UpdateBlueprintRequest> {
    private static final SdkField<String> BLUEPRINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("blueprintArn").getter(UpdateBlueprintRequest.getter(UpdateBlueprintRequest::blueprintArn)).setter(UpdateBlueprintRequest.setter(Builder::blueprintArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("blueprintArn").build()}).build();
    private static final SdkField<String> SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("schema").getter(UpdateBlueprintRequest.getter(UpdateBlueprintRequest::schema)).setter(UpdateBlueprintRequest.setter(Builder::schema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schema").build()}).build();
    private static final SdkField<String> BLUEPRINT_STAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("blueprintStage").getter(UpdateBlueprintRequest.getter(UpdateBlueprintRequest::blueprintStageAsString)).setter(UpdateBlueprintRequest.setter(Builder::blueprintStage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprintStage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLUEPRINT_ARN_FIELD, SCHEMA_FIELD, BLUEPRINT_STAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("blueprintArn", BLUEPRINT_ARN_FIELD);
            this.put("schema", SCHEMA_FIELD);
            this.put("blueprintStage", BLUEPRINT_STAGE_FIELD);
        }
    });
    private final String blueprintArn;
    private final String schema;
    private final String blueprintStage;

    private UpdateBlueprintRequest(BuilderImpl builder) {
        super(builder);
        this.blueprintArn = builder.blueprintArn;
        this.schema = builder.schema;
        this.blueprintStage = builder.blueprintStage;
    }

    public final String blueprintArn() {
        return this.blueprintArn;
    }

    public final String schema() {
        return this.schema;
    }

    public final BlueprintStage blueprintStage() {
        return BlueprintStage.fromValue(this.blueprintStage);
    }

    public final String blueprintStageAsString() {
        return this.blueprintStage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.blueprintArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.schema());
        hashCode = 31 * hashCode + Objects.hashCode(this.blueprintStageAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBlueprintRequest)) {
            return false;
        }
        UpdateBlueprintRequest other = (UpdateBlueprintRequest)((Object)obj);
        return Objects.equals(this.blueprintArn(), other.blueprintArn()) && Objects.equals(this.schema(), other.schema()) && Objects.equals(this.blueprintStageAsString(), other.blueprintStageAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateBlueprintRequest").add("BlueprintArn", (Object)this.blueprintArn()).add("Schema", (Object)(this.schema() == null ? null : "*** Sensitive Data Redacted ***")).add("BlueprintStage", (Object)this.blueprintStageAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "blueprintArn": {
                return Optional.ofNullable(clazz.cast(this.blueprintArn()));
            }
            case "schema": {
                return Optional.ofNullable(clazz.cast(this.schema()));
            }
            case "blueprintStage": {
                return Optional.ofNullable(clazz.cast(this.blueprintStageAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBlueprintRequest, T> g) {
        return obj -> g.apply((UpdateBlueprintRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockDataAutomationRequest.BuilderImpl
    implements Builder {
        private String blueprintArn;
        private String schema;
        private String blueprintStage;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBlueprintRequest model) {
            super(model);
            this.blueprintArn(model.blueprintArn);
            this.schema(model.schema);
            this.blueprintStage(model.blueprintStage);
        }

        public final String getBlueprintArn() {
            return this.blueprintArn;
        }

        public final void setBlueprintArn(String blueprintArn) {
            this.blueprintArn = blueprintArn;
        }

        @Override
        public final Builder blueprintArn(String blueprintArn) {
            this.blueprintArn = blueprintArn;
            return this;
        }

        public final String getSchema() {
            return this.schema;
        }

        public final void setSchema(String schema) {
            this.schema = schema;
        }

        @Override
        public final Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public final String getBlueprintStage() {
            return this.blueprintStage;
        }

        public final void setBlueprintStage(String blueprintStage) {
            this.blueprintStage = blueprintStage;
        }

        @Override
        public final Builder blueprintStage(String blueprintStage) {
            this.blueprintStage = blueprintStage;
            return this;
        }

        @Override
        public final Builder blueprintStage(BlueprintStage blueprintStage) {
            this.blueprintStage(blueprintStage == null ? null : blueprintStage.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateBlueprintRequest build() {
            return new UpdateBlueprintRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockDataAutomationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateBlueprintRequest> {
        public Builder blueprintArn(String var1);

        public Builder schema(String var1);

        public Builder blueprintStage(String var1);

        public Builder blueprintStage(BlueprintStage var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

