/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Create Blueprint Request
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateBlueprintRequest extends BedrockDataAutomationRequest implements
        ToCopyableBuilder<CreateBlueprintRequest.Builder, CreateBlueprintRequest> {
    private static final SdkField<String> BLUEPRINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("blueprintName").getter(getter(CreateBlueprintRequest::blueprintName))
            .setter(setter(Builder::blueprintName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprintName").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(CreateBlueprintRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> BLUEPRINT_STAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("blueprintStage").getter(getter(CreateBlueprintRequest::blueprintStageAsString))
            .setter(setter(Builder::blueprintStage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprintStage").build()).build();

    private static final SdkField<String> SCHEMA_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("schema")
            .getter(getter(CreateBlueprintRequest::schema)).setter(setter(Builder::schema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schema").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateBlueprintRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField
            .<EncryptionConfiguration> builder(MarshallingType.SDK_POJO).memberName("encryptionConfiguration")
            .getter(getter(CreateBlueprintRequest::encryptionConfiguration)).setter(setter(Builder::encryptionConfiguration))
            .constructor(EncryptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLUEPRINT_NAME_FIELD,
            TYPE_FIELD, BLUEPRINT_STAGE_FIELD, SCHEMA_FIELD, CLIENT_TOKEN_FIELD, ENCRYPTION_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String blueprintName;

    private final String type;

    private final String blueprintStage;

    private final String schema;

    private final String clientToken;

    private final EncryptionConfiguration encryptionConfiguration;

    private CreateBlueprintRequest(BuilderImpl builder) {
        super(builder);
        this.blueprintName = builder.blueprintName;
        this.type = builder.type;
        this.blueprintStage = builder.blueprintStage;
        this.schema = builder.schema;
        this.clientToken = builder.clientToken;
        this.encryptionConfiguration = builder.encryptionConfiguration;
    }

    /**
     * Returns the value of the BlueprintName property for this object.
     * 
     * @return The value of the BlueprintName property for this object.
     */
    public final String blueprintName() {
        return blueprintName;
    }

    /**
     * Returns the value of the Type property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The value of the Type property for this object.
     * @see Type
     */
    public final Type type() {
        return Type.fromValue(type);
    }

    /**
     * Returns the value of the Type property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The value of the Type property for this object.
     * @see Type
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * Returns the value of the BlueprintStage property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #blueprintStage}
     * will return {@link BlueprintStage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #blueprintStageAsString}.
     * </p>
     * 
     * @return The value of the BlueprintStage property for this object.
     * @see BlueprintStage
     */
    public final BlueprintStage blueprintStage() {
        return BlueprintStage.fromValue(blueprintStage);
    }

    /**
     * Returns the value of the BlueprintStage property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #blueprintStage}
     * will return {@link BlueprintStage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #blueprintStageAsString}.
     * </p>
     * 
     * @return The value of the BlueprintStage property for this object.
     * @see BlueprintStage
     */
    public final String blueprintStageAsString() {
        return blueprintStage;
    }

    /**
     * Returns the value of the Schema property for this object.
     * 
     * @return The value of the Schema property for this object.
     */
    public final String schema() {
        return schema;
    }

    /**
     * Returns the value of the ClientToken property for this object.
     * 
     * @return The value of the ClientToken property for this object.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * Returns the value of the EncryptionConfiguration property for this object.
     * 
     * @return The value of the EncryptionConfiguration property for this object.
     */
    public final EncryptionConfiguration encryptionConfiguration() {
        return encryptionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(blueprintName());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(blueprintStageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(schema());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBlueprintRequest)) {
            return false;
        }
        CreateBlueprintRequest other = (CreateBlueprintRequest) obj;
        return Objects.equals(blueprintName(), other.blueprintName()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(blueprintStageAsString(), other.blueprintStageAsString())
                && Objects.equals(schema(), other.schema()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(encryptionConfiguration(), other.encryptionConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateBlueprintRequest")
                .add("BlueprintName", blueprintName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Type", typeAsString()).add("BlueprintStage", blueprintStageAsString())
                .add("Schema", schema() == null ? null : "*** Sensitive Data Redacted ***").add("ClientToken", clientToken())
                .add("EncryptionConfiguration", encryptionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "blueprintName":
            return Optional.ofNullable(clazz.cast(blueprintName()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "blueprintStage":
            return Optional.ofNullable(clazz.cast(blueprintStageAsString()));
        case "schema":
            return Optional.ofNullable(clazz.cast(schema()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "encryptionConfiguration":
            return Optional.ofNullable(clazz.cast(encryptionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("blueprintName", BLUEPRINT_NAME_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("blueprintStage", BLUEPRINT_STAGE_FIELD);
        map.put("schema", SCHEMA_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("encryptionConfiguration", ENCRYPTION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateBlueprintRequest, T> g) {
        return obj -> g.apply((CreateBlueprintRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockDataAutomationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateBlueprintRequest> {
        /**
         * Sets the value of the BlueprintName property for this object.
         *
         * @param blueprintName
         *        The new value for the BlueprintName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprintName(String blueprintName);

        /**
         * Sets the value of the Type property for this object.
         *
         * @param type
         *        The new value for the Type property for this object.
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(String type);

        /**
         * Sets the value of the Type property for this object.
         *
         * @param type
         *        The new value for the Type property for this object.
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(Type type);

        /**
         * Sets the value of the BlueprintStage property for this object.
         *
         * @param blueprintStage
         *        The new value for the BlueprintStage property for this object.
         * @see BlueprintStage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BlueprintStage
         */
        Builder blueprintStage(String blueprintStage);

        /**
         * Sets the value of the BlueprintStage property for this object.
         *
         * @param blueprintStage
         *        The new value for the BlueprintStage property for this object.
         * @see BlueprintStage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BlueprintStage
         */
        Builder blueprintStage(BlueprintStage blueprintStage);

        /**
         * Sets the value of the Schema property for this object.
         *
         * @param schema
         *        The new value for the Schema property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schema(String schema);

        /**
         * Sets the value of the ClientToken property for this object.
         *
         * @param clientToken
         *        The new value for the ClientToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * Sets the value of the EncryptionConfiguration property for this object.
         *
         * @param encryptionConfiguration
         *        The new value for the EncryptionConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration);

        /**
         * Sets the value of the EncryptionConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link EncryptionConfiguration.Builder} avoiding
         * the need to create one manually via {@link EncryptionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncryptionConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #encryptionConfiguration(EncryptionConfiguration)}.
         * 
         * @param encryptionConfiguration
         *        a consumer that will call methods on {@link EncryptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionConfiguration(EncryptionConfiguration)
         */
        default Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return encryptionConfiguration(EncryptionConfiguration.builder().applyMutation(encryptionConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockDataAutomationRequest.BuilderImpl implements Builder {
        private String blueprintName;

        private String type;

        private String blueprintStage;

        private String schema;

        private String clientToken;

        private EncryptionConfiguration encryptionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBlueprintRequest model) {
            super(model);
            blueprintName(model.blueprintName);
            type(model.type);
            blueprintStage(model.blueprintStage);
            schema(model.schema);
            clientToken(model.clientToken);
            encryptionConfiguration(model.encryptionConfiguration);
        }

        public final String getBlueprintName() {
            return blueprintName;
        }

        public final void setBlueprintName(String blueprintName) {
            this.blueprintName = blueprintName;
        }

        @Override
        public final Builder blueprintName(String blueprintName) {
            this.blueprintName = blueprintName;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(Type type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getBlueprintStage() {
            return blueprintStage;
        }

        public final void setBlueprintStage(String blueprintStage) {
            this.blueprintStage = blueprintStage;
        }

        @Override
        public final Builder blueprintStage(String blueprintStage) {
            this.blueprintStage = blueprintStage;
            return this;
        }

        @Override
        public final Builder blueprintStage(BlueprintStage blueprintStage) {
            this.blueprintStage(blueprintStage == null ? null : blueprintStage.toString());
            return this;
        }

        public final String getSchema() {
            return schema;
        }

        public final void setSchema(String schema) {
            this.schema = schema;
        }

        @Override
        public final Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return encryptionConfiguration != null ? encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBlueprintRequest build() {
            return new CreateBlueprintRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
