/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Standard Output Configuration of Document
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentStandardOutputConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DocumentStandardOutputConfiguration.Builder, DocumentStandardOutputConfiguration> {
    private static final SdkField<DocumentStandardExtraction> EXTRACTION_FIELD = SdkField
            .<DocumentStandardExtraction> builder(MarshallingType.SDK_POJO).memberName("extraction")
            .getter(getter(DocumentStandardOutputConfiguration::extraction)).setter(setter(Builder::extraction))
            .constructor(DocumentStandardExtraction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("extraction").build()).build();

    private static final SdkField<DocumentStandardGenerativeField> GENERATIVE_FIELD_FIELD = SdkField
            .<DocumentStandardGenerativeField> builder(MarshallingType.SDK_POJO).memberName("generativeField")
            .getter(getter(DocumentStandardOutputConfiguration::generativeField)).setter(setter(Builder::generativeField))
            .constructor(DocumentStandardGenerativeField::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generativeField").build()).build();

    private static final SdkField<DocumentOutputFormat> OUTPUT_FORMAT_FIELD = SdkField
            .<DocumentOutputFormat> builder(MarshallingType.SDK_POJO).memberName("outputFormat")
            .getter(getter(DocumentStandardOutputConfiguration::outputFormat)).setter(setter(Builder::outputFormat))
            .constructor(DocumentOutputFormat::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputFormat").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXTRACTION_FIELD,
            GENERATIVE_FIELD_FIELD, OUTPUT_FORMAT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DocumentStandardExtraction extraction;

    private final DocumentStandardGenerativeField generativeField;

    private final DocumentOutputFormat outputFormat;

    private DocumentStandardOutputConfiguration(BuilderImpl builder) {
        this.extraction = builder.extraction;
        this.generativeField = builder.generativeField;
        this.outputFormat = builder.outputFormat;
    }

    /**
     * Returns the value of the Extraction property for this object.
     * 
     * @return The value of the Extraction property for this object.
     */
    public final DocumentStandardExtraction extraction() {
        return extraction;
    }

    /**
     * Returns the value of the GenerativeField property for this object.
     * 
     * @return The value of the GenerativeField property for this object.
     */
    public final DocumentStandardGenerativeField generativeField() {
        return generativeField;
    }

    /**
     * Returns the value of the OutputFormat property for this object.
     * 
     * @return The value of the OutputFormat property for this object.
     */
    public final DocumentOutputFormat outputFormat() {
        return outputFormat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(extraction());
        hashCode = 31 * hashCode + Objects.hashCode(generativeField());
        hashCode = 31 * hashCode + Objects.hashCode(outputFormat());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentStandardOutputConfiguration)) {
            return false;
        }
        DocumentStandardOutputConfiguration other = (DocumentStandardOutputConfiguration) obj;
        return Objects.equals(extraction(), other.extraction()) && Objects.equals(generativeField(), other.generativeField())
                && Objects.equals(outputFormat(), other.outputFormat());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DocumentStandardOutputConfiguration").add("Extraction", extraction())
                .add("GenerativeField", generativeField()).add("OutputFormat", outputFormat()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "extraction":
            return Optional.ofNullable(clazz.cast(extraction()));
        case "generativeField":
            return Optional.ofNullable(clazz.cast(generativeField()));
        case "outputFormat":
            return Optional.ofNullable(clazz.cast(outputFormat()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("extraction", EXTRACTION_FIELD);
        map.put("generativeField", GENERATIVE_FIELD_FIELD);
        map.put("outputFormat", OUTPUT_FORMAT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DocumentStandardOutputConfiguration, T> g) {
        return obj -> g.apply((DocumentStandardOutputConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocumentStandardOutputConfiguration> {
        /**
         * Sets the value of the Extraction property for this object.
         *
         * @param extraction
         *        The new value for the Extraction property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extraction(DocumentStandardExtraction extraction);

        /**
         * Sets the value of the Extraction property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DocumentStandardExtraction.Builder}
         * avoiding the need to create one manually via {@link DocumentStandardExtraction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentStandardExtraction.Builder#build()} is called immediately
         * and its result is passed to {@link #extraction(DocumentStandardExtraction)}.
         * 
         * @param extraction
         *        a consumer that will call methods on {@link DocumentStandardExtraction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #extraction(DocumentStandardExtraction)
         */
        default Builder extraction(Consumer<DocumentStandardExtraction.Builder> extraction) {
            return extraction(DocumentStandardExtraction.builder().applyMutation(extraction).build());
        }

        /**
         * Sets the value of the GenerativeField property for this object.
         *
         * @param generativeField
         *        The new value for the GenerativeField property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generativeField(DocumentStandardGenerativeField generativeField);

        /**
         * Sets the value of the GenerativeField property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DocumentStandardGenerativeField.Builder}
         * avoiding the need to create one manually via {@link DocumentStandardGenerativeField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentStandardGenerativeField.Builder#build()} is called
         * immediately and its result is passed to {@link #generativeField(DocumentStandardGenerativeField)}.
         * 
         * @param generativeField
         *        a consumer that will call methods on {@link DocumentStandardGenerativeField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #generativeField(DocumentStandardGenerativeField)
         */
        default Builder generativeField(Consumer<DocumentStandardGenerativeField.Builder> generativeField) {
            return generativeField(DocumentStandardGenerativeField.builder().applyMutation(generativeField).build());
        }

        /**
         * Sets the value of the OutputFormat property for this object.
         *
         * @param outputFormat
         *        The new value for the OutputFormat property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputFormat(DocumentOutputFormat outputFormat);

        /**
         * Sets the value of the OutputFormat property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DocumentOutputFormat.Builder} avoiding
         * the need to create one manually via {@link DocumentOutputFormat#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentOutputFormat.Builder#build()} is called immediately and
         * its result is passed to {@link #outputFormat(DocumentOutputFormat)}.
         * 
         * @param outputFormat
         *        a consumer that will call methods on {@link DocumentOutputFormat.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputFormat(DocumentOutputFormat)
         */
        default Builder outputFormat(Consumer<DocumentOutputFormat.Builder> outputFormat) {
            return outputFormat(DocumentOutputFormat.builder().applyMutation(outputFormat).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DocumentStandardExtraction extraction;

        private DocumentStandardGenerativeField generativeField;

        private DocumentOutputFormat outputFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentStandardOutputConfiguration model) {
            extraction(model.extraction);
            generativeField(model.generativeField);
            outputFormat(model.outputFormat);
        }

        public final DocumentStandardExtraction.Builder getExtraction() {
            return extraction != null ? extraction.toBuilder() : null;
        }

        public final void setExtraction(DocumentStandardExtraction.BuilderImpl extraction) {
            this.extraction = extraction != null ? extraction.build() : null;
        }

        @Override
        public final Builder extraction(DocumentStandardExtraction extraction) {
            this.extraction = extraction;
            return this;
        }

        public final DocumentStandardGenerativeField.Builder getGenerativeField() {
            return generativeField != null ? generativeField.toBuilder() : null;
        }

        public final void setGenerativeField(DocumentStandardGenerativeField.BuilderImpl generativeField) {
            this.generativeField = generativeField != null ? generativeField.build() : null;
        }

        @Override
        public final Builder generativeField(DocumentStandardGenerativeField generativeField) {
            this.generativeField = generativeField;
            return this;
        }

        public final DocumentOutputFormat.Builder getOutputFormat() {
            return outputFormat != null ? outputFormat.toBuilder() : null;
        }

        public final void setOutputFormat(DocumentOutputFormat.BuilderImpl outputFormat) {
            this.outputFormat = outputFormat != null ? outputFormat.build() : null;
        }

        @Override
        public final Builder outputFormat(DocumentOutputFormat outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        @Override
        public DocumentStandardOutputConfiguration build() {
            return new DocumentStandardOutputConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
