/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * List DataAutomationProject Request
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDataAutomationProjectsRequest extends BedrockDataAutomationRequest implements
        ToCopyableBuilder<ListDataAutomationProjectsRequest.Builder, ListDataAutomationProjectsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListDataAutomationProjectsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListDataAutomationProjectsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<String> PROJECT_STAGE_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectStageFilter").getter(getter(ListDataAutomationProjectsRequest::projectStageFilterAsString))
            .setter(setter(Builder::projectStageFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectStageFilter").build())
            .build();

    private static final SdkField<BlueprintFilter> BLUEPRINT_FILTER_FIELD = SdkField
            .<BlueprintFilter> builder(MarshallingType.SDK_POJO).memberName("blueprintFilter")
            .getter(getter(ListDataAutomationProjectsRequest::blueprintFilter)).setter(setter(Builder::blueprintFilter))
            .constructor(BlueprintFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprintFilter").build()).build();

    private static final SdkField<String> RESOURCE_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceOwner").getter(getter(ListDataAutomationProjectsRequest::resourceOwnerAsString))
            .setter(setter(Builder::resourceOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceOwner").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, PROJECT_STAGE_FILTER_FIELD, BLUEPRINT_FILTER_FIELD, RESOURCE_OWNER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer maxResults;

    private final String nextToken;

    private final String projectStageFilter;

    private final BlueprintFilter blueprintFilter;

    private final String resourceOwner;

    private ListDataAutomationProjectsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.projectStageFilter = builder.projectStageFilter;
        this.blueprintFilter = builder.blueprintFilter;
        this.resourceOwner = builder.resourceOwner;
    }

    /**
     * Returns the value of the MaxResults property for this object.
     * 
     * @return The value of the MaxResults property for this object.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * Returns the value of the ProjectStageFilter property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #projectStageFilter} will return {@link DataAutomationProjectStageFilter#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #projectStageFilterAsString}.
     * </p>
     * 
     * @return The value of the ProjectStageFilter property for this object.
     * @see DataAutomationProjectStageFilter
     */
    public final DataAutomationProjectStageFilter projectStageFilter() {
        return DataAutomationProjectStageFilter.fromValue(projectStageFilter);
    }

    /**
     * Returns the value of the ProjectStageFilter property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #projectStageFilter} will return {@link DataAutomationProjectStageFilter#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #projectStageFilterAsString}.
     * </p>
     * 
     * @return The value of the ProjectStageFilter property for this object.
     * @see DataAutomationProjectStageFilter
     */
    public final String projectStageFilterAsString() {
        return projectStageFilter;
    }

    /**
     * Returns the value of the BlueprintFilter property for this object.
     * 
     * @return The value of the BlueprintFilter property for this object.
     */
    public final BlueprintFilter blueprintFilter() {
        return blueprintFilter;
    }

    /**
     * Returns the value of the ResourceOwner property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceOwner}
     * will return {@link ResourceOwner#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceOwnerAsString}.
     * </p>
     * 
     * @return The value of the ResourceOwner property for this object.
     * @see ResourceOwner
     */
    public final ResourceOwner resourceOwner() {
        return ResourceOwner.fromValue(resourceOwner);
    }

    /**
     * Returns the value of the ResourceOwner property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceOwner}
     * will return {@link ResourceOwner#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceOwnerAsString}.
     * </p>
     * 
     * @return The value of the ResourceOwner property for this object.
     * @see ResourceOwner
     */
    public final String resourceOwnerAsString() {
        return resourceOwner;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(projectStageFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(blueprintFilter());
        hashCode = 31 * hashCode + Objects.hashCode(resourceOwnerAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataAutomationProjectsRequest)) {
            return false;
        }
        ListDataAutomationProjectsRequest other = (ListDataAutomationProjectsRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(projectStageFilterAsString(), other.projectStageFilterAsString())
                && Objects.equals(blueprintFilter(), other.blueprintFilter())
                && Objects.equals(resourceOwnerAsString(), other.resourceOwnerAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDataAutomationProjectsRequest").add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("ProjectStageFilter", projectStageFilterAsString())
                .add("BlueprintFilter", blueprintFilter()).add("ResourceOwner", resourceOwnerAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "projectStageFilter":
            return Optional.ofNullable(clazz.cast(projectStageFilterAsString()));
        case "blueprintFilter":
            return Optional.ofNullable(clazz.cast(blueprintFilter()));
        case "resourceOwner":
            return Optional.ofNullable(clazz.cast(resourceOwnerAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("projectStageFilter", PROJECT_STAGE_FILTER_FIELD);
        map.put("blueprintFilter", BLUEPRINT_FILTER_FIELD);
        map.put("resourceOwner", RESOURCE_OWNER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDataAutomationProjectsRequest, T> g) {
        return obj -> g.apply((ListDataAutomationProjectsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockDataAutomationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListDataAutomationProjectsRequest> {
        /**
         * Sets the value of the MaxResults property for this object.
         *
         * @param maxResults
         *        The new value for the MaxResults property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * Sets the value of the ProjectStageFilter property for this object.
         *
         * @param projectStageFilter
         *        The new value for the ProjectStageFilter property for this object.
         * @see DataAutomationProjectStageFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataAutomationProjectStageFilter
         */
        Builder projectStageFilter(String projectStageFilter);

        /**
         * Sets the value of the ProjectStageFilter property for this object.
         *
         * @param projectStageFilter
         *        The new value for the ProjectStageFilter property for this object.
         * @see DataAutomationProjectStageFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataAutomationProjectStageFilter
         */
        Builder projectStageFilter(DataAutomationProjectStageFilter projectStageFilter);

        /**
         * Sets the value of the BlueprintFilter property for this object.
         *
         * @param blueprintFilter
         *        The new value for the BlueprintFilter property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprintFilter(BlueprintFilter blueprintFilter);

        /**
         * Sets the value of the BlueprintFilter property for this object.
         *
         * This is a convenience method that creates an instance of the {@link BlueprintFilter.Builder} avoiding the
         * need to create one manually via {@link BlueprintFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BlueprintFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #blueprintFilter(BlueprintFilter)}.
         * 
         * @param blueprintFilter
         *        a consumer that will call methods on {@link BlueprintFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blueprintFilter(BlueprintFilter)
         */
        default Builder blueprintFilter(Consumer<BlueprintFilter.Builder> blueprintFilter) {
            return blueprintFilter(BlueprintFilter.builder().applyMutation(blueprintFilter).build());
        }

        /**
         * Sets the value of the ResourceOwner property for this object.
         *
         * @param resourceOwner
         *        The new value for the ResourceOwner property for this object.
         * @see ResourceOwner
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceOwner
         */
        Builder resourceOwner(String resourceOwner);

        /**
         * Sets the value of the ResourceOwner property for this object.
         *
         * @param resourceOwner
         *        The new value for the ResourceOwner property for this object.
         * @see ResourceOwner
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceOwner
         */
        Builder resourceOwner(ResourceOwner resourceOwner);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockDataAutomationRequest.BuilderImpl implements Builder {
        private Integer maxResults;

        private String nextToken;

        private String projectStageFilter;

        private BlueprintFilter blueprintFilter;

        private String resourceOwner;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataAutomationProjectsRequest model) {
            super(model);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            projectStageFilter(model.projectStageFilter);
            blueprintFilter(model.blueprintFilter);
            resourceOwner(model.resourceOwner);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getProjectStageFilter() {
            return projectStageFilter;
        }

        public final void setProjectStageFilter(String projectStageFilter) {
            this.projectStageFilter = projectStageFilter;
        }

        @Override
        public final Builder projectStageFilter(String projectStageFilter) {
            this.projectStageFilter = projectStageFilter;
            return this;
        }

        @Override
        public final Builder projectStageFilter(DataAutomationProjectStageFilter projectStageFilter) {
            this.projectStageFilter(projectStageFilter == null ? null : projectStageFilter.toString());
            return this;
        }

        public final BlueprintFilter.Builder getBlueprintFilter() {
            return blueprintFilter != null ? blueprintFilter.toBuilder() : null;
        }

        public final void setBlueprintFilter(BlueprintFilter.BuilderImpl blueprintFilter) {
            this.blueprintFilter = blueprintFilter != null ? blueprintFilter.build() : null;
        }

        @Override
        public final Builder blueprintFilter(BlueprintFilter blueprintFilter) {
            this.blueprintFilter = blueprintFilter;
            return this;
        }

        public final String getResourceOwner() {
            return resourceOwner;
        }

        public final void setResourceOwner(String resourceOwner) {
            this.resourceOwner = resourceOwner;
        }

        @Override
        public final Builder resourceOwner(String resourceOwner) {
            this.resourceOwner = resourceOwner;
            return this;
        }

        @Override
        public final Builder resourceOwner(ResourceOwner resourceOwner) {
            this.resourceOwner(resourceOwner == null ? null : resourceOwner.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDataAutomationProjectsRequest build() {
            return new ListDataAutomationProjectsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
