/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Data Automation Project Filter
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataAutomationProjectFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<DataAutomationProjectFilter.Builder, DataAutomationProjectFilter> {
    private static final SdkField<String> PROJECT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectArn").getter(getter(DataAutomationProjectFilter::projectArn)).setter(setter(Builder::projectArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectArn").build()).build();

    private static final SdkField<String> PROJECT_STAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectStage").getter(getter(DataAutomationProjectFilter::projectStageAsString))
            .setter(setter(Builder::projectStage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectStage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_ARN_FIELD,
            PROJECT_STAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String projectArn;

    private final String projectStage;

    private DataAutomationProjectFilter(BuilderImpl builder) {
        this.projectArn = builder.projectArn;
        this.projectStage = builder.projectStage;
    }

    /**
     * Returns the value of the ProjectArn property for this object.
     * 
     * @return The value of the ProjectArn property for this object.
     */
    public final String projectArn() {
        return projectArn;
    }

    /**
     * Returns the value of the ProjectStage property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #projectStage} will
     * return {@link DataAutomationProjectStage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #projectStageAsString}.
     * </p>
     * 
     * @return The value of the ProjectStage property for this object.
     * @see DataAutomationProjectStage
     */
    public final DataAutomationProjectStage projectStage() {
        return DataAutomationProjectStage.fromValue(projectStage);
    }

    /**
     * Returns the value of the ProjectStage property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #projectStage} will
     * return {@link DataAutomationProjectStage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #projectStageAsString}.
     * </p>
     * 
     * @return The value of the ProjectStage property for this object.
     * @see DataAutomationProjectStage
     */
    public final String projectStageAsString() {
        return projectStage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(projectArn());
        hashCode = 31 * hashCode + Objects.hashCode(projectStageAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataAutomationProjectFilter)) {
            return false;
        }
        DataAutomationProjectFilter other = (DataAutomationProjectFilter) obj;
        return Objects.equals(projectArn(), other.projectArn())
                && Objects.equals(projectStageAsString(), other.projectStageAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataAutomationProjectFilter").add("ProjectArn", projectArn())
                .add("ProjectStage", projectStageAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "projectArn":
            return Optional.ofNullable(clazz.cast(projectArn()));
        case "projectStage":
            return Optional.ofNullable(clazz.cast(projectStageAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("projectArn", PROJECT_ARN_FIELD);
        map.put("projectStage", PROJECT_STAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataAutomationProjectFilter, T> g) {
        return obj -> g.apply((DataAutomationProjectFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataAutomationProjectFilter> {
        /**
         * Sets the value of the ProjectArn property for this object.
         *
         * @param projectArn
         *        The new value for the ProjectArn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectArn(String projectArn);

        /**
         * Sets the value of the ProjectStage property for this object.
         *
         * @param projectStage
         *        The new value for the ProjectStage property for this object.
         * @see DataAutomationProjectStage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataAutomationProjectStage
         */
        Builder projectStage(String projectStage);

        /**
         * Sets the value of the ProjectStage property for this object.
         *
         * @param projectStage
         *        The new value for the ProjectStage property for this object.
         * @see DataAutomationProjectStage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataAutomationProjectStage
         */
        Builder projectStage(DataAutomationProjectStage projectStage);
    }

    static final class BuilderImpl implements Builder {
        private String projectArn;

        private String projectStage;

        private BuilderImpl() {
        }

        private BuilderImpl(DataAutomationProjectFilter model) {
            projectArn(model.projectArn);
            projectStage(model.projectStage);
        }

        public final String getProjectArn() {
            return projectArn;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        @Override
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        public final String getProjectStage() {
            return projectStage;
        }

        public final void setProjectStage(String projectStage) {
            this.projectStage = projectStage;
        }

        @Override
        public final Builder projectStage(String projectStage) {
            this.projectStage = projectStage;
            return this;
        }

        @Override
        public final Builder projectStage(DataAutomationProjectStage projectStage) {
            this.projectStage(projectStage == null ? null : projectStage.toString());
            return this;
        }

        @Override
        public DataAutomationProjectFilter build() {
            return new DataAutomationProjectFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
