/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * List Blueprint Request
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBlueprintsRequest extends BedrockDataAutomationRequest implements
        ToCopyableBuilder<ListBlueprintsRequest.Builder, ListBlueprintsRequest> {
    private static final SdkField<String> BLUEPRINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("blueprintArn").getter(getter(ListBlueprintsRequest::blueprintArn)).setter(setter(Builder::blueprintArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprintArn").build()).build();

    private static final SdkField<String> RESOURCE_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceOwner").getter(getter(ListBlueprintsRequest::resourceOwnerAsString))
            .setter(setter(Builder::resourceOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceOwner").build()).build();

    private static final SdkField<String> BLUEPRINT_STAGE_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("blueprintStageFilter").getter(getter(ListBlueprintsRequest::blueprintStageFilterAsString))
            .setter(setter(Builder::blueprintStageFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprintStageFilter").build())
            .build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListBlueprintsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListBlueprintsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<DataAutomationProjectFilter> PROJECT_FILTER_FIELD = SdkField
            .<DataAutomationProjectFilter> builder(MarshallingType.SDK_POJO).memberName("projectFilter")
            .getter(getter(ListBlueprintsRequest::projectFilter)).setter(setter(Builder::projectFilter))
            .constructor(DataAutomationProjectFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectFilter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLUEPRINT_ARN_FIELD,
            RESOURCE_OWNER_FIELD, BLUEPRINT_STAGE_FILTER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, PROJECT_FILTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String blueprintArn;

    private final String resourceOwner;

    private final String blueprintStageFilter;

    private final Integer maxResults;

    private final String nextToken;

    private final DataAutomationProjectFilter projectFilter;

    private ListBlueprintsRequest(BuilderImpl builder) {
        super(builder);
        this.blueprintArn = builder.blueprintArn;
        this.resourceOwner = builder.resourceOwner;
        this.blueprintStageFilter = builder.blueprintStageFilter;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.projectFilter = builder.projectFilter;
    }

    /**
     * Returns the value of the BlueprintArn property for this object.
     * 
     * @return The value of the BlueprintArn property for this object.
     */
    public final String blueprintArn() {
        return blueprintArn;
    }

    /**
     * Returns the value of the ResourceOwner property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceOwner}
     * will return {@link ResourceOwner#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceOwnerAsString}.
     * </p>
     * 
     * @return The value of the ResourceOwner property for this object.
     * @see ResourceOwner
     */
    public final ResourceOwner resourceOwner() {
        return ResourceOwner.fromValue(resourceOwner);
    }

    /**
     * Returns the value of the ResourceOwner property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceOwner}
     * will return {@link ResourceOwner#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceOwnerAsString}.
     * </p>
     * 
     * @return The value of the ResourceOwner property for this object.
     * @see ResourceOwner
     */
    public final String resourceOwnerAsString() {
        return resourceOwner;
    }

    /**
     * Returns the value of the BlueprintStageFilter property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #blueprintStageFilter} will return {@link BlueprintStageFilter#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #blueprintStageFilterAsString}.
     * </p>
     * 
     * @return The value of the BlueprintStageFilter property for this object.
     * @see BlueprintStageFilter
     */
    public final BlueprintStageFilter blueprintStageFilter() {
        return BlueprintStageFilter.fromValue(blueprintStageFilter);
    }

    /**
     * Returns the value of the BlueprintStageFilter property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #blueprintStageFilter} will return {@link BlueprintStageFilter#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #blueprintStageFilterAsString}.
     * </p>
     * 
     * @return The value of the BlueprintStageFilter property for this object.
     * @see BlueprintStageFilter
     */
    public final String blueprintStageFilterAsString() {
        return blueprintStageFilter;
    }

    /**
     * Returns the value of the MaxResults property for this object.
     * 
     * @return The value of the MaxResults property for this object.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * Returns the value of the ProjectFilter property for this object.
     * 
     * @return The value of the ProjectFilter property for this object.
     */
    public final DataAutomationProjectFilter projectFilter() {
        return projectFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(blueprintArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceOwnerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(blueprintStageFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(projectFilter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBlueprintsRequest)) {
            return false;
        }
        ListBlueprintsRequest other = (ListBlueprintsRequest) obj;
        return Objects.equals(blueprintArn(), other.blueprintArn())
                && Objects.equals(resourceOwnerAsString(), other.resourceOwnerAsString())
                && Objects.equals(blueprintStageFilterAsString(), other.blueprintStageFilterAsString())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(projectFilter(), other.projectFilter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBlueprintsRequest").add("BlueprintArn", blueprintArn())
                .add("ResourceOwner", resourceOwnerAsString()).add("BlueprintStageFilter", blueprintStageFilterAsString())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).add("ProjectFilter", projectFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "blueprintArn":
            return Optional.ofNullable(clazz.cast(blueprintArn()));
        case "resourceOwner":
            return Optional.ofNullable(clazz.cast(resourceOwnerAsString()));
        case "blueprintStageFilter":
            return Optional.ofNullable(clazz.cast(blueprintStageFilterAsString()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "projectFilter":
            return Optional.ofNullable(clazz.cast(projectFilter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("blueprintArn", BLUEPRINT_ARN_FIELD);
        map.put("resourceOwner", RESOURCE_OWNER_FIELD);
        map.put("blueprintStageFilter", BLUEPRINT_STAGE_FILTER_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("projectFilter", PROJECT_FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListBlueprintsRequest, T> g) {
        return obj -> g.apply((ListBlueprintsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockDataAutomationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListBlueprintsRequest> {
        /**
         * Sets the value of the BlueprintArn property for this object.
         *
         * @param blueprintArn
         *        The new value for the BlueprintArn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprintArn(String blueprintArn);

        /**
         * Sets the value of the ResourceOwner property for this object.
         *
         * @param resourceOwner
         *        The new value for the ResourceOwner property for this object.
         * @see ResourceOwner
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceOwner
         */
        Builder resourceOwner(String resourceOwner);

        /**
         * Sets the value of the ResourceOwner property for this object.
         *
         * @param resourceOwner
         *        The new value for the ResourceOwner property for this object.
         * @see ResourceOwner
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceOwner
         */
        Builder resourceOwner(ResourceOwner resourceOwner);

        /**
         * Sets the value of the BlueprintStageFilter property for this object.
         *
         * @param blueprintStageFilter
         *        The new value for the BlueprintStageFilter property for this object.
         * @see BlueprintStageFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BlueprintStageFilter
         */
        Builder blueprintStageFilter(String blueprintStageFilter);

        /**
         * Sets the value of the BlueprintStageFilter property for this object.
         *
         * @param blueprintStageFilter
         *        The new value for the BlueprintStageFilter property for this object.
         * @see BlueprintStageFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BlueprintStageFilter
         */
        Builder blueprintStageFilter(BlueprintStageFilter blueprintStageFilter);

        /**
         * Sets the value of the MaxResults property for this object.
         *
         * @param maxResults
         *        The new value for the MaxResults property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * Sets the value of the ProjectFilter property for this object.
         *
         * @param projectFilter
         *        The new value for the ProjectFilter property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectFilter(DataAutomationProjectFilter projectFilter);

        /**
         * Sets the value of the ProjectFilter property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DataAutomationProjectFilter.Builder}
         * avoiding the need to create one manually via {@link DataAutomationProjectFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataAutomationProjectFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #projectFilter(DataAutomationProjectFilter)}.
         * 
         * @param projectFilter
         *        a consumer that will call methods on {@link DataAutomationProjectFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #projectFilter(DataAutomationProjectFilter)
         */
        default Builder projectFilter(Consumer<DataAutomationProjectFilter.Builder> projectFilter) {
            return projectFilter(DataAutomationProjectFilter.builder().applyMutation(projectFilter).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockDataAutomationRequest.BuilderImpl implements Builder {
        private String blueprintArn;

        private String resourceOwner;

        private String blueprintStageFilter;

        private Integer maxResults;

        private String nextToken;

        private DataAutomationProjectFilter projectFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBlueprintsRequest model) {
            super(model);
            blueprintArn(model.blueprintArn);
            resourceOwner(model.resourceOwner);
            blueprintStageFilter(model.blueprintStageFilter);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            projectFilter(model.projectFilter);
        }

        public final String getBlueprintArn() {
            return blueprintArn;
        }

        public final void setBlueprintArn(String blueprintArn) {
            this.blueprintArn = blueprintArn;
        }

        @Override
        public final Builder blueprintArn(String blueprintArn) {
            this.blueprintArn = blueprintArn;
            return this;
        }

        public final String getResourceOwner() {
            return resourceOwner;
        }

        public final void setResourceOwner(String resourceOwner) {
            this.resourceOwner = resourceOwner;
        }

        @Override
        public final Builder resourceOwner(String resourceOwner) {
            this.resourceOwner = resourceOwner;
            return this;
        }

        @Override
        public final Builder resourceOwner(ResourceOwner resourceOwner) {
            this.resourceOwner(resourceOwner == null ? null : resourceOwner.toString());
            return this;
        }

        public final String getBlueprintStageFilter() {
            return blueprintStageFilter;
        }

        public final void setBlueprintStageFilter(String blueprintStageFilter) {
            this.blueprintStageFilter = blueprintStageFilter;
        }

        @Override
        public final Builder blueprintStageFilter(String blueprintStageFilter) {
            this.blueprintStageFilter = blueprintStageFilter;
            return this;
        }

        @Override
        public final Builder blueprintStageFilter(BlueprintStageFilter blueprintStageFilter) {
            this.blueprintStageFilter(blueprintStageFilter == null ? null : blueprintStageFilter.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final DataAutomationProjectFilter.Builder getProjectFilter() {
            return projectFilter != null ? projectFilter.toBuilder() : null;
        }

        public final void setProjectFilter(DataAutomationProjectFilter.BuilderImpl projectFilter) {
            this.projectFilter = projectFilter != null ? projectFilter.build() : null;
        }

        @Override
        public final Builder projectFilter(DataAutomationProjectFilter projectFilter) {
            this.projectFilter = projectFilter;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListBlueprintsRequest build() {
            return new ListBlueprintsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
