/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Custom output configuration
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomOutputConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomOutputConfiguration.Builder, CustomOutputConfiguration> {
    private static final SdkField<List<BlueprintItem>> BLUEPRINTS_FIELD = SdkField
            .<List<BlueprintItem>> builder(MarshallingType.LIST)
            .memberName("blueprints")
            .getter(getter(CustomOutputConfiguration::blueprints))
            .setter(setter(Builder::blueprints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BlueprintItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(BlueprintItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLUEPRINTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<BlueprintItem> blueprints;

    private CustomOutputConfiguration(BuilderImpl builder) {
        this.blueprints = builder.blueprints;
    }

    /**
     * For responses, this returns true if the service returned a value for the Blueprints property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasBlueprints() {
        return blueprints != null && !(blueprints instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Blueprints property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlueprints} method.
     * </p>
     * 
     * @return The value of the Blueprints property for this object.
     */
    public final List<BlueprintItem> blueprints() {
        return blueprints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasBlueprints() ? blueprints() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomOutputConfiguration)) {
            return false;
        }
        CustomOutputConfiguration other = (CustomOutputConfiguration) obj;
        return hasBlueprints() == other.hasBlueprints() && Objects.equals(blueprints(), other.blueprints());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomOutputConfiguration").add("Blueprints", hasBlueprints() ? blueprints() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "blueprints":
            return Optional.ofNullable(clazz.cast(blueprints()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("blueprints", BLUEPRINTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomOutputConfiguration, T> g) {
        return obj -> g.apply((CustomOutputConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomOutputConfiguration> {
        /**
         * Sets the value of the Blueprints property for this object.
         *
         * @param blueprints
         *        The new value for the Blueprints property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprints(Collection<BlueprintItem> blueprints);

        /**
         * Sets the value of the Blueprints property for this object.
         *
         * @param blueprints
         *        The new value for the Blueprints property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprints(BlueprintItem... blueprints);

        /**
         * Sets the value of the Blueprints property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockdataautomation.model.BlueprintItem.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.bedrockdataautomation.model.BlueprintItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockdataautomation.model.BlueprintItem.Builder#build()} is called
         * immediately and its result is passed to {@link #blueprints(List<BlueprintItem>)}.
         * 
         * @param blueprints
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockdataautomation.model.BlueprintItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blueprints(java.util.Collection<BlueprintItem>)
         */
        Builder blueprints(Consumer<BlueprintItem.Builder>... blueprints);
    }

    static final class BuilderImpl implements Builder {
        private List<BlueprintItem> blueprints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CustomOutputConfiguration model) {
            blueprints(model.blueprints);
        }

        public final List<BlueprintItem.Builder> getBlueprints() {
            List<BlueprintItem.Builder> result = BlueprintItemsCopier.copyToBuilder(this.blueprints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlueprints(Collection<BlueprintItem.BuilderImpl> blueprints) {
            this.blueprints = BlueprintItemsCopier.copyFromBuilder(blueprints);
        }

        @Override
        public final Builder blueprints(Collection<BlueprintItem> blueprints) {
            this.blueprints = BlueprintItemsCopier.copy(blueprints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blueprints(BlueprintItem... blueprints) {
            blueprints(Arrays.asList(blueprints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blueprints(Consumer<BlueprintItem.Builder>... blueprints) {
            blueprints(Stream.of(blueprints).map(c -> BlueprintItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public CustomOutputConfiguration build() {
            return new CustomOutputConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
