/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Output Format of Document
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentOutputFormat implements SdkPojo, Serializable,
        ToCopyableBuilder<DocumentOutputFormat.Builder, DocumentOutputFormat> {
    private static final SdkField<DocumentOutputTextFormat> TEXT_FORMAT_FIELD = SdkField
            .<DocumentOutputTextFormat> builder(MarshallingType.SDK_POJO).memberName("textFormat")
            .getter(getter(DocumentOutputFormat::textFormat)).setter(setter(Builder::textFormat))
            .constructor(DocumentOutputTextFormat::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("textFormat").build()).build();

    private static final SdkField<DocumentOutputAdditionalFileFormat> ADDITIONAL_FILE_FORMAT_FIELD = SdkField
            .<DocumentOutputAdditionalFileFormat> builder(MarshallingType.SDK_POJO).memberName("additionalFileFormat")
            .getter(getter(DocumentOutputFormat::additionalFileFormat)).setter(setter(Builder::additionalFileFormat))
            .constructor(DocumentOutputAdditionalFileFormat::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalFileFormat").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_FORMAT_FIELD,
            ADDITIONAL_FILE_FORMAT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DocumentOutputTextFormat textFormat;

    private final DocumentOutputAdditionalFileFormat additionalFileFormat;

    private DocumentOutputFormat(BuilderImpl builder) {
        this.textFormat = builder.textFormat;
        this.additionalFileFormat = builder.additionalFileFormat;
    }

    /**
     * Returns the value of the TextFormat property for this object.
     * 
     * @return The value of the TextFormat property for this object.
     */
    public final DocumentOutputTextFormat textFormat() {
        return textFormat;
    }

    /**
     * Returns the value of the AdditionalFileFormat property for this object.
     * 
     * @return The value of the AdditionalFileFormat property for this object.
     */
    public final DocumentOutputAdditionalFileFormat additionalFileFormat() {
        return additionalFileFormat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(textFormat());
        hashCode = 31 * hashCode + Objects.hashCode(additionalFileFormat());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentOutputFormat)) {
            return false;
        }
        DocumentOutputFormat other = (DocumentOutputFormat) obj;
        return Objects.equals(textFormat(), other.textFormat())
                && Objects.equals(additionalFileFormat(), other.additionalFileFormat());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DocumentOutputFormat").add("TextFormat", textFormat())
                .add("AdditionalFileFormat", additionalFileFormat()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "textFormat":
            return Optional.ofNullable(clazz.cast(textFormat()));
        case "additionalFileFormat":
            return Optional.ofNullable(clazz.cast(additionalFileFormat()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("textFormat", TEXT_FORMAT_FIELD);
        map.put("additionalFileFormat", ADDITIONAL_FILE_FORMAT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DocumentOutputFormat, T> g) {
        return obj -> g.apply((DocumentOutputFormat) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocumentOutputFormat> {
        /**
         * Sets the value of the TextFormat property for this object.
         *
         * @param textFormat
         *        The new value for the TextFormat property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textFormat(DocumentOutputTextFormat textFormat);

        /**
         * Sets the value of the TextFormat property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DocumentOutputTextFormat.Builder}
         * avoiding the need to create one manually via {@link DocumentOutputTextFormat#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentOutputTextFormat.Builder#build()} is called immediately
         * and its result is passed to {@link #textFormat(DocumentOutputTextFormat)}.
         * 
         * @param textFormat
         *        a consumer that will call methods on {@link DocumentOutputTextFormat.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #textFormat(DocumentOutputTextFormat)
         */
        default Builder textFormat(Consumer<DocumentOutputTextFormat.Builder> textFormat) {
            return textFormat(DocumentOutputTextFormat.builder().applyMutation(textFormat).build());
        }

        /**
         * Sets the value of the AdditionalFileFormat property for this object.
         *
         * @param additionalFileFormat
         *        The new value for the AdditionalFileFormat property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalFileFormat(DocumentOutputAdditionalFileFormat additionalFileFormat);

        /**
         * Sets the value of the AdditionalFileFormat property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link DocumentOutputAdditionalFileFormat.Builder} avoiding the need to create one manually via
         * {@link DocumentOutputAdditionalFileFormat#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentOutputAdditionalFileFormat.Builder#build()} is called
         * immediately and its result is passed to {@link #additionalFileFormat(DocumentOutputAdditionalFileFormat)}.
         * 
         * @param additionalFileFormat
         *        a consumer that will call methods on {@link DocumentOutputAdditionalFileFormat.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalFileFormat(DocumentOutputAdditionalFileFormat)
         */
        default Builder additionalFileFormat(Consumer<DocumentOutputAdditionalFileFormat.Builder> additionalFileFormat) {
            return additionalFileFormat(DocumentOutputAdditionalFileFormat.builder().applyMutation(additionalFileFormat).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DocumentOutputTextFormat textFormat;

        private DocumentOutputAdditionalFileFormat additionalFileFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentOutputFormat model) {
            textFormat(model.textFormat);
            additionalFileFormat(model.additionalFileFormat);
        }

        public final DocumentOutputTextFormat.Builder getTextFormat() {
            return textFormat != null ? textFormat.toBuilder() : null;
        }

        public final void setTextFormat(DocumentOutputTextFormat.BuilderImpl textFormat) {
            this.textFormat = textFormat != null ? textFormat.build() : null;
        }

        @Override
        public final Builder textFormat(DocumentOutputTextFormat textFormat) {
            this.textFormat = textFormat;
            return this;
        }

        public final DocumentOutputAdditionalFileFormat.Builder getAdditionalFileFormat() {
            return additionalFileFormat != null ? additionalFileFormat.toBuilder() : null;
        }

        public final void setAdditionalFileFormat(DocumentOutputAdditionalFileFormat.BuilderImpl additionalFileFormat) {
            this.additionalFileFormat = additionalFileFormat != null ? additionalFileFormat.build() : null;
        }

        @Override
        public final Builder additionalFileFormat(DocumentOutputAdditionalFileFormat additionalFileFormat) {
            this.additionalFileFormat = additionalFileFormat;
            return this;
        }

        @Override
        public DocumentOutputFormat build() {
            return new DocumentOutputFormat(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
