/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Override configuration
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OverrideConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<OverrideConfiguration.Builder, OverrideConfiguration> {
    private static final SdkField<DocumentOverrideConfiguration> DOCUMENT_FIELD = SdkField
            .<DocumentOverrideConfiguration> builder(MarshallingType.SDK_POJO).memberName("document")
            .getter(getter(OverrideConfiguration::document)).setter(setter(Builder::document))
            .constructor(DocumentOverrideConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("document").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DocumentOverrideConfiguration document;

    private OverrideConfiguration(BuilderImpl builder) {
        this.document = builder.document;
    }

    /**
     * Returns the value of the Document property for this object.
     * 
     * @return The value of the Document property for this object.
     */
    public final DocumentOverrideConfiguration document() {
        return document;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(document());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OverrideConfiguration)) {
            return false;
        }
        OverrideConfiguration other = (OverrideConfiguration) obj;
        return Objects.equals(document(), other.document());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OverrideConfiguration").add("Document", document()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "document":
            return Optional.ofNullable(clazz.cast(document()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("document", DOCUMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OverrideConfiguration, T> g) {
        return obj -> g.apply((OverrideConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OverrideConfiguration> {
        /**
         * Sets the value of the Document property for this object.
         *
         * @param document
         *        The new value for the Document property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder document(DocumentOverrideConfiguration document);

        /**
         * Sets the value of the Document property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DocumentOverrideConfiguration.Builder}
         * avoiding the need to create one manually via {@link DocumentOverrideConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentOverrideConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #document(DocumentOverrideConfiguration)}.
         * 
         * @param document
         *        a consumer that will call methods on {@link DocumentOverrideConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #document(DocumentOverrideConfiguration)
         */
        default Builder document(Consumer<DocumentOverrideConfiguration.Builder> document) {
            return document(DocumentOverrideConfiguration.builder().applyMutation(document).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DocumentOverrideConfiguration document;

        private BuilderImpl() {
        }

        private BuilderImpl(OverrideConfiguration model) {
            document(model.document);
        }

        public final DocumentOverrideConfiguration.Builder getDocument() {
            return document != null ? document.toBuilder() : null;
        }

        public final void setDocument(DocumentOverrideConfiguration.BuilderImpl document) {
            this.document = document != null ? document.build() : null;
        }

        @Override
        public final Builder document(DocumentOverrideConfiguration document) {
            this.document = document;
            return this;
        }

        @Override
        public OverrideConfiguration build() {
            return new OverrideConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
