/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockdataautomation;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.bedrockdataautomation.model.CreateBlueprintRequest;
import software.amazon.awssdk.services.bedrockdataautomation.model.CreateBlueprintResponse;
import software.amazon.awssdk.services.bedrockdataautomation.model.CreateBlueprintVersionRequest;
import software.amazon.awssdk.services.bedrockdataautomation.model.CreateBlueprintVersionResponse;
import software.amazon.awssdk.services.bedrockdataautomation.model.CreateDataAutomationProjectRequest;
import software.amazon.awssdk.services.bedrockdataautomation.model.CreateDataAutomationProjectResponse;
import software.amazon.awssdk.services.bedrockdataautomation.model.DeleteBlueprintRequest;
import software.amazon.awssdk.services.bedrockdataautomation.model.DeleteBlueprintResponse;
import software.amazon.awssdk.services.bedrockdataautomation.model.DeleteDataAutomationProjectRequest;
import software.amazon.awssdk.services.bedrockdataautomation.model.DeleteDataAutomationProjectResponse;
import software.amazon.awssdk.services.bedrockdataautomation.model.GetBlueprintRequest;
import software.amazon.awssdk.services.bedrockdataautomation.model.GetBlueprintResponse;
import software.amazon.awssdk.services.bedrockdataautomation.model.GetDataAutomationProjectRequest;
import software.amazon.awssdk.services.bedrockdataautomation.model.GetDataAutomationProjectResponse;
import software.amazon.awssdk.services.bedrockdataautomation.model.ListBlueprintsRequest;
import software.amazon.awssdk.services.bedrockdataautomation.model.ListBlueprintsResponse;
import software.amazon.awssdk.services.bedrockdataautomation.model.ListDataAutomationProjectsRequest;
import software.amazon.awssdk.services.bedrockdataautomation.model.ListDataAutomationProjectsResponse;
import software.amazon.awssdk.services.bedrockdataautomation.model.UpdateBlueprintRequest;
import software.amazon.awssdk.services.bedrockdataautomation.model.UpdateBlueprintResponse;
import software.amazon.awssdk.services.bedrockdataautomation.model.UpdateDataAutomationProjectRequest;
import software.amazon.awssdk.services.bedrockdataautomation.model.UpdateDataAutomationProjectResponse;
import software.amazon.awssdk.services.bedrockdataautomation.paginators.ListBlueprintsPublisher;
import software.amazon.awssdk.services.bedrockdataautomation.paginators.ListDataAutomationProjectsPublisher;

/**
 * Service client for accessing Data Automation for Amazon Bedrock asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * Amazon Bedrock Data Automation BuildTime
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface BedrockDataAutomationAsyncClient extends AwsClient {
    String SERVICE_NAME = "bedrock";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "bedrock-data-automation";

    /**
     * <p>
     * Creates an Amazon Bedrock Data Automation Blueprint
     * </p>
     *
     * @param createBlueprintRequest
     *        Create Blueprint Request
     * @return A Java Future containing the result of the CreateBlueprint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockDataAutomationException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockDataAutomationAsyncClient.CreateBlueprint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/CreateBlueprint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateBlueprintResponse> createBlueprint(CreateBlueprintRequest createBlueprintRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Bedrock Data Automation Blueprint
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBlueprintRequest.Builder} avoiding the need
     * to create one manually via {@link CreateBlueprintRequest#builder()}
     * </p>
     *
     * @param createBlueprintRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockdataautomation.model.CreateBlueprintRequest.Builder} to
     *        create a request. Create Blueprint Request
     * @return A Java Future containing the result of the CreateBlueprint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockDataAutomationException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockDataAutomationAsyncClient.CreateBlueprint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/CreateBlueprint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateBlueprintResponse> createBlueprint(
            Consumer<CreateBlueprintRequest.Builder> createBlueprintRequest) {
        return createBlueprint(CreateBlueprintRequest.builder().applyMutation(createBlueprintRequest).build());
    }

    /**
     * <p>
     * Creates a new version of an existing Amazon Bedrock Data Automation Blueprint
     * </p>
     *
     * @param createBlueprintVersionRequest
     *        Create Blueprint Version Request
     * @return A Java Future containing the result of the CreateBlueprintVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockDataAutomationException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockDataAutomationAsyncClient.CreateBlueprintVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/CreateBlueprintVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateBlueprintVersionResponse> createBlueprintVersion(
            CreateBlueprintVersionRequest createBlueprintVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new version of an existing Amazon Bedrock Data Automation Blueprint
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBlueprintVersionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateBlueprintVersionRequest#builder()}
     * </p>
     *
     * @param createBlueprintVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockdataautomation.model.CreateBlueprintVersionRequest.Builder}
     *        to create a request. Create Blueprint Version Request
     * @return A Java Future containing the result of the CreateBlueprintVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockDataAutomationException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockDataAutomationAsyncClient.CreateBlueprintVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/CreateBlueprintVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateBlueprintVersionResponse> createBlueprintVersion(
            Consumer<CreateBlueprintVersionRequest.Builder> createBlueprintVersionRequest) {
        return createBlueprintVersion(CreateBlueprintVersionRequest.builder().applyMutation(createBlueprintVersionRequest)
                .build());
    }

    /**
     * <p>
     * Creates an Amazon Bedrock Data Automation Project
     * </p>
     *
     * @param createDataAutomationProjectRequest
     *        Create DataAutomationProject Request
     * @return A Java Future containing the result of the CreateDataAutomationProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockDataAutomationException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockDataAutomationAsyncClient.CreateDataAutomationProject
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/CreateDataAutomationProject"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDataAutomationProjectResponse> createDataAutomationProject(
            CreateDataAutomationProjectRequest createDataAutomationProjectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Bedrock Data Automation Project
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDataAutomationProjectRequest.Builder}
     * avoiding the need to create one manually via {@link CreateDataAutomationProjectRequest#builder()}
     * </p>
     *
     * @param createDataAutomationProjectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockdataautomation.model.CreateDataAutomationProjectRequest.Builder}
     *        to create a request. Create DataAutomationProject Request
     * @return A Java Future containing the result of the CreateDataAutomationProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockDataAutomationException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockDataAutomationAsyncClient.CreateDataAutomationProject
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/CreateDataAutomationProject"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDataAutomationProjectResponse> createDataAutomationProject(
            Consumer<CreateDataAutomationProjectRequest.Builder> createDataAutomationProjectRequest) {
        return createDataAutomationProject(CreateDataAutomationProjectRequest.builder()
                .applyMutation(createDataAutomationProjectRequest).build());
    }

    /**
     * <p>
     * Deletes an existing Amazon Bedrock Data Automation Blueprint
     * </p>
     *
     * @param deleteBlueprintRequest
     *        Delete Blueprint Request
     * @return A Java Future containing the result of the DeleteBlueprint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockDataAutomationException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockDataAutomationAsyncClient.DeleteBlueprint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/DeleteBlueprint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteBlueprintResponse> deleteBlueprint(DeleteBlueprintRequest deleteBlueprintRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing Amazon Bedrock Data Automation Blueprint
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBlueprintRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteBlueprintRequest#builder()}
     * </p>
     *
     * @param deleteBlueprintRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockdataautomation.model.DeleteBlueprintRequest.Builder} to
     *        create a request. Delete Blueprint Request
     * @return A Java Future containing the result of the DeleteBlueprint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockDataAutomationException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockDataAutomationAsyncClient.DeleteBlueprint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/DeleteBlueprint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteBlueprintResponse> deleteBlueprint(
            Consumer<DeleteBlueprintRequest.Builder> deleteBlueprintRequest) {
        return deleteBlueprint(DeleteBlueprintRequest.builder().applyMutation(deleteBlueprintRequest).build());
    }

    /**
     * <p>
     * Deletes an existing Amazon Bedrock Data Automation Project
     * </p>
     *
     * @param deleteDataAutomationProjectRequest
     *        Delete DataAutomationProject Request
     * @return A Java Future containing the result of the DeleteDataAutomationProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockDataAutomationException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockDataAutomationAsyncClient.DeleteDataAutomationProject
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/DeleteDataAutomationProject"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDataAutomationProjectResponse> deleteDataAutomationProject(
            DeleteDataAutomationProjectRequest deleteDataAutomationProjectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing Amazon Bedrock Data Automation Project
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDataAutomationProjectRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteDataAutomationProjectRequest#builder()}
     * </p>
     *
     * @param deleteDataAutomationProjectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockdataautomation.model.DeleteDataAutomationProjectRequest.Builder}
     *        to create a request. Delete DataAutomationProject Request
     * @return A Java Future containing the result of the DeleteDataAutomationProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockDataAutomationException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockDataAutomationAsyncClient.DeleteDataAutomationProject
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/DeleteDataAutomationProject"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDataAutomationProjectResponse> deleteDataAutomationProject(
            Consumer<DeleteDataAutomationProjectRequest.Builder> deleteDataAutomationProjectRequest) {
        return deleteDataAutomationProject(DeleteDataAutomationProjectRequest.builder()
                .applyMutation(deleteDataAutomationProjectRequest).build());
    }

    /**
     * <p>
     * Gets an existing Amazon Bedrock Data Automation Blueprint
     * </p>
     *
     * @param getBlueprintRequest
     *        Get Blueprint Request
     * @return A Java Future containing the result of the GetBlueprint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockDataAutomationException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockDataAutomationAsyncClient.GetBlueprint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/GetBlueprint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetBlueprintResponse> getBlueprint(GetBlueprintRequest getBlueprintRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an existing Amazon Bedrock Data Automation Blueprint
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBlueprintRequest.Builder} avoiding the need to
     * create one manually via {@link GetBlueprintRequest#builder()}
     * </p>
     *
     * @param getBlueprintRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockdataautomation.model.GetBlueprintRequest.Builder} to create
     *        a request. Get Blueprint Request
     * @return A Java Future containing the result of the GetBlueprint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockDataAutomationException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockDataAutomationAsyncClient.GetBlueprint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/GetBlueprint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetBlueprintResponse> getBlueprint(Consumer<GetBlueprintRequest.Builder> getBlueprintRequest) {
        return getBlueprint(GetBlueprintRequest.builder().applyMutation(getBlueprintRequest).build());
    }

    /**
     * <p>
     * Gets an existing Amazon Bedrock Data Automation Project
     * </p>
     *
     * @param getDataAutomationProjectRequest
     *        Get DataAutomationProject Request
     * @return A Java Future containing the result of the GetDataAutomationProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockDataAutomationException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockDataAutomationAsyncClient.GetDataAutomationProject
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/GetDataAutomationProject"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDataAutomationProjectResponse> getDataAutomationProject(
            GetDataAutomationProjectRequest getDataAutomationProjectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an existing Amazon Bedrock Data Automation Project
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataAutomationProjectRequest.Builder} avoiding
     * the need to create one manually via {@link GetDataAutomationProjectRequest#builder()}
     * </p>
     *
     * @param getDataAutomationProjectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockdataautomation.model.GetDataAutomationProjectRequest.Builder}
     *        to create a request. Get DataAutomationProject Request
     * @return A Java Future containing the result of the GetDataAutomationProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockDataAutomationException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockDataAutomationAsyncClient.GetDataAutomationProject
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/GetDataAutomationProject"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDataAutomationProjectResponse> getDataAutomationProject(
            Consumer<GetDataAutomationProjectRequest.Builder> getDataAutomationProjectRequest) {
        return getDataAutomationProject(GetDataAutomationProjectRequest.builder().applyMutation(getDataAutomationProjectRequest)
                .build());
    }

    /**
     * <p>
     * Lists all existing Amazon Bedrock Data Automation Blueprints
     * </p>
     *
     * @param listBlueprintsRequest
     *        List Blueprint Request
     * @return A Java Future containing the result of the ListBlueprints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockDataAutomationException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockDataAutomationAsyncClient.ListBlueprints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/ListBlueprints"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBlueprintsResponse> listBlueprints(ListBlueprintsRequest listBlueprintsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all existing Amazon Bedrock Data Automation Blueprints
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBlueprintsRequest.Builder} avoiding the need to
     * create one manually via {@link ListBlueprintsRequest#builder()}
     * </p>
     *
     * @param listBlueprintsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockdataautomation.model.ListBlueprintsRequest.Builder} to
     *        create a request. List Blueprint Request
     * @return A Java Future containing the result of the ListBlueprints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockDataAutomationException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockDataAutomationAsyncClient.ListBlueprints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/ListBlueprints"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBlueprintsResponse> listBlueprints(Consumer<ListBlueprintsRequest.Builder> listBlueprintsRequest) {
        return listBlueprints(ListBlueprintsRequest.builder().applyMutation(listBlueprintsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBlueprints(software.amazon.awssdk.services.bedrockdataautomation.model.ListBlueprintsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockdataautomation.paginators.ListBlueprintsPublisher publisher = client.listBlueprintsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockdataautomation.paginators.ListBlueprintsPublisher publisher = client.listBlueprintsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockdataautomation.model.ListBlueprintsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockdataautomation.model.ListBlueprintsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBlueprints(software.amazon.awssdk.services.bedrockdataautomation.model.ListBlueprintsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBlueprintsRequest
     *        List Blueprint Request
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockDataAutomationException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockDataAutomationAsyncClient.ListBlueprints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/ListBlueprints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBlueprintsPublisher listBlueprintsPaginator(ListBlueprintsRequest listBlueprintsRequest) {
        return new ListBlueprintsPublisher(this, listBlueprintsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBlueprints(software.amazon.awssdk.services.bedrockdataautomation.model.ListBlueprintsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockdataautomation.paginators.ListBlueprintsPublisher publisher = client.listBlueprintsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockdataautomation.paginators.ListBlueprintsPublisher publisher = client.listBlueprintsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockdataautomation.model.ListBlueprintsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockdataautomation.model.ListBlueprintsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBlueprints(software.amazon.awssdk.services.bedrockdataautomation.model.ListBlueprintsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBlueprintsRequest.Builder} avoiding the need to
     * create one manually via {@link ListBlueprintsRequest#builder()}
     * </p>
     *
     * @param listBlueprintsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockdataautomation.model.ListBlueprintsRequest.Builder} to
     *        create a request. List Blueprint Request
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockDataAutomationException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockDataAutomationAsyncClient.ListBlueprints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/ListBlueprints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBlueprintsPublisher listBlueprintsPaginator(Consumer<ListBlueprintsRequest.Builder> listBlueprintsRequest) {
        return listBlueprintsPaginator(ListBlueprintsRequest.builder().applyMutation(listBlueprintsRequest).build());
    }

    /**
     * <p>
     * Lists all existing Amazon Bedrock Data Automation Projects
     * </p>
     *
     * @param listDataAutomationProjectsRequest
     *        List DataAutomationProject Request
     * @return A Java Future containing the result of the ListDataAutomationProjects operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockDataAutomationException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockDataAutomationAsyncClient.ListDataAutomationProjects
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/ListDataAutomationProjects"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDataAutomationProjectsResponse> listDataAutomationProjects(
            ListDataAutomationProjectsRequest listDataAutomationProjectsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all existing Amazon Bedrock Data Automation Projects
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataAutomationProjectsRequest.Builder} avoiding
     * the need to create one manually via {@link ListDataAutomationProjectsRequest#builder()}
     * </p>
     *
     * @param listDataAutomationProjectsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockdataautomation.model.ListDataAutomationProjectsRequest.Builder}
     *        to create a request. List DataAutomationProject Request
     * @return A Java Future containing the result of the ListDataAutomationProjects operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockDataAutomationException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockDataAutomationAsyncClient.ListDataAutomationProjects
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/ListDataAutomationProjects"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDataAutomationProjectsResponse> listDataAutomationProjects(
            Consumer<ListDataAutomationProjectsRequest.Builder> listDataAutomationProjectsRequest) {
        return listDataAutomationProjects(ListDataAutomationProjectsRequest.builder()
                .applyMutation(listDataAutomationProjectsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataAutomationProjects(software.amazon.awssdk.services.bedrockdataautomation.model.ListDataAutomationProjectsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockdataautomation.paginators.ListDataAutomationProjectsPublisher publisher = client.listDataAutomationProjectsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockdataautomation.paginators.ListDataAutomationProjectsPublisher publisher = client.listDataAutomationProjectsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockdataautomation.model.ListDataAutomationProjectsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockdataautomation.model.ListDataAutomationProjectsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataAutomationProjects(software.amazon.awssdk.services.bedrockdataautomation.model.ListDataAutomationProjectsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDataAutomationProjectsRequest
     *        List DataAutomationProject Request
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockDataAutomationException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockDataAutomationAsyncClient.ListDataAutomationProjects
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/ListDataAutomationProjects"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataAutomationProjectsPublisher listDataAutomationProjectsPaginator(
            ListDataAutomationProjectsRequest listDataAutomationProjectsRequest) {
        return new ListDataAutomationProjectsPublisher(this, listDataAutomationProjectsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataAutomationProjects(software.amazon.awssdk.services.bedrockdataautomation.model.ListDataAutomationProjectsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockdataautomation.paginators.ListDataAutomationProjectsPublisher publisher = client.listDataAutomationProjectsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockdataautomation.paginators.ListDataAutomationProjectsPublisher publisher = client.listDataAutomationProjectsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockdataautomation.model.ListDataAutomationProjectsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockdataautomation.model.ListDataAutomationProjectsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataAutomationProjects(software.amazon.awssdk.services.bedrockdataautomation.model.ListDataAutomationProjectsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataAutomationProjectsRequest.Builder} avoiding
     * the need to create one manually via {@link ListDataAutomationProjectsRequest#builder()}
     * </p>
     *
     * @param listDataAutomationProjectsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockdataautomation.model.ListDataAutomationProjectsRequest.Builder}
     *        to create a request. List DataAutomationProject Request
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockDataAutomationException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockDataAutomationAsyncClient.ListDataAutomationProjects
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/ListDataAutomationProjects"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataAutomationProjectsPublisher listDataAutomationProjectsPaginator(
            Consumer<ListDataAutomationProjectsRequest.Builder> listDataAutomationProjectsRequest) {
        return listDataAutomationProjectsPaginator(ListDataAutomationProjectsRequest.builder()
                .applyMutation(listDataAutomationProjectsRequest).build());
    }

    /**
     * <p>
     * Updates an existing Amazon Bedrock Data Automation Blueprint
     * </p>
     *
     * @param updateBlueprintRequest
     *        Update Blueprint Request
     * @return A Java Future containing the result of the UpdateBlueprint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockDataAutomationException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockDataAutomationAsyncClient.UpdateBlueprint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/UpdateBlueprint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateBlueprintResponse> updateBlueprint(UpdateBlueprintRequest updateBlueprintRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing Amazon Bedrock Data Automation Blueprint
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBlueprintRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateBlueprintRequest#builder()}
     * </p>
     *
     * @param updateBlueprintRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockdataautomation.model.UpdateBlueprintRequest.Builder} to
     *        create a request. Update Blueprint Request
     * @return A Java Future containing the result of the UpdateBlueprint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockDataAutomationException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockDataAutomationAsyncClient.UpdateBlueprint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/UpdateBlueprint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateBlueprintResponse> updateBlueprint(
            Consumer<UpdateBlueprintRequest.Builder> updateBlueprintRequest) {
        return updateBlueprint(UpdateBlueprintRequest.builder().applyMutation(updateBlueprintRequest).build());
    }

    /**
     * <p>
     * Updates an existing Amazon Bedrock Data Automation Project
     * </p>
     *
     * @param updateDataAutomationProjectRequest
     *        Update DataAutomationProject Request
     * @return A Java Future containing the result of the UpdateDataAutomationProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockDataAutomationException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockDataAutomationAsyncClient.UpdateDataAutomationProject
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/UpdateDataAutomationProject"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDataAutomationProjectResponse> updateDataAutomationProject(
            UpdateDataAutomationProjectRequest updateDataAutomationProjectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing Amazon Bedrock Data Automation Project
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDataAutomationProjectRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateDataAutomationProjectRequest#builder()}
     * </p>
     *
     * @param updateDataAutomationProjectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockdataautomation.model.UpdateDataAutomationProjectRequest.Builder}
     *        to create a request. Update DataAutomationProject Request
     * @return A Java Future containing the result of the UpdateDataAutomationProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockDataAutomationException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockDataAutomationAsyncClient.UpdateDataAutomationProject
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/UpdateDataAutomationProject"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDataAutomationProjectResponse> updateDataAutomationProject(
            Consumer<UpdateDataAutomationProjectRequest.Builder> updateDataAutomationProjectRequest) {
        return updateDataAutomationProject(UpdateDataAutomationProjectRequest.builder()
                .applyMutation(updateDataAutomationProjectRequest).build());
    }

    @Override
    default BedrockDataAutomationServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link BedrockDataAutomationAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static BedrockDataAutomationAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link BedrockDataAutomationAsyncClient}.
     */
    static BedrockDataAutomationAsyncClientBuilder builder() {
        return new DefaultBedrockDataAutomationAsyncClientBuilder();
    }
}
