/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary of a Blueprint
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BlueprintSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<BlueprintSummary.Builder, BlueprintSummary> {
    private static final SdkField<String> BLUEPRINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("blueprintArn").getter(getter(BlueprintSummary::blueprintArn)).setter(setter(Builder::blueprintArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprintArn").build()).build();

    private static final SdkField<String> BLUEPRINT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("blueprintVersion").getter(getter(BlueprintSummary::blueprintVersion))
            .setter(setter(Builder::blueprintVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprintVersion").build()).build();

    private static final SdkField<String> BLUEPRINT_STAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("blueprintStage").getter(getter(BlueprintSummary::blueprintStageAsString))
            .setter(setter(Builder::blueprintStage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprintStage").build()).build();

    private static final SdkField<String> BLUEPRINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("blueprintName").getter(getter(BlueprintSummary::blueprintName)).setter(setter(Builder::blueprintName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprintName").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(BlueprintSummary::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedTime")
            .getter(getter(BlueprintSummary::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLUEPRINT_ARN_FIELD,
            BLUEPRINT_VERSION_FIELD, BLUEPRINT_STAGE_FIELD, BLUEPRINT_NAME_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String blueprintArn;

    private final String blueprintVersion;

    private final String blueprintStage;

    private final String blueprintName;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private BlueprintSummary(BuilderImpl builder) {
        this.blueprintArn = builder.blueprintArn;
        this.blueprintVersion = builder.blueprintVersion;
        this.blueprintStage = builder.blueprintStage;
        this.blueprintName = builder.blueprintName;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    /**
     * Returns the value of the BlueprintArn property for this object.
     * 
     * @return The value of the BlueprintArn property for this object.
     */
    public final String blueprintArn() {
        return blueprintArn;
    }

    /**
     * Returns the value of the BlueprintVersion property for this object.
     * 
     * @return The value of the BlueprintVersion property for this object.
     */
    public final String blueprintVersion() {
        return blueprintVersion;
    }

    /**
     * Returns the value of the BlueprintStage property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #blueprintStage}
     * will return {@link BlueprintStage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #blueprintStageAsString}.
     * </p>
     * 
     * @return The value of the BlueprintStage property for this object.
     * @see BlueprintStage
     */
    public final BlueprintStage blueprintStage() {
        return BlueprintStage.fromValue(blueprintStage);
    }

    /**
     * Returns the value of the BlueprintStage property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #blueprintStage}
     * will return {@link BlueprintStage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #blueprintStageAsString}.
     * </p>
     * 
     * @return The value of the BlueprintStage property for this object.
     * @see BlueprintStage
     */
    public final String blueprintStageAsString() {
        return blueprintStage;
    }

    /**
     * Returns the value of the BlueprintName property for this object.
     * 
     * @return The value of the BlueprintName property for this object.
     */
    public final String blueprintName() {
        return blueprintName;
    }

    /**
     * Returns the value of the CreationTime property for this object.
     * 
     * @return The value of the CreationTime property for this object.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * Returns the value of the LastModifiedTime property for this object.
     * 
     * @return The value of the LastModifiedTime property for this object.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(blueprintArn());
        hashCode = 31 * hashCode + Objects.hashCode(blueprintVersion());
        hashCode = 31 * hashCode + Objects.hashCode(blueprintStageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(blueprintName());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlueprintSummary)) {
            return false;
        }
        BlueprintSummary other = (BlueprintSummary) obj;
        return Objects.equals(blueprintArn(), other.blueprintArn())
                && Objects.equals(blueprintVersion(), other.blueprintVersion())
                && Objects.equals(blueprintStageAsString(), other.blueprintStageAsString())
                && Objects.equals(blueprintName(), other.blueprintName()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BlueprintSummary").add("BlueprintArn", blueprintArn())
                .add("BlueprintVersion", blueprintVersion()).add("BlueprintStage", blueprintStageAsString())
                .add("BlueprintName", blueprintName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CreationTime", creationTime()).add("LastModifiedTime", lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "blueprintArn":
            return Optional.ofNullable(clazz.cast(blueprintArn()));
        case "blueprintVersion":
            return Optional.ofNullable(clazz.cast(blueprintVersion()));
        case "blueprintStage":
            return Optional.ofNullable(clazz.cast(blueprintStageAsString()));
        case "blueprintName":
            return Optional.ofNullable(clazz.cast(blueprintName()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("blueprintArn", BLUEPRINT_ARN_FIELD);
        map.put("blueprintVersion", BLUEPRINT_VERSION_FIELD);
        map.put("blueprintStage", BLUEPRINT_STAGE_FIELD);
        map.put("blueprintName", BLUEPRINT_NAME_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("lastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BlueprintSummary, T> g) {
        return obj -> g.apply((BlueprintSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BlueprintSummary> {
        /**
         * Sets the value of the BlueprintArn property for this object.
         *
         * @param blueprintArn
         *        The new value for the BlueprintArn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprintArn(String blueprintArn);

        /**
         * Sets the value of the BlueprintVersion property for this object.
         *
         * @param blueprintVersion
         *        The new value for the BlueprintVersion property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprintVersion(String blueprintVersion);

        /**
         * Sets the value of the BlueprintStage property for this object.
         *
         * @param blueprintStage
         *        The new value for the BlueprintStage property for this object.
         * @see BlueprintStage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BlueprintStage
         */
        Builder blueprintStage(String blueprintStage);

        /**
         * Sets the value of the BlueprintStage property for this object.
         *
         * @param blueprintStage
         *        The new value for the BlueprintStage property for this object.
         * @see BlueprintStage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BlueprintStage
         */
        Builder blueprintStage(BlueprintStage blueprintStage);

        /**
         * Sets the value of the BlueprintName property for this object.
         *
         * @param blueprintName
         *        The new value for the BlueprintName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprintName(String blueprintName);

        /**
         * Sets the value of the CreationTime property for this object.
         *
         * @param creationTime
         *        The new value for the CreationTime property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * Sets the value of the LastModifiedTime property for this object.
         *
         * @param lastModifiedTime
         *        The new value for the LastModifiedTime property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);
    }

    static final class BuilderImpl implements Builder {
        private String blueprintArn;

        private String blueprintVersion;

        private String blueprintStage;

        private String blueprintName;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(BlueprintSummary model) {
            blueprintArn(model.blueprintArn);
            blueprintVersion(model.blueprintVersion);
            blueprintStage(model.blueprintStage);
            blueprintName(model.blueprintName);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
        }

        public final String getBlueprintArn() {
            return blueprintArn;
        }

        public final void setBlueprintArn(String blueprintArn) {
            this.blueprintArn = blueprintArn;
        }

        @Override
        public final Builder blueprintArn(String blueprintArn) {
            this.blueprintArn = blueprintArn;
            return this;
        }

        public final String getBlueprintVersion() {
            return blueprintVersion;
        }

        public final void setBlueprintVersion(String blueprintVersion) {
            this.blueprintVersion = blueprintVersion;
        }

        @Override
        public final Builder blueprintVersion(String blueprintVersion) {
            this.blueprintVersion = blueprintVersion;
            return this;
        }

        public final String getBlueprintStage() {
            return blueprintStage;
        }

        public final void setBlueprintStage(String blueprintStage) {
            this.blueprintStage = blueprintStage;
        }

        @Override
        public final Builder blueprintStage(String blueprintStage) {
            this.blueprintStage = blueprintStage;
            return this;
        }

        @Override
        public final Builder blueprintStage(BlueprintStage blueprintStage) {
            this.blueprintStage(blueprintStage == null ? null : blueprintStage.toString());
            return this;
        }

        public final String getBlueprintName() {
            return blueprintName;
        }

        public final void setBlueprintName(String blueprintName) {
            this.blueprintName = blueprintName;
        }

        @Override
        public final Builder blueprintName(String blueprintName) {
            this.blueprintName = blueprintName;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        @Override
        public BlueprintSummary build() {
            return new BlueprintSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
