/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Standard Extraction Configuration of Document
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentStandardExtraction implements SdkPojo, Serializable,
        ToCopyableBuilder<DocumentStandardExtraction.Builder, DocumentStandardExtraction> {
    private static final SdkField<DocumentExtractionGranularity> GRANULARITY_FIELD = SdkField
            .<DocumentExtractionGranularity> builder(MarshallingType.SDK_POJO).memberName("granularity")
            .getter(getter(DocumentStandardExtraction::granularity)).setter(setter(Builder::granularity))
            .constructor(DocumentExtractionGranularity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("granularity").build()).build();

    private static final SdkField<DocumentBoundingBox> BOUNDING_BOX_FIELD = SdkField
            .<DocumentBoundingBox> builder(MarshallingType.SDK_POJO).memberName("boundingBox")
            .getter(getter(DocumentStandardExtraction::boundingBox)).setter(setter(Builder::boundingBox))
            .constructor(DocumentBoundingBox::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("boundingBox").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRANULARITY_FIELD,
            BOUNDING_BOX_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DocumentExtractionGranularity granularity;

    private final DocumentBoundingBox boundingBox;

    private DocumentStandardExtraction(BuilderImpl builder) {
        this.granularity = builder.granularity;
        this.boundingBox = builder.boundingBox;
    }

    /**
     * Returns the value of the Granularity property for this object.
     * 
     * @return The value of the Granularity property for this object.
     */
    public final DocumentExtractionGranularity granularity() {
        return granularity;
    }

    /**
     * Returns the value of the BoundingBox property for this object.
     * 
     * @return The value of the BoundingBox property for this object.
     */
    public final DocumentBoundingBox boundingBox() {
        return boundingBox;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(granularity());
        hashCode = 31 * hashCode + Objects.hashCode(boundingBox());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentStandardExtraction)) {
            return false;
        }
        DocumentStandardExtraction other = (DocumentStandardExtraction) obj;
        return Objects.equals(granularity(), other.granularity()) && Objects.equals(boundingBox(), other.boundingBox());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DocumentStandardExtraction").add("Granularity", granularity()).add("BoundingBox", boundingBox())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "granularity":
            return Optional.ofNullable(clazz.cast(granularity()));
        case "boundingBox":
            return Optional.ofNullable(clazz.cast(boundingBox()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("granularity", GRANULARITY_FIELD);
        map.put("boundingBox", BOUNDING_BOX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DocumentStandardExtraction, T> g) {
        return obj -> g.apply((DocumentStandardExtraction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocumentStandardExtraction> {
        /**
         * Sets the value of the Granularity property for this object.
         *
         * @param granularity
         *        The new value for the Granularity property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder granularity(DocumentExtractionGranularity granularity);

        /**
         * Sets the value of the Granularity property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DocumentExtractionGranularity.Builder}
         * avoiding the need to create one manually via {@link DocumentExtractionGranularity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentExtractionGranularity.Builder#build()} is called
         * immediately and its result is passed to {@link #granularity(DocumentExtractionGranularity)}.
         * 
         * @param granularity
         *        a consumer that will call methods on {@link DocumentExtractionGranularity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #granularity(DocumentExtractionGranularity)
         */
        default Builder granularity(Consumer<DocumentExtractionGranularity.Builder> granularity) {
            return granularity(DocumentExtractionGranularity.builder().applyMutation(granularity).build());
        }

        /**
         * Sets the value of the BoundingBox property for this object.
         *
         * @param boundingBox
         *        The new value for the BoundingBox property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder boundingBox(DocumentBoundingBox boundingBox);

        /**
         * Sets the value of the BoundingBox property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DocumentBoundingBox.Builder} avoiding the
         * need to create one manually via {@link DocumentBoundingBox#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentBoundingBox.Builder#build()} is called immediately and
         * its result is passed to {@link #boundingBox(DocumentBoundingBox)}.
         * 
         * @param boundingBox
         *        a consumer that will call methods on {@link DocumentBoundingBox.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #boundingBox(DocumentBoundingBox)
         */
        default Builder boundingBox(Consumer<DocumentBoundingBox.Builder> boundingBox) {
            return boundingBox(DocumentBoundingBox.builder().applyMutation(boundingBox).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DocumentExtractionGranularity granularity;

        private DocumentBoundingBox boundingBox;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentStandardExtraction model) {
            granularity(model.granularity);
            boundingBox(model.boundingBox);
        }

        public final DocumentExtractionGranularity.Builder getGranularity() {
            return granularity != null ? granularity.toBuilder() : null;
        }

        public final void setGranularity(DocumentExtractionGranularity.BuilderImpl granularity) {
            this.granularity = granularity != null ? granularity.build() : null;
        }

        @Override
        public final Builder granularity(DocumentExtractionGranularity granularity) {
            this.granularity = granularity;
            return this;
        }

        public final DocumentBoundingBox.Builder getBoundingBox() {
            return boundingBox != null ? boundingBox.toBuilder() : null;
        }

        public final void setBoundingBox(DocumentBoundingBox.BuilderImpl boundingBox) {
            this.boundingBox = boundingBox != null ? boundingBox.build() : null;
        }

        @Override
        public final Builder boundingBox(DocumentBoundingBox boundingBox) {
            this.boundingBox = boundingBox;
            return this;
        }

        @Override
        public DocumentStandardExtraction build() {
            return new DocumentStandardExtraction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
