/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Blueprint Filter
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BlueprintFilter implements SdkPojo, Serializable, ToCopyableBuilder<BlueprintFilter.Builder, BlueprintFilter> {
    private static final SdkField<String> BLUEPRINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("blueprintArn").getter(getter(BlueprintFilter::blueprintArn)).setter(setter(Builder::blueprintArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprintArn").build()).build();

    private static final SdkField<String> BLUEPRINT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("blueprintVersion").getter(getter(BlueprintFilter::blueprintVersion))
            .setter(setter(Builder::blueprintVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprintVersion").build()).build();

    private static final SdkField<String> BLUEPRINT_STAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("blueprintStage").getter(getter(BlueprintFilter::blueprintStageAsString))
            .setter(setter(Builder::blueprintStage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprintStage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLUEPRINT_ARN_FIELD,
            BLUEPRINT_VERSION_FIELD, BLUEPRINT_STAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String blueprintArn;

    private final String blueprintVersion;

    private final String blueprintStage;

    private BlueprintFilter(BuilderImpl builder) {
        this.blueprintArn = builder.blueprintArn;
        this.blueprintVersion = builder.blueprintVersion;
        this.blueprintStage = builder.blueprintStage;
    }

    /**
     * Returns the value of the BlueprintArn property for this object.
     * 
     * @return The value of the BlueprintArn property for this object.
     */
    public final String blueprintArn() {
        return blueprintArn;
    }

    /**
     * Returns the value of the BlueprintVersion property for this object.
     * 
     * @return The value of the BlueprintVersion property for this object.
     */
    public final String blueprintVersion() {
        return blueprintVersion;
    }

    /**
     * Returns the value of the BlueprintStage property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #blueprintStage}
     * will return {@link BlueprintStage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #blueprintStageAsString}.
     * </p>
     * 
     * @return The value of the BlueprintStage property for this object.
     * @see BlueprintStage
     */
    public final BlueprintStage blueprintStage() {
        return BlueprintStage.fromValue(blueprintStage);
    }

    /**
     * Returns the value of the BlueprintStage property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #blueprintStage}
     * will return {@link BlueprintStage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #blueprintStageAsString}.
     * </p>
     * 
     * @return The value of the BlueprintStage property for this object.
     * @see BlueprintStage
     */
    public final String blueprintStageAsString() {
        return blueprintStage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(blueprintArn());
        hashCode = 31 * hashCode + Objects.hashCode(blueprintVersion());
        hashCode = 31 * hashCode + Objects.hashCode(blueprintStageAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlueprintFilter)) {
            return false;
        }
        BlueprintFilter other = (BlueprintFilter) obj;
        return Objects.equals(blueprintArn(), other.blueprintArn())
                && Objects.equals(blueprintVersion(), other.blueprintVersion())
                && Objects.equals(blueprintStageAsString(), other.blueprintStageAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BlueprintFilter").add("BlueprintArn", blueprintArn())
                .add("BlueprintVersion", blueprintVersion()).add("BlueprintStage", blueprintStageAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "blueprintArn":
            return Optional.ofNullable(clazz.cast(blueprintArn()));
        case "blueprintVersion":
            return Optional.ofNullable(clazz.cast(blueprintVersion()));
        case "blueprintStage":
            return Optional.ofNullable(clazz.cast(blueprintStageAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("blueprintArn", BLUEPRINT_ARN_FIELD);
        map.put("blueprintVersion", BLUEPRINT_VERSION_FIELD);
        map.put("blueprintStage", BLUEPRINT_STAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BlueprintFilter, T> g) {
        return obj -> g.apply((BlueprintFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BlueprintFilter> {
        /**
         * Sets the value of the BlueprintArn property for this object.
         *
         * @param blueprintArn
         *        The new value for the BlueprintArn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprintArn(String blueprintArn);

        /**
         * Sets the value of the BlueprintVersion property for this object.
         *
         * @param blueprintVersion
         *        The new value for the BlueprintVersion property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprintVersion(String blueprintVersion);

        /**
         * Sets the value of the BlueprintStage property for this object.
         *
         * @param blueprintStage
         *        The new value for the BlueprintStage property for this object.
         * @see BlueprintStage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BlueprintStage
         */
        Builder blueprintStage(String blueprintStage);

        /**
         * Sets the value of the BlueprintStage property for this object.
         *
         * @param blueprintStage
         *        The new value for the BlueprintStage property for this object.
         * @see BlueprintStage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BlueprintStage
         */
        Builder blueprintStage(BlueprintStage blueprintStage);
    }

    static final class BuilderImpl implements Builder {
        private String blueprintArn;

        private String blueprintVersion;

        private String blueprintStage;

        private BuilderImpl() {
        }

        private BuilderImpl(BlueprintFilter model) {
            blueprintArn(model.blueprintArn);
            blueprintVersion(model.blueprintVersion);
            blueprintStage(model.blueprintStage);
        }

        public final String getBlueprintArn() {
            return blueprintArn;
        }

        public final void setBlueprintArn(String blueprintArn) {
            this.blueprintArn = blueprintArn;
        }

        @Override
        public final Builder blueprintArn(String blueprintArn) {
            this.blueprintArn = blueprintArn;
            return this;
        }

        public final String getBlueprintVersion() {
            return blueprintVersion;
        }

        public final void setBlueprintVersion(String blueprintVersion) {
            this.blueprintVersion = blueprintVersion;
        }

        @Override
        public final Builder blueprintVersion(String blueprintVersion) {
            this.blueprintVersion = blueprintVersion;
            return this;
        }

        public final String getBlueprintStage() {
            return blueprintStage;
        }

        public final void setBlueprintStage(String blueprintStage) {
            this.blueprintStage = blueprintStage;
        }

        @Override
        public final Builder blueprintStage(String blueprintStage) {
            this.blueprintStage = blueprintStage;
            return this;
        }

        @Override
        public final Builder blueprintStage(BlueprintStage blueprintStage) {
            this.blueprintStage(blueprintStage == null ? null : blueprintStage.toString());
            return this;
        }

        @Override
        public BlueprintFilter build() {
            return new BlueprintFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
