/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockdataautomation;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.bedrockdataautomation.model.AccessDeniedException;
import software.amazon.awssdk.services.bedrockdataautomation.model.BedrockDataAutomationException;
import software.amazon.awssdk.services.bedrockdataautomation.model.ConflictException;
import software.amazon.awssdk.services.bedrockdataautomation.model.CreateBlueprintRequest;
import software.amazon.awssdk.services.bedrockdataautomation.model.CreateBlueprintResponse;
import software.amazon.awssdk.services.bedrockdataautomation.model.CreateBlueprintVersionRequest;
import software.amazon.awssdk.services.bedrockdataautomation.model.CreateBlueprintVersionResponse;
import software.amazon.awssdk.services.bedrockdataautomation.model.CreateDataAutomationProjectRequest;
import software.amazon.awssdk.services.bedrockdataautomation.model.CreateDataAutomationProjectResponse;
import software.amazon.awssdk.services.bedrockdataautomation.model.DeleteBlueprintRequest;
import software.amazon.awssdk.services.bedrockdataautomation.model.DeleteBlueprintResponse;
import software.amazon.awssdk.services.bedrockdataautomation.model.DeleteDataAutomationProjectRequest;
import software.amazon.awssdk.services.bedrockdataautomation.model.DeleteDataAutomationProjectResponse;
import software.amazon.awssdk.services.bedrockdataautomation.model.GetBlueprintRequest;
import software.amazon.awssdk.services.bedrockdataautomation.model.GetBlueprintResponse;
import software.amazon.awssdk.services.bedrockdataautomation.model.GetDataAutomationProjectRequest;
import software.amazon.awssdk.services.bedrockdataautomation.model.GetDataAutomationProjectResponse;
import software.amazon.awssdk.services.bedrockdataautomation.model.InternalServerException;
import software.amazon.awssdk.services.bedrockdataautomation.model.ListBlueprintsRequest;
import software.amazon.awssdk.services.bedrockdataautomation.model.ListBlueprintsResponse;
import software.amazon.awssdk.services.bedrockdataautomation.model.ListDataAutomationProjectsRequest;
import software.amazon.awssdk.services.bedrockdataautomation.model.ListDataAutomationProjectsResponse;
import software.amazon.awssdk.services.bedrockdataautomation.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.bedrockdataautomation.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.bedrockdataautomation.model.ResourceNotFoundException;
import software.amazon.awssdk.services.bedrockdataautomation.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.bedrockdataautomation.model.TagResourceRequest;
import software.amazon.awssdk.services.bedrockdataautomation.model.TagResourceResponse;
import software.amazon.awssdk.services.bedrockdataautomation.model.ThrottlingException;
import software.amazon.awssdk.services.bedrockdataautomation.model.UntagResourceRequest;
import software.amazon.awssdk.services.bedrockdataautomation.model.UntagResourceResponse;
import software.amazon.awssdk.services.bedrockdataautomation.model.UpdateBlueprintRequest;
import software.amazon.awssdk.services.bedrockdataautomation.model.UpdateBlueprintResponse;
import software.amazon.awssdk.services.bedrockdataautomation.model.UpdateDataAutomationProjectRequest;
import software.amazon.awssdk.services.bedrockdataautomation.model.UpdateDataAutomationProjectResponse;
import software.amazon.awssdk.services.bedrockdataautomation.model.ValidationException;
import software.amazon.awssdk.services.bedrockdataautomation.paginators.ListBlueprintsIterable;
import software.amazon.awssdk.services.bedrockdataautomation.paginators.ListDataAutomationProjectsIterable;

/**
 * Service client for accessing Data Automation for Amazon Bedrock. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * Amazon Bedrock Data Automation BuildTime
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface BedrockDataAutomationClient extends AwsClient {
    String SERVICE_NAME = "bedrock";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "bedrock-data-automation";

    /**
     * <p>
     * Creates an Amazon Bedrock Data Automation Blueprint
     * </p>
     *
     * @param createBlueprintRequest
     *        Create Blueprint Request
     * @return Result of the CreateBlueprint operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws ValidationException
     *         This exception is thrown when the request's input validation fails
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockDataAutomationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockDataAutomationClient.CreateBlueprint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/CreateBlueprint"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateBlueprintResponse createBlueprint(CreateBlueprintRequest createBlueprintRequest)
            throws ServiceQuotaExceededException, ValidationException, ConflictException, InternalServerException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, BedrockDataAutomationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Bedrock Data Automation Blueprint
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBlueprintRequest.Builder} avoiding the need
     * to create one manually via {@link CreateBlueprintRequest#builder()}
     * </p>
     *
     * @param createBlueprintRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockdataautomation.model.CreateBlueprintRequest.Builder} to
     *        create a request. Create Blueprint Request
     * @return Result of the CreateBlueprint operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws ValidationException
     *         This exception is thrown when the request's input validation fails
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockDataAutomationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockDataAutomationClient.CreateBlueprint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/CreateBlueprint"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateBlueprintResponse createBlueprint(Consumer<CreateBlueprintRequest.Builder> createBlueprintRequest)
            throws ServiceQuotaExceededException, ValidationException, ConflictException, InternalServerException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, BedrockDataAutomationException {
        return createBlueprint(CreateBlueprintRequest.builder().applyMutation(createBlueprintRequest).build());
    }

    /**
     * <p>
     * Creates a new version of an existing Amazon Bedrock Data Automation Blueprint
     * </p>
     *
     * @param createBlueprintVersionRequest
     *        Create Blueprint Version Request
     * @return Result of the CreateBlueprintVersion operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws ValidationException
     *         This exception is thrown when the request's input validation fails
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockDataAutomationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockDataAutomationClient.CreateBlueprintVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/CreateBlueprintVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateBlueprintVersionResponse createBlueprintVersion(CreateBlueprintVersionRequest createBlueprintVersionRequest)
            throws ServiceQuotaExceededException, ValidationException, InternalServerException, ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            BedrockDataAutomationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new version of an existing Amazon Bedrock Data Automation Blueprint
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBlueprintVersionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateBlueprintVersionRequest#builder()}
     * </p>
     *
     * @param createBlueprintVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockdataautomation.model.CreateBlueprintVersionRequest.Builder}
     *        to create a request. Create Blueprint Version Request
     * @return Result of the CreateBlueprintVersion operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws ValidationException
     *         This exception is thrown when the request's input validation fails
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockDataAutomationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockDataAutomationClient.CreateBlueprintVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/CreateBlueprintVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateBlueprintVersionResponse createBlueprintVersion(
            Consumer<CreateBlueprintVersionRequest.Builder> createBlueprintVersionRequest) throws ServiceQuotaExceededException,
            ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, BedrockDataAutomationException {
        return createBlueprintVersion(CreateBlueprintVersionRequest.builder().applyMutation(createBlueprintVersionRequest)
                .build());
    }

    /**
     * <p>
     * Creates an Amazon Bedrock Data Automation Project
     * </p>
     *
     * @param createDataAutomationProjectRequest
     *        Create DataAutomationProject Request
     * @return Result of the CreateDataAutomationProject operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws ValidationException
     *         This exception is thrown when the request's input validation fails
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockDataAutomationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockDataAutomationClient.CreateDataAutomationProject
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/CreateDataAutomationProject"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDataAutomationProjectResponse createDataAutomationProject(
            CreateDataAutomationProjectRequest createDataAutomationProjectRequest) throws ServiceQuotaExceededException,
            ValidationException, ConflictException, InternalServerException, ThrottlingException, AccessDeniedException,
            AwsServiceException, SdkClientException, BedrockDataAutomationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Bedrock Data Automation Project
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDataAutomationProjectRequest.Builder}
     * avoiding the need to create one manually via {@link CreateDataAutomationProjectRequest#builder()}
     * </p>
     *
     * @param createDataAutomationProjectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockdataautomation.model.CreateDataAutomationProjectRequest.Builder}
     *        to create a request. Create DataAutomationProject Request
     * @return Result of the CreateDataAutomationProject operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws ValidationException
     *         This exception is thrown when the request's input validation fails
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockDataAutomationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockDataAutomationClient.CreateDataAutomationProject
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/CreateDataAutomationProject"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDataAutomationProjectResponse createDataAutomationProject(
            Consumer<CreateDataAutomationProjectRequest.Builder> createDataAutomationProjectRequest)
            throws ServiceQuotaExceededException, ValidationException, ConflictException, InternalServerException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, BedrockDataAutomationException {
        return createDataAutomationProject(CreateDataAutomationProjectRequest.builder()
                .applyMutation(createDataAutomationProjectRequest).build());
    }

    /**
     * <p>
     * Deletes an existing Amazon Bedrock Data Automation Blueprint
     * </p>
     *
     * @param deleteBlueprintRequest
     *        Delete Blueprint Request
     * @return Result of the DeleteBlueprint operation returned by the service.
     * @throws ValidationException
     *         This exception is thrown when the request's input validation fails
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockDataAutomationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockDataAutomationClient.DeleteBlueprint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/DeleteBlueprint"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteBlueprintResponse deleteBlueprint(DeleteBlueprintRequest deleteBlueprintRequest) throws ValidationException,
            InternalServerException, ThrottlingException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BedrockDataAutomationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing Amazon Bedrock Data Automation Blueprint
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBlueprintRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteBlueprintRequest#builder()}
     * </p>
     *
     * @param deleteBlueprintRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockdataautomation.model.DeleteBlueprintRequest.Builder} to
     *        create a request. Delete Blueprint Request
     * @return Result of the DeleteBlueprint operation returned by the service.
     * @throws ValidationException
     *         This exception is thrown when the request's input validation fails
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockDataAutomationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockDataAutomationClient.DeleteBlueprint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/DeleteBlueprint"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteBlueprintResponse deleteBlueprint(Consumer<DeleteBlueprintRequest.Builder> deleteBlueprintRequest)
            throws ValidationException, InternalServerException, ThrottlingException, AccessDeniedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BedrockDataAutomationException {
        return deleteBlueprint(DeleteBlueprintRequest.builder().applyMutation(deleteBlueprintRequest).build());
    }

    /**
     * <p>
     * Deletes an existing Amazon Bedrock Data Automation Project
     * </p>
     *
     * @param deleteDataAutomationProjectRequest
     *        Delete DataAutomationProject Request
     * @return Result of the DeleteDataAutomationProject operation returned by the service.
     * @throws ValidationException
     *         This exception is thrown when the request's input validation fails
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockDataAutomationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockDataAutomationClient.DeleteDataAutomationProject
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/DeleteDataAutomationProject"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDataAutomationProjectResponse deleteDataAutomationProject(
            DeleteDataAutomationProjectRequest deleteDataAutomationProjectRequest) throws ValidationException,
            InternalServerException, ThrottlingException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BedrockDataAutomationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing Amazon Bedrock Data Automation Project
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDataAutomationProjectRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteDataAutomationProjectRequest#builder()}
     * </p>
     *
     * @param deleteDataAutomationProjectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockdataautomation.model.DeleteDataAutomationProjectRequest.Builder}
     *        to create a request. Delete DataAutomationProject Request
     * @return Result of the DeleteDataAutomationProject operation returned by the service.
     * @throws ValidationException
     *         This exception is thrown when the request's input validation fails
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockDataAutomationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockDataAutomationClient.DeleteDataAutomationProject
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/DeleteDataAutomationProject"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDataAutomationProjectResponse deleteDataAutomationProject(
            Consumer<DeleteDataAutomationProjectRequest.Builder> deleteDataAutomationProjectRequest) throws ValidationException,
            InternalServerException, ThrottlingException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BedrockDataAutomationException {
        return deleteDataAutomationProject(DeleteDataAutomationProjectRequest.builder()
                .applyMutation(deleteDataAutomationProjectRequest).build());
    }

    /**
     * <p>
     * Gets an existing Amazon Bedrock Data Automation Blueprint
     * </p>
     *
     * @param getBlueprintRequest
     *        Get Blueprint Request
     * @return Result of the GetBlueprint operation returned by the service.
     * @throws ValidationException
     *         This exception is thrown when the request's input validation fails
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockDataAutomationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockDataAutomationClient.GetBlueprint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/GetBlueprint"
     *      target="_top">AWS API Documentation</a>
     */
    default GetBlueprintResponse getBlueprint(GetBlueprintRequest getBlueprintRequest) throws ValidationException,
            InternalServerException, ThrottlingException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BedrockDataAutomationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an existing Amazon Bedrock Data Automation Blueprint
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBlueprintRequest.Builder} avoiding the need to
     * create one manually via {@link GetBlueprintRequest#builder()}
     * </p>
     *
     * @param getBlueprintRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockdataautomation.model.GetBlueprintRequest.Builder} to create
     *        a request. Get Blueprint Request
     * @return Result of the GetBlueprint operation returned by the service.
     * @throws ValidationException
     *         This exception is thrown when the request's input validation fails
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockDataAutomationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockDataAutomationClient.GetBlueprint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/GetBlueprint"
     *      target="_top">AWS API Documentation</a>
     */
    default GetBlueprintResponse getBlueprint(Consumer<GetBlueprintRequest.Builder> getBlueprintRequest)
            throws ValidationException, InternalServerException, ThrottlingException, AccessDeniedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BedrockDataAutomationException {
        return getBlueprint(GetBlueprintRequest.builder().applyMutation(getBlueprintRequest).build());
    }

    /**
     * <p>
     * Gets an existing Amazon Bedrock Data Automation Project
     * </p>
     *
     * @param getDataAutomationProjectRequest
     *        Get DataAutomationProject Request
     * @return Result of the GetDataAutomationProject operation returned by the service.
     * @throws ValidationException
     *         This exception is thrown when the request's input validation fails
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockDataAutomationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockDataAutomationClient.GetDataAutomationProject
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/GetDataAutomationProject"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDataAutomationProjectResponse getDataAutomationProject(
            GetDataAutomationProjectRequest getDataAutomationProjectRequest) throws ValidationException, InternalServerException,
            ThrottlingException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            BedrockDataAutomationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an existing Amazon Bedrock Data Automation Project
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataAutomationProjectRequest.Builder} avoiding
     * the need to create one manually via {@link GetDataAutomationProjectRequest#builder()}
     * </p>
     *
     * @param getDataAutomationProjectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockdataautomation.model.GetDataAutomationProjectRequest.Builder}
     *        to create a request. Get DataAutomationProject Request
     * @return Result of the GetDataAutomationProject operation returned by the service.
     * @throws ValidationException
     *         This exception is thrown when the request's input validation fails
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockDataAutomationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockDataAutomationClient.GetDataAutomationProject
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/GetDataAutomationProject"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDataAutomationProjectResponse getDataAutomationProject(
            Consumer<GetDataAutomationProjectRequest.Builder> getDataAutomationProjectRequest) throws ValidationException,
            InternalServerException, ThrottlingException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BedrockDataAutomationException {
        return getDataAutomationProject(GetDataAutomationProjectRequest.builder().applyMutation(getDataAutomationProjectRequest)
                .build());
    }

    /**
     * <p>
     * Lists all existing Amazon Bedrock Data Automation Blueprints
     * </p>
     *
     * @param listBlueprintsRequest
     *        List Blueprint Request
     * @return Result of the ListBlueprints operation returned by the service.
     * @throws ValidationException
     *         This exception is thrown when the request's input validation fails
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockDataAutomationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockDataAutomationClient.ListBlueprints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/ListBlueprints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBlueprintsResponse listBlueprints(ListBlueprintsRequest listBlueprintsRequest) throws ValidationException,
            InternalServerException, ThrottlingException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BedrockDataAutomationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all existing Amazon Bedrock Data Automation Blueprints
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBlueprintsRequest.Builder} avoiding the need to
     * create one manually via {@link ListBlueprintsRequest#builder()}
     * </p>
     *
     * @param listBlueprintsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockdataautomation.model.ListBlueprintsRequest.Builder} to
     *        create a request. List Blueprint Request
     * @return Result of the ListBlueprints operation returned by the service.
     * @throws ValidationException
     *         This exception is thrown when the request's input validation fails
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockDataAutomationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockDataAutomationClient.ListBlueprints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/ListBlueprints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBlueprintsResponse listBlueprints(Consumer<ListBlueprintsRequest.Builder> listBlueprintsRequest)
            throws ValidationException, InternalServerException, ThrottlingException, AccessDeniedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BedrockDataAutomationException {
        return listBlueprints(ListBlueprintsRequest.builder().applyMutation(listBlueprintsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBlueprints(software.amazon.awssdk.services.bedrockdataautomation.model.ListBlueprintsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockdataautomation.paginators.ListBlueprintsIterable responses = client.listBlueprintsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bedrockdataautomation.paginators.ListBlueprintsIterable responses = client
     *             .listBlueprintsPaginator(request);
     *     for (software.amazon.awssdk.services.bedrockdataautomation.model.ListBlueprintsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockdataautomation.paginators.ListBlueprintsIterable responses = client.listBlueprintsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBlueprints(software.amazon.awssdk.services.bedrockdataautomation.model.ListBlueprintsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBlueprintsRequest
     *        List Blueprint Request
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         This exception is thrown when the request's input validation fails
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockDataAutomationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockDataAutomationClient.ListBlueprints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/ListBlueprints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBlueprintsIterable listBlueprintsPaginator(ListBlueprintsRequest listBlueprintsRequest)
            throws ValidationException, InternalServerException, ThrottlingException, AccessDeniedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BedrockDataAutomationException {
        return new ListBlueprintsIterable(this, listBlueprintsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBlueprints(software.amazon.awssdk.services.bedrockdataautomation.model.ListBlueprintsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockdataautomation.paginators.ListBlueprintsIterable responses = client.listBlueprintsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bedrockdataautomation.paginators.ListBlueprintsIterable responses = client
     *             .listBlueprintsPaginator(request);
     *     for (software.amazon.awssdk.services.bedrockdataautomation.model.ListBlueprintsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockdataautomation.paginators.ListBlueprintsIterable responses = client.listBlueprintsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBlueprints(software.amazon.awssdk.services.bedrockdataautomation.model.ListBlueprintsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBlueprintsRequest.Builder} avoiding the need to
     * create one manually via {@link ListBlueprintsRequest#builder()}
     * </p>
     *
     * @param listBlueprintsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockdataautomation.model.ListBlueprintsRequest.Builder} to
     *        create a request. List Blueprint Request
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         This exception is thrown when the request's input validation fails
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockDataAutomationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockDataAutomationClient.ListBlueprints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/ListBlueprints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBlueprintsIterable listBlueprintsPaginator(Consumer<ListBlueprintsRequest.Builder> listBlueprintsRequest)
            throws ValidationException, InternalServerException, ThrottlingException, AccessDeniedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BedrockDataAutomationException {
        return listBlueprintsPaginator(ListBlueprintsRequest.builder().applyMutation(listBlueprintsRequest).build());
    }

    /**
     * <p>
     * Lists all existing Amazon Bedrock Data Automation Projects
     * </p>
     *
     * @param listDataAutomationProjectsRequest
     *        List DataAutomationProject Request
     * @return Result of the ListDataAutomationProjects operation returned by the service.
     * @throws ValidationException
     *         This exception is thrown when the request's input validation fails
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockDataAutomationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockDataAutomationClient.ListDataAutomationProjects
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/ListDataAutomationProjects"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataAutomationProjectsResponse listDataAutomationProjects(
            ListDataAutomationProjectsRequest listDataAutomationProjectsRequest) throws ValidationException,
            InternalServerException, ThrottlingException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BedrockDataAutomationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all existing Amazon Bedrock Data Automation Projects
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataAutomationProjectsRequest.Builder} avoiding
     * the need to create one manually via {@link ListDataAutomationProjectsRequest#builder()}
     * </p>
     *
     * @param listDataAutomationProjectsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockdataautomation.model.ListDataAutomationProjectsRequest.Builder}
     *        to create a request. List DataAutomationProject Request
     * @return Result of the ListDataAutomationProjects operation returned by the service.
     * @throws ValidationException
     *         This exception is thrown when the request's input validation fails
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockDataAutomationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockDataAutomationClient.ListDataAutomationProjects
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/ListDataAutomationProjects"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataAutomationProjectsResponse listDataAutomationProjects(
            Consumer<ListDataAutomationProjectsRequest.Builder> listDataAutomationProjectsRequest) throws ValidationException,
            InternalServerException, ThrottlingException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BedrockDataAutomationException {
        return listDataAutomationProjects(ListDataAutomationProjectsRequest.builder()
                .applyMutation(listDataAutomationProjectsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataAutomationProjects(software.amazon.awssdk.services.bedrockdataautomation.model.ListDataAutomationProjectsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockdataautomation.paginators.ListDataAutomationProjectsIterable responses = client.listDataAutomationProjectsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bedrockdataautomation.paginators.ListDataAutomationProjectsIterable responses = client
     *             .listDataAutomationProjectsPaginator(request);
     *     for (software.amazon.awssdk.services.bedrockdataautomation.model.ListDataAutomationProjectsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockdataautomation.paginators.ListDataAutomationProjectsIterable responses = client.listDataAutomationProjectsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataAutomationProjects(software.amazon.awssdk.services.bedrockdataautomation.model.ListDataAutomationProjectsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDataAutomationProjectsRequest
     *        List DataAutomationProject Request
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         This exception is thrown when the request's input validation fails
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockDataAutomationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockDataAutomationClient.ListDataAutomationProjects
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/ListDataAutomationProjects"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataAutomationProjectsIterable listDataAutomationProjectsPaginator(
            ListDataAutomationProjectsRequest listDataAutomationProjectsRequest) throws ValidationException,
            InternalServerException, ThrottlingException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BedrockDataAutomationException {
        return new ListDataAutomationProjectsIterable(this, listDataAutomationProjectsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataAutomationProjects(software.amazon.awssdk.services.bedrockdataautomation.model.ListDataAutomationProjectsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockdataautomation.paginators.ListDataAutomationProjectsIterable responses = client.listDataAutomationProjectsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bedrockdataautomation.paginators.ListDataAutomationProjectsIterable responses = client
     *             .listDataAutomationProjectsPaginator(request);
     *     for (software.amazon.awssdk.services.bedrockdataautomation.model.ListDataAutomationProjectsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockdataautomation.paginators.ListDataAutomationProjectsIterable responses = client.listDataAutomationProjectsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataAutomationProjects(software.amazon.awssdk.services.bedrockdataautomation.model.ListDataAutomationProjectsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataAutomationProjectsRequest.Builder} avoiding
     * the need to create one manually via {@link ListDataAutomationProjectsRequest#builder()}
     * </p>
     *
     * @param listDataAutomationProjectsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockdataautomation.model.ListDataAutomationProjectsRequest.Builder}
     *        to create a request. List DataAutomationProject Request
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         This exception is thrown when the request's input validation fails
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockDataAutomationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockDataAutomationClient.ListDataAutomationProjects
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/ListDataAutomationProjects"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataAutomationProjectsIterable listDataAutomationProjectsPaginator(
            Consumer<ListDataAutomationProjectsRequest.Builder> listDataAutomationProjectsRequest) throws ValidationException,
            InternalServerException, ThrottlingException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BedrockDataAutomationException {
        return listDataAutomationProjectsPaginator(ListDataAutomationProjectsRequest.builder()
                .applyMutation(listDataAutomationProjectsRequest).build());
    }

    /**
     * <p>
     * List tags for an Amazon Bedrock Data Automation resource
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         This exception is thrown when the request's input validation fails
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockDataAutomationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockDataAutomationClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ValidationException, InternalServerException, ThrottlingException, AccessDeniedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BedrockDataAutomationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List tags for an Amazon Bedrock Data Automation resource
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockdataautomation.model.ListTagsForResourceRequest.Builder} to
     *        create a request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         This exception is thrown when the request's input validation fails
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockDataAutomationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockDataAutomationClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ValidationException,
            InternalServerException, ThrottlingException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BedrockDataAutomationException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Tag an Amazon Bedrock Data Automation resource
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws ValidationException
     *         This exception is thrown when the request's input validation fails
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockDataAutomationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockDataAutomationClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ServiceQuotaExceededException,
            ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, BedrockDataAutomationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tag an Amazon Bedrock Data Automation resource
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockdataautomation.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws ValidationException
     *         This exception is thrown when the request's input validation fails
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockDataAutomationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockDataAutomationClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws ServiceQuotaExceededException, ValidationException, InternalServerException, ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            BedrockDataAutomationException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Untag an Amazon Bedrock Data Automation resource
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         This exception is thrown when the request's input validation fails
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockDataAutomationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockDataAutomationClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException,
            InternalServerException, ThrottlingException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BedrockDataAutomationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Untag an Amazon Bedrock Data Automation resource
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockdataautomation.model.UntagResourceRequest.Builder} to create
     *        a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         This exception is thrown when the request's input validation fails
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockDataAutomationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockDataAutomationClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ValidationException, InternalServerException, ThrottlingException, AccessDeniedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BedrockDataAutomationException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an existing Amazon Bedrock Data Automation Blueprint
     * </p>
     *
     * @param updateBlueprintRequest
     *        Update Blueprint Request
     * @return Result of the UpdateBlueprint operation returned by the service.
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ValidationException
     *         This exception is thrown when the request's input validation fails
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockDataAutomationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockDataAutomationClient.UpdateBlueprint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/UpdateBlueprint"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateBlueprintResponse updateBlueprint(UpdateBlueprintRequest updateBlueprintRequest) throws ConflictException,
            ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, BedrockDataAutomationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing Amazon Bedrock Data Automation Blueprint
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBlueprintRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateBlueprintRequest#builder()}
     * </p>
     *
     * @param updateBlueprintRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockdataautomation.model.UpdateBlueprintRequest.Builder} to
     *        create a request. Update Blueprint Request
     * @return Result of the UpdateBlueprint operation returned by the service.
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ValidationException
     *         This exception is thrown when the request's input validation fails
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockDataAutomationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockDataAutomationClient.UpdateBlueprint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/UpdateBlueprint"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateBlueprintResponse updateBlueprint(Consumer<UpdateBlueprintRequest.Builder> updateBlueprintRequest)
            throws ConflictException, ValidationException, InternalServerException, ThrottlingException, AccessDeniedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BedrockDataAutomationException {
        return updateBlueprint(UpdateBlueprintRequest.builder().applyMutation(updateBlueprintRequest).build());
    }

    /**
     * <p>
     * Updates an existing Amazon Bedrock Data Automation Project
     * </p>
     *
     * @param updateDataAutomationProjectRequest
     *        Update DataAutomationProject Request
     * @return Result of the UpdateDataAutomationProject operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ValidationException
     *         This exception is thrown when the request's input validation fails
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockDataAutomationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockDataAutomationClient.UpdateDataAutomationProject
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/UpdateDataAutomationProject"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDataAutomationProjectResponse updateDataAutomationProject(
            UpdateDataAutomationProjectRequest updateDataAutomationProjectRequest) throws ServiceQuotaExceededException,
            ConflictException, ValidationException, InternalServerException, ThrottlingException, AccessDeniedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BedrockDataAutomationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing Amazon Bedrock Data Automation Project
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDataAutomationProjectRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateDataAutomationProjectRequest#builder()}
     * </p>
     *
     * @param updateDataAutomationProjectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockdataautomation.model.UpdateDataAutomationProjectRequest.Builder}
     *        to create a request. Update DataAutomationProject Request
     * @return Result of the UpdateDataAutomationProject operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ValidationException
     *         This exception is thrown when the request's input validation fails
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockDataAutomationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockDataAutomationClient.UpdateDataAutomationProject
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-2023-07-26/UpdateDataAutomationProject"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDataAutomationProjectResponse updateDataAutomationProject(
            Consumer<UpdateDataAutomationProjectRequest.Builder> updateDataAutomationProjectRequest)
            throws ServiceQuotaExceededException, ConflictException, ValidationException, InternalServerException,
            ThrottlingException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            BedrockDataAutomationException {
        return updateDataAutomationProject(UpdateDataAutomationProjectRequest.builder()
                .applyMutation(updateDataAutomationProjectRequest).build());
    }

    /**
     * Create a {@link BedrockDataAutomationClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static BedrockDataAutomationClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link BedrockDataAutomationClient}.
     */
    static BedrockDataAutomationClientBuilder builder() {
        return new DefaultBedrockDataAutomationClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default BedrockDataAutomationServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
