/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the information of a Blueprint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Blueprint implements SdkPojo, Serializable, ToCopyableBuilder<Blueprint.Builder, Blueprint> {
    private static final SdkField<String> BLUEPRINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("blueprintArn").getter(getter(Blueprint::blueprintArn)).setter(setter(Builder::blueprintArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprintArn").build()).build();

    private static final SdkField<String> SCHEMA_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("schema")
            .getter(getter(Blueprint::schema)).setter(setter(Builder::schema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schema").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(Blueprint::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(Blueprint::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedTime")
            .getter(getter(Blueprint::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> BLUEPRINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("blueprintName").getter(getter(Blueprint::blueprintName)).setter(setter(Builder::blueprintName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprintName").build()).build();

    private static final SdkField<String> BLUEPRINT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("blueprintVersion").getter(getter(Blueprint::blueprintVersion)).setter(setter(Builder::blueprintVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprintVersion").build()).build();

    private static final SdkField<String> BLUEPRINT_STAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("blueprintStage").getter(getter(Blueprint::blueprintStageAsString))
            .setter(setter(Builder::blueprintStage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprintStage").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyId").getter(getter(Blueprint::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()).build();

    private static final SdkField<Map<String, String>> KMS_ENCRYPTION_CONTEXT_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("kmsEncryptionContext")
            .getter(getter(Blueprint::kmsEncryptionContext))
            .setter(setter(Builder::kmsEncryptionContext))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsEncryptionContext").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLUEPRINT_ARN_FIELD,
            SCHEMA_FIELD, TYPE_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, BLUEPRINT_NAME_FIELD,
            BLUEPRINT_VERSION_FIELD, BLUEPRINT_STAGE_FIELD, KMS_KEY_ID_FIELD, KMS_ENCRYPTION_CONTEXT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String blueprintArn;

    private final String schema;

    private final String type;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private final String blueprintName;

    private final String blueprintVersion;

    private final String blueprintStage;

    private final String kmsKeyId;

    private final Map<String, String> kmsEncryptionContext;

    private Blueprint(BuilderImpl builder) {
        this.blueprintArn = builder.blueprintArn;
        this.schema = builder.schema;
        this.type = builder.type;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.blueprintName = builder.blueprintName;
        this.blueprintVersion = builder.blueprintVersion;
        this.blueprintStage = builder.blueprintStage;
        this.kmsKeyId = builder.kmsKeyId;
        this.kmsEncryptionContext = builder.kmsEncryptionContext;
    }

    /**
     * Returns the value of the BlueprintArn property for this object.
     * 
     * @return The value of the BlueprintArn property for this object.
     */
    public final String blueprintArn() {
        return blueprintArn;
    }

    /**
     * Returns the value of the Schema property for this object.
     * 
     * @return The value of the Schema property for this object.
     */
    public final String schema() {
        return schema;
    }

    /**
     * Returns the value of the Type property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The value of the Type property for this object.
     * @see Type
     */
    public final Type type() {
        return Type.fromValue(type);
    }

    /**
     * Returns the value of the Type property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The value of the Type property for this object.
     * @see Type
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * Returns the value of the CreationTime property for this object.
     * 
     * @return The value of the CreationTime property for this object.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * Returns the value of the LastModifiedTime property for this object.
     * 
     * @return The value of the LastModifiedTime property for this object.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * Returns the value of the BlueprintName property for this object.
     * 
     * @return The value of the BlueprintName property for this object.
     */
    public final String blueprintName() {
        return blueprintName;
    }

    /**
     * Returns the value of the BlueprintVersion property for this object.
     * 
     * @return The value of the BlueprintVersion property for this object.
     */
    public final String blueprintVersion() {
        return blueprintVersion;
    }

    /**
     * Returns the value of the BlueprintStage property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #blueprintStage}
     * will return {@link BlueprintStage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #blueprintStageAsString}.
     * </p>
     * 
     * @return The value of the BlueprintStage property for this object.
     * @see BlueprintStage
     */
    public final BlueprintStage blueprintStage() {
        return BlueprintStage.fromValue(blueprintStage);
    }

    /**
     * Returns the value of the BlueprintStage property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #blueprintStage}
     * will return {@link BlueprintStage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #blueprintStageAsString}.
     * </p>
     * 
     * @return The value of the BlueprintStage property for this object.
     * @see BlueprintStage
     */
    public final String blueprintStageAsString() {
        return blueprintStage;
    }

    /**
     * Returns the value of the KmsKeyId property for this object.
     * 
     * @return The value of the KmsKeyId property for this object.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * For responses, this returns true if the service returned a value for the KmsEncryptionContext property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasKmsEncryptionContext() {
        return kmsEncryptionContext != null && !(kmsEncryptionContext instanceof SdkAutoConstructMap);
    }

    /**
     * Returns the value of the KmsEncryptionContext property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKmsEncryptionContext} method.
     * </p>
     * 
     * @return The value of the KmsEncryptionContext property for this object.
     */
    public final Map<String, String> kmsEncryptionContext() {
        return kmsEncryptionContext;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(blueprintArn());
        hashCode = 31 * hashCode + Objects.hashCode(schema());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(blueprintName());
        hashCode = 31 * hashCode + Objects.hashCode(blueprintVersion());
        hashCode = 31 * hashCode + Objects.hashCode(blueprintStageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(hasKmsEncryptionContext() ? kmsEncryptionContext() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Blueprint)) {
            return false;
        }
        Blueprint other = (Blueprint) obj;
        return Objects.equals(blueprintArn(), other.blueprintArn()) && Objects.equals(schema(), other.schema())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(blueprintName(), other.blueprintName())
                && Objects.equals(blueprintVersion(), other.blueprintVersion())
                && Objects.equals(blueprintStageAsString(), other.blueprintStageAsString())
                && Objects.equals(kmsKeyId(), other.kmsKeyId()) && hasKmsEncryptionContext() == other.hasKmsEncryptionContext()
                && Objects.equals(kmsEncryptionContext(), other.kmsEncryptionContext());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Blueprint").add("BlueprintArn", blueprintArn())
                .add("Schema", schema() == null ? null : "*** Sensitive Data Redacted ***").add("Type", typeAsString())
                .add("CreationTime", creationTime()).add("LastModifiedTime", lastModifiedTime())
                .add("BlueprintName", blueprintName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("BlueprintVersion", blueprintVersion()).add("BlueprintStage", blueprintStageAsString())
                .add("KmsKeyId", kmsKeyId())
                .add("KmsEncryptionContext", hasKmsEncryptionContext() ? kmsEncryptionContext() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "blueprintArn":
            return Optional.ofNullable(clazz.cast(blueprintArn()));
        case "schema":
            return Optional.ofNullable(clazz.cast(schema()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "blueprintName":
            return Optional.ofNullable(clazz.cast(blueprintName()));
        case "blueprintVersion":
            return Optional.ofNullable(clazz.cast(blueprintVersion()));
        case "blueprintStage":
            return Optional.ofNullable(clazz.cast(blueprintStageAsString()));
        case "kmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "kmsEncryptionContext":
            return Optional.ofNullable(clazz.cast(kmsEncryptionContext()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("blueprintArn", BLUEPRINT_ARN_FIELD);
        map.put("schema", SCHEMA_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("lastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("blueprintName", BLUEPRINT_NAME_FIELD);
        map.put("blueprintVersion", BLUEPRINT_VERSION_FIELD);
        map.put("blueprintStage", BLUEPRINT_STAGE_FIELD);
        map.put("kmsKeyId", KMS_KEY_ID_FIELD);
        map.put("kmsEncryptionContext", KMS_ENCRYPTION_CONTEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Blueprint, T> g) {
        return obj -> g.apply((Blueprint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Blueprint> {
        /**
         * Sets the value of the BlueprintArn property for this object.
         *
         * @param blueprintArn
         *        The new value for the BlueprintArn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprintArn(String blueprintArn);

        /**
         * Sets the value of the Schema property for this object.
         *
         * @param schema
         *        The new value for the Schema property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schema(String schema);

        /**
         * Sets the value of the Type property for this object.
         *
         * @param type
         *        The new value for the Type property for this object.
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(String type);

        /**
         * Sets the value of the Type property for this object.
         *
         * @param type
         *        The new value for the Type property for this object.
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(Type type);

        /**
         * Sets the value of the CreationTime property for this object.
         *
         * @param creationTime
         *        The new value for the CreationTime property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * Sets the value of the LastModifiedTime property for this object.
         *
         * @param lastModifiedTime
         *        The new value for the LastModifiedTime property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * Sets the value of the BlueprintName property for this object.
         *
         * @param blueprintName
         *        The new value for the BlueprintName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprintName(String blueprintName);

        /**
         * Sets the value of the BlueprintVersion property for this object.
         *
         * @param blueprintVersion
         *        The new value for the BlueprintVersion property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprintVersion(String blueprintVersion);

        /**
         * Sets the value of the BlueprintStage property for this object.
         *
         * @param blueprintStage
         *        The new value for the BlueprintStage property for this object.
         * @see BlueprintStage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BlueprintStage
         */
        Builder blueprintStage(String blueprintStage);

        /**
         * Sets the value of the BlueprintStage property for this object.
         *
         * @param blueprintStage
         *        The new value for the BlueprintStage property for this object.
         * @see BlueprintStage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BlueprintStage
         */
        Builder blueprintStage(BlueprintStage blueprintStage);

        /**
         * Sets the value of the KmsKeyId property for this object.
         *
         * @param kmsKeyId
         *        The new value for the KmsKeyId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * Sets the value of the KmsEncryptionContext property for this object.
         *
         * @param kmsEncryptionContext
         *        The new value for the KmsEncryptionContext property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsEncryptionContext(Map<String, String> kmsEncryptionContext);
    }

    static final class BuilderImpl implements Builder {
        private String blueprintArn;

        private String schema;

        private String type;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private String blueprintName;

        private String blueprintVersion;

        private String blueprintStage;

        private String kmsKeyId;

        private Map<String, String> kmsEncryptionContext = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Blueprint model) {
            blueprintArn(model.blueprintArn);
            schema(model.schema);
            type(model.type);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
            blueprintName(model.blueprintName);
            blueprintVersion(model.blueprintVersion);
            blueprintStage(model.blueprintStage);
            kmsKeyId(model.kmsKeyId);
            kmsEncryptionContext(model.kmsEncryptionContext);
        }

        public final String getBlueprintArn() {
            return blueprintArn;
        }

        public final void setBlueprintArn(String blueprintArn) {
            this.blueprintArn = blueprintArn;
        }

        @Override
        public final Builder blueprintArn(String blueprintArn) {
            this.blueprintArn = blueprintArn;
            return this;
        }

        public final String getSchema() {
            return schema;
        }

        public final void setSchema(String schema) {
            this.schema = schema;
        }

        @Override
        public final Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(Type type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getBlueprintName() {
            return blueprintName;
        }

        public final void setBlueprintName(String blueprintName) {
            this.blueprintName = blueprintName;
        }

        @Override
        public final Builder blueprintName(String blueprintName) {
            this.blueprintName = blueprintName;
            return this;
        }

        public final String getBlueprintVersion() {
            return blueprintVersion;
        }

        public final void setBlueprintVersion(String blueprintVersion) {
            this.blueprintVersion = blueprintVersion;
        }

        @Override
        public final Builder blueprintVersion(String blueprintVersion) {
            this.blueprintVersion = blueprintVersion;
            return this;
        }

        public final String getBlueprintStage() {
            return blueprintStage;
        }

        public final void setBlueprintStage(String blueprintStage) {
            this.blueprintStage = blueprintStage;
        }

        @Override
        public final Builder blueprintStage(String blueprintStage) {
            this.blueprintStage = blueprintStage;
            return this;
        }

        @Override
        public final Builder blueprintStage(BlueprintStage blueprintStage) {
            this.blueprintStage(blueprintStage == null ? null : blueprintStage.toString());
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Map<String, String> getKmsEncryptionContext() {
            if (kmsEncryptionContext instanceof SdkAutoConstructMap) {
                return null;
            }
            return kmsEncryptionContext;
        }

        public final void setKmsEncryptionContext(Map<String, String> kmsEncryptionContext) {
            this.kmsEncryptionContext = KmsEncryptionContextCopier.copy(kmsEncryptionContext);
        }

        @Override
        public final Builder kmsEncryptionContext(Map<String, String> kmsEncryptionContext) {
            this.kmsEncryptionContext = KmsEncryptionContextCopier.copy(kmsEncryptionContext);
            return this;
        }

        @Override
        public Blueprint build() {
            return new Blueprint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
