/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Create DataAutomationProject Request
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDataAutomationProjectRequest extends BedrockDataAutomationRequest implements
        ToCopyableBuilder<CreateDataAutomationProjectRequest.Builder, CreateDataAutomationProjectRequest> {
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectName").getter(getter(CreateDataAutomationProjectRequest::projectName))
            .setter(setter(Builder::projectName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectName").build()).build();

    private static final SdkField<String> PROJECT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectDescription").getter(getter(CreateDataAutomationProjectRequest::projectDescription))
            .setter(setter(Builder::projectDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectDescription").build())
            .build();

    private static final SdkField<String> PROJECT_STAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectStage").getter(getter(CreateDataAutomationProjectRequest::projectStageAsString))
            .setter(setter(Builder::projectStage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectStage").build()).build();

    private static final SdkField<StandardOutputConfiguration> STANDARD_OUTPUT_CONFIGURATION_FIELD = SdkField
            .<StandardOutputConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("standardOutputConfiguration")
            .getter(getter(CreateDataAutomationProjectRequest::standardOutputConfiguration))
            .setter(setter(Builder::standardOutputConfiguration))
            .constructor(StandardOutputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("standardOutputConfiguration")
                    .build()).build();

    private static final SdkField<CustomOutputConfiguration> CUSTOM_OUTPUT_CONFIGURATION_FIELD = SdkField
            .<CustomOutputConfiguration> builder(MarshallingType.SDK_POJO).memberName("customOutputConfiguration")
            .getter(getter(CreateDataAutomationProjectRequest::customOutputConfiguration))
            .setter(setter(Builder::customOutputConfiguration)).constructor(CustomOutputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customOutputConfiguration").build())
            .build();

    private static final SdkField<OverrideConfiguration> OVERRIDE_CONFIGURATION_FIELD = SdkField
            .<OverrideConfiguration> builder(MarshallingType.SDK_POJO).memberName("overrideConfiguration")
            .getter(getter(CreateDataAutomationProjectRequest::overrideConfigurationValue))
            .setter(setter(Builder::overrideConfigurationValue)).constructor(OverrideConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrideConfiguration").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateDataAutomationProjectRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField
            .<EncryptionConfiguration> builder(MarshallingType.SDK_POJO).memberName("encryptionConfiguration")
            .getter(getter(CreateDataAutomationProjectRequest::encryptionConfiguration))
            .setter(setter(Builder::encryptionConfiguration)).constructor(EncryptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionConfiguration").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateDataAutomationProjectRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_NAME_FIELD,
            PROJECT_DESCRIPTION_FIELD, PROJECT_STAGE_FIELD, STANDARD_OUTPUT_CONFIGURATION_FIELD,
            CUSTOM_OUTPUT_CONFIGURATION_FIELD, OVERRIDE_CONFIGURATION_FIELD, CLIENT_TOKEN_FIELD, ENCRYPTION_CONFIGURATION_FIELD,
            TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String projectName;

    private final String projectDescription;

    private final String projectStage;

    private final StandardOutputConfiguration standardOutputConfiguration;

    private final CustomOutputConfiguration customOutputConfiguration;

    private final OverrideConfiguration overrideConfigurationValue;

    private final String clientToken;

    private final EncryptionConfiguration encryptionConfiguration;

    private final List<Tag> tags;

    private CreateDataAutomationProjectRequest(BuilderImpl builder) {
        super(builder);
        this.projectName = builder.projectName;
        this.projectDescription = builder.projectDescription;
        this.projectStage = builder.projectStage;
        this.standardOutputConfiguration = builder.standardOutputConfiguration;
        this.customOutputConfiguration = builder.customOutputConfiguration;
        this.overrideConfigurationValue = builder.overrideConfigurationValue;
        this.clientToken = builder.clientToken;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.tags = builder.tags;
    }

    /**
     * Returns the value of the ProjectName property for this object.
     * 
     * @return The value of the ProjectName property for this object.
     */
    public final String projectName() {
        return projectName;
    }

    /**
     * Returns the value of the ProjectDescription property for this object.
     * 
     * @return The value of the ProjectDescription property for this object.
     */
    public final String projectDescription() {
        return projectDescription;
    }

    /**
     * Returns the value of the ProjectStage property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #projectStage} will
     * return {@link DataAutomationProjectStage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #projectStageAsString}.
     * </p>
     * 
     * @return The value of the ProjectStage property for this object.
     * @see DataAutomationProjectStage
     */
    public final DataAutomationProjectStage projectStage() {
        return DataAutomationProjectStage.fromValue(projectStage);
    }

    /**
     * Returns the value of the ProjectStage property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #projectStage} will
     * return {@link DataAutomationProjectStage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #projectStageAsString}.
     * </p>
     * 
     * @return The value of the ProjectStage property for this object.
     * @see DataAutomationProjectStage
     */
    public final String projectStageAsString() {
        return projectStage;
    }

    /**
     * Returns the value of the StandardOutputConfiguration property for this object.
     * 
     * @return The value of the StandardOutputConfiguration property for this object.
     */
    public final StandardOutputConfiguration standardOutputConfiguration() {
        return standardOutputConfiguration;
    }

    /**
     * Returns the value of the CustomOutputConfiguration property for this object.
     * 
     * @return The value of the CustomOutputConfiguration property for this object.
     */
    public final CustomOutputConfiguration customOutputConfiguration() {
        return customOutputConfiguration;
    }

    /**
     * Returns the value of the OverrideConfiguration property for this object.
     * 
     * @return The value of the OverrideConfiguration property for this object.
     */
    public final OverrideConfiguration overrideConfigurationValue() {
        return overrideConfigurationValue;
    }

    /**
     * Returns the value of the ClientToken property for this object.
     * 
     * @return The value of the ClientToken property for this object.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * Returns the value of the EncryptionConfiguration property for this object.
     * 
     * @return The value of the EncryptionConfiguration property for this object.
     */
    public final EncryptionConfiguration encryptionConfiguration() {
        return encryptionConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Tags property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The value of the Tags property for this object.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(projectName());
        hashCode = 31 * hashCode + Objects.hashCode(projectDescription());
        hashCode = 31 * hashCode + Objects.hashCode(projectStageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(standardOutputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(customOutputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(overrideConfigurationValue());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataAutomationProjectRequest)) {
            return false;
        }
        CreateDataAutomationProjectRequest other = (CreateDataAutomationProjectRequest) obj;
        return Objects.equals(projectName(), other.projectName())
                && Objects.equals(projectDescription(), other.projectDescription())
                && Objects.equals(projectStageAsString(), other.projectStageAsString())
                && Objects.equals(standardOutputConfiguration(), other.standardOutputConfiguration())
                && Objects.equals(customOutputConfiguration(), other.customOutputConfiguration())
                && Objects.equals(overrideConfigurationValue(), other.overrideConfigurationValue())
                && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(encryptionConfiguration(), other.encryptionConfiguration()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDataAutomationProjectRequest")
                .add("ProjectName", projectName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ProjectDescription", projectDescription() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ProjectStage", projectStageAsString()).add("StandardOutputConfiguration", standardOutputConfiguration())
                .add("CustomOutputConfiguration", customOutputConfiguration())
                .add("OverrideConfiguration", overrideConfigurationValue()).add("ClientToken", clientToken())
                .add("EncryptionConfiguration", encryptionConfiguration()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "projectName":
            return Optional.ofNullable(clazz.cast(projectName()));
        case "projectDescription":
            return Optional.ofNullable(clazz.cast(projectDescription()));
        case "projectStage":
            return Optional.ofNullable(clazz.cast(projectStageAsString()));
        case "standardOutputConfiguration":
            return Optional.ofNullable(clazz.cast(standardOutputConfiguration()));
        case "customOutputConfiguration":
            return Optional.ofNullable(clazz.cast(customOutputConfiguration()));
        case "overrideConfiguration":
            return Optional.ofNullable(clazz.cast(overrideConfigurationValue()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "encryptionConfiguration":
            return Optional.ofNullable(clazz.cast(encryptionConfiguration()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("projectName", PROJECT_NAME_FIELD);
        map.put("projectDescription", PROJECT_DESCRIPTION_FIELD);
        map.put("projectStage", PROJECT_STAGE_FIELD);
        map.put("standardOutputConfiguration", STANDARD_OUTPUT_CONFIGURATION_FIELD);
        map.put("customOutputConfiguration", CUSTOM_OUTPUT_CONFIGURATION_FIELD);
        map.put("overrideConfiguration", OVERRIDE_CONFIGURATION_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("encryptionConfiguration", ENCRYPTION_CONFIGURATION_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDataAutomationProjectRequest, T> g) {
        return obj -> g.apply((CreateDataAutomationProjectRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockDataAutomationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateDataAutomationProjectRequest> {
        /**
         * Sets the value of the ProjectName property for this object.
         *
         * @param projectName
         *        The new value for the ProjectName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectName(String projectName);

        /**
         * Sets the value of the ProjectDescription property for this object.
         *
         * @param projectDescription
         *        The new value for the ProjectDescription property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectDescription(String projectDescription);

        /**
         * Sets the value of the ProjectStage property for this object.
         *
         * @param projectStage
         *        The new value for the ProjectStage property for this object.
         * @see DataAutomationProjectStage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataAutomationProjectStage
         */
        Builder projectStage(String projectStage);

        /**
         * Sets the value of the ProjectStage property for this object.
         *
         * @param projectStage
         *        The new value for the ProjectStage property for this object.
         * @see DataAutomationProjectStage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataAutomationProjectStage
         */
        Builder projectStage(DataAutomationProjectStage projectStage);

        /**
         * Sets the value of the StandardOutputConfiguration property for this object.
         *
         * @param standardOutputConfiguration
         *        The new value for the StandardOutputConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardOutputConfiguration(StandardOutputConfiguration standardOutputConfiguration);

        /**
         * Sets the value of the StandardOutputConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link StandardOutputConfiguration.Builder}
         * avoiding the need to create one manually via {@link StandardOutputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StandardOutputConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #standardOutputConfiguration(StandardOutputConfiguration)}.
         * 
         * @param standardOutputConfiguration
         *        a consumer that will call methods on {@link StandardOutputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #standardOutputConfiguration(StandardOutputConfiguration)
         */
        default Builder standardOutputConfiguration(Consumer<StandardOutputConfiguration.Builder> standardOutputConfiguration) {
            return standardOutputConfiguration(StandardOutputConfiguration.builder().applyMutation(standardOutputConfiguration)
                    .build());
        }

        /**
         * Sets the value of the CustomOutputConfiguration property for this object.
         *
         * @param customOutputConfiguration
         *        The new value for the CustomOutputConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customOutputConfiguration(CustomOutputConfiguration customOutputConfiguration);

        /**
         * Sets the value of the CustomOutputConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CustomOutputConfiguration.Builder}
         * avoiding the need to create one manually via {@link CustomOutputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomOutputConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #customOutputConfiguration(CustomOutputConfiguration)}.
         * 
         * @param customOutputConfiguration
         *        a consumer that will call methods on {@link CustomOutputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customOutputConfiguration(CustomOutputConfiguration)
         */
        default Builder customOutputConfiguration(Consumer<CustomOutputConfiguration.Builder> customOutputConfiguration) {
            return customOutputConfiguration(CustomOutputConfiguration.builder().applyMutation(customOutputConfiguration).build());
        }

        /**
         * Sets the value of the OverrideConfiguration property for this object.
         *
         * @param overrideConfigurationValue
         *        The new value for the OverrideConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrideConfigurationValue(OverrideConfiguration overrideConfigurationValue);

        /**
         * Sets the value of the OverrideConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link OverrideConfiguration.Builder} avoiding
         * the need to create one manually via {@link OverrideConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OverrideConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #overrideConfigurationValue(OverrideConfiguration)}.
         * 
         * @param overrideConfigurationValue
         *        a consumer that will call methods on {@link OverrideConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #overrideConfigurationValue(OverrideConfiguration)
         */
        default Builder overrideConfigurationValue(Consumer<OverrideConfiguration.Builder> overrideConfigurationValue) {
            return overrideConfigurationValue(OverrideConfiguration.builder().applyMutation(overrideConfigurationValue).build());
        }

        /**
         * Sets the value of the ClientToken property for this object.
         *
         * @param clientToken
         *        The new value for the ClientToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * Sets the value of the EncryptionConfiguration property for this object.
         *
         * @param encryptionConfiguration
         *        The new value for the EncryptionConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration);

        /**
         * Sets the value of the EncryptionConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link EncryptionConfiguration.Builder} avoiding
         * the need to create one manually via {@link EncryptionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncryptionConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #encryptionConfiguration(EncryptionConfiguration)}.
         * 
         * @param encryptionConfiguration
         *        a consumer that will call methods on {@link EncryptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionConfiguration(EncryptionConfiguration)
         */
        default Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return encryptionConfiguration(EncryptionConfiguration.builder().applyMutation(encryptionConfiguration).build());
        }

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockdataautomation.model.Tag.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.bedrockdataautomation.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockdataautomation.model.Tag.Builder#build()} is called immediately
         * and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockdataautomation.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockDataAutomationRequest.BuilderImpl implements Builder {
        private String projectName;

        private String projectDescription;

        private String projectStage;

        private StandardOutputConfiguration standardOutputConfiguration;

        private CustomOutputConfiguration customOutputConfiguration;

        private OverrideConfiguration overrideConfigurationValue;

        private String clientToken;

        private EncryptionConfiguration encryptionConfiguration;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataAutomationProjectRequest model) {
            super(model);
            projectName(model.projectName);
            projectDescription(model.projectDescription);
            projectStage(model.projectStage);
            standardOutputConfiguration(model.standardOutputConfiguration);
            customOutputConfiguration(model.customOutputConfiguration);
            overrideConfigurationValue(model.overrideConfigurationValue);
            clientToken(model.clientToken);
            encryptionConfiguration(model.encryptionConfiguration);
            tags(model.tags);
        }

        public final String getProjectName() {
            return projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final String getProjectDescription() {
            return projectDescription;
        }

        public final void setProjectDescription(String projectDescription) {
            this.projectDescription = projectDescription;
        }

        @Override
        public final Builder projectDescription(String projectDescription) {
            this.projectDescription = projectDescription;
            return this;
        }

        public final String getProjectStage() {
            return projectStage;
        }

        public final void setProjectStage(String projectStage) {
            this.projectStage = projectStage;
        }

        @Override
        public final Builder projectStage(String projectStage) {
            this.projectStage = projectStage;
            return this;
        }

        @Override
        public final Builder projectStage(DataAutomationProjectStage projectStage) {
            this.projectStage(projectStage == null ? null : projectStage.toString());
            return this;
        }

        public final StandardOutputConfiguration.Builder getStandardOutputConfiguration() {
            return standardOutputConfiguration != null ? standardOutputConfiguration.toBuilder() : null;
        }

        public final void setStandardOutputConfiguration(StandardOutputConfiguration.BuilderImpl standardOutputConfiguration) {
            this.standardOutputConfiguration = standardOutputConfiguration != null ? standardOutputConfiguration.build() : null;
        }

        @Override
        public final Builder standardOutputConfiguration(StandardOutputConfiguration standardOutputConfiguration) {
            this.standardOutputConfiguration = standardOutputConfiguration;
            return this;
        }

        public final CustomOutputConfiguration.Builder getCustomOutputConfiguration() {
            return customOutputConfiguration != null ? customOutputConfiguration.toBuilder() : null;
        }

        public final void setCustomOutputConfiguration(CustomOutputConfiguration.BuilderImpl customOutputConfiguration) {
            this.customOutputConfiguration = customOutputConfiguration != null ? customOutputConfiguration.build() : null;
        }

        @Override
        public final Builder customOutputConfiguration(CustomOutputConfiguration customOutputConfiguration) {
            this.customOutputConfiguration = customOutputConfiguration;
            return this;
        }

        public final OverrideConfiguration.Builder getOverrideConfigurationValue() {
            return overrideConfigurationValue != null ? overrideConfigurationValue.toBuilder() : null;
        }

        public final void setOverrideConfigurationValue(OverrideConfiguration.BuilderImpl overrideConfigurationValue) {
            this.overrideConfigurationValue = overrideConfigurationValue != null ? overrideConfigurationValue.build() : null;
        }

        @Override
        public final Builder overrideConfigurationValue(OverrideConfiguration overrideConfigurationValue) {
            this.overrideConfigurationValue = overrideConfigurationValue;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return encryptionConfiguration != null ? encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataAutomationProjectRequest build() {
            return new CreateDataAutomationProjectRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
