/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Delete Blueprint Request
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteBlueprintRequest extends BedrockDataAutomationRequest implements
        ToCopyableBuilder<DeleteBlueprintRequest.Builder, DeleteBlueprintRequest> {
    private static final SdkField<String> BLUEPRINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("blueprintArn").getter(getter(DeleteBlueprintRequest::blueprintArn))
            .setter(setter(Builder::blueprintArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("blueprintArn").build()).build();

    private static final SdkField<String> BLUEPRINT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("blueprintVersion").getter(getter(DeleteBlueprintRequest::blueprintVersion))
            .setter(setter(Builder::blueprintVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("blueprintVersion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLUEPRINT_ARN_FIELD,
            BLUEPRINT_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String blueprintArn;

    private final String blueprintVersion;

    private DeleteBlueprintRequest(BuilderImpl builder) {
        super(builder);
        this.blueprintArn = builder.blueprintArn;
        this.blueprintVersion = builder.blueprintVersion;
    }

    /**
     * <p>
     * ARN generated at the server side when a Blueprint is created
     * </p>
     * 
     * @return ARN generated at the server side when a Blueprint is created
     */
    public final String blueprintArn() {
        return blueprintArn;
    }

    /**
     * <p>
     * Optional field to delete a specific Blueprint version
     * </p>
     * 
     * @return Optional field to delete a specific Blueprint version
     */
    public final String blueprintVersion() {
        return blueprintVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(blueprintArn());
        hashCode = 31 * hashCode + Objects.hashCode(blueprintVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteBlueprintRequest)) {
            return false;
        }
        DeleteBlueprintRequest other = (DeleteBlueprintRequest) obj;
        return Objects.equals(blueprintArn(), other.blueprintArn())
                && Objects.equals(blueprintVersion(), other.blueprintVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteBlueprintRequest").add("BlueprintArn", blueprintArn())
                .add("BlueprintVersion", blueprintVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "blueprintArn":
            return Optional.ofNullable(clazz.cast(blueprintArn()));
        case "blueprintVersion":
            return Optional.ofNullable(clazz.cast(blueprintVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("blueprintArn", BLUEPRINT_ARN_FIELD);
        map.put("blueprintVersion", BLUEPRINT_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteBlueprintRequest, T> g) {
        return obj -> g.apply((DeleteBlueprintRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockDataAutomationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteBlueprintRequest> {
        /**
         * <p>
         * ARN generated at the server side when a Blueprint is created
         * </p>
         * 
         * @param blueprintArn
         *        ARN generated at the server side when a Blueprint is created
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprintArn(String blueprintArn);

        /**
         * <p>
         * Optional field to delete a specific Blueprint version
         * </p>
         * 
         * @param blueprintVersion
         *        Optional field to delete a specific Blueprint version
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprintVersion(String blueprintVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockDataAutomationRequest.BuilderImpl implements Builder {
        private String blueprintArn;

        private String blueprintVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteBlueprintRequest model) {
            super(model);
            blueprintArn(model.blueprintArn);
            blueprintVersion(model.blueprintVersion);
        }

        public final String getBlueprintArn() {
            return blueprintArn;
        }

        public final void setBlueprintArn(String blueprintArn) {
            this.blueprintArn = blueprintArn;
        }

        @Override
        public final Builder blueprintArn(String blueprintArn) {
            this.blueprintArn = blueprintArn;
            return this;
        }

        public final String getBlueprintVersion() {
            return blueprintVersion;
        }

        public final void setBlueprintVersion(String blueprintVersion) {
            this.blueprintVersion = blueprintVersion;
        }

        @Override
        public final Builder blueprintVersion(String blueprintVersion) {
            this.blueprintVersion = blueprintVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteBlueprintRequest build() {
            return new DeleteBlueprintRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
