/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * List Blueprint Response
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBlueprintsResponse extends BedrockDataAutomationResponse implements
        ToCopyableBuilder<ListBlueprintsResponse.Builder, ListBlueprintsResponse> {
    private static final SdkField<List<BlueprintSummary>> BLUEPRINTS_FIELD = SdkField
            .<List<BlueprintSummary>> builder(MarshallingType.LIST)
            .memberName("blueprints")
            .getter(getter(ListBlueprintsResponse::blueprints))
            .setter(setter(Builder::blueprints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BlueprintSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(BlueprintSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListBlueprintsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLUEPRINTS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<BlueprintSummary> blueprints;

    private final String nextToken;

    private ListBlueprintsResponse(BuilderImpl builder) {
        super(builder);
        this.blueprints = builder.blueprints;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Blueprints property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasBlueprints() {
        return blueprints != null && !(blueprints instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Blueprints property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlueprints} method.
     * </p>
     * 
     * @return The value of the Blueprints property for this object.
     */
    public final List<BlueprintSummary> blueprints() {
        return blueprints;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBlueprints() ? blueprints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBlueprintsResponse)) {
            return false;
        }
        ListBlueprintsResponse other = (ListBlueprintsResponse) obj;
        return hasBlueprints() == other.hasBlueprints() && Objects.equals(blueprints(), other.blueprints())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBlueprintsResponse").add("Blueprints", hasBlueprints() ? blueprints() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "blueprints":
            return Optional.ofNullable(clazz.cast(blueprints()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("blueprints", BLUEPRINTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListBlueprintsResponse, T> g) {
        return obj -> g.apply((ListBlueprintsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockDataAutomationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListBlueprintsResponse> {
        /**
         * Sets the value of the Blueprints property for this object.
         *
         * @param blueprints
         *        The new value for the Blueprints property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprints(Collection<BlueprintSummary> blueprints);

        /**
         * Sets the value of the Blueprints property for this object.
         *
         * @param blueprints
         *        The new value for the Blueprints property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprints(BlueprintSummary... blueprints);

        /**
         * Sets the value of the Blueprints property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockdataautomation.model.BlueprintSummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.bedrockdataautomation.model.BlueprintSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockdataautomation.model.BlueprintSummary.Builder#build()} is
         * called immediately and its result is passed to {@link #blueprints(List<BlueprintSummary>)}.
         * 
         * @param blueprints
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockdataautomation.model.BlueprintSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blueprints(java.util.Collection<BlueprintSummary>)
         */
        Builder blueprints(Consumer<BlueprintSummary.Builder>... blueprints);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends BedrockDataAutomationResponse.BuilderImpl implements Builder {
        private List<BlueprintSummary> blueprints = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBlueprintsResponse model) {
            super(model);
            blueprints(model.blueprints);
            nextToken(model.nextToken);
        }

        public final List<BlueprintSummary.Builder> getBlueprints() {
            List<BlueprintSummary.Builder> result = BlueprintsCopier.copyToBuilder(this.blueprints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlueprints(Collection<BlueprintSummary.BuilderImpl> blueprints) {
            this.blueprints = BlueprintsCopier.copyFromBuilder(blueprints);
        }

        @Override
        public final Builder blueprints(Collection<BlueprintSummary> blueprints) {
            this.blueprints = BlueprintsCopier.copy(blueprints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blueprints(BlueprintSummary... blueprints) {
            blueprints(Arrays.asList(blueprints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blueprints(Consumer<BlueprintSummary.Builder>... blueprints) {
            blueprints(Stream.of(blueprints).map(c -> BlueprintSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListBlueprintsResponse build() {
            return new ListBlueprintsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
