/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * List DataAutomationProject Response
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDataAutomationProjectsResponse extends BedrockDataAutomationResponse implements
        ToCopyableBuilder<ListDataAutomationProjectsResponse.Builder, ListDataAutomationProjectsResponse> {
    private static final SdkField<List<DataAutomationProjectSummary>> PROJECTS_FIELD = SdkField
            .<List<DataAutomationProjectSummary>> builder(MarshallingType.LIST)
            .memberName("projects")
            .getter(getter(ListDataAutomationProjectsResponse::projects))
            .setter(setter(Builder::projects))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projects").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataAutomationProjectSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataAutomationProjectSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListDataAutomationProjectsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECTS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<DataAutomationProjectSummary> projects;

    private final String nextToken;

    private ListDataAutomationProjectsResponse(BuilderImpl builder) {
        super(builder);
        this.projects = builder.projects;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Projects property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasProjects() {
        return projects != null && !(projects instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Projects property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProjects} method.
     * </p>
     * 
     * @return The value of the Projects property for this object.
     */
    public final List<DataAutomationProjectSummary> projects() {
        return projects;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasProjects() ? projects() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataAutomationProjectsResponse)) {
            return false;
        }
        ListDataAutomationProjectsResponse other = (ListDataAutomationProjectsResponse) obj;
        return hasProjects() == other.hasProjects() && Objects.equals(projects(), other.projects())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDataAutomationProjectsResponse").add("Projects", hasProjects() ? projects() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "projects":
            return Optional.ofNullable(clazz.cast(projects()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("projects", PROJECTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDataAutomationProjectsResponse, T> g) {
        return obj -> g.apply((ListDataAutomationProjectsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockDataAutomationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListDataAutomationProjectsResponse> {
        /**
         * Sets the value of the Projects property for this object.
         *
         * @param projects
         *        The new value for the Projects property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projects(Collection<DataAutomationProjectSummary> projects);

        /**
         * Sets the value of the Projects property for this object.
         *
         * @param projects
         *        The new value for the Projects property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projects(DataAutomationProjectSummary... projects);

        /**
         * Sets the value of the Projects property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockdataautomation.model.DataAutomationProjectSummary.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.bedrockdataautomation.model.DataAutomationProjectSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockdataautomation.model.DataAutomationProjectSummary.Builder#build()}
         * is called immediately and its result is passed to {@link #projects(List<DataAutomationProjectSummary>)}.
         * 
         * @param projects
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockdataautomation.model.DataAutomationProjectSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #projects(java.util.Collection<DataAutomationProjectSummary>)
         */
        Builder projects(Consumer<DataAutomationProjectSummary.Builder>... projects);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends BedrockDataAutomationResponse.BuilderImpl implements Builder {
        private List<DataAutomationProjectSummary> projects = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataAutomationProjectsResponse model) {
            super(model);
            projects(model.projects);
            nextToken(model.nextToken);
        }

        public final List<DataAutomationProjectSummary.Builder> getProjects() {
            List<DataAutomationProjectSummary.Builder> result = DataAutomationProjectSummariesCopier.copyToBuilder(this.projects);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProjects(Collection<DataAutomationProjectSummary.BuilderImpl> projects) {
            this.projects = DataAutomationProjectSummariesCopier.copyFromBuilder(projects);
        }

        @Override
        public final Builder projects(Collection<DataAutomationProjectSummary> projects) {
            this.projects = DataAutomationProjectSummariesCopier.copy(projects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projects(DataAutomationProjectSummary... projects) {
            projects(Arrays.asList(projects));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projects(Consumer<DataAutomationProjectSummary.Builder>... projects) {
            projects(Stream.of(projects).map(c -> DataAutomationProjectSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDataAutomationProjectsResponse build() {
            return new ListDataAutomationProjectsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
