/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Standard output configuration
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StandardOutputConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<StandardOutputConfiguration.Builder, StandardOutputConfiguration> {
    private static final SdkField<DocumentStandardOutputConfiguration> DOCUMENT_FIELD = SdkField
            .<DocumentStandardOutputConfiguration> builder(MarshallingType.SDK_POJO).memberName("document")
            .getter(getter(StandardOutputConfiguration::document)).setter(setter(Builder::document))
            .constructor(DocumentStandardOutputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("document").build()).build();

    private static final SdkField<ImageStandardOutputConfiguration> IMAGE_FIELD = SdkField
            .<ImageStandardOutputConfiguration> builder(MarshallingType.SDK_POJO).memberName("image")
            .getter(getter(StandardOutputConfiguration::image)).setter(setter(Builder::image))
            .constructor(ImageStandardOutputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("image").build()).build();

    private static final SdkField<VideoStandardOutputConfiguration> VIDEO_FIELD = SdkField
            .<VideoStandardOutputConfiguration> builder(MarshallingType.SDK_POJO).memberName("video")
            .getter(getter(StandardOutputConfiguration::video)).setter(setter(Builder::video))
            .constructor(VideoStandardOutputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("video").build()).build();

    private static final SdkField<AudioStandardOutputConfiguration> AUDIO_FIELD = SdkField
            .<AudioStandardOutputConfiguration> builder(MarshallingType.SDK_POJO).memberName("audio")
            .getter(getter(StandardOutputConfiguration::audio)).setter(setter(Builder::audio))
            .constructor(AudioStandardOutputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audio").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_FIELD, IMAGE_FIELD,
            VIDEO_FIELD, AUDIO_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DocumentStandardOutputConfiguration document;

    private final ImageStandardOutputConfiguration image;

    private final VideoStandardOutputConfiguration video;

    private final AudioStandardOutputConfiguration audio;

    private StandardOutputConfiguration(BuilderImpl builder) {
        this.document = builder.document;
        this.image = builder.image;
        this.video = builder.video;
        this.audio = builder.audio;
    }

    /**
     * Returns the value of the Document property for this object.
     * 
     * @return The value of the Document property for this object.
     */
    public final DocumentStandardOutputConfiguration document() {
        return document;
    }

    /**
     * Returns the value of the Image property for this object.
     * 
     * @return The value of the Image property for this object.
     */
    public final ImageStandardOutputConfiguration image() {
        return image;
    }

    /**
     * Returns the value of the Video property for this object.
     * 
     * @return The value of the Video property for this object.
     */
    public final VideoStandardOutputConfiguration video() {
        return video;
    }

    /**
     * Returns the value of the Audio property for this object.
     * 
     * @return The value of the Audio property for this object.
     */
    public final AudioStandardOutputConfiguration audio() {
        return audio;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(document());
        hashCode = 31 * hashCode + Objects.hashCode(image());
        hashCode = 31 * hashCode + Objects.hashCode(video());
        hashCode = 31 * hashCode + Objects.hashCode(audio());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StandardOutputConfiguration)) {
            return false;
        }
        StandardOutputConfiguration other = (StandardOutputConfiguration) obj;
        return Objects.equals(document(), other.document()) && Objects.equals(image(), other.image())
                && Objects.equals(video(), other.video()) && Objects.equals(audio(), other.audio());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StandardOutputConfiguration").add("Document", document()).add("Image", image())
                .add("Video", video()).add("Audio", audio()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "document":
            return Optional.ofNullable(clazz.cast(document()));
        case "image":
            return Optional.ofNullable(clazz.cast(image()));
        case "video":
            return Optional.ofNullable(clazz.cast(video()));
        case "audio":
            return Optional.ofNullable(clazz.cast(audio()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("document", DOCUMENT_FIELD);
        map.put("image", IMAGE_FIELD);
        map.put("video", VIDEO_FIELD);
        map.put("audio", AUDIO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StandardOutputConfiguration, T> g) {
        return obj -> g.apply((StandardOutputConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StandardOutputConfiguration> {
        /**
         * Sets the value of the Document property for this object.
         *
         * @param document
         *        The new value for the Document property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder document(DocumentStandardOutputConfiguration document);

        /**
         * Sets the value of the Document property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link DocumentStandardOutputConfiguration.Builder} avoiding the need to create one manually via
         * {@link DocumentStandardOutputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentStandardOutputConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #document(DocumentStandardOutputConfiguration)}.
         * 
         * @param document
         *        a consumer that will call methods on {@link DocumentStandardOutputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #document(DocumentStandardOutputConfiguration)
         */
        default Builder document(Consumer<DocumentStandardOutputConfiguration.Builder> document) {
            return document(DocumentStandardOutputConfiguration.builder().applyMutation(document).build());
        }

        /**
         * Sets the value of the Image property for this object.
         *
         * @param image
         *        The new value for the Image property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder image(ImageStandardOutputConfiguration image);

        /**
         * Sets the value of the Image property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ImageStandardOutputConfiguration.Builder}
         * avoiding the need to create one manually via {@link ImageStandardOutputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImageStandardOutputConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #image(ImageStandardOutputConfiguration)}.
         * 
         * @param image
         *        a consumer that will call methods on {@link ImageStandardOutputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #image(ImageStandardOutputConfiguration)
         */
        default Builder image(Consumer<ImageStandardOutputConfiguration.Builder> image) {
            return image(ImageStandardOutputConfiguration.builder().applyMutation(image).build());
        }

        /**
         * Sets the value of the Video property for this object.
         *
         * @param video
         *        The new value for the Video property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder video(VideoStandardOutputConfiguration video);

        /**
         * Sets the value of the Video property for this object.
         *
         * This is a convenience method that creates an instance of the {@link VideoStandardOutputConfiguration.Builder}
         * avoiding the need to create one manually via {@link VideoStandardOutputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VideoStandardOutputConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #video(VideoStandardOutputConfiguration)}.
         * 
         * @param video
         *        a consumer that will call methods on {@link VideoStandardOutputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #video(VideoStandardOutputConfiguration)
         */
        default Builder video(Consumer<VideoStandardOutputConfiguration.Builder> video) {
            return video(VideoStandardOutputConfiguration.builder().applyMutation(video).build());
        }

        /**
         * Sets the value of the Audio property for this object.
         *
         * @param audio
         *        The new value for the Audio property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audio(AudioStandardOutputConfiguration audio);

        /**
         * Sets the value of the Audio property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AudioStandardOutputConfiguration.Builder}
         * avoiding the need to create one manually via {@link AudioStandardOutputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AudioStandardOutputConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #audio(AudioStandardOutputConfiguration)}.
         * 
         * @param audio
         *        a consumer that will call methods on {@link AudioStandardOutputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #audio(AudioStandardOutputConfiguration)
         */
        default Builder audio(Consumer<AudioStandardOutputConfiguration.Builder> audio) {
            return audio(AudioStandardOutputConfiguration.builder().applyMutation(audio).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DocumentStandardOutputConfiguration document;

        private ImageStandardOutputConfiguration image;

        private VideoStandardOutputConfiguration video;

        private AudioStandardOutputConfiguration audio;

        private BuilderImpl() {
        }

        private BuilderImpl(StandardOutputConfiguration model) {
            document(model.document);
            image(model.image);
            video(model.video);
            audio(model.audio);
        }

        public final DocumentStandardOutputConfiguration.Builder getDocument() {
            return document != null ? document.toBuilder() : null;
        }

        public final void setDocument(DocumentStandardOutputConfiguration.BuilderImpl document) {
            this.document = document != null ? document.build() : null;
        }

        @Override
        public final Builder document(DocumentStandardOutputConfiguration document) {
            this.document = document;
            return this;
        }

        public final ImageStandardOutputConfiguration.Builder getImage() {
            return image != null ? image.toBuilder() : null;
        }

        public final void setImage(ImageStandardOutputConfiguration.BuilderImpl image) {
            this.image = image != null ? image.build() : null;
        }

        @Override
        public final Builder image(ImageStandardOutputConfiguration image) {
            this.image = image;
            return this;
        }

        public final VideoStandardOutputConfiguration.Builder getVideo() {
            return video != null ? video.toBuilder() : null;
        }

        public final void setVideo(VideoStandardOutputConfiguration.BuilderImpl video) {
            this.video = video != null ? video.build() : null;
        }

        @Override
        public final Builder video(VideoStandardOutputConfiguration video) {
            this.video = video;
            return this;
        }

        public final AudioStandardOutputConfiguration.Builder getAudio() {
            return audio != null ? audio.toBuilder() : null;
        }

        public final void setAudio(AudioStandardOutputConfiguration.BuilderImpl audio) {
            this.audio = audio != null ? audio.build() : null;
        }

        @Override
        public final Builder audio(AudioStandardOutputConfiguration audio) {
            this.audio = audio;
            return this;
        }

        @Override
        public StandardOutputConfiguration build() {
            return new StandardOutputConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
