/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Standard Extraction Configuration of Video
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VideoStandardExtraction implements SdkPojo, Serializable,
        ToCopyableBuilder<VideoStandardExtraction.Builder, VideoStandardExtraction> {
    private static final SdkField<VideoExtractionCategory> CATEGORY_FIELD = SdkField
            .<VideoExtractionCategory> builder(MarshallingType.SDK_POJO).memberName("category")
            .getter(getter(VideoStandardExtraction::category)).setter(setter(Builder::category))
            .constructor(VideoExtractionCategory::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("category").build()).build();

    private static final SdkField<VideoBoundingBox> BOUNDING_BOX_FIELD = SdkField
            .<VideoBoundingBox> builder(MarshallingType.SDK_POJO).memberName("boundingBox")
            .getter(getter(VideoStandardExtraction::boundingBox)).setter(setter(Builder::boundingBox))
            .constructor(VideoBoundingBox::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("boundingBox").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_FIELD,
            BOUNDING_BOX_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final VideoExtractionCategory category;

    private final VideoBoundingBox boundingBox;

    private VideoStandardExtraction(BuilderImpl builder) {
        this.category = builder.category;
        this.boundingBox = builder.boundingBox;
    }

    /**
     * Returns the value of the Category property for this object.
     * 
     * @return The value of the Category property for this object.
     */
    public final VideoExtractionCategory category() {
        return category;
    }

    /**
     * Returns the value of the BoundingBox property for this object.
     * 
     * @return The value of the BoundingBox property for this object.
     */
    public final VideoBoundingBox boundingBox() {
        return boundingBox;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(category());
        hashCode = 31 * hashCode + Objects.hashCode(boundingBox());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoStandardExtraction)) {
            return false;
        }
        VideoStandardExtraction other = (VideoStandardExtraction) obj;
        return Objects.equals(category(), other.category()) && Objects.equals(boundingBox(), other.boundingBox());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VideoStandardExtraction").add("Category", category()).add("BoundingBox", boundingBox()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "category":
            return Optional.ofNullable(clazz.cast(category()));
        case "boundingBox":
            return Optional.ofNullable(clazz.cast(boundingBox()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("category", CATEGORY_FIELD);
        map.put("boundingBox", BOUNDING_BOX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VideoStandardExtraction, T> g) {
        return obj -> g.apply((VideoStandardExtraction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VideoStandardExtraction> {
        /**
         * Sets the value of the Category property for this object.
         *
         * @param category
         *        The new value for the Category property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder category(VideoExtractionCategory category);

        /**
         * Sets the value of the Category property for this object.
         *
         * This is a convenience method that creates an instance of the {@link VideoExtractionCategory.Builder} avoiding
         * the need to create one manually via {@link VideoExtractionCategory#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VideoExtractionCategory.Builder#build()} is called immediately
         * and its result is passed to {@link #category(VideoExtractionCategory)}.
         * 
         * @param category
         *        a consumer that will call methods on {@link VideoExtractionCategory.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #category(VideoExtractionCategory)
         */
        default Builder category(Consumer<VideoExtractionCategory.Builder> category) {
            return category(VideoExtractionCategory.builder().applyMutation(category).build());
        }

        /**
         * Sets the value of the BoundingBox property for this object.
         *
         * @param boundingBox
         *        The new value for the BoundingBox property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder boundingBox(VideoBoundingBox boundingBox);

        /**
         * Sets the value of the BoundingBox property for this object.
         *
         * This is a convenience method that creates an instance of the {@link VideoBoundingBox.Builder} avoiding the
         * need to create one manually via {@link VideoBoundingBox#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VideoBoundingBox.Builder#build()} is called immediately and its
         * result is passed to {@link #boundingBox(VideoBoundingBox)}.
         * 
         * @param boundingBox
         *        a consumer that will call methods on {@link VideoBoundingBox.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #boundingBox(VideoBoundingBox)
         */
        default Builder boundingBox(Consumer<VideoBoundingBox.Builder> boundingBox) {
            return boundingBox(VideoBoundingBox.builder().applyMutation(boundingBox).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private VideoExtractionCategory category;

        private VideoBoundingBox boundingBox;

        private BuilderImpl() {
        }

        private BuilderImpl(VideoStandardExtraction model) {
            category(model.category);
            boundingBox(model.boundingBox);
        }

        public final VideoExtractionCategory.Builder getCategory() {
            return category != null ? category.toBuilder() : null;
        }

        public final void setCategory(VideoExtractionCategory.BuilderImpl category) {
            this.category = category != null ? category.build() : null;
        }

        @Override
        public final Builder category(VideoExtractionCategory category) {
            this.category = category;
            return this;
        }

        public final VideoBoundingBox.Builder getBoundingBox() {
            return boundingBox != null ? boundingBox.toBuilder() : null;
        }

        public final void setBoundingBox(VideoBoundingBox.BuilderImpl boundingBox) {
            this.boundingBox = boundingBox != null ? boundingBox.build() : null;
        }

        @Override
        public final Builder boundingBox(VideoBoundingBox boundingBox) {
            this.boundingBox = boundingBox;
            return this;
        }

        @Override
        public VideoStandardExtraction build() {
            return new VideoStandardExtraction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
