/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for different audio extraction category types
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AudioExtractionCategoryTypeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AudioExtractionCategoryTypeConfiguration.Builder, AudioExtractionCategoryTypeConfiguration> {
    private static final SdkField<TranscriptConfiguration> TRANSCRIPT_FIELD = SdkField
            .<TranscriptConfiguration> builder(MarshallingType.SDK_POJO).memberName("transcript")
            .getter(getter(AudioExtractionCategoryTypeConfiguration::transcript)).setter(setter(Builder::transcript))
            .constructor(TranscriptConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transcript").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSCRIPT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TranscriptConfiguration transcript;

    private AudioExtractionCategoryTypeConfiguration(BuilderImpl builder) {
        this.transcript = builder.transcript;
    }

    /**
     * Returns the value of the Transcript property for this object.
     * 
     * @return The value of the Transcript property for this object.
     */
    public final TranscriptConfiguration transcript() {
        return transcript;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transcript());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioExtractionCategoryTypeConfiguration)) {
            return false;
        }
        AudioExtractionCategoryTypeConfiguration other = (AudioExtractionCategoryTypeConfiguration) obj;
        return Objects.equals(transcript(), other.transcript());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AudioExtractionCategoryTypeConfiguration").add("Transcript", transcript()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "transcript":
            return Optional.ofNullable(clazz.cast(transcript()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("transcript", TRANSCRIPT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AudioExtractionCategoryTypeConfiguration, T> g) {
        return obj -> g.apply((AudioExtractionCategoryTypeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AudioExtractionCategoryTypeConfiguration> {
        /**
         * Sets the value of the Transcript property for this object.
         *
         * @param transcript
         *        The new value for the Transcript property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transcript(TranscriptConfiguration transcript);

        /**
         * Sets the value of the Transcript property for this object.
         *
         * This is a convenience method that creates an instance of the {@link TranscriptConfiguration.Builder} avoiding
         * the need to create one manually via {@link TranscriptConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TranscriptConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #transcript(TranscriptConfiguration)}.
         * 
         * @param transcript
         *        a consumer that will call methods on {@link TranscriptConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transcript(TranscriptConfiguration)
         */
        default Builder transcript(Consumer<TranscriptConfiguration.Builder> transcript) {
            return transcript(TranscriptConfiguration.builder().applyMutation(transcript).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TranscriptConfiguration transcript;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioExtractionCategoryTypeConfiguration model) {
            transcript(model.transcript);
        }

        public final TranscriptConfiguration.Builder getTranscript() {
            return transcript != null ? transcript.toBuilder() : null;
        }

        public final void setTranscript(TranscriptConfiguration.BuilderImpl transcript) {
            this.transcript = transcript != null ? transcript.build() : null;
        }

        @Override
        public final Builder transcript(TranscriptConfiguration transcript) {
            this.transcript = transcript;
            return this;
        }

        @Override
        public AudioExtractionCategoryTypeConfiguration build() {
            return new AudioExtractionCategoryTypeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
