/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Optional configuration for audio language settings
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AudioLanguageConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AudioLanguageConfiguration.Builder, AudioLanguageConfiguration> {
    private static final SdkField<List<String>> INPUT_LANGUAGES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("inputLanguages")
            .getter(getter(AudioLanguageConfiguration::inputLanguagesAsStrings))
            .setter(setter(Builder::inputLanguagesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputLanguages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> GENERATIVE_OUTPUT_LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("generativeOutputLanguage").getter(getter(AudioLanguageConfiguration::generativeOutputLanguageAsString))
            .setter(setter(Builder::generativeOutputLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generativeOutputLanguage").build())
            .build();

    private static final SdkField<Boolean> IDENTIFY_MULTIPLE_LANGUAGES_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("identifyMultipleLanguages")
            .getter(getter(AudioLanguageConfiguration::identifyMultipleLanguages))
            .setter(setter(Builder::identifyMultipleLanguages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifyMultipleLanguages").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_LANGUAGES_FIELD,
            GENERATIVE_OUTPUT_LANGUAGE_FIELD, IDENTIFY_MULTIPLE_LANGUAGES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> inputLanguages;

    private final String generativeOutputLanguage;

    private final Boolean identifyMultipleLanguages;

    private AudioLanguageConfiguration(BuilderImpl builder) {
        this.inputLanguages = builder.inputLanguages;
        this.generativeOutputLanguage = builder.generativeOutputLanguage;
        this.identifyMultipleLanguages = builder.identifyMultipleLanguages;
    }

    /**
     * Returns the value of the InputLanguages property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputLanguages} method.
     * </p>
     * 
     * @return The value of the InputLanguages property for this object.
     */
    public final List<Language> inputLanguages() {
        return AudioInputLanguagesCopier.copyStringToEnum(inputLanguages);
    }

    /**
     * For responses, this returns true if the service returned a value for the InputLanguages property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInputLanguages() {
        return inputLanguages != null && !(inputLanguages instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the InputLanguages property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputLanguages} method.
     * </p>
     * 
     * @return The value of the InputLanguages property for this object.
     */
    public final List<String> inputLanguagesAsStrings() {
        return inputLanguages;
    }

    /**
     * Returns the value of the GenerativeOutputLanguage property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #generativeOutputLanguage} will return {@link AudioGenerativeOutputLanguage#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #generativeOutputLanguageAsString}.
     * </p>
     * 
     * @return The value of the GenerativeOutputLanguage property for this object.
     * @see AudioGenerativeOutputLanguage
     */
    public final AudioGenerativeOutputLanguage generativeOutputLanguage() {
        return AudioGenerativeOutputLanguage.fromValue(generativeOutputLanguage);
    }

    /**
     * Returns the value of the GenerativeOutputLanguage property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #generativeOutputLanguage} will return {@link AudioGenerativeOutputLanguage#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #generativeOutputLanguageAsString}.
     * </p>
     * 
     * @return The value of the GenerativeOutputLanguage property for this object.
     * @see AudioGenerativeOutputLanguage
     */
    public final String generativeOutputLanguageAsString() {
        return generativeOutputLanguage;
    }

    /**
     * <p>
     * Enable multiple language identification in audio
     * </p>
     * 
     * @return Enable multiple language identification in audio
     */
    public final Boolean identifyMultipleLanguages() {
        return identifyMultipleLanguages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasInputLanguages() ? inputLanguagesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(generativeOutputLanguageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(identifyMultipleLanguages());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioLanguageConfiguration)) {
            return false;
        }
        AudioLanguageConfiguration other = (AudioLanguageConfiguration) obj;
        return hasInputLanguages() == other.hasInputLanguages()
                && Objects.equals(inputLanguagesAsStrings(), other.inputLanguagesAsStrings())
                && Objects.equals(generativeOutputLanguageAsString(), other.generativeOutputLanguageAsString())
                && Objects.equals(identifyMultipleLanguages(), other.identifyMultipleLanguages());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AudioLanguageConfiguration")
                .add("InputLanguages", hasInputLanguages() ? inputLanguagesAsStrings() : null)
                .add("GenerativeOutputLanguage", generativeOutputLanguageAsString())
                .add("IdentifyMultipleLanguages", identifyMultipleLanguages()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inputLanguages":
            return Optional.ofNullable(clazz.cast(inputLanguagesAsStrings()));
        case "generativeOutputLanguage":
            return Optional.ofNullable(clazz.cast(generativeOutputLanguageAsString()));
        case "identifyMultipleLanguages":
            return Optional.ofNullable(clazz.cast(identifyMultipleLanguages()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("inputLanguages", INPUT_LANGUAGES_FIELD);
        map.put("generativeOutputLanguage", GENERATIVE_OUTPUT_LANGUAGE_FIELD);
        map.put("identifyMultipleLanguages", IDENTIFY_MULTIPLE_LANGUAGES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AudioLanguageConfiguration, T> g) {
        return obj -> g.apply((AudioLanguageConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AudioLanguageConfiguration> {
        /**
         * Sets the value of the InputLanguages property for this object.
         *
         * @param inputLanguages
         *        The new value for the InputLanguages property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputLanguagesWithStrings(Collection<String> inputLanguages);

        /**
         * Sets the value of the InputLanguages property for this object.
         *
         * @param inputLanguages
         *        The new value for the InputLanguages property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputLanguagesWithStrings(String... inputLanguages);

        /**
         * Sets the value of the InputLanguages property for this object.
         *
         * @param inputLanguages
         *        The new value for the InputLanguages property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputLanguages(Collection<Language> inputLanguages);

        /**
         * Sets the value of the InputLanguages property for this object.
         *
         * @param inputLanguages
         *        The new value for the InputLanguages property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputLanguages(Language... inputLanguages);

        /**
         * Sets the value of the GenerativeOutputLanguage property for this object.
         *
         * @param generativeOutputLanguage
         *        The new value for the GenerativeOutputLanguage property for this object.
         * @see AudioGenerativeOutputLanguage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AudioGenerativeOutputLanguage
         */
        Builder generativeOutputLanguage(String generativeOutputLanguage);

        /**
         * Sets the value of the GenerativeOutputLanguage property for this object.
         *
         * @param generativeOutputLanguage
         *        The new value for the GenerativeOutputLanguage property for this object.
         * @see AudioGenerativeOutputLanguage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AudioGenerativeOutputLanguage
         */
        Builder generativeOutputLanguage(AudioGenerativeOutputLanguage generativeOutputLanguage);

        /**
         * <p>
         * Enable multiple language identification in audio
         * </p>
         * 
         * @param identifyMultipleLanguages
         *        Enable multiple language identification in audio
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifyMultipleLanguages(Boolean identifyMultipleLanguages);
    }

    static final class BuilderImpl implements Builder {
        private List<String> inputLanguages = DefaultSdkAutoConstructList.getInstance();

        private String generativeOutputLanguage;

        private Boolean identifyMultipleLanguages;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioLanguageConfiguration model) {
            inputLanguagesWithStrings(model.inputLanguages);
            generativeOutputLanguage(model.generativeOutputLanguage);
            identifyMultipleLanguages(model.identifyMultipleLanguages);
        }

        public final Collection<String> getInputLanguages() {
            if (inputLanguages instanceof SdkAutoConstructList) {
                return null;
            }
            return inputLanguages;
        }

        public final void setInputLanguages(Collection<String> inputLanguages) {
            this.inputLanguages = AudioInputLanguagesCopier.copy(inputLanguages);
        }

        @Override
        public final Builder inputLanguagesWithStrings(Collection<String> inputLanguages) {
            this.inputLanguages = AudioInputLanguagesCopier.copy(inputLanguages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputLanguagesWithStrings(String... inputLanguages) {
            inputLanguagesWithStrings(Arrays.asList(inputLanguages));
            return this;
        }

        @Override
        public final Builder inputLanguages(Collection<Language> inputLanguages) {
            this.inputLanguages = AudioInputLanguagesCopier.copyEnumToString(inputLanguages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputLanguages(Language... inputLanguages) {
            inputLanguages(Arrays.asList(inputLanguages));
            return this;
        }

        public final String getGenerativeOutputLanguage() {
            return generativeOutputLanguage;
        }

        public final void setGenerativeOutputLanguage(String generativeOutputLanguage) {
            this.generativeOutputLanguage = generativeOutputLanguage;
        }

        @Override
        public final Builder generativeOutputLanguage(String generativeOutputLanguage) {
            this.generativeOutputLanguage = generativeOutputLanguage;
            return this;
        }

        @Override
        public final Builder generativeOutputLanguage(AudioGenerativeOutputLanguage generativeOutputLanguage) {
            this.generativeOutputLanguage(generativeOutputLanguage == null ? null : generativeOutputLanguage.toString());
            return this;
        }

        public final Boolean getIdentifyMultipleLanguages() {
            return identifyMultipleLanguages;
        }

        public final void setIdentifyMultipleLanguages(Boolean identifyMultipleLanguages) {
            this.identifyMultipleLanguages = identifyMultipleLanguages;
        }

        @Override
        public final Builder identifyMultipleLanguages(Boolean identifyMultipleLanguages) {
            this.identifyMultipleLanguages = identifyMultipleLanguages;
            return this;
        }

        @Override
        public AudioLanguageConfiguration build() {
            return new AudioLanguageConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
