/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Override Configuration of Audio
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AudioOverrideConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AudioOverrideConfiguration.Builder, AudioOverrideConfiguration> {
    private static final SdkField<ModalityProcessingConfiguration> MODALITY_PROCESSING_FIELD = SdkField
            .<ModalityProcessingConfiguration> builder(MarshallingType.SDK_POJO).memberName("modalityProcessing")
            .getter(getter(AudioOverrideConfiguration::modalityProcessing)).setter(setter(Builder::modalityProcessing))
            .constructor(ModalityProcessingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modalityProcessing").build())
            .build();

    private static final SdkField<AudioLanguageConfiguration> LANGUAGE_CONFIGURATION_FIELD = SdkField
            .<AudioLanguageConfiguration> builder(MarshallingType.SDK_POJO).memberName("languageConfiguration")
            .getter(getter(AudioOverrideConfiguration::languageConfiguration)).setter(setter(Builder::languageConfiguration))
            .constructor(AudioLanguageConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("languageConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODALITY_PROCESSING_FIELD,
            LANGUAGE_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ModalityProcessingConfiguration modalityProcessing;

    private final AudioLanguageConfiguration languageConfiguration;

    private AudioOverrideConfiguration(BuilderImpl builder) {
        this.modalityProcessing = builder.modalityProcessing;
        this.languageConfiguration = builder.languageConfiguration;
    }

    /**
     * Returns the value of the ModalityProcessing property for this object.
     * 
     * @return The value of the ModalityProcessing property for this object.
     */
    public final ModalityProcessingConfiguration modalityProcessing() {
        return modalityProcessing;
    }

    /**
     * Returns the value of the LanguageConfiguration property for this object.
     * 
     * @return The value of the LanguageConfiguration property for this object.
     */
    public final AudioLanguageConfiguration languageConfiguration() {
        return languageConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modalityProcessing());
        hashCode = 31 * hashCode + Objects.hashCode(languageConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioOverrideConfiguration)) {
            return false;
        }
        AudioOverrideConfiguration other = (AudioOverrideConfiguration) obj;
        return Objects.equals(modalityProcessing(), other.modalityProcessing())
                && Objects.equals(languageConfiguration(), other.languageConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AudioOverrideConfiguration").add("ModalityProcessing", modalityProcessing())
                .add("LanguageConfiguration", languageConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "modalityProcessing":
            return Optional.ofNullable(clazz.cast(modalityProcessing()));
        case "languageConfiguration":
            return Optional.ofNullable(clazz.cast(languageConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("modalityProcessing", MODALITY_PROCESSING_FIELD);
        map.put("languageConfiguration", LANGUAGE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AudioOverrideConfiguration, T> g) {
        return obj -> g.apply((AudioOverrideConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AudioOverrideConfiguration> {
        /**
         * Sets the value of the ModalityProcessing property for this object.
         *
         * @param modalityProcessing
         *        The new value for the ModalityProcessing property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modalityProcessing(ModalityProcessingConfiguration modalityProcessing);

        /**
         * Sets the value of the ModalityProcessing property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ModalityProcessingConfiguration.Builder}
         * avoiding the need to create one manually via {@link ModalityProcessingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModalityProcessingConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #modalityProcessing(ModalityProcessingConfiguration)}.
         * 
         * @param modalityProcessing
         *        a consumer that will call methods on {@link ModalityProcessingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modalityProcessing(ModalityProcessingConfiguration)
         */
        default Builder modalityProcessing(Consumer<ModalityProcessingConfiguration.Builder> modalityProcessing) {
            return modalityProcessing(ModalityProcessingConfiguration.builder().applyMutation(modalityProcessing).build());
        }

        /**
         * Sets the value of the LanguageConfiguration property for this object.
         *
         * @param languageConfiguration
         *        The new value for the LanguageConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languageConfiguration(AudioLanguageConfiguration languageConfiguration);

        /**
         * Sets the value of the LanguageConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AudioLanguageConfiguration.Builder}
         * avoiding the need to create one manually via {@link AudioLanguageConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AudioLanguageConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #languageConfiguration(AudioLanguageConfiguration)}.
         * 
         * @param languageConfiguration
         *        a consumer that will call methods on {@link AudioLanguageConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #languageConfiguration(AudioLanguageConfiguration)
         */
        default Builder languageConfiguration(Consumer<AudioLanguageConfiguration.Builder> languageConfiguration) {
            return languageConfiguration(AudioLanguageConfiguration.builder().applyMutation(languageConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ModalityProcessingConfiguration modalityProcessing;

        private AudioLanguageConfiguration languageConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioOverrideConfiguration model) {
            modalityProcessing(model.modalityProcessing);
            languageConfiguration(model.languageConfiguration);
        }

        public final ModalityProcessingConfiguration.Builder getModalityProcessing() {
            return modalityProcessing != null ? modalityProcessing.toBuilder() : null;
        }

        public final void setModalityProcessing(ModalityProcessingConfiguration.BuilderImpl modalityProcessing) {
            this.modalityProcessing = modalityProcessing != null ? modalityProcessing.build() : null;
        }

        @Override
        public final Builder modalityProcessing(ModalityProcessingConfiguration modalityProcessing) {
            this.modalityProcessing = modalityProcessing;
            return this;
        }

        public final AudioLanguageConfiguration.Builder getLanguageConfiguration() {
            return languageConfiguration != null ? languageConfiguration.toBuilder() : null;
        }

        public final void setLanguageConfiguration(AudioLanguageConfiguration.BuilderImpl languageConfiguration) {
            this.languageConfiguration = languageConfiguration != null ? languageConfiguration.build() : null;
        }

        @Override
        public final Builder languageConfiguration(AudioLanguageConfiguration languageConfiguration) {
            this.languageConfiguration = languageConfiguration;
            return this;
        }

        @Override
        public AudioOverrideConfiguration build() {
            return new AudioOverrideConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
