/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the information of a DataAutomationProject.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataAutomationProject implements SdkPojo, Serializable,
        ToCopyableBuilder<DataAutomationProject.Builder, DataAutomationProject> {
    private static final SdkField<String> PROJECT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectArn").getter(getter(DataAutomationProject::projectArn)).setter(setter(Builder::projectArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectArn").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(DataAutomationProject::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedTime")
            .getter(getter(DataAutomationProject::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectName").getter(getter(DataAutomationProject::projectName)).setter(setter(Builder::projectName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectName").build()).build();

    private static final SdkField<String> PROJECT_STAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectStage").getter(getter(DataAutomationProject::projectStageAsString))
            .setter(setter(Builder::projectStage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectStage").build()).build();

    private static final SdkField<String> PROJECT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectDescription").getter(getter(DataAutomationProject::projectDescription))
            .setter(setter(Builder::projectDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectDescription").build())
            .build();

    private static final SdkField<StandardOutputConfiguration> STANDARD_OUTPUT_CONFIGURATION_FIELD = SdkField
            .<StandardOutputConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("standardOutputConfiguration")
            .getter(getter(DataAutomationProject::standardOutputConfiguration))
            .setter(setter(Builder::standardOutputConfiguration))
            .constructor(StandardOutputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("standardOutputConfiguration")
                    .build()).build();

    private static final SdkField<CustomOutputConfiguration> CUSTOM_OUTPUT_CONFIGURATION_FIELD = SdkField
            .<CustomOutputConfiguration> builder(MarshallingType.SDK_POJO).memberName("customOutputConfiguration")
            .getter(getter(DataAutomationProject::customOutputConfiguration)).setter(setter(Builder::customOutputConfiguration))
            .constructor(CustomOutputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customOutputConfiguration").build())
            .build();

    private static final SdkField<OverrideConfiguration> OVERRIDE_CONFIGURATION_FIELD = SdkField
            .<OverrideConfiguration> builder(MarshallingType.SDK_POJO).memberName("overrideConfiguration")
            .getter(getter(DataAutomationProject::overrideConfigurationValue))
            .setter(setter(Builder::overrideConfigurationValue)).constructor(OverrideConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrideConfiguration").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DataAutomationProject::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyId").getter(getter(DataAutomationProject::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()).build();

    private static final SdkField<Map<String, String>> KMS_ENCRYPTION_CONTEXT_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("kmsEncryptionContext")
            .getter(getter(DataAutomationProject::kmsEncryptionContext))
            .setter(setter(Builder::kmsEncryptionContext))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsEncryptionContext").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_ARN_FIELD,
            CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, PROJECT_NAME_FIELD, PROJECT_STAGE_FIELD, PROJECT_DESCRIPTION_FIELD,
            STANDARD_OUTPUT_CONFIGURATION_FIELD, CUSTOM_OUTPUT_CONFIGURATION_FIELD, OVERRIDE_CONFIGURATION_FIELD, STATUS_FIELD,
            KMS_KEY_ID_FIELD, KMS_ENCRYPTION_CONTEXT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String projectArn;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private final String projectName;

    private final String projectStage;

    private final String projectDescription;

    private final StandardOutputConfiguration standardOutputConfiguration;

    private final CustomOutputConfiguration customOutputConfiguration;

    private final OverrideConfiguration overrideConfigurationValue;

    private final String status;

    private final String kmsKeyId;

    private final Map<String, String> kmsEncryptionContext;

    private DataAutomationProject(BuilderImpl builder) {
        this.projectArn = builder.projectArn;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.projectName = builder.projectName;
        this.projectStage = builder.projectStage;
        this.projectDescription = builder.projectDescription;
        this.standardOutputConfiguration = builder.standardOutputConfiguration;
        this.customOutputConfiguration = builder.customOutputConfiguration;
        this.overrideConfigurationValue = builder.overrideConfigurationValue;
        this.status = builder.status;
        this.kmsKeyId = builder.kmsKeyId;
        this.kmsEncryptionContext = builder.kmsEncryptionContext;
    }

    /**
     * Returns the value of the ProjectArn property for this object.
     * 
     * @return The value of the ProjectArn property for this object.
     */
    public final String projectArn() {
        return projectArn;
    }

    /**
     * Returns the value of the CreationTime property for this object.
     * 
     * @return The value of the CreationTime property for this object.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * Returns the value of the LastModifiedTime property for this object.
     * 
     * @return The value of the LastModifiedTime property for this object.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * Returns the value of the ProjectName property for this object.
     * 
     * @return The value of the ProjectName property for this object.
     */
    public final String projectName() {
        return projectName;
    }

    /**
     * Returns the value of the ProjectStage property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #projectStage} will
     * return {@link DataAutomationProjectStage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #projectStageAsString}.
     * </p>
     * 
     * @return The value of the ProjectStage property for this object.
     * @see DataAutomationProjectStage
     */
    public final DataAutomationProjectStage projectStage() {
        return DataAutomationProjectStage.fromValue(projectStage);
    }

    /**
     * Returns the value of the ProjectStage property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #projectStage} will
     * return {@link DataAutomationProjectStage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #projectStageAsString}.
     * </p>
     * 
     * @return The value of the ProjectStage property for this object.
     * @see DataAutomationProjectStage
     */
    public final String projectStageAsString() {
        return projectStage;
    }

    /**
     * Returns the value of the ProjectDescription property for this object.
     * 
     * @return The value of the ProjectDescription property for this object.
     */
    public final String projectDescription() {
        return projectDescription;
    }

    /**
     * Returns the value of the StandardOutputConfiguration property for this object.
     * 
     * @return The value of the StandardOutputConfiguration property for this object.
     */
    public final StandardOutputConfiguration standardOutputConfiguration() {
        return standardOutputConfiguration;
    }

    /**
     * Returns the value of the CustomOutputConfiguration property for this object.
     * 
     * @return The value of the CustomOutputConfiguration property for this object.
     */
    public final CustomOutputConfiguration customOutputConfiguration() {
        return customOutputConfiguration;
    }

    /**
     * Returns the value of the OverrideConfiguration property for this object.
     * 
     * @return The value of the OverrideConfiguration property for this object.
     */
    public final OverrideConfiguration overrideConfigurationValue() {
        return overrideConfigurationValue;
    }

    /**
     * Returns the value of the Status property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DataAutomationProjectStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The value of the Status property for this object.
     * @see DataAutomationProjectStatus
     */
    public final DataAutomationProjectStatus status() {
        return DataAutomationProjectStatus.fromValue(status);
    }

    /**
     * Returns the value of the Status property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DataAutomationProjectStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The value of the Status property for this object.
     * @see DataAutomationProjectStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * Returns the value of the KmsKeyId property for this object.
     * 
     * @return The value of the KmsKeyId property for this object.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * For responses, this returns true if the service returned a value for the KmsEncryptionContext property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasKmsEncryptionContext() {
        return kmsEncryptionContext != null && !(kmsEncryptionContext instanceof SdkAutoConstructMap);
    }

    /**
     * Returns the value of the KmsEncryptionContext property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKmsEncryptionContext} method.
     * </p>
     * 
     * @return The value of the KmsEncryptionContext property for this object.
     */
    public final Map<String, String> kmsEncryptionContext() {
        return kmsEncryptionContext;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(projectArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(projectName());
        hashCode = 31 * hashCode + Objects.hashCode(projectStageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(projectDescription());
        hashCode = 31 * hashCode + Objects.hashCode(standardOutputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(customOutputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(overrideConfigurationValue());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(hasKmsEncryptionContext() ? kmsEncryptionContext() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataAutomationProject)) {
            return false;
        }
        DataAutomationProject other = (DataAutomationProject) obj;
        return Objects.equals(projectArn(), other.projectArn()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(projectName(), other.projectName())
                && Objects.equals(projectStageAsString(), other.projectStageAsString())
                && Objects.equals(projectDescription(), other.projectDescription())
                && Objects.equals(standardOutputConfiguration(), other.standardOutputConfiguration())
                && Objects.equals(customOutputConfiguration(), other.customOutputConfiguration())
                && Objects.equals(overrideConfigurationValue(), other.overrideConfigurationValue())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && hasKmsEncryptionContext() == other.hasKmsEncryptionContext()
                && Objects.equals(kmsEncryptionContext(), other.kmsEncryptionContext());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataAutomationProject").add("ProjectArn", projectArn()).add("CreationTime", creationTime())
                .add("LastModifiedTime", lastModifiedTime())
                .add("ProjectName", projectName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ProjectStage", projectStageAsString())
                .add("ProjectDescription", projectDescription() == null ? null : "*** Sensitive Data Redacted ***")
                .add("StandardOutputConfiguration", standardOutputConfiguration())
                .add("CustomOutputConfiguration", customOutputConfiguration())
                .add("OverrideConfiguration", overrideConfigurationValue()).add("Status", statusAsString())
                .add("KmsKeyId", kmsKeyId())
                .add("KmsEncryptionContext", hasKmsEncryptionContext() ? kmsEncryptionContext() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "projectArn":
            return Optional.ofNullable(clazz.cast(projectArn()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "projectName":
            return Optional.ofNullable(clazz.cast(projectName()));
        case "projectStage":
            return Optional.ofNullable(clazz.cast(projectStageAsString()));
        case "projectDescription":
            return Optional.ofNullable(clazz.cast(projectDescription()));
        case "standardOutputConfiguration":
            return Optional.ofNullable(clazz.cast(standardOutputConfiguration()));
        case "customOutputConfiguration":
            return Optional.ofNullable(clazz.cast(customOutputConfiguration()));
        case "overrideConfiguration":
            return Optional.ofNullable(clazz.cast(overrideConfigurationValue()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "kmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "kmsEncryptionContext":
            return Optional.ofNullable(clazz.cast(kmsEncryptionContext()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("projectArn", PROJECT_ARN_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("lastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("projectName", PROJECT_NAME_FIELD);
        map.put("projectStage", PROJECT_STAGE_FIELD);
        map.put("projectDescription", PROJECT_DESCRIPTION_FIELD);
        map.put("standardOutputConfiguration", STANDARD_OUTPUT_CONFIGURATION_FIELD);
        map.put("customOutputConfiguration", CUSTOM_OUTPUT_CONFIGURATION_FIELD);
        map.put("overrideConfiguration", OVERRIDE_CONFIGURATION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("kmsKeyId", KMS_KEY_ID_FIELD);
        map.put("kmsEncryptionContext", KMS_ENCRYPTION_CONTEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataAutomationProject, T> g) {
        return obj -> g.apply((DataAutomationProject) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataAutomationProject> {
        /**
         * Sets the value of the ProjectArn property for this object.
         *
         * @param projectArn
         *        The new value for the ProjectArn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectArn(String projectArn);

        /**
         * Sets the value of the CreationTime property for this object.
         *
         * @param creationTime
         *        The new value for the CreationTime property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * Sets the value of the LastModifiedTime property for this object.
         *
         * @param lastModifiedTime
         *        The new value for the LastModifiedTime property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * Sets the value of the ProjectName property for this object.
         *
         * @param projectName
         *        The new value for the ProjectName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectName(String projectName);

        /**
         * Sets the value of the ProjectStage property for this object.
         *
         * @param projectStage
         *        The new value for the ProjectStage property for this object.
         * @see DataAutomationProjectStage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataAutomationProjectStage
         */
        Builder projectStage(String projectStage);

        /**
         * Sets the value of the ProjectStage property for this object.
         *
         * @param projectStage
         *        The new value for the ProjectStage property for this object.
         * @see DataAutomationProjectStage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataAutomationProjectStage
         */
        Builder projectStage(DataAutomationProjectStage projectStage);

        /**
         * Sets the value of the ProjectDescription property for this object.
         *
         * @param projectDescription
         *        The new value for the ProjectDescription property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectDescription(String projectDescription);

        /**
         * Sets the value of the StandardOutputConfiguration property for this object.
         *
         * @param standardOutputConfiguration
         *        The new value for the StandardOutputConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardOutputConfiguration(StandardOutputConfiguration standardOutputConfiguration);

        /**
         * Sets the value of the StandardOutputConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link StandardOutputConfiguration.Builder}
         * avoiding the need to create one manually via {@link StandardOutputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StandardOutputConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #standardOutputConfiguration(StandardOutputConfiguration)}.
         * 
         * @param standardOutputConfiguration
         *        a consumer that will call methods on {@link StandardOutputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #standardOutputConfiguration(StandardOutputConfiguration)
         */
        default Builder standardOutputConfiguration(Consumer<StandardOutputConfiguration.Builder> standardOutputConfiguration) {
            return standardOutputConfiguration(StandardOutputConfiguration.builder().applyMutation(standardOutputConfiguration)
                    .build());
        }

        /**
         * Sets the value of the CustomOutputConfiguration property for this object.
         *
         * @param customOutputConfiguration
         *        The new value for the CustomOutputConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customOutputConfiguration(CustomOutputConfiguration customOutputConfiguration);

        /**
         * Sets the value of the CustomOutputConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CustomOutputConfiguration.Builder}
         * avoiding the need to create one manually via {@link CustomOutputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomOutputConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #customOutputConfiguration(CustomOutputConfiguration)}.
         * 
         * @param customOutputConfiguration
         *        a consumer that will call methods on {@link CustomOutputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customOutputConfiguration(CustomOutputConfiguration)
         */
        default Builder customOutputConfiguration(Consumer<CustomOutputConfiguration.Builder> customOutputConfiguration) {
            return customOutputConfiguration(CustomOutputConfiguration.builder().applyMutation(customOutputConfiguration).build());
        }

        /**
         * Sets the value of the OverrideConfiguration property for this object.
         *
         * @param overrideConfigurationValue
         *        The new value for the OverrideConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrideConfigurationValue(OverrideConfiguration overrideConfigurationValue);

        /**
         * Sets the value of the OverrideConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link OverrideConfiguration.Builder} avoiding
         * the need to create one manually via {@link OverrideConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OverrideConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #overrideConfigurationValue(OverrideConfiguration)}.
         * 
         * @param overrideConfigurationValue
         *        a consumer that will call methods on {@link OverrideConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #overrideConfigurationValue(OverrideConfiguration)
         */
        default Builder overrideConfigurationValue(Consumer<OverrideConfiguration.Builder> overrideConfigurationValue) {
            return overrideConfigurationValue(OverrideConfiguration.builder().applyMutation(overrideConfigurationValue).build());
        }

        /**
         * Sets the value of the Status property for this object.
         *
         * @param status
         *        The new value for the Status property for this object.
         * @see DataAutomationProjectStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataAutomationProjectStatus
         */
        Builder status(String status);

        /**
         * Sets the value of the Status property for this object.
         *
         * @param status
         *        The new value for the Status property for this object.
         * @see DataAutomationProjectStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataAutomationProjectStatus
         */
        Builder status(DataAutomationProjectStatus status);

        /**
         * Sets the value of the KmsKeyId property for this object.
         *
         * @param kmsKeyId
         *        The new value for the KmsKeyId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * Sets the value of the KmsEncryptionContext property for this object.
         *
         * @param kmsEncryptionContext
         *        The new value for the KmsEncryptionContext property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsEncryptionContext(Map<String, String> kmsEncryptionContext);
    }

    static final class BuilderImpl implements Builder {
        private String projectArn;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private String projectName;

        private String projectStage;

        private String projectDescription;

        private StandardOutputConfiguration standardOutputConfiguration;

        private CustomOutputConfiguration customOutputConfiguration;

        private OverrideConfiguration overrideConfigurationValue;

        private String status;

        private String kmsKeyId;

        private Map<String, String> kmsEncryptionContext = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DataAutomationProject model) {
            projectArn(model.projectArn);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
            projectName(model.projectName);
            projectStage(model.projectStage);
            projectDescription(model.projectDescription);
            standardOutputConfiguration(model.standardOutputConfiguration);
            customOutputConfiguration(model.customOutputConfiguration);
            overrideConfigurationValue(model.overrideConfigurationValue);
            status(model.status);
            kmsKeyId(model.kmsKeyId);
            kmsEncryptionContext(model.kmsEncryptionContext);
        }

        public final String getProjectArn() {
            return projectArn;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        @Override
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getProjectName() {
            return projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final String getProjectStage() {
            return projectStage;
        }

        public final void setProjectStage(String projectStage) {
            this.projectStage = projectStage;
        }

        @Override
        public final Builder projectStage(String projectStage) {
            this.projectStage = projectStage;
            return this;
        }

        @Override
        public final Builder projectStage(DataAutomationProjectStage projectStage) {
            this.projectStage(projectStage == null ? null : projectStage.toString());
            return this;
        }

        public final String getProjectDescription() {
            return projectDescription;
        }

        public final void setProjectDescription(String projectDescription) {
            this.projectDescription = projectDescription;
        }

        @Override
        public final Builder projectDescription(String projectDescription) {
            this.projectDescription = projectDescription;
            return this;
        }

        public final StandardOutputConfiguration.Builder getStandardOutputConfiguration() {
            return standardOutputConfiguration != null ? standardOutputConfiguration.toBuilder() : null;
        }

        public final void setStandardOutputConfiguration(StandardOutputConfiguration.BuilderImpl standardOutputConfiguration) {
            this.standardOutputConfiguration = standardOutputConfiguration != null ? standardOutputConfiguration.build() : null;
        }

        @Override
        public final Builder standardOutputConfiguration(StandardOutputConfiguration standardOutputConfiguration) {
            this.standardOutputConfiguration = standardOutputConfiguration;
            return this;
        }

        public final CustomOutputConfiguration.Builder getCustomOutputConfiguration() {
            return customOutputConfiguration != null ? customOutputConfiguration.toBuilder() : null;
        }

        public final void setCustomOutputConfiguration(CustomOutputConfiguration.BuilderImpl customOutputConfiguration) {
            this.customOutputConfiguration = customOutputConfiguration != null ? customOutputConfiguration.build() : null;
        }

        @Override
        public final Builder customOutputConfiguration(CustomOutputConfiguration customOutputConfiguration) {
            this.customOutputConfiguration = customOutputConfiguration;
            return this;
        }

        public final OverrideConfiguration.Builder getOverrideConfigurationValue() {
            return overrideConfigurationValue != null ? overrideConfigurationValue.toBuilder() : null;
        }

        public final void setOverrideConfigurationValue(OverrideConfiguration.BuilderImpl overrideConfigurationValue) {
            this.overrideConfigurationValue = overrideConfigurationValue != null ? overrideConfigurationValue.build() : null;
        }

        @Override
        public final Builder overrideConfigurationValue(OverrideConfiguration overrideConfigurationValue) {
            this.overrideConfigurationValue = overrideConfigurationValue;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DataAutomationProjectStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Map<String, String> getKmsEncryptionContext() {
            if (kmsEncryptionContext instanceof SdkAutoConstructMap) {
                return null;
            }
            return kmsEncryptionContext;
        }

        public final void setKmsEncryptionContext(Map<String, String> kmsEncryptionContext) {
            this.kmsEncryptionContext = KmsEncryptionContextCopier.copy(kmsEncryptionContext);
        }

        @Override
        public final Builder kmsEncryptionContext(Map<String, String> kmsEncryptionContext) {
            this.kmsEncryptionContext = KmsEncryptionContextCopier.copy(kmsEncryptionContext);
            return this;
        }

        @Override
        public DataAutomationProject build() {
            return new DataAutomationProject(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
