/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Override Configuration of Document
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentOverrideConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DocumentOverrideConfiguration.Builder, DocumentOverrideConfiguration> {
    private static final SdkField<SplitterConfiguration> SPLITTER_FIELD = SdkField
            .<SplitterConfiguration> builder(MarshallingType.SDK_POJO).memberName("splitter")
            .getter(getter(DocumentOverrideConfiguration::splitter)).setter(setter(Builder::splitter))
            .constructor(SplitterConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("splitter").build()).build();

    private static final SdkField<ModalityProcessingConfiguration> MODALITY_PROCESSING_FIELD = SdkField
            .<ModalityProcessingConfiguration> builder(MarshallingType.SDK_POJO).memberName("modalityProcessing")
            .getter(getter(DocumentOverrideConfiguration::modalityProcessing)).setter(setter(Builder::modalityProcessing))
            .constructor(ModalityProcessingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modalityProcessing").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPLITTER_FIELD,
            MODALITY_PROCESSING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SplitterConfiguration splitter;

    private final ModalityProcessingConfiguration modalityProcessing;

    private DocumentOverrideConfiguration(BuilderImpl builder) {
        this.splitter = builder.splitter;
        this.modalityProcessing = builder.modalityProcessing;
    }

    /**
     * Returns the value of the Splitter property for this object.
     * 
     * @return The value of the Splitter property for this object.
     */
    public final SplitterConfiguration splitter() {
        return splitter;
    }

    /**
     * Returns the value of the ModalityProcessing property for this object.
     * 
     * @return The value of the ModalityProcessing property for this object.
     */
    public final ModalityProcessingConfiguration modalityProcessing() {
        return modalityProcessing;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(splitter());
        hashCode = 31 * hashCode + Objects.hashCode(modalityProcessing());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentOverrideConfiguration)) {
            return false;
        }
        DocumentOverrideConfiguration other = (DocumentOverrideConfiguration) obj;
        return Objects.equals(splitter(), other.splitter()) && Objects.equals(modalityProcessing(), other.modalityProcessing());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DocumentOverrideConfiguration").add("Splitter", splitter())
                .add("ModalityProcessing", modalityProcessing()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "splitter":
            return Optional.ofNullable(clazz.cast(splitter()));
        case "modalityProcessing":
            return Optional.ofNullable(clazz.cast(modalityProcessing()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("splitter", SPLITTER_FIELD);
        map.put("modalityProcessing", MODALITY_PROCESSING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DocumentOverrideConfiguration, T> g) {
        return obj -> g.apply((DocumentOverrideConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocumentOverrideConfiguration> {
        /**
         * Sets the value of the Splitter property for this object.
         *
         * @param splitter
         *        The new value for the Splitter property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder splitter(SplitterConfiguration splitter);

        /**
         * Sets the value of the Splitter property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SplitterConfiguration.Builder} avoiding
         * the need to create one manually via {@link SplitterConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SplitterConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #splitter(SplitterConfiguration)}.
         * 
         * @param splitter
         *        a consumer that will call methods on {@link SplitterConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #splitter(SplitterConfiguration)
         */
        default Builder splitter(Consumer<SplitterConfiguration.Builder> splitter) {
            return splitter(SplitterConfiguration.builder().applyMutation(splitter).build());
        }

        /**
         * Sets the value of the ModalityProcessing property for this object.
         *
         * @param modalityProcessing
         *        The new value for the ModalityProcessing property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modalityProcessing(ModalityProcessingConfiguration modalityProcessing);

        /**
         * Sets the value of the ModalityProcessing property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ModalityProcessingConfiguration.Builder}
         * avoiding the need to create one manually via {@link ModalityProcessingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModalityProcessingConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #modalityProcessing(ModalityProcessingConfiguration)}.
         * 
         * @param modalityProcessing
         *        a consumer that will call methods on {@link ModalityProcessingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modalityProcessing(ModalityProcessingConfiguration)
         */
        default Builder modalityProcessing(Consumer<ModalityProcessingConfiguration.Builder> modalityProcessing) {
            return modalityProcessing(ModalityProcessingConfiguration.builder().applyMutation(modalityProcessing).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SplitterConfiguration splitter;

        private ModalityProcessingConfiguration modalityProcessing;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentOverrideConfiguration model) {
            splitter(model.splitter);
            modalityProcessing(model.modalityProcessing);
        }

        public final SplitterConfiguration.Builder getSplitter() {
            return splitter != null ? splitter.toBuilder() : null;
        }

        public final void setSplitter(SplitterConfiguration.BuilderImpl splitter) {
            this.splitter = splitter != null ? splitter.build() : null;
        }

        @Override
        public final Builder splitter(SplitterConfiguration splitter) {
            this.splitter = splitter;
            return this;
        }

        public final ModalityProcessingConfiguration.Builder getModalityProcessing() {
            return modalityProcessing != null ? modalityProcessing.toBuilder() : null;
        }

        public final void setModalityProcessing(ModalityProcessingConfiguration.BuilderImpl modalityProcessing) {
            this.modalityProcessing = modalityProcessing != null ? modalityProcessing.build() : null;
        }

        @Override
        public final Builder modalityProcessing(ModalityProcessingConfiguration modalityProcessing) {
            this.modalityProcessing = modalityProcessing;
            return this;
        }

        @Override
        public DocumentOverrideConfiguration build() {
            return new DocumentOverrideConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
