/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for routing file type to desired modality
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModalityRoutingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ModalityRoutingConfiguration.Builder, ModalityRoutingConfiguration> {
    private static final SdkField<String> JPEG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jpeg")
            .getter(getter(ModalityRoutingConfiguration::jpegAsString)).setter(setter(Builder::jpeg))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jpeg").build()).build();

    private static final SdkField<String> PNG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("png")
            .getter(getter(ModalityRoutingConfiguration::pngAsString)).setter(setter(Builder::png))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("png").build()).build();

    private static final SdkField<String> MP4_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("mp4")
            .getter(getter(ModalityRoutingConfiguration::mp4AsString)).setter(setter(Builder::mp4))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mp4").build()).build();

    private static final SdkField<String> MOV_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("mov")
            .getter(getter(ModalityRoutingConfiguration::movAsString)).setter(setter(Builder::mov))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mov").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JPEG_FIELD, PNG_FIELD,
            MP4_FIELD, MOV_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String jpeg;

    private final String png;

    private final String mp4;

    private final String mov;

    private ModalityRoutingConfiguration(BuilderImpl builder) {
        this.jpeg = builder.jpeg;
        this.png = builder.png;
        this.mp4 = builder.mp4;
        this.mov = builder.mov;
    }

    /**
     * Returns the value of the Jpeg property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jpeg} will return
     * {@link DesiredModality#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jpegAsString}.
     * </p>
     * 
     * @return The value of the Jpeg property for this object.
     * @see DesiredModality
     */
    public final DesiredModality jpeg() {
        return DesiredModality.fromValue(jpeg);
    }

    /**
     * Returns the value of the Jpeg property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jpeg} will return
     * {@link DesiredModality#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jpegAsString}.
     * </p>
     * 
     * @return The value of the Jpeg property for this object.
     * @see DesiredModality
     */
    public final String jpegAsString() {
        return jpeg;
    }

    /**
     * Returns the value of the Png property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #png} will return
     * {@link DesiredModality#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pngAsString}.
     * </p>
     * 
     * @return The value of the Png property for this object.
     * @see DesiredModality
     */
    public final DesiredModality png() {
        return DesiredModality.fromValue(png);
    }

    /**
     * Returns the value of the Png property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #png} will return
     * {@link DesiredModality#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pngAsString}.
     * </p>
     * 
     * @return The value of the Png property for this object.
     * @see DesiredModality
     */
    public final String pngAsString() {
        return png;
    }

    /**
     * Returns the value of the Mp4 property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mp4} will return
     * {@link DesiredModality#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mp4AsString}.
     * </p>
     * 
     * @return The value of the Mp4 property for this object.
     * @see DesiredModality
     */
    public final DesiredModality mp4() {
        return DesiredModality.fromValue(mp4);
    }

    /**
     * Returns the value of the Mp4 property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mp4} will return
     * {@link DesiredModality#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mp4AsString}.
     * </p>
     * 
     * @return The value of the Mp4 property for this object.
     * @see DesiredModality
     */
    public final String mp4AsString() {
        return mp4;
    }

    /**
     * Returns the value of the Mov property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mov} will return
     * {@link DesiredModality#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #movAsString}.
     * </p>
     * 
     * @return The value of the Mov property for this object.
     * @see DesiredModality
     */
    public final DesiredModality mov() {
        return DesiredModality.fromValue(mov);
    }

    /**
     * Returns the value of the Mov property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mov} will return
     * {@link DesiredModality#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #movAsString}.
     * </p>
     * 
     * @return The value of the Mov property for this object.
     * @see DesiredModality
     */
    public final String movAsString() {
        return mov;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jpegAsString());
        hashCode = 31 * hashCode + Objects.hashCode(pngAsString());
        hashCode = 31 * hashCode + Objects.hashCode(mp4AsString());
        hashCode = 31 * hashCode + Objects.hashCode(movAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModalityRoutingConfiguration)) {
            return false;
        }
        ModalityRoutingConfiguration other = (ModalityRoutingConfiguration) obj;
        return Objects.equals(jpegAsString(), other.jpegAsString()) && Objects.equals(pngAsString(), other.pngAsString())
                && Objects.equals(mp4AsString(), other.mp4AsString()) && Objects.equals(movAsString(), other.movAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModalityRoutingConfiguration").add("Jpeg", jpegAsString()).add("Png", pngAsString())
                .add("Mp4", mp4AsString()).add("Mov", movAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jpeg":
            return Optional.ofNullable(clazz.cast(jpegAsString()));
        case "png":
            return Optional.ofNullable(clazz.cast(pngAsString()));
        case "mp4":
            return Optional.ofNullable(clazz.cast(mp4AsString()));
        case "mov":
            return Optional.ofNullable(clazz.cast(movAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("jpeg", JPEG_FIELD);
        map.put("png", PNG_FIELD);
        map.put("mp4", MP4_FIELD);
        map.put("mov", MOV_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModalityRoutingConfiguration, T> g) {
        return obj -> g.apply((ModalityRoutingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModalityRoutingConfiguration> {
        /**
         * Sets the value of the Jpeg property for this object.
         *
         * @param jpeg
         *        The new value for the Jpeg property for this object.
         * @see DesiredModality
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DesiredModality
         */
        Builder jpeg(String jpeg);

        /**
         * Sets the value of the Jpeg property for this object.
         *
         * @param jpeg
         *        The new value for the Jpeg property for this object.
         * @see DesiredModality
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DesiredModality
         */
        Builder jpeg(DesiredModality jpeg);

        /**
         * Sets the value of the Png property for this object.
         *
         * @param png
         *        The new value for the Png property for this object.
         * @see DesiredModality
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DesiredModality
         */
        Builder png(String png);

        /**
         * Sets the value of the Png property for this object.
         *
         * @param png
         *        The new value for the Png property for this object.
         * @see DesiredModality
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DesiredModality
         */
        Builder png(DesiredModality png);

        /**
         * Sets the value of the Mp4 property for this object.
         *
         * @param mp4
         *        The new value for the Mp4 property for this object.
         * @see DesiredModality
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DesiredModality
         */
        Builder mp4(String mp4);

        /**
         * Sets the value of the Mp4 property for this object.
         *
         * @param mp4
         *        The new value for the Mp4 property for this object.
         * @see DesiredModality
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DesiredModality
         */
        Builder mp4(DesiredModality mp4);

        /**
         * Sets the value of the Mov property for this object.
         *
         * @param mov
         *        The new value for the Mov property for this object.
         * @see DesiredModality
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DesiredModality
         */
        Builder mov(String mov);

        /**
         * Sets the value of the Mov property for this object.
         *
         * @param mov
         *        The new value for the Mov property for this object.
         * @see DesiredModality
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DesiredModality
         */
        Builder mov(DesiredModality mov);
    }

    static final class BuilderImpl implements Builder {
        private String jpeg;

        private String png;

        private String mp4;

        private String mov;

        private BuilderImpl() {
        }

        private BuilderImpl(ModalityRoutingConfiguration model) {
            jpeg(model.jpeg);
            png(model.png);
            mp4(model.mp4);
            mov(model.mov);
        }

        public final String getJpeg() {
            return jpeg;
        }

        public final void setJpeg(String jpeg) {
            this.jpeg = jpeg;
        }

        @Override
        public final Builder jpeg(String jpeg) {
            this.jpeg = jpeg;
            return this;
        }

        @Override
        public final Builder jpeg(DesiredModality jpeg) {
            this.jpeg(jpeg == null ? null : jpeg.toString());
            return this;
        }

        public final String getPng() {
            return png;
        }

        public final void setPng(String png) {
            this.png = png;
        }

        @Override
        public final Builder png(String png) {
            this.png = png;
            return this;
        }

        @Override
        public final Builder png(DesiredModality png) {
            this.png(png == null ? null : png.toString());
            return this;
        }

        public final String getMp4() {
            return mp4;
        }

        public final void setMp4(String mp4) {
            this.mp4 = mp4;
        }

        @Override
        public final Builder mp4(String mp4) {
            this.mp4 = mp4;
            return this;
        }

        @Override
        public final Builder mp4(DesiredModality mp4) {
            this.mp4(mp4 == null ? null : mp4.toString());
            return this;
        }

        public final String getMov() {
            return mov;
        }

        public final void setMov(String mov) {
            this.mov = mov;
        }

        @Override
        public final Builder mov(String mov) {
            this.mov = mov;
            return this;
        }

        @Override
        public final Builder mov(DesiredModality mov) {
            this.mov(mov == null ? null : mov.toString());
            return this;
        }

        @Override
        public ModalityRoutingConfiguration build() {
            return new ModalityRoutingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
