/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Override configuration
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OverrideConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<OverrideConfiguration.Builder, OverrideConfiguration> {
    private static final SdkField<DocumentOverrideConfiguration> DOCUMENT_FIELD = SdkField
            .<DocumentOverrideConfiguration> builder(MarshallingType.SDK_POJO).memberName("document")
            .getter(getter(OverrideConfiguration::document)).setter(setter(Builder::document))
            .constructor(DocumentOverrideConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("document").build()).build();

    private static final SdkField<ImageOverrideConfiguration> IMAGE_FIELD = SdkField
            .<ImageOverrideConfiguration> builder(MarshallingType.SDK_POJO).memberName("image")
            .getter(getter(OverrideConfiguration::image)).setter(setter(Builder::image))
            .constructor(ImageOverrideConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("image").build()).build();

    private static final SdkField<VideoOverrideConfiguration> VIDEO_FIELD = SdkField
            .<VideoOverrideConfiguration> builder(MarshallingType.SDK_POJO).memberName("video")
            .getter(getter(OverrideConfiguration::video)).setter(setter(Builder::video))
            .constructor(VideoOverrideConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("video").build()).build();

    private static final SdkField<AudioOverrideConfiguration> AUDIO_FIELD = SdkField
            .<AudioOverrideConfiguration> builder(MarshallingType.SDK_POJO).memberName("audio")
            .getter(getter(OverrideConfiguration::audio)).setter(setter(Builder::audio))
            .constructor(AudioOverrideConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audio").build()).build();

    private static final SdkField<ModalityRoutingConfiguration> MODALITY_ROUTING_FIELD = SdkField
            .<ModalityRoutingConfiguration> builder(MarshallingType.SDK_POJO).memberName("modalityRouting")
            .getter(getter(OverrideConfiguration::modalityRouting)).setter(setter(Builder::modalityRouting))
            .constructor(ModalityRoutingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modalityRouting").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_FIELD, IMAGE_FIELD,
            VIDEO_FIELD, AUDIO_FIELD, MODALITY_ROUTING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DocumentOverrideConfiguration document;

    private final ImageOverrideConfiguration image;

    private final VideoOverrideConfiguration video;

    private final AudioOverrideConfiguration audio;

    private final ModalityRoutingConfiguration modalityRouting;

    private OverrideConfiguration(BuilderImpl builder) {
        this.document = builder.document;
        this.image = builder.image;
        this.video = builder.video;
        this.audio = builder.audio;
        this.modalityRouting = builder.modalityRouting;
    }

    /**
     * Returns the value of the Document property for this object.
     * 
     * @return The value of the Document property for this object.
     */
    public final DocumentOverrideConfiguration document() {
        return document;
    }

    /**
     * Returns the value of the Image property for this object.
     * 
     * @return The value of the Image property for this object.
     */
    public final ImageOverrideConfiguration image() {
        return image;
    }

    /**
     * Returns the value of the Video property for this object.
     * 
     * @return The value of the Video property for this object.
     */
    public final VideoOverrideConfiguration video() {
        return video;
    }

    /**
     * Returns the value of the Audio property for this object.
     * 
     * @return The value of the Audio property for this object.
     */
    public final AudioOverrideConfiguration audio() {
        return audio;
    }

    /**
     * Returns the value of the ModalityRouting property for this object.
     * 
     * @return The value of the ModalityRouting property for this object.
     */
    public final ModalityRoutingConfiguration modalityRouting() {
        return modalityRouting;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(document());
        hashCode = 31 * hashCode + Objects.hashCode(image());
        hashCode = 31 * hashCode + Objects.hashCode(video());
        hashCode = 31 * hashCode + Objects.hashCode(audio());
        hashCode = 31 * hashCode + Objects.hashCode(modalityRouting());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OverrideConfiguration)) {
            return false;
        }
        OverrideConfiguration other = (OverrideConfiguration) obj;
        return Objects.equals(document(), other.document()) && Objects.equals(image(), other.image())
                && Objects.equals(video(), other.video()) && Objects.equals(audio(), other.audio())
                && Objects.equals(modalityRouting(), other.modalityRouting());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OverrideConfiguration").add("Document", document()).add("Image", image()).add("Video", video())
                .add("Audio", audio()).add("ModalityRouting", modalityRouting()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "document":
            return Optional.ofNullable(clazz.cast(document()));
        case "image":
            return Optional.ofNullable(clazz.cast(image()));
        case "video":
            return Optional.ofNullable(clazz.cast(video()));
        case "audio":
            return Optional.ofNullable(clazz.cast(audio()));
        case "modalityRouting":
            return Optional.ofNullable(clazz.cast(modalityRouting()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("document", DOCUMENT_FIELD);
        map.put("image", IMAGE_FIELD);
        map.put("video", VIDEO_FIELD);
        map.put("audio", AUDIO_FIELD);
        map.put("modalityRouting", MODALITY_ROUTING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OverrideConfiguration, T> g) {
        return obj -> g.apply((OverrideConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OverrideConfiguration> {
        /**
         * Sets the value of the Document property for this object.
         *
         * @param document
         *        The new value for the Document property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder document(DocumentOverrideConfiguration document);

        /**
         * Sets the value of the Document property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DocumentOverrideConfiguration.Builder}
         * avoiding the need to create one manually via {@link DocumentOverrideConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentOverrideConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #document(DocumentOverrideConfiguration)}.
         * 
         * @param document
         *        a consumer that will call methods on {@link DocumentOverrideConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #document(DocumentOverrideConfiguration)
         */
        default Builder document(Consumer<DocumentOverrideConfiguration.Builder> document) {
            return document(DocumentOverrideConfiguration.builder().applyMutation(document).build());
        }

        /**
         * Sets the value of the Image property for this object.
         *
         * @param image
         *        The new value for the Image property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder image(ImageOverrideConfiguration image);

        /**
         * Sets the value of the Image property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ImageOverrideConfiguration.Builder}
         * avoiding the need to create one manually via {@link ImageOverrideConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImageOverrideConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #image(ImageOverrideConfiguration)}.
         * 
         * @param image
         *        a consumer that will call methods on {@link ImageOverrideConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #image(ImageOverrideConfiguration)
         */
        default Builder image(Consumer<ImageOverrideConfiguration.Builder> image) {
            return image(ImageOverrideConfiguration.builder().applyMutation(image).build());
        }

        /**
         * Sets the value of the Video property for this object.
         *
         * @param video
         *        The new value for the Video property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder video(VideoOverrideConfiguration video);

        /**
         * Sets the value of the Video property for this object.
         *
         * This is a convenience method that creates an instance of the {@link VideoOverrideConfiguration.Builder}
         * avoiding the need to create one manually via {@link VideoOverrideConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VideoOverrideConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #video(VideoOverrideConfiguration)}.
         * 
         * @param video
         *        a consumer that will call methods on {@link VideoOverrideConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #video(VideoOverrideConfiguration)
         */
        default Builder video(Consumer<VideoOverrideConfiguration.Builder> video) {
            return video(VideoOverrideConfiguration.builder().applyMutation(video).build());
        }

        /**
         * Sets the value of the Audio property for this object.
         *
         * @param audio
         *        The new value for the Audio property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audio(AudioOverrideConfiguration audio);

        /**
         * Sets the value of the Audio property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AudioOverrideConfiguration.Builder}
         * avoiding the need to create one manually via {@link AudioOverrideConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AudioOverrideConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #audio(AudioOverrideConfiguration)}.
         * 
         * @param audio
         *        a consumer that will call methods on {@link AudioOverrideConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #audio(AudioOverrideConfiguration)
         */
        default Builder audio(Consumer<AudioOverrideConfiguration.Builder> audio) {
            return audio(AudioOverrideConfiguration.builder().applyMutation(audio).build());
        }

        /**
         * Sets the value of the ModalityRouting property for this object.
         *
         * @param modalityRouting
         *        The new value for the ModalityRouting property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modalityRouting(ModalityRoutingConfiguration modalityRouting);

        /**
         * Sets the value of the ModalityRouting property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ModalityRoutingConfiguration.Builder}
         * avoiding the need to create one manually via {@link ModalityRoutingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModalityRoutingConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #modalityRouting(ModalityRoutingConfiguration)}.
         * 
         * @param modalityRouting
         *        a consumer that will call methods on {@link ModalityRoutingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modalityRouting(ModalityRoutingConfiguration)
         */
        default Builder modalityRouting(Consumer<ModalityRoutingConfiguration.Builder> modalityRouting) {
            return modalityRouting(ModalityRoutingConfiguration.builder().applyMutation(modalityRouting).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DocumentOverrideConfiguration document;

        private ImageOverrideConfiguration image;

        private VideoOverrideConfiguration video;

        private AudioOverrideConfiguration audio;

        private ModalityRoutingConfiguration modalityRouting;

        private BuilderImpl() {
        }

        private BuilderImpl(OverrideConfiguration model) {
            document(model.document);
            image(model.image);
            video(model.video);
            audio(model.audio);
            modalityRouting(model.modalityRouting);
        }

        public final DocumentOverrideConfiguration.Builder getDocument() {
            return document != null ? document.toBuilder() : null;
        }

        public final void setDocument(DocumentOverrideConfiguration.BuilderImpl document) {
            this.document = document != null ? document.build() : null;
        }

        @Override
        public final Builder document(DocumentOverrideConfiguration document) {
            this.document = document;
            return this;
        }

        public final ImageOverrideConfiguration.Builder getImage() {
            return image != null ? image.toBuilder() : null;
        }

        public final void setImage(ImageOverrideConfiguration.BuilderImpl image) {
            this.image = image != null ? image.build() : null;
        }

        @Override
        public final Builder image(ImageOverrideConfiguration image) {
            this.image = image;
            return this;
        }

        public final VideoOverrideConfiguration.Builder getVideo() {
            return video != null ? video.toBuilder() : null;
        }

        public final void setVideo(VideoOverrideConfiguration.BuilderImpl video) {
            this.video = video != null ? video.build() : null;
        }

        @Override
        public final Builder video(VideoOverrideConfiguration video) {
            this.video = video;
            return this;
        }

        public final AudioOverrideConfiguration.Builder getAudio() {
            return audio != null ? audio.toBuilder() : null;
        }

        public final void setAudio(AudioOverrideConfiguration.BuilderImpl audio) {
            this.audio = audio != null ? audio.build() : null;
        }

        @Override
        public final Builder audio(AudioOverrideConfiguration audio) {
            this.audio = audio;
            return this;
        }

        public final ModalityRoutingConfiguration.Builder getModalityRouting() {
            return modalityRouting != null ? modalityRouting.toBuilder() : null;
        }

        public final void setModalityRouting(ModalityRoutingConfiguration.BuilderImpl modalityRouting) {
            this.modalityRouting = modalityRouting != null ? modalityRouting.build() : null;
        }

        @Override
        public final Builder modalityRouting(ModalityRoutingConfiguration modalityRouting) {
            this.modalityRouting = modalityRouting;
            return this;
        }

        @Override
        public OverrideConfiguration build() {
            return new OverrideConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
