/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for transcript related features
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TranscriptConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<TranscriptConfiguration.Builder, TranscriptConfiguration> {
    private static final SdkField<SpeakerLabelingConfiguration> SPEAKER_LABELING_FIELD = SdkField
            .<SpeakerLabelingConfiguration> builder(MarshallingType.SDK_POJO).memberName("speakerLabeling")
            .getter(getter(TranscriptConfiguration::speakerLabeling)).setter(setter(Builder::speakerLabeling))
            .constructor(SpeakerLabelingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("speakerLabeling").build()).build();

    private static final SdkField<ChannelLabelingConfiguration> CHANNEL_LABELING_FIELD = SdkField
            .<ChannelLabelingConfiguration> builder(MarshallingType.SDK_POJO).memberName("channelLabeling")
            .getter(getter(TranscriptConfiguration::channelLabeling)).setter(setter(Builder::channelLabeling))
            .constructor(ChannelLabelingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelLabeling").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPEAKER_LABELING_FIELD,
            CHANNEL_LABELING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SpeakerLabelingConfiguration speakerLabeling;

    private final ChannelLabelingConfiguration channelLabeling;

    private TranscriptConfiguration(BuilderImpl builder) {
        this.speakerLabeling = builder.speakerLabeling;
        this.channelLabeling = builder.channelLabeling;
    }

    /**
     * Returns the value of the SpeakerLabeling property for this object.
     * 
     * @return The value of the SpeakerLabeling property for this object.
     */
    public final SpeakerLabelingConfiguration speakerLabeling() {
        return speakerLabeling;
    }

    /**
     * Returns the value of the ChannelLabeling property for this object.
     * 
     * @return The value of the ChannelLabeling property for this object.
     */
    public final ChannelLabelingConfiguration channelLabeling() {
        return channelLabeling;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(speakerLabeling());
        hashCode = 31 * hashCode + Objects.hashCode(channelLabeling());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TranscriptConfiguration)) {
            return false;
        }
        TranscriptConfiguration other = (TranscriptConfiguration) obj;
        return Objects.equals(speakerLabeling(), other.speakerLabeling())
                && Objects.equals(channelLabeling(), other.channelLabeling());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TranscriptConfiguration").add("SpeakerLabeling", speakerLabeling())
                .add("ChannelLabeling", channelLabeling()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "speakerLabeling":
            return Optional.ofNullable(clazz.cast(speakerLabeling()));
        case "channelLabeling":
            return Optional.ofNullable(clazz.cast(channelLabeling()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("speakerLabeling", SPEAKER_LABELING_FIELD);
        map.put("channelLabeling", CHANNEL_LABELING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TranscriptConfiguration, T> g) {
        return obj -> g.apply((TranscriptConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TranscriptConfiguration> {
        /**
         * Sets the value of the SpeakerLabeling property for this object.
         *
         * @param speakerLabeling
         *        The new value for the SpeakerLabeling property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder speakerLabeling(SpeakerLabelingConfiguration speakerLabeling);

        /**
         * Sets the value of the SpeakerLabeling property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SpeakerLabelingConfiguration.Builder}
         * avoiding the need to create one manually via {@link SpeakerLabelingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SpeakerLabelingConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #speakerLabeling(SpeakerLabelingConfiguration)}.
         * 
         * @param speakerLabeling
         *        a consumer that will call methods on {@link SpeakerLabelingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #speakerLabeling(SpeakerLabelingConfiguration)
         */
        default Builder speakerLabeling(Consumer<SpeakerLabelingConfiguration.Builder> speakerLabeling) {
            return speakerLabeling(SpeakerLabelingConfiguration.builder().applyMutation(speakerLabeling).build());
        }

        /**
         * Sets the value of the ChannelLabeling property for this object.
         *
         * @param channelLabeling
         *        The new value for the ChannelLabeling property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelLabeling(ChannelLabelingConfiguration channelLabeling);

        /**
         * Sets the value of the ChannelLabeling property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ChannelLabelingConfiguration.Builder}
         * avoiding the need to create one manually via {@link ChannelLabelingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChannelLabelingConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #channelLabeling(ChannelLabelingConfiguration)}.
         * 
         * @param channelLabeling
         *        a consumer that will call methods on {@link ChannelLabelingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #channelLabeling(ChannelLabelingConfiguration)
         */
        default Builder channelLabeling(Consumer<ChannelLabelingConfiguration.Builder> channelLabeling) {
            return channelLabeling(ChannelLabelingConfiguration.builder().applyMutation(channelLabeling).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SpeakerLabelingConfiguration speakerLabeling;

        private ChannelLabelingConfiguration channelLabeling;

        private BuilderImpl() {
        }

        private BuilderImpl(TranscriptConfiguration model) {
            speakerLabeling(model.speakerLabeling);
            channelLabeling(model.channelLabeling);
        }

        public final SpeakerLabelingConfiguration.Builder getSpeakerLabeling() {
            return speakerLabeling != null ? speakerLabeling.toBuilder() : null;
        }

        public final void setSpeakerLabeling(SpeakerLabelingConfiguration.BuilderImpl speakerLabeling) {
            this.speakerLabeling = speakerLabeling != null ? speakerLabeling.build() : null;
        }

        @Override
        public final Builder speakerLabeling(SpeakerLabelingConfiguration speakerLabeling) {
            this.speakerLabeling = speakerLabeling;
            return this;
        }

        public final ChannelLabelingConfiguration.Builder getChannelLabeling() {
            return channelLabeling != null ? channelLabeling.toBuilder() : null;
        }

        public final void setChannelLabeling(ChannelLabelingConfiguration.BuilderImpl channelLabeling) {
            this.channelLabeling = channelLabeling != null ? channelLabeling.build() : null;
        }

        @Override
        public final Builder channelLabeling(ChannelLabelingConfiguration channelLabeling) {
            this.channelLabeling = channelLabeling;
            return this;
        }

        @Override
        public TranscriptConfiguration build() {
            return new TranscriptConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
