/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Update DataAutomationProject Request
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDataAutomationProjectRequest extends BedrockDataAutomationRequest implements
        ToCopyableBuilder<UpdateDataAutomationProjectRequest.Builder, UpdateDataAutomationProjectRequest> {
    private static final SdkField<String> PROJECT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectArn").getter(getter(UpdateDataAutomationProjectRequest::projectArn))
            .setter(setter(Builder::projectArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("projectArn").build()).build();

    private static final SdkField<String> PROJECT_STAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectStage").getter(getter(UpdateDataAutomationProjectRequest::projectStageAsString))
            .setter(setter(Builder::projectStage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectStage").build()).build();

    private static final SdkField<String> PROJECT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectDescription").getter(getter(UpdateDataAutomationProjectRequest::projectDescription))
            .setter(setter(Builder::projectDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectDescription").build())
            .build();

    private static final SdkField<StandardOutputConfiguration> STANDARD_OUTPUT_CONFIGURATION_FIELD = SdkField
            .<StandardOutputConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("standardOutputConfiguration")
            .getter(getter(UpdateDataAutomationProjectRequest::standardOutputConfiguration))
            .setter(setter(Builder::standardOutputConfiguration))
            .constructor(StandardOutputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("standardOutputConfiguration")
                    .build()).build();

    private static final SdkField<CustomOutputConfiguration> CUSTOM_OUTPUT_CONFIGURATION_FIELD = SdkField
            .<CustomOutputConfiguration> builder(MarshallingType.SDK_POJO).memberName("customOutputConfiguration")
            .getter(getter(UpdateDataAutomationProjectRequest::customOutputConfiguration))
            .setter(setter(Builder::customOutputConfiguration)).constructor(CustomOutputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customOutputConfiguration").build())
            .build();

    private static final SdkField<OverrideConfiguration> OVERRIDE_CONFIGURATION_FIELD = SdkField
            .<OverrideConfiguration> builder(MarshallingType.SDK_POJO).memberName("overrideConfiguration")
            .getter(getter(UpdateDataAutomationProjectRequest::overrideConfigurationValue))
            .setter(setter(Builder::overrideConfigurationValue)).constructor(OverrideConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrideConfiguration").build())
            .build();

    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField
            .<EncryptionConfiguration> builder(MarshallingType.SDK_POJO).memberName("encryptionConfiguration")
            .getter(getter(UpdateDataAutomationProjectRequest::encryptionConfiguration))
            .setter(setter(Builder::encryptionConfiguration)).constructor(EncryptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_ARN_FIELD,
            PROJECT_STAGE_FIELD, PROJECT_DESCRIPTION_FIELD, STANDARD_OUTPUT_CONFIGURATION_FIELD,
            CUSTOM_OUTPUT_CONFIGURATION_FIELD, OVERRIDE_CONFIGURATION_FIELD, ENCRYPTION_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String projectArn;

    private final String projectStage;

    private final String projectDescription;

    private final StandardOutputConfiguration standardOutputConfiguration;

    private final CustomOutputConfiguration customOutputConfiguration;

    private final OverrideConfiguration overrideConfigurationValue;

    private final EncryptionConfiguration encryptionConfiguration;

    private UpdateDataAutomationProjectRequest(BuilderImpl builder) {
        super(builder);
        this.projectArn = builder.projectArn;
        this.projectStage = builder.projectStage;
        this.projectDescription = builder.projectDescription;
        this.standardOutputConfiguration = builder.standardOutputConfiguration;
        this.customOutputConfiguration = builder.customOutputConfiguration;
        this.overrideConfigurationValue = builder.overrideConfigurationValue;
        this.encryptionConfiguration = builder.encryptionConfiguration;
    }

    /**
     * <p>
     * ARN generated at the server side when a DataAutomationProject is created
     * </p>
     * 
     * @return ARN generated at the server side when a DataAutomationProject is created
     */
    public final String projectArn() {
        return projectArn;
    }

    /**
     * Returns the value of the ProjectStage property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #projectStage} will
     * return {@link DataAutomationProjectStage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #projectStageAsString}.
     * </p>
     * 
     * @return The value of the ProjectStage property for this object.
     * @see DataAutomationProjectStage
     */
    public final DataAutomationProjectStage projectStage() {
        return DataAutomationProjectStage.fromValue(projectStage);
    }

    /**
     * Returns the value of the ProjectStage property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #projectStage} will
     * return {@link DataAutomationProjectStage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #projectStageAsString}.
     * </p>
     * 
     * @return The value of the ProjectStage property for this object.
     * @see DataAutomationProjectStage
     */
    public final String projectStageAsString() {
        return projectStage;
    }

    /**
     * Returns the value of the ProjectDescription property for this object.
     * 
     * @return The value of the ProjectDescription property for this object.
     */
    public final String projectDescription() {
        return projectDescription;
    }

    /**
     * Returns the value of the StandardOutputConfiguration property for this object.
     * 
     * @return The value of the StandardOutputConfiguration property for this object.
     */
    public final StandardOutputConfiguration standardOutputConfiguration() {
        return standardOutputConfiguration;
    }

    /**
     * Returns the value of the CustomOutputConfiguration property for this object.
     * 
     * @return The value of the CustomOutputConfiguration property for this object.
     */
    public final CustomOutputConfiguration customOutputConfiguration() {
        return customOutputConfiguration;
    }

    /**
     * Returns the value of the OverrideConfiguration property for this object.
     * 
     * @return The value of the OverrideConfiguration property for this object.
     */
    public final OverrideConfiguration overrideConfigurationValue() {
        return overrideConfigurationValue;
    }

    /**
     * Returns the value of the EncryptionConfiguration property for this object.
     * 
     * @return The value of the EncryptionConfiguration property for this object.
     */
    public final EncryptionConfiguration encryptionConfiguration() {
        return encryptionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(projectArn());
        hashCode = 31 * hashCode + Objects.hashCode(projectStageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(projectDescription());
        hashCode = 31 * hashCode + Objects.hashCode(standardOutputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(customOutputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(overrideConfigurationValue());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDataAutomationProjectRequest)) {
            return false;
        }
        UpdateDataAutomationProjectRequest other = (UpdateDataAutomationProjectRequest) obj;
        return Objects.equals(projectArn(), other.projectArn())
                && Objects.equals(projectStageAsString(), other.projectStageAsString())
                && Objects.equals(projectDescription(), other.projectDescription())
                && Objects.equals(standardOutputConfiguration(), other.standardOutputConfiguration())
                && Objects.equals(customOutputConfiguration(), other.customOutputConfiguration())
                && Objects.equals(overrideConfigurationValue(), other.overrideConfigurationValue())
                && Objects.equals(encryptionConfiguration(), other.encryptionConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDataAutomationProjectRequest").add("ProjectArn", projectArn())
                .add("ProjectStage", projectStageAsString())
                .add("ProjectDescription", projectDescription() == null ? null : "*** Sensitive Data Redacted ***")
                .add("StandardOutputConfiguration", standardOutputConfiguration())
                .add("CustomOutputConfiguration", customOutputConfiguration())
                .add("OverrideConfiguration", overrideConfigurationValue())
                .add("EncryptionConfiguration", encryptionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "projectArn":
            return Optional.ofNullable(clazz.cast(projectArn()));
        case "projectStage":
            return Optional.ofNullable(clazz.cast(projectStageAsString()));
        case "projectDescription":
            return Optional.ofNullable(clazz.cast(projectDescription()));
        case "standardOutputConfiguration":
            return Optional.ofNullable(clazz.cast(standardOutputConfiguration()));
        case "customOutputConfiguration":
            return Optional.ofNullable(clazz.cast(customOutputConfiguration()));
        case "overrideConfiguration":
            return Optional.ofNullable(clazz.cast(overrideConfigurationValue()));
        case "encryptionConfiguration":
            return Optional.ofNullable(clazz.cast(encryptionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("projectArn", PROJECT_ARN_FIELD);
        map.put("projectStage", PROJECT_STAGE_FIELD);
        map.put("projectDescription", PROJECT_DESCRIPTION_FIELD);
        map.put("standardOutputConfiguration", STANDARD_OUTPUT_CONFIGURATION_FIELD);
        map.put("customOutputConfiguration", CUSTOM_OUTPUT_CONFIGURATION_FIELD);
        map.put("overrideConfiguration", OVERRIDE_CONFIGURATION_FIELD);
        map.put("encryptionConfiguration", ENCRYPTION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDataAutomationProjectRequest, T> g) {
        return obj -> g.apply((UpdateDataAutomationProjectRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockDataAutomationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateDataAutomationProjectRequest> {
        /**
         * <p>
         * ARN generated at the server side when a DataAutomationProject is created
         * </p>
         * 
         * @param projectArn
         *        ARN generated at the server side when a DataAutomationProject is created
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectArn(String projectArn);

        /**
         * Sets the value of the ProjectStage property for this object.
         *
         * @param projectStage
         *        The new value for the ProjectStage property for this object.
         * @see DataAutomationProjectStage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataAutomationProjectStage
         */
        Builder projectStage(String projectStage);

        /**
         * Sets the value of the ProjectStage property for this object.
         *
         * @param projectStage
         *        The new value for the ProjectStage property for this object.
         * @see DataAutomationProjectStage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataAutomationProjectStage
         */
        Builder projectStage(DataAutomationProjectStage projectStage);

        /**
         * Sets the value of the ProjectDescription property for this object.
         *
         * @param projectDescription
         *        The new value for the ProjectDescription property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectDescription(String projectDescription);

        /**
         * Sets the value of the StandardOutputConfiguration property for this object.
         *
         * @param standardOutputConfiguration
         *        The new value for the StandardOutputConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardOutputConfiguration(StandardOutputConfiguration standardOutputConfiguration);

        /**
         * Sets the value of the StandardOutputConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link StandardOutputConfiguration.Builder}
         * avoiding the need to create one manually via {@link StandardOutputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StandardOutputConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #standardOutputConfiguration(StandardOutputConfiguration)}.
         * 
         * @param standardOutputConfiguration
         *        a consumer that will call methods on {@link StandardOutputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #standardOutputConfiguration(StandardOutputConfiguration)
         */
        default Builder standardOutputConfiguration(Consumer<StandardOutputConfiguration.Builder> standardOutputConfiguration) {
            return standardOutputConfiguration(StandardOutputConfiguration.builder().applyMutation(standardOutputConfiguration)
                    .build());
        }

        /**
         * Sets the value of the CustomOutputConfiguration property for this object.
         *
         * @param customOutputConfiguration
         *        The new value for the CustomOutputConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customOutputConfiguration(CustomOutputConfiguration customOutputConfiguration);

        /**
         * Sets the value of the CustomOutputConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CustomOutputConfiguration.Builder}
         * avoiding the need to create one manually via {@link CustomOutputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomOutputConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #customOutputConfiguration(CustomOutputConfiguration)}.
         * 
         * @param customOutputConfiguration
         *        a consumer that will call methods on {@link CustomOutputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customOutputConfiguration(CustomOutputConfiguration)
         */
        default Builder customOutputConfiguration(Consumer<CustomOutputConfiguration.Builder> customOutputConfiguration) {
            return customOutputConfiguration(CustomOutputConfiguration.builder().applyMutation(customOutputConfiguration).build());
        }

        /**
         * Sets the value of the OverrideConfiguration property for this object.
         *
         * @param overrideConfigurationValue
         *        The new value for the OverrideConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrideConfigurationValue(OverrideConfiguration overrideConfigurationValue);

        /**
         * Sets the value of the OverrideConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link OverrideConfiguration.Builder} avoiding
         * the need to create one manually via {@link OverrideConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OverrideConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #overrideConfigurationValue(OverrideConfiguration)}.
         * 
         * @param overrideConfigurationValue
         *        a consumer that will call methods on {@link OverrideConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #overrideConfigurationValue(OverrideConfiguration)
         */
        default Builder overrideConfigurationValue(Consumer<OverrideConfiguration.Builder> overrideConfigurationValue) {
            return overrideConfigurationValue(OverrideConfiguration.builder().applyMutation(overrideConfigurationValue).build());
        }

        /**
         * Sets the value of the EncryptionConfiguration property for this object.
         *
         * @param encryptionConfiguration
         *        The new value for the EncryptionConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration);

        /**
         * Sets the value of the EncryptionConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link EncryptionConfiguration.Builder} avoiding
         * the need to create one manually via {@link EncryptionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncryptionConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #encryptionConfiguration(EncryptionConfiguration)}.
         * 
         * @param encryptionConfiguration
         *        a consumer that will call methods on {@link EncryptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionConfiguration(EncryptionConfiguration)
         */
        default Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return encryptionConfiguration(EncryptionConfiguration.builder().applyMutation(encryptionConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockDataAutomationRequest.BuilderImpl implements Builder {
        private String projectArn;

        private String projectStage;

        private String projectDescription;

        private StandardOutputConfiguration standardOutputConfiguration;

        private CustomOutputConfiguration customOutputConfiguration;

        private OverrideConfiguration overrideConfigurationValue;

        private EncryptionConfiguration encryptionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDataAutomationProjectRequest model) {
            super(model);
            projectArn(model.projectArn);
            projectStage(model.projectStage);
            projectDescription(model.projectDescription);
            standardOutputConfiguration(model.standardOutputConfiguration);
            customOutputConfiguration(model.customOutputConfiguration);
            overrideConfigurationValue(model.overrideConfigurationValue);
            encryptionConfiguration(model.encryptionConfiguration);
        }

        public final String getProjectArn() {
            return projectArn;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        @Override
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        public final String getProjectStage() {
            return projectStage;
        }

        public final void setProjectStage(String projectStage) {
            this.projectStage = projectStage;
        }

        @Override
        public final Builder projectStage(String projectStage) {
            this.projectStage = projectStage;
            return this;
        }

        @Override
        public final Builder projectStage(DataAutomationProjectStage projectStage) {
            this.projectStage(projectStage == null ? null : projectStage.toString());
            return this;
        }

        public final String getProjectDescription() {
            return projectDescription;
        }

        public final void setProjectDescription(String projectDescription) {
            this.projectDescription = projectDescription;
        }

        @Override
        public final Builder projectDescription(String projectDescription) {
            this.projectDescription = projectDescription;
            return this;
        }

        public final StandardOutputConfiguration.Builder getStandardOutputConfiguration() {
            return standardOutputConfiguration != null ? standardOutputConfiguration.toBuilder() : null;
        }

        public final void setStandardOutputConfiguration(StandardOutputConfiguration.BuilderImpl standardOutputConfiguration) {
            this.standardOutputConfiguration = standardOutputConfiguration != null ? standardOutputConfiguration.build() : null;
        }

        @Override
        public final Builder standardOutputConfiguration(StandardOutputConfiguration standardOutputConfiguration) {
            this.standardOutputConfiguration = standardOutputConfiguration;
            return this;
        }

        public final CustomOutputConfiguration.Builder getCustomOutputConfiguration() {
            return customOutputConfiguration != null ? customOutputConfiguration.toBuilder() : null;
        }

        public final void setCustomOutputConfiguration(CustomOutputConfiguration.BuilderImpl customOutputConfiguration) {
            this.customOutputConfiguration = customOutputConfiguration != null ? customOutputConfiguration.build() : null;
        }

        @Override
        public final Builder customOutputConfiguration(CustomOutputConfiguration customOutputConfiguration) {
            this.customOutputConfiguration = customOutputConfiguration;
            return this;
        }

        public final OverrideConfiguration.Builder getOverrideConfigurationValue() {
            return overrideConfigurationValue != null ? overrideConfigurationValue.toBuilder() : null;
        }

        public final void setOverrideConfigurationValue(OverrideConfiguration.BuilderImpl overrideConfigurationValue) {
            this.overrideConfigurationValue = overrideConfigurationValue != null ? overrideConfigurationValue.build() : null;
        }

        @Override
        public final Builder overrideConfigurationValue(OverrideConfiguration overrideConfigurationValue) {
            this.overrideConfigurationValue = overrideConfigurationValue;
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return encryptionConfiguration != null ? encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDataAutomationProjectRequest build() {
            return new UpdateDataAutomationProjectRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
