/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Standard Generative Field Configuration of Video
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VideoStandardGenerativeField implements SdkPojo, Serializable,
        ToCopyableBuilder<VideoStandardGenerativeField.Builder, VideoStandardGenerativeField> {
    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(VideoStandardGenerativeField::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<List<String>> TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("types")
            .getter(getter(VideoStandardGenerativeField::typesAsStrings))
            .setter(setter(Builder::typesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("types").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD, TYPES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String state;

    private final List<String> types;

    private VideoStandardGenerativeField(BuilderImpl builder) {
        this.state = builder.state;
        this.types = builder.types;
    }

    /**
     * Returns the value of the State property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link State#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The value of the State property for this object.
     * @see State
     */
    public final State state() {
        return State.fromValue(state);
    }

    /**
     * Returns the value of the State property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link State#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The value of the State property for this object.
     * @see State
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * Returns the value of the Types property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTypes} method.
     * </p>
     * 
     * @return The value of the Types property for this object.
     */
    public final List<VideoStandardGenerativeFieldType> types() {
        return VideoStandardGenerativeFieldTypesCopier.copyStringToEnum(types);
    }

    /**
     * For responses, this returns true if the service returned a value for the Types property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTypes() {
        return types != null && !(types instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Types property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTypes} method.
     * </p>
     * 
     * @return The value of the Types property for this object.
     */
    public final List<String> typesAsStrings() {
        return types;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTypes() ? typesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoStandardGenerativeField)) {
            return false;
        }
        VideoStandardGenerativeField other = (VideoStandardGenerativeField) obj;
        return Objects.equals(stateAsString(), other.stateAsString()) && hasTypes() == other.hasTypes()
                && Objects.equals(typesAsStrings(), other.typesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VideoStandardGenerativeField").add("State", stateAsString())
                .add("Types", hasTypes() ? typesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "types":
            return Optional.ofNullable(clazz.cast(typesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("state", STATE_FIELD);
        map.put("types", TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VideoStandardGenerativeField, T> g) {
        return obj -> g.apply((VideoStandardGenerativeField) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VideoStandardGenerativeField> {
        /**
         * Sets the value of the State property for this object.
         *
         * @param state
         *        The new value for the State property for this object.
         * @see State
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see State
         */
        Builder state(String state);

        /**
         * Sets the value of the State property for this object.
         *
         * @param state
         *        The new value for the State property for this object.
         * @see State
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see State
         */
        Builder state(State state);

        /**
         * Sets the value of the Types property for this object.
         *
         * @param types
         *        The new value for the Types property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typesWithStrings(Collection<String> types);

        /**
         * Sets the value of the Types property for this object.
         *
         * @param types
         *        The new value for the Types property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typesWithStrings(String... types);

        /**
         * Sets the value of the Types property for this object.
         *
         * @param types
         *        The new value for the Types property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder types(Collection<VideoStandardGenerativeFieldType> types);

        /**
         * Sets the value of the Types property for this object.
         *
         * @param types
         *        The new value for the Types property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder types(VideoStandardGenerativeFieldType... types);
    }

    static final class BuilderImpl implements Builder {
        private String state;

        private List<String> types = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VideoStandardGenerativeField model) {
            state(model.state);
            typesWithStrings(model.types);
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(State state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Collection<String> getTypes() {
            if (types instanceof SdkAutoConstructList) {
                return null;
            }
            return types;
        }

        public final void setTypes(Collection<String> types) {
            this.types = VideoStandardGenerativeFieldTypesCopier.copy(types);
        }

        @Override
        public final Builder typesWithStrings(Collection<String> types) {
            this.types = VideoStandardGenerativeFieldTypesCopier.copy(types);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder typesWithStrings(String... types) {
            typesWithStrings(Arrays.asList(types));
            return this;
        }

        @Override
        public final Builder types(Collection<VideoStandardGenerativeFieldType> types) {
            this.types = VideoStandardGenerativeFieldTypesCopier.copyEnumToString(types);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder types(VideoStandardGenerativeFieldType... types) {
            types(Arrays.asList(types));
            return this;
        }

        @Override
        public VideoStandardGenerativeField build() {
            return new VideoStandardGenerativeField(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
