/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Standard Output Configuration of Video
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VideoStandardOutputConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<VideoStandardOutputConfiguration.Builder, VideoStandardOutputConfiguration> {
    private static final SdkField<VideoStandardExtraction> EXTRACTION_FIELD = SdkField
            .<VideoStandardExtraction> builder(MarshallingType.SDK_POJO).memberName("extraction")
            .getter(getter(VideoStandardOutputConfiguration::extraction)).setter(setter(Builder::extraction))
            .constructor(VideoStandardExtraction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("extraction").build()).build();

    private static final SdkField<VideoStandardGenerativeField> GENERATIVE_FIELD_FIELD = SdkField
            .<VideoStandardGenerativeField> builder(MarshallingType.SDK_POJO).memberName("generativeField")
            .getter(getter(VideoStandardOutputConfiguration::generativeField)).setter(setter(Builder::generativeField))
            .constructor(VideoStandardGenerativeField::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generativeField").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXTRACTION_FIELD,
            GENERATIVE_FIELD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final VideoStandardExtraction extraction;

    private final VideoStandardGenerativeField generativeField;

    private VideoStandardOutputConfiguration(BuilderImpl builder) {
        this.extraction = builder.extraction;
        this.generativeField = builder.generativeField;
    }

    /**
     * Returns the value of the Extraction property for this object.
     * 
     * @return The value of the Extraction property for this object.
     */
    public final VideoStandardExtraction extraction() {
        return extraction;
    }

    /**
     * Returns the value of the GenerativeField property for this object.
     * 
     * @return The value of the GenerativeField property for this object.
     */
    public final VideoStandardGenerativeField generativeField() {
        return generativeField;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(extraction());
        hashCode = 31 * hashCode + Objects.hashCode(generativeField());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoStandardOutputConfiguration)) {
            return false;
        }
        VideoStandardOutputConfiguration other = (VideoStandardOutputConfiguration) obj;
        return Objects.equals(extraction(), other.extraction()) && Objects.equals(generativeField(), other.generativeField());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VideoStandardOutputConfiguration").add("Extraction", extraction())
                .add("GenerativeField", generativeField()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "extraction":
            return Optional.ofNullable(clazz.cast(extraction()));
        case "generativeField":
            return Optional.ofNullable(clazz.cast(generativeField()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("extraction", EXTRACTION_FIELD);
        map.put("generativeField", GENERATIVE_FIELD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VideoStandardOutputConfiguration, T> g) {
        return obj -> g.apply((VideoStandardOutputConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VideoStandardOutputConfiguration> {
        /**
         * Sets the value of the Extraction property for this object.
         *
         * @param extraction
         *        The new value for the Extraction property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extraction(VideoStandardExtraction extraction);

        /**
         * Sets the value of the Extraction property for this object.
         *
         * This is a convenience method that creates an instance of the {@link VideoStandardExtraction.Builder} avoiding
         * the need to create one manually via {@link VideoStandardExtraction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VideoStandardExtraction.Builder#build()} is called immediately
         * and its result is passed to {@link #extraction(VideoStandardExtraction)}.
         * 
         * @param extraction
         *        a consumer that will call methods on {@link VideoStandardExtraction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #extraction(VideoStandardExtraction)
         */
        default Builder extraction(Consumer<VideoStandardExtraction.Builder> extraction) {
            return extraction(VideoStandardExtraction.builder().applyMutation(extraction).build());
        }

        /**
         * Sets the value of the GenerativeField property for this object.
         *
         * @param generativeField
         *        The new value for the GenerativeField property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generativeField(VideoStandardGenerativeField generativeField);

        /**
         * Sets the value of the GenerativeField property for this object.
         *
         * This is a convenience method that creates an instance of the {@link VideoStandardGenerativeField.Builder}
         * avoiding the need to create one manually via {@link VideoStandardGenerativeField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VideoStandardGenerativeField.Builder#build()} is called
         * immediately and its result is passed to {@link #generativeField(VideoStandardGenerativeField)}.
         * 
         * @param generativeField
         *        a consumer that will call methods on {@link VideoStandardGenerativeField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #generativeField(VideoStandardGenerativeField)
         */
        default Builder generativeField(Consumer<VideoStandardGenerativeField.Builder> generativeField) {
            return generativeField(VideoStandardGenerativeField.builder().applyMutation(generativeField).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private VideoStandardExtraction extraction;

        private VideoStandardGenerativeField generativeField;

        private BuilderImpl() {
        }

        private BuilderImpl(VideoStandardOutputConfiguration model) {
            extraction(model.extraction);
            generativeField(model.generativeField);
        }

        public final VideoStandardExtraction.Builder getExtraction() {
            return extraction != null ? extraction.toBuilder() : null;
        }

        public final void setExtraction(VideoStandardExtraction.BuilderImpl extraction) {
            this.extraction = extraction != null ? extraction.build() : null;
        }

        @Override
        public final Builder extraction(VideoStandardExtraction extraction) {
            this.extraction = extraction;
            return this;
        }

        public final VideoStandardGenerativeField.Builder getGenerativeField() {
            return generativeField != null ? generativeField.toBuilder() : null;
        }

        public final void setGenerativeField(VideoStandardGenerativeField.BuilderImpl generativeField) {
            this.generativeField = generativeField != null ? generativeField.build() : null;
        }

        @Override
        public final Builder generativeField(VideoStandardGenerativeField generativeField) {
            this.generativeField = generativeField;
            return this;
        }

        @Override
        public VideoStandardOutputConfiguration build() {
            return new VideoStandardOutputConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
