/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockdataautomationruntime;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.bedrockdataautomationruntime.model.GetDataAutomationStatusRequest;
import software.amazon.awssdk.services.bedrockdataautomationruntime.model.GetDataAutomationStatusResponse;
import software.amazon.awssdk.services.bedrockdataautomationruntime.model.InvokeDataAutomationAsyncRequest;
import software.amazon.awssdk.services.bedrockdataautomationruntime.model.InvokeDataAutomationAsyncResponse;

/**
 * Service client for accessing Runtime for Amazon Bedrock Data Automation asynchronously. This can be created using the
 * static {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * Amazon Bedrock Data Automation Runtime
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface BedrockDataAutomationRuntimeAsyncClient extends AwsClient {
    String SERVICE_NAME = "bedrock";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "bedrock-data-automation-runtime";

    /**
     * <p>
     * API used to get data automation status.
     * </p>
     *
     * @param getDataAutomationStatusRequest
     *        Structure for request of GetDataAutomationStatus API.
     * @return A Java Future containing the result of the GetDataAutomationStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException This exception will be thrown when customer does not have access to API.</li>
     *         <li>ValidationException This exception will be thrown when customer provided invalid parameters.</li>
     *         <li>InternalServerException This exception is for any internal un-expected service errors.</li>
     *         <li>ThrottlingException This exception will be thrown when customer reached API TPS limit.</li>
     *         <li>ResourceNotFoundException This exception will be thrown when resource provided from customer not
     *         found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockDataAutomationRuntimeException Base class for all service exceptions. Unknown exceptions will
     *         be thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockDataAutomationRuntimeAsyncClient.GetDataAutomationStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-runtime-2024-06-13/GetDataAutomationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDataAutomationStatusResponse> getDataAutomationStatus(
            GetDataAutomationStatusRequest getDataAutomationStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * API used to get data automation status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataAutomationStatusRequest.Builder} avoiding
     * the need to create one manually via {@link GetDataAutomationStatusRequest#builder()}
     * </p>
     *
     * @param getDataAutomationStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockdataautomationruntime.model.GetDataAutomationStatusRequest.Builder}
     *        to create a request. Structure for request of GetDataAutomationStatus API.
     * @return A Java Future containing the result of the GetDataAutomationStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException This exception will be thrown when customer does not have access to API.</li>
     *         <li>ValidationException This exception will be thrown when customer provided invalid parameters.</li>
     *         <li>InternalServerException This exception is for any internal un-expected service errors.</li>
     *         <li>ThrottlingException This exception will be thrown when customer reached API TPS limit.</li>
     *         <li>ResourceNotFoundException This exception will be thrown when resource provided from customer not
     *         found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockDataAutomationRuntimeException Base class for all service exceptions. Unknown exceptions will
     *         be thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockDataAutomationRuntimeAsyncClient.GetDataAutomationStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-runtime-2024-06-13/GetDataAutomationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDataAutomationStatusResponse> getDataAutomationStatus(
            Consumer<GetDataAutomationStatusRequest.Builder> getDataAutomationStatusRequest) {
        return getDataAutomationStatus(GetDataAutomationStatusRequest.builder().applyMutation(getDataAutomationStatusRequest)
                .build());
    }

    /**
     * <p>
     * Async API: Invoke data automation.
     * </p>
     *
     * @param invokeDataAutomationAsyncRequest
     *        Invoke Data Automation Async Request
     * @return A Java Future containing the result of the InvokeDataAutomationAsync operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception will be thrown when service quota is exceeded.</li>
     *         <li>AccessDeniedException This exception will be thrown when customer does not have access to API.</li>
     *         <li>ValidationException This exception will be thrown when customer provided invalid parameters.</li>
     *         <li>InternalServerException This exception is for any internal un-expected service errors.</li>
     *         <li>ThrottlingException This exception will be thrown when customer reached API TPS limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockDataAutomationRuntimeException Base class for all service exceptions. Unknown exceptions will
     *         be thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockDataAutomationRuntimeAsyncClient.InvokeDataAutomationAsync
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-runtime-2024-06-13/InvokeDataAutomationAsync"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<InvokeDataAutomationAsyncResponse> invokeDataAutomationAsync(
            InvokeDataAutomationAsyncRequest invokeDataAutomationAsyncRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Async API: Invoke data automation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InvokeDataAutomationAsyncRequest.Builder} avoiding
     * the need to create one manually via {@link InvokeDataAutomationAsyncRequest#builder()}
     * </p>
     *
     * @param invokeDataAutomationAsyncRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockdataautomationruntime.model.InvokeDataAutomationAsyncRequest.Builder}
     *        to create a request. Invoke Data Automation Async Request
     * @return A Java Future containing the result of the InvokeDataAutomationAsync operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception will be thrown when service quota is exceeded.</li>
     *         <li>AccessDeniedException This exception will be thrown when customer does not have access to API.</li>
     *         <li>ValidationException This exception will be thrown when customer provided invalid parameters.</li>
     *         <li>InternalServerException This exception is for any internal un-expected service errors.</li>
     *         <li>ThrottlingException This exception will be thrown when customer reached API TPS limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockDataAutomationRuntimeException Base class for all service exceptions. Unknown exceptions will
     *         be thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockDataAutomationRuntimeAsyncClient.InvokeDataAutomationAsync
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-runtime-2024-06-13/InvokeDataAutomationAsync"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<InvokeDataAutomationAsyncResponse> invokeDataAutomationAsync(
            Consumer<InvokeDataAutomationAsyncRequest.Builder> invokeDataAutomationAsyncRequest) {
        return invokeDataAutomationAsync(InvokeDataAutomationAsyncRequest.builder()
                .applyMutation(invokeDataAutomationAsyncRequest).build());
    }

    @Override
    default BedrockDataAutomationRuntimeServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link BedrockDataAutomationRuntimeAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static BedrockDataAutomationRuntimeAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link BedrockDataAutomationRuntimeAsyncClient}.
     */
    static BedrockDataAutomationRuntimeAsyncClientBuilder builder() {
        return new DefaultBedrockDataAutomationRuntimeAsyncClientBuilder();
    }
}
