/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockdataautomationruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Structure for single blueprint entity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Blueprint implements SdkPojo, Serializable, ToCopyableBuilder<Blueprint.Builder, Blueprint> {
    private static final SdkField<String> BLUEPRINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("blueprintArn").getter(getter(Blueprint::blueprintArn)).setter(setter(Builder::blueprintArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprintArn").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(Blueprint::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<String> STAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("stage")
            .getter(getter(Blueprint::stageAsString)).setter(setter(Builder::stage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLUEPRINT_ARN_FIELD,
            VERSION_FIELD, STAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String blueprintArn;

    private final String version;

    private final String stage;

    private Blueprint(BuilderImpl builder) {
        this.blueprintArn = builder.blueprintArn;
        this.version = builder.version;
        this.stage = builder.stage;
    }

    /**
     * <p>
     * Arn of blueprint.
     * </p>
     * 
     * @return Arn of blueprint.
     */
    public final String blueprintArn() {
        return blueprintArn;
    }

    /**
     * <p>
     * Version of blueprint.
     * </p>
     * 
     * @return Version of blueprint.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * Stage of blueprint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stage} will return
     * {@link BlueprintStage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stageAsString}.
     * </p>
     * 
     * @return Stage of blueprint.
     * @see BlueprintStage
     */
    public final BlueprintStage stage() {
        return BlueprintStage.fromValue(stage);
    }

    /**
     * <p>
     * Stage of blueprint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stage} will return
     * {@link BlueprintStage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stageAsString}.
     * </p>
     * 
     * @return Stage of blueprint.
     * @see BlueprintStage
     */
    public final String stageAsString() {
        return stage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(blueprintArn());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(stageAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Blueprint)) {
            return false;
        }
        Blueprint other = (Blueprint) obj;
        return Objects.equals(blueprintArn(), other.blueprintArn()) && Objects.equals(version(), other.version())
                && Objects.equals(stageAsString(), other.stageAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Blueprint").add("BlueprintArn", blueprintArn()).add("Version", version())
                .add("Stage", stageAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "blueprintArn":
            return Optional.ofNullable(clazz.cast(blueprintArn()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "stage":
            return Optional.ofNullable(clazz.cast(stageAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("blueprintArn", BLUEPRINT_ARN_FIELD);
        map.put("version", VERSION_FIELD);
        map.put("stage", STAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Blueprint, T> g) {
        return obj -> g.apply((Blueprint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Blueprint> {
        /**
         * <p>
         * Arn of blueprint.
         * </p>
         * 
         * @param blueprintArn
         *        Arn of blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprintArn(String blueprintArn);

        /**
         * <p>
         * Version of blueprint.
         * </p>
         * 
         * @param version
         *        Version of blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * Stage of blueprint.
         * </p>
         * 
         * @param stage
         *        Stage of blueprint.
         * @see BlueprintStage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BlueprintStage
         */
        Builder stage(String stage);

        /**
         * <p>
         * Stage of blueprint.
         * </p>
         * 
         * @param stage
         *        Stage of blueprint.
         * @see BlueprintStage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BlueprintStage
         */
        Builder stage(BlueprintStage stage);
    }

    static final class BuilderImpl implements Builder {
        private String blueprintArn;

        private String version;

        private String stage;

        private BuilderImpl() {
        }

        private BuilderImpl(Blueprint model) {
            blueprintArn(model.blueprintArn);
            version(model.version);
            stage(model.stage);
        }

        public final String getBlueprintArn() {
            return blueprintArn;
        }

        public final void setBlueprintArn(String blueprintArn) {
            this.blueprintArn = blueprintArn;
        }

        @Override
        public final Builder blueprintArn(String blueprintArn) {
            this.blueprintArn = blueprintArn;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getStage() {
            return stage;
        }

        public final void setStage(String stage) {
            this.stage = stage;
        }

        @Override
        public final Builder stage(String stage) {
            this.stage = stage;
            return this;
        }

        @Override
        public final Builder stage(BlueprintStage stage) {
            this.stage(stage == null ? null : stage.toString());
            return this;
        }

        @Override
        public Blueprint build() {
            return new Blueprint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
