/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockdataautomationruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Data automation configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataAutomationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DataAutomationConfiguration.Builder, DataAutomationConfiguration> {
    private static final SdkField<String> DATA_AUTOMATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataAutomationArn").getter(getter(DataAutomationConfiguration::dataAutomationArn))
            .setter(setter(Builder::dataAutomationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataAutomationArn").build()).build();

    private static final SdkField<String> STAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("stage")
            .getter(getter(DataAutomationConfiguration::stageAsString)).setter(setter(Builder::stage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_AUTOMATION_ARN_FIELD,
            STAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dataAutomationArn;

    private final String stage;

    private DataAutomationConfiguration(BuilderImpl builder) {
        this.dataAutomationArn = builder.dataAutomationArn;
        this.stage = builder.stage;
    }

    /**
     * <p>
     * Data automation arn.
     * </p>
     * 
     * @return Data automation arn.
     */
    public final String dataAutomationArn() {
        return dataAutomationArn;
    }

    /**
     * <p>
     * Data automation stage.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stage} will return
     * {@link DataAutomationStage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stageAsString}.
     * </p>
     * 
     * @return Data automation stage.
     * @see DataAutomationStage
     */
    public final DataAutomationStage stage() {
        return DataAutomationStage.fromValue(stage);
    }

    /**
     * <p>
     * Data automation stage.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stage} will return
     * {@link DataAutomationStage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stageAsString}.
     * </p>
     * 
     * @return Data automation stage.
     * @see DataAutomationStage
     */
    public final String stageAsString() {
        return stage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataAutomationArn());
        hashCode = 31 * hashCode + Objects.hashCode(stageAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataAutomationConfiguration)) {
            return false;
        }
        DataAutomationConfiguration other = (DataAutomationConfiguration) obj;
        return Objects.equals(dataAutomationArn(), other.dataAutomationArn())
                && Objects.equals(stageAsString(), other.stageAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataAutomationConfiguration").add("DataAutomationArn", dataAutomationArn())
                .add("Stage", stageAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataAutomationArn":
            return Optional.ofNullable(clazz.cast(dataAutomationArn()));
        case "stage":
            return Optional.ofNullable(clazz.cast(stageAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dataAutomationArn", DATA_AUTOMATION_ARN_FIELD);
        map.put("stage", STAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataAutomationConfiguration, T> g) {
        return obj -> g.apply((DataAutomationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataAutomationConfiguration> {
        /**
         * <p>
         * Data automation arn.
         * </p>
         * 
         * @param dataAutomationArn
         *        Data automation arn.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataAutomationArn(String dataAutomationArn);

        /**
         * <p>
         * Data automation stage.
         * </p>
         * 
         * @param stage
         *        Data automation stage.
         * @see DataAutomationStage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataAutomationStage
         */
        Builder stage(String stage);

        /**
         * <p>
         * Data automation stage.
         * </p>
         * 
         * @param stage
         *        Data automation stage.
         * @see DataAutomationStage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataAutomationStage
         */
        Builder stage(DataAutomationStage stage);
    }

    static final class BuilderImpl implements Builder {
        private String dataAutomationArn;

        private String stage;

        private BuilderImpl() {
        }

        private BuilderImpl(DataAutomationConfiguration model) {
            dataAutomationArn(model.dataAutomationArn);
            stage(model.stage);
        }

        public final String getDataAutomationArn() {
            return dataAutomationArn;
        }

        public final void setDataAutomationArn(String dataAutomationArn) {
            this.dataAutomationArn = dataAutomationArn;
        }

        @Override
        public final Builder dataAutomationArn(String dataAutomationArn) {
            this.dataAutomationArn = dataAutomationArn;
            return this;
        }

        public final String getStage() {
            return stage;
        }

        public final void setStage(String stage) {
            this.stage = stage;
        }

        @Override
        public final Builder stage(String stage) {
            this.stage = stage;
            return this;
        }

        @Override
        public final Builder stage(DataAutomationStage stage) {
            this.stage(stage == null ? null : stage.toString());
            return this;
        }

        @Override
        public DataAutomationConfiguration build() {
            return new DataAutomationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
