/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockdataautomationruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Invoke Data Automation Async Request
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvokeDataAutomationAsyncRequest extends BedrockDataAutomationRuntimeRequest implements
        ToCopyableBuilder<InvokeDataAutomationAsyncRequest.Builder, InvokeDataAutomationAsyncRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(InvokeDataAutomationAsyncRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<InputConfiguration> INPUT_CONFIGURATION_FIELD = SdkField
            .<InputConfiguration> builder(MarshallingType.SDK_POJO).memberName("inputConfiguration")
            .getter(getter(InvokeDataAutomationAsyncRequest::inputConfiguration)).setter(setter(Builder::inputConfiguration))
            .constructor(InputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputConfiguration").build())
            .build();

    private static final SdkField<OutputConfiguration> OUTPUT_CONFIGURATION_FIELD = SdkField
            .<OutputConfiguration> builder(MarshallingType.SDK_POJO).memberName("outputConfiguration")
            .getter(getter(InvokeDataAutomationAsyncRequest::outputConfiguration)).setter(setter(Builder::outputConfiguration))
            .constructor(OutputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputConfiguration").build())
            .build();

    private static final SdkField<DataAutomationConfiguration> DATA_AUTOMATION_CONFIGURATION_FIELD = SdkField
            .<DataAutomationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("dataAutomationConfiguration")
            .getter(getter(InvokeDataAutomationAsyncRequest::dataAutomationConfiguration))
            .setter(setter(Builder::dataAutomationConfiguration))
            .constructor(DataAutomationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataAutomationConfiguration")
                    .build()).build();

    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField
            .<EncryptionConfiguration> builder(MarshallingType.SDK_POJO).memberName("encryptionConfiguration")
            .getter(getter(InvokeDataAutomationAsyncRequest::encryptionConfiguration))
            .setter(setter(Builder::encryptionConfiguration)).constructor(EncryptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionConfiguration").build())
            .build();

    private static final SdkField<NotificationConfiguration> NOTIFICATION_CONFIGURATION_FIELD = SdkField
            .<NotificationConfiguration> builder(MarshallingType.SDK_POJO).memberName("notificationConfiguration")
            .getter(getter(InvokeDataAutomationAsyncRequest::notificationConfiguration))
            .setter(setter(Builder::notificationConfiguration)).constructor(NotificationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationConfiguration").build())
            .build();

    private static final SdkField<List<Blueprint>> BLUEPRINTS_FIELD = SdkField
            .<List<Blueprint>> builder(MarshallingType.LIST)
            .memberName("blueprints")
            .getter(getter(InvokeDataAutomationAsyncRequest::blueprints))
            .setter(setter(Builder::blueprints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Blueprint> builder(MarshallingType.SDK_POJO)
                                            .constructor(Blueprint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            INPUT_CONFIGURATION_FIELD, OUTPUT_CONFIGURATION_FIELD, DATA_AUTOMATION_CONFIGURATION_FIELD,
            ENCRYPTION_CONFIGURATION_FIELD, NOTIFICATION_CONFIGURATION_FIELD, BLUEPRINTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final InputConfiguration inputConfiguration;

    private final OutputConfiguration outputConfiguration;

    private final DataAutomationConfiguration dataAutomationConfiguration;

    private final EncryptionConfiguration encryptionConfiguration;

    private final NotificationConfiguration notificationConfiguration;

    private final List<Blueprint> blueprints;

    private InvokeDataAutomationAsyncRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.inputConfiguration = builder.inputConfiguration;
        this.outputConfiguration = builder.outputConfiguration;
        this.dataAutomationConfiguration = builder.dataAutomationConfiguration;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.notificationConfiguration = builder.notificationConfiguration;
        this.blueprints = builder.blueprints;
    }

    /**
     * <p>
     * Idempotency token.
     * </p>
     * 
     * @return Idempotency token.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Input configuration.
     * </p>
     * 
     * @return Input configuration.
     */
    public final InputConfiguration inputConfiguration() {
        return inputConfiguration;
    }

    /**
     * <p>
     * Output configuration.
     * </p>
     * 
     * @return Output configuration.
     */
    public final OutputConfiguration outputConfiguration() {
        return outputConfiguration;
    }

    /**
     * <p>
     * Data automation configuration.
     * </p>
     * 
     * @return Data automation configuration.
     */
    public final DataAutomationConfiguration dataAutomationConfiguration() {
        return dataAutomationConfiguration;
    }

    /**
     * <p>
     * Encryption configuration.
     * </p>
     * 
     * @return Encryption configuration.
     */
    public final EncryptionConfiguration encryptionConfiguration() {
        return encryptionConfiguration;
    }

    /**
     * <p>
     * Notification configuration.
     * </p>
     * 
     * @return Notification configuration.
     */
    public final NotificationConfiguration notificationConfiguration() {
        return notificationConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Blueprints property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasBlueprints() {
        return blueprints != null && !(blueprints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Blueprint list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlueprints} method.
     * </p>
     * 
     * @return Blueprint list.
     */
    public final List<Blueprint> blueprints() {
        return blueprints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(inputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(outputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(dataAutomationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(notificationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasBlueprints() ? blueprints() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeDataAutomationAsyncRequest)) {
            return false;
        }
        InvokeDataAutomationAsyncRequest other = (InvokeDataAutomationAsyncRequest) obj;
        return Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(inputConfiguration(), other.inputConfiguration())
                && Objects.equals(outputConfiguration(), other.outputConfiguration())
                && Objects.equals(dataAutomationConfiguration(), other.dataAutomationConfiguration())
                && Objects.equals(encryptionConfiguration(), other.encryptionConfiguration())
                && Objects.equals(notificationConfiguration(), other.notificationConfiguration())
                && hasBlueprints() == other.hasBlueprints() && Objects.equals(blueprints(), other.blueprints());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InvokeDataAutomationAsyncRequest").add("ClientToken", clientToken())
                .add("InputConfiguration", inputConfiguration()).add("OutputConfiguration", outputConfiguration())
                .add("DataAutomationConfiguration", dataAutomationConfiguration())
                .add("EncryptionConfiguration", encryptionConfiguration())
                .add("NotificationConfiguration", notificationConfiguration())
                .add("Blueprints", hasBlueprints() ? blueprints() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "inputConfiguration":
            return Optional.ofNullable(clazz.cast(inputConfiguration()));
        case "outputConfiguration":
            return Optional.ofNullable(clazz.cast(outputConfiguration()));
        case "dataAutomationConfiguration":
            return Optional.ofNullable(clazz.cast(dataAutomationConfiguration()));
        case "encryptionConfiguration":
            return Optional.ofNullable(clazz.cast(encryptionConfiguration()));
        case "notificationConfiguration":
            return Optional.ofNullable(clazz.cast(notificationConfiguration()));
        case "blueprints":
            return Optional.ofNullable(clazz.cast(blueprints()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("inputConfiguration", INPUT_CONFIGURATION_FIELD);
        map.put("outputConfiguration", OUTPUT_CONFIGURATION_FIELD);
        map.put("dataAutomationConfiguration", DATA_AUTOMATION_CONFIGURATION_FIELD);
        map.put("encryptionConfiguration", ENCRYPTION_CONFIGURATION_FIELD);
        map.put("notificationConfiguration", NOTIFICATION_CONFIGURATION_FIELD);
        map.put("blueprints", BLUEPRINTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvokeDataAutomationAsyncRequest, T> g) {
        return obj -> g.apply((InvokeDataAutomationAsyncRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockDataAutomationRuntimeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, InvokeDataAutomationAsyncRequest> {
        /**
         * <p>
         * Idempotency token.
         * </p>
         * 
         * @param clientToken
         *        Idempotency token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Input configuration.
         * </p>
         * 
         * @param inputConfiguration
         *        Input configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputConfiguration(InputConfiguration inputConfiguration);

        /**
         * <p>
         * Input configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link InputConfiguration.Builder} avoiding the
         * need to create one manually via {@link InputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InputConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #inputConfiguration(InputConfiguration)}.
         * 
         * @param inputConfiguration
         *        a consumer that will call methods on {@link InputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputConfiguration(InputConfiguration)
         */
        default Builder inputConfiguration(Consumer<InputConfiguration.Builder> inputConfiguration) {
            return inputConfiguration(InputConfiguration.builder().applyMutation(inputConfiguration).build());
        }

        /**
         * <p>
         * Output configuration.
         * </p>
         * 
         * @param outputConfiguration
         *        Output configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConfiguration(OutputConfiguration outputConfiguration);

        /**
         * <p>
         * Output configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link OutputConfiguration.Builder} avoiding the
         * need to create one manually via {@link OutputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OutputConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #outputConfiguration(OutputConfiguration)}.
         * 
         * @param outputConfiguration
         *        a consumer that will call methods on {@link OutputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConfiguration(OutputConfiguration)
         */
        default Builder outputConfiguration(Consumer<OutputConfiguration.Builder> outputConfiguration) {
            return outputConfiguration(OutputConfiguration.builder().applyMutation(outputConfiguration).build());
        }

        /**
         * <p>
         * Data automation configuration.
         * </p>
         * 
         * @param dataAutomationConfiguration
         *        Data automation configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataAutomationConfiguration(DataAutomationConfiguration dataAutomationConfiguration);

        /**
         * <p>
         * Data automation configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataAutomationConfiguration.Builder}
         * avoiding the need to create one manually via {@link DataAutomationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataAutomationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #dataAutomationConfiguration(DataAutomationConfiguration)}.
         * 
         * @param dataAutomationConfiguration
         *        a consumer that will call methods on {@link DataAutomationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataAutomationConfiguration(DataAutomationConfiguration)
         */
        default Builder dataAutomationConfiguration(Consumer<DataAutomationConfiguration.Builder> dataAutomationConfiguration) {
            return dataAutomationConfiguration(DataAutomationConfiguration.builder().applyMutation(dataAutomationConfiguration)
                    .build());
        }

        /**
         * <p>
         * Encryption configuration.
         * </p>
         * 
         * @param encryptionConfiguration
         *        Encryption configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration);

        /**
         * <p>
         * Encryption configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link EncryptionConfiguration.Builder} avoiding
         * the need to create one manually via {@link EncryptionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncryptionConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #encryptionConfiguration(EncryptionConfiguration)}.
         * 
         * @param encryptionConfiguration
         *        a consumer that will call methods on {@link EncryptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionConfiguration(EncryptionConfiguration)
         */
        default Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return encryptionConfiguration(EncryptionConfiguration.builder().applyMutation(encryptionConfiguration).build());
        }

        /**
         * <p>
         * Notification configuration.
         * </p>
         * 
         * @param notificationConfiguration
         *        Notification configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationConfiguration(NotificationConfiguration notificationConfiguration);

        /**
         * <p>
         * Notification configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link NotificationConfiguration.Builder}
         * avoiding the need to create one manually via {@link NotificationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NotificationConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #notificationConfiguration(NotificationConfiguration)}.
         * 
         * @param notificationConfiguration
         *        a consumer that will call methods on {@link NotificationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notificationConfiguration(NotificationConfiguration)
         */
        default Builder notificationConfiguration(Consumer<NotificationConfiguration.Builder> notificationConfiguration) {
            return notificationConfiguration(NotificationConfiguration.builder().applyMutation(notificationConfiguration).build());
        }

        /**
         * <p>
         * Blueprint list.
         * </p>
         * 
         * @param blueprints
         *        Blueprint list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprints(Collection<Blueprint> blueprints);

        /**
         * <p>
         * Blueprint list.
         * </p>
         * 
         * @param blueprints
         *        Blueprint list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprints(Blueprint... blueprints);

        /**
         * <p>
         * Blueprint list.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockdataautomationruntime.model.Blueprint.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.bedrockdataautomationruntime.model.Blueprint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockdataautomationruntime.model.Blueprint.Builder#build()} is
         * called immediately and its result is passed to {@link #blueprints(List<Blueprint>)}.
         * 
         * @param blueprints
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockdataautomationruntime.model.Blueprint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blueprints(java.util.Collection<Blueprint>)
         */
        Builder blueprints(Consumer<Blueprint.Builder>... blueprints);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockDataAutomationRuntimeRequest.BuilderImpl implements Builder {
        private String clientToken;

        private InputConfiguration inputConfiguration;

        private OutputConfiguration outputConfiguration;

        private DataAutomationConfiguration dataAutomationConfiguration;

        private EncryptionConfiguration encryptionConfiguration;

        private NotificationConfiguration notificationConfiguration;

        private List<Blueprint> blueprints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeDataAutomationAsyncRequest model) {
            super(model);
            clientToken(model.clientToken);
            inputConfiguration(model.inputConfiguration);
            outputConfiguration(model.outputConfiguration);
            dataAutomationConfiguration(model.dataAutomationConfiguration);
            encryptionConfiguration(model.encryptionConfiguration);
            notificationConfiguration(model.notificationConfiguration);
            blueprints(model.blueprints);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final InputConfiguration.Builder getInputConfiguration() {
            return inputConfiguration != null ? inputConfiguration.toBuilder() : null;
        }

        public final void setInputConfiguration(InputConfiguration.BuilderImpl inputConfiguration) {
            this.inputConfiguration = inputConfiguration != null ? inputConfiguration.build() : null;
        }

        @Override
        public final Builder inputConfiguration(InputConfiguration inputConfiguration) {
            this.inputConfiguration = inputConfiguration;
            return this;
        }

        public final OutputConfiguration.Builder getOutputConfiguration() {
            return outputConfiguration != null ? outputConfiguration.toBuilder() : null;
        }

        public final void setOutputConfiguration(OutputConfiguration.BuilderImpl outputConfiguration) {
            this.outputConfiguration = outputConfiguration != null ? outputConfiguration.build() : null;
        }

        @Override
        public final Builder outputConfiguration(OutputConfiguration outputConfiguration) {
            this.outputConfiguration = outputConfiguration;
            return this;
        }

        public final DataAutomationConfiguration.Builder getDataAutomationConfiguration() {
            return dataAutomationConfiguration != null ? dataAutomationConfiguration.toBuilder() : null;
        }

        public final void setDataAutomationConfiguration(DataAutomationConfiguration.BuilderImpl dataAutomationConfiguration) {
            this.dataAutomationConfiguration = dataAutomationConfiguration != null ? dataAutomationConfiguration.build() : null;
        }

        @Override
        public final Builder dataAutomationConfiguration(DataAutomationConfiguration dataAutomationConfiguration) {
            this.dataAutomationConfiguration = dataAutomationConfiguration;
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return encryptionConfiguration != null ? encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final NotificationConfiguration.Builder getNotificationConfiguration() {
            return notificationConfiguration != null ? notificationConfiguration.toBuilder() : null;
        }

        public final void setNotificationConfiguration(NotificationConfiguration.BuilderImpl notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration != null ? notificationConfiguration.build() : null;
        }

        @Override
        public final Builder notificationConfiguration(NotificationConfiguration notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration;
            return this;
        }

        public final List<Blueprint.Builder> getBlueprints() {
            List<Blueprint.Builder> result = BlueprintListCopier.copyToBuilder(this.blueprints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlueprints(Collection<Blueprint.BuilderImpl> blueprints) {
            this.blueprints = BlueprintListCopier.copyFromBuilder(blueprints);
        }

        @Override
        public final Builder blueprints(Collection<Blueprint> blueprints) {
            this.blueprints = BlueprintListCopier.copy(blueprints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blueprints(Blueprint... blueprints) {
            blueprints(Arrays.asList(blueprints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blueprints(Consumer<Blueprint.Builder>... blueprints) {
            blueprints(Stream.of(blueprints).map(c -> Blueprint.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InvokeDataAutomationAsyncRequest build() {
            return new InvokeDataAutomationAsyncRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
