/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockdataautomationruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Notification configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NotificationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<NotificationConfiguration.Builder, NotificationConfiguration> {
    private static final SdkField<EventBridgeConfiguration> EVENT_BRIDGE_CONFIGURATION_FIELD = SdkField
            .<EventBridgeConfiguration> builder(MarshallingType.SDK_POJO).memberName("eventBridgeConfiguration")
            .getter(getter(NotificationConfiguration::eventBridgeConfiguration))
            .setter(setter(Builder::eventBridgeConfiguration)).constructor(EventBridgeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventBridgeConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(EVENT_BRIDGE_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final EventBridgeConfiguration eventBridgeConfiguration;

    private NotificationConfiguration(BuilderImpl builder) {
        this.eventBridgeConfiguration = builder.eventBridgeConfiguration;
    }

    /**
     * <p>
     * Event bridge configuration.
     * </p>
     * 
     * @return Event bridge configuration.
     */
    public final EventBridgeConfiguration eventBridgeConfiguration() {
        return eventBridgeConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventBridgeConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationConfiguration)) {
            return false;
        }
        NotificationConfiguration other = (NotificationConfiguration) obj;
        return Objects.equals(eventBridgeConfiguration(), other.eventBridgeConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NotificationConfiguration").add("EventBridgeConfiguration", eventBridgeConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventBridgeConfiguration":
            return Optional.ofNullable(clazz.cast(eventBridgeConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("eventBridgeConfiguration", EVENT_BRIDGE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NotificationConfiguration, T> g) {
        return obj -> g.apply((NotificationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NotificationConfiguration> {
        /**
         * <p>
         * Event bridge configuration.
         * </p>
         * 
         * @param eventBridgeConfiguration
         *        Event bridge configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventBridgeConfiguration(EventBridgeConfiguration eventBridgeConfiguration);

        /**
         * <p>
         * Event bridge configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link EventBridgeConfiguration.Builder}
         * avoiding the need to create one manually via {@link EventBridgeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EventBridgeConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #eventBridgeConfiguration(EventBridgeConfiguration)}.
         * 
         * @param eventBridgeConfiguration
         *        a consumer that will call methods on {@link EventBridgeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventBridgeConfiguration(EventBridgeConfiguration)
         */
        default Builder eventBridgeConfiguration(Consumer<EventBridgeConfiguration.Builder> eventBridgeConfiguration) {
            return eventBridgeConfiguration(EventBridgeConfiguration.builder().applyMutation(eventBridgeConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EventBridgeConfiguration eventBridgeConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationConfiguration model) {
            eventBridgeConfiguration(model.eventBridgeConfiguration);
        }

        public final EventBridgeConfiguration.Builder getEventBridgeConfiguration() {
            return eventBridgeConfiguration != null ? eventBridgeConfiguration.toBuilder() : null;
        }

        public final void setEventBridgeConfiguration(EventBridgeConfiguration.BuilderImpl eventBridgeConfiguration) {
            this.eventBridgeConfiguration = eventBridgeConfiguration != null ? eventBridgeConfiguration.build() : null;
        }

        @Override
        public final Builder eventBridgeConfiguration(EventBridgeConfiguration eventBridgeConfiguration) {
            this.eventBridgeConfiguration = eventBridgeConfiguration;
            return this;
        }

        @Override
        public NotificationConfiguration build() {
            return new NotificationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
