/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockdataautomationruntime;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.bedrockdataautomationruntime.model.AccessDeniedException;
import software.amazon.awssdk.services.bedrockdataautomationruntime.model.BedrockDataAutomationRuntimeException;
import software.amazon.awssdk.services.bedrockdataautomationruntime.model.GetDataAutomationStatusRequest;
import software.amazon.awssdk.services.bedrockdataautomationruntime.model.GetDataAutomationStatusResponse;
import software.amazon.awssdk.services.bedrockdataautomationruntime.model.InternalServerException;
import software.amazon.awssdk.services.bedrockdataautomationruntime.model.InvokeDataAutomationAsyncRequest;
import software.amazon.awssdk.services.bedrockdataautomationruntime.model.InvokeDataAutomationAsyncResponse;
import software.amazon.awssdk.services.bedrockdataautomationruntime.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.bedrockdataautomationruntime.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.bedrockdataautomationruntime.model.ResourceNotFoundException;
import software.amazon.awssdk.services.bedrockdataautomationruntime.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.bedrockdataautomationruntime.model.TagResourceRequest;
import software.amazon.awssdk.services.bedrockdataautomationruntime.model.TagResourceResponse;
import software.amazon.awssdk.services.bedrockdataautomationruntime.model.ThrottlingException;
import software.amazon.awssdk.services.bedrockdataautomationruntime.model.UntagResourceRequest;
import software.amazon.awssdk.services.bedrockdataautomationruntime.model.UntagResourceResponse;
import software.amazon.awssdk.services.bedrockdataautomationruntime.model.ValidationException;

/**
 * Service client for accessing Runtime for Amazon Bedrock Data Automation. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * Amazon Bedrock Data Automation Runtime
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface BedrockDataAutomationRuntimeClient extends AwsClient {
    String SERVICE_NAME = "bedrock";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "bedrock-data-automation-runtime";

    /**
     * <p>
     * API used to get data automation status.
     * </p>
     *
     * @param getDataAutomationStatusRequest
     *        Structure for request of GetDataAutomationStatus API.
     * @return Result of the GetDataAutomationStatus operation returned by the service.
     * @throws ValidationException
     *         This exception will be thrown when customer provided invalid parameters.
     * @throws AccessDeniedException
     *         This exception will be thrown when customer does not have access to API.
     * @throws InternalServerException
     *         This exception is for any internal un-expected service errors.
     * @throws ThrottlingException
     *         This exception will be thrown when customer reached API TPS limit.
     * @throws ResourceNotFoundException
     *         This exception will be thrown when resource provided from customer not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockDataAutomationRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockDataAutomationRuntimeClient.GetDataAutomationStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-runtime-2024-06-13/GetDataAutomationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDataAutomationStatusResponse getDataAutomationStatus(GetDataAutomationStatusRequest getDataAutomationStatusRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BedrockDataAutomationRuntimeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * API used to get data automation status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataAutomationStatusRequest.Builder} avoiding
     * the need to create one manually via {@link GetDataAutomationStatusRequest#builder()}
     * </p>
     *
     * @param getDataAutomationStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockdataautomationruntime.model.GetDataAutomationStatusRequest.Builder}
     *        to create a request. Structure for request of GetDataAutomationStatus API.
     * @return Result of the GetDataAutomationStatus operation returned by the service.
     * @throws ValidationException
     *         This exception will be thrown when customer provided invalid parameters.
     * @throws AccessDeniedException
     *         This exception will be thrown when customer does not have access to API.
     * @throws InternalServerException
     *         This exception is for any internal un-expected service errors.
     * @throws ThrottlingException
     *         This exception will be thrown when customer reached API TPS limit.
     * @throws ResourceNotFoundException
     *         This exception will be thrown when resource provided from customer not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockDataAutomationRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockDataAutomationRuntimeClient.GetDataAutomationStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-runtime-2024-06-13/GetDataAutomationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDataAutomationStatusResponse getDataAutomationStatus(
            Consumer<GetDataAutomationStatusRequest.Builder> getDataAutomationStatusRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BedrockDataAutomationRuntimeException {
        return getDataAutomationStatus(GetDataAutomationStatusRequest.builder().applyMutation(getDataAutomationStatusRequest)
                .build());
    }

    /**
     * <p>
     * Async API: Invoke data automation.
     * </p>
     *
     * @param invokeDataAutomationAsyncRequest
     *        Invoke Data Automation Async Request
     * @return Result of the InvokeDataAutomationAsync operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception will be thrown when service quota is exceeded.
     * @throws ValidationException
     *         This exception will be thrown when customer provided invalid parameters.
     * @throws AccessDeniedException
     *         This exception will be thrown when customer does not have access to API.
     * @throws InternalServerException
     *         This exception is for any internal un-expected service errors.
     * @throws ThrottlingException
     *         This exception will be thrown when customer reached API TPS limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockDataAutomationRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockDataAutomationRuntimeClient.InvokeDataAutomationAsync
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-runtime-2024-06-13/InvokeDataAutomationAsync"
     *      target="_top">AWS API Documentation</a>
     */
    default InvokeDataAutomationAsyncResponse invokeDataAutomationAsync(
            InvokeDataAutomationAsyncRequest invokeDataAutomationAsyncRequest) throws ServiceQuotaExceededException,
            ValidationException, AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, BedrockDataAutomationRuntimeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Async API: Invoke data automation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InvokeDataAutomationAsyncRequest.Builder} avoiding
     * the need to create one manually via {@link InvokeDataAutomationAsyncRequest#builder()}
     * </p>
     *
     * @param invokeDataAutomationAsyncRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockdataautomationruntime.model.InvokeDataAutomationAsyncRequest.Builder}
     *        to create a request. Invoke Data Automation Async Request
     * @return Result of the InvokeDataAutomationAsync operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception will be thrown when service quota is exceeded.
     * @throws ValidationException
     *         This exception will be thrown when customer provided invalid parameters.
     * @throws AccessDeniedException
     *         This exception will be thrown when customer does not have access to API.
     * @throws InternalServerException
     *         This exception is for any internal un-expected service errors.
     * @throws ThrottlingException
     *         This exception will be thrown when customer reached API TPS limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockDataAutomationRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockDataAutomationRuntimeClient.InvokeDataAutomationAsync
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-runtime-2024-06-13/InvokeDataAutomationAsync"
     *      target="_top">AWS API Documentation</a>
     */
    default InvokeDataAutomationAsyncResponse invokeDataAutomationAsync(
            Consumer<InvokeDataAutomationAsyncRequest.Builder> invokeDataAutomationAsyncRequest)
            throws ServiceQuotaExceededException, ValidationException, AccessDeniedException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, BedrockDataAutomationRuntimeException {
        return invokeDataAutomationAsync(InvokeDataAutomationAsyncRequest.builder()
                .applyMutation(invokeDataAutomationAsyncRequest).build());
    }

    /**
     * <p>
     * List tags for an Amazon Bedrock Data Automation resource
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         This exception will be thrown when customer provided invalid parameters.
     * @throws AccessDeniedException
     *         This exception will be thrown when customer does not have access to API.
     * @throws InternalServerException
     *         This exception is for any internal un-expected service errors.
     * @throws ResourceNotFoundException
     *         This exception will be thrown when resource provided from customer not found.
     * @throws ThrottlingException
     *         This exception will be thrown when customer reached API TPS limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockDataAutomationRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockDataAutomationRuntimeClient.ListTagsForResource
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-runtime-2024-06-13/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, BedrockDataAutomationRuntimeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List tags for an Amazon Bedrock Data Automation resource
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockdataautomationruntime.model.ListTagsForResourceRequest.Builder}
     *        to create a request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         This exception will be thrown when customer provided invalid parameters.
     * @throws AccessDeniedException
     *         This exception will be thrown when customer does not have access to API.
     * @throws InternalServerException
     *         This exception is for any internal un-expected service errors.
     * @throws ResourceNotFoundException
     *         This exception will be thrown when resource provided from customer not found.
     * @throws ThrottlingException
     *         This exception will be thrown when customer reached API TPS limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockDataAutomationRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockDataAutomationRuntimeClient.ListTagsForResource
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-runtime-2024-06-13/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, BedrockDataAutomationRuntimeException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Tag an Amazon Bedrock Data Automation resource
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception will be thrown when service quota is exceeded.
     * @throws ValidationException
     *         This exception will be thrown when customer provided invalid parameters.
     * @throws AccessDeniedException
     *         This exception will be thrown when customer does not have access to API.
     * @throws InternalServerException
     *         This exception is for any internal un-expected service errors.
     * @throws ResourceNotFoundException
     *         This exception will be thrown when resource provided from customer not found.
     * @throws ThrottlingException
     *         This exception will be thrown when customer reached API TPS limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockDataAutomationRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockDataAutomationRuntimeClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-runtime-2024-06-13/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ServiceQuotaExceededException,
            ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, BedrockDataAutomationRuntimeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tag an Amazon Bedrock Data Automation resource
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockdataautomationruntime.model.TagResourceRequest.Builder} to
     *        create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception will be thrown when service quota is exceeded.
     * @throws ValidationException
     *         This exception will be thrown when customer provided invalid parameters.
     * @throws AccessDeniedException
     *         This exception will be thrown when customer does not have access to API.
     * @throws InternalServerException
     *         This exception is for any internal un-expected service errors.
     * @throws ResourceNotFoundException
     *         This exception will be thrown when resource provided from customer not found.
     * @throws ThrottlingException
     *         This exception will be thrown when customer reached API TPS limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockDataAutomationRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockDataAutomationRuntimeClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-runtime-2024-06-13/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws ServiceQuotaExceededException, ValidationException, AccessDeniedException, InternalServerException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            BedrockDataAutomationRuntimeException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Untag an Amazon Bedrock Data Automation resource
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         This exception will be thrown when customer provided invalid parameters.
     * @throws AccessDeniedException
     *         This exception will be thrown when customer does not have access to API.
     * @throws InternalServerException
     *         This exception is for any internal un-expected service errors.
     * @throws ResourceNotFoundException
     *         This exception will be thrown when resource provided from customer not found.
     * @throws ThrottlingException
     *         This exception will be thrown when customer reached API TPS limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockDataAutomationRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockDataAutomationRuntimeClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-runtime-2024-06-13/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, BedrockDataAutomationRuntimeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Untag an Amazon Bedrock Data Automation resource
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockdataautomationruntime.model.UntagResourceRequest.Builder} to
     *        create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         This exception will be thrown when customer provided invalid parameters.
     * @throws AccessDeniedException
     *         This exception will be thrown when customer does not have access to API.
     * @throws InternalServerException
     *         This exception is for any internal un-expected service errors.
     * @throws ResourceNotFoundException
     *         This exception will be thrown when resource provided from customer not found.
     * @throws ThrottlingException
     *         This exception will be thrown when customer reached API TPS limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockDataAutomationRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockDataAutomationRuntimeClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-data-automation-runtime-2024-06-13/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, BedrockDataAutomationRuntimeException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * Create a {@link BedrockDataAutomationRuntimeClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static BedrockDataAutomationRuntimeClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link BedrockDataAutomationRuntimeClient}.
     */
    static BedrockDataAutomationRuntimeClientBuilder builder() {
        return new DefaultBedrockDataAutomationRuntimeClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default BedrockDataAutomationRuntimeServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
