/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockdataautomationruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Event bridge configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventBridgeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<EventBridgeConfiguration.Builder, EventBridgeConfiguration> {
    private static final SdkField<Boolean> EVENT_BRIDGE_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("eventBridgeEnabled").getter(getter(EventBridgeConfiguration::eventBridgeEnabled))
            .setter(setter(Builder::eventBridgeEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventBridgeEnabled").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_BRIDGE_ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean eventBridgeEnabled;

    private EventBridgeConfiguration(BuilderImpl builder) {
        this.eventBridgeEnabled = builder.eventBridgeEnabled;
    }

    /**
     * <p>
     * Event bridge flag.
     * </p>
     * 
     * @return Event bridge flag.
     */
    public final Boolean eventBridgeEnabled() {
        return eventBridgeEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventBridgeEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventBridgeConfiguration)) {
            return false;
        }
        EventBridgeConfiguration other = (EventBridgeConfiguration) obj;
        return Objects.equals(eventBridgeEnabled(), other.eventBridgeEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EventBridgeConfiguration").add("EventBridgeEnabled", eventBridgeEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventBridgeEnabled":
            return Optional.ofNullable(clazz.cast(eventBridgeEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("eventBridgeEnabled", EVENT_BRIDGE_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EventBridgeConfiguration, T> g) {
        return obj -> g.apply((EventBridgeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventBridgeConfiguration> {
        /**
         * <p>
         * Event bridge flag.
         * </p>
         * 
         * @param eventBridgeEnabled
         *        Event bridge flag.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventBridgeEnabled(Boolean eventBridgeEnabled);
    }

    static final class BuilderImpl implements Builder {
        private Boolean eventBridgeEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(EventBridgeConfiguration model) {
            eventBridgeEnabled(model.eventBridgeEnabled);
        }

        public final Boolean getEventBridgeEnabled() {
            return eventBridgeEnabled;
        }

        public final void setEventBridgeEnabled(Boolean eventBridgeEnabled) {
            this.eventBridgeEnabled = eventBridgeEnabled;
        }

        @Override
        public final Builder eventBridgeEnabled(Boolean eventBridgeEnabled) {
            this.eventBridgeEnabled = eventBridgeEnabled;
            return this;
        }

        @Override
        public EventBridgeConfiguration build() {
            return new EventBridgeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
