/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockdataautomationruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Timestamp segment
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimestampSegment implements SdkPojo, Serializable,
        ToCopyableBuilder<TimestampSegment.Builder, TimestampSegment> {
    private static final SdkField<Long> START_TIME_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("startTimeMillis").getter(getter(TimestampSegment::startTimeMillis))
            .setter(setter(Builder::startTimeMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTimeMillis").build()).build();

    private static final SdkField<Long> END_TIME_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("endTimeMillis").getter(getter(TimestampSegment::endTimeMillis)).setter(setter(Builder::endTimeMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTimeMillis").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_MILLIS_FIELD,
            END_TIME_MILLIS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long startTimeMillis;

    private final Long endTimeMillis;

    private TimestampSegment(BuilderImpl builder) {
        this.startTimeMillis = builder.startTimeMillis;
        this.endTimeMillis = builder.endTimeMillis;
    }

    /**
     * <p>
     * Start timestamp in milliseconds
     * </p>
     * 
     * @return Start timestamp in milliseconds
     */
    public final Long startTimeMillis() {
        return startTimeMillis;
    }

    /**
     * <p>
     * End timestamp in milliseconds
     * </p>
     * 
     * @return End timestamp in milliseconds
     */
    public final Long endTimeMillis() {
        return endTimeMillis;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startTimeMillis());
        hashCode = 31 * hashCode + Objects.hashCode(endTimeMillis());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimestampSegment)) {
            return false;
        }
        TimestampSegment other = (TimestampSegment) obj;
        return Objects.equals(startTimeMillis(), other.startTimeMillis())
                && Objects.equals(endTimeMillis(), other.endTimeMillis());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimestampSegment").add("StartTimeMillis", startTimeMillis())
                .add("EndTimeMillis", endTimeMillis()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "startTimeMillis":
            return Optional.ofNullable(clazz.cast(startTimeMillis()));
        case "endTimeMillis":
            return Optional.ofNullable(clazz.cast(endTimeMillis()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("startTimeMillis", START_TIME_MILLIS_FIELD);
        map.put("endTimeMillis", END_TIME_MILLIS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TimestampSegment, T> g) {
        return obj -> g.apply((TimestampSegment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimestampSegment> {
        /**
         * <p>
         * Start timestamp in milliseconds
         * </p>
         * 
         * @param startTimeMillis
         *        Start timestamp in milliseconds
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimeMillis(Long startTimeMillis);

        /**
         * <p>
         * End timestamp in milliseconds
         * </p>
         * 
         * @param endTimeMillis
         *        End timestamp in milliseconds
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTimeMillis(Long endTimeMillis);
    }

    static final class BuilderImpl implements Builder {
        private Long startTimeMillis;

        private Long endTimeMillis;

        private BuilderImpl() {
        }

        private BuilderImpl(TimestampSegment model) {
            startTimeMillis(model.startTimeMillis);
            endTimeMillis(model.endTimeMillis);
        }

        public final Long getStartTimeMillis() {
            return startTimeMillis;
        }

        public final void setStartTimeMillis(Long startTimeMillis) {
            this.startTimeMillis = startTimeMillis;
        }

        @Override
        public final Builder startTimeMillis(Long startTimeMillis) {
            this.startTimeMillis = startTimeMillis;
            return this;
        }

        public final Long getEndTimeMillis() {
            return endTimeMillis;
        }

        public final void setEndTimeMillis(Long endTimeMillis) {
            this.endTimeMillis = endTimeMillis;
        }

        @Override
        public final Builder endTimeMillis(Long endTimeMillis) {
            this.endTimeMillis = endTimeMillis;
            return this;
        }

        @Override
        public TimestampSegment build() {
            return new TimestampSegment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
