/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockdataautomationruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Response of GetDataAutomationStatus API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDataAutomationStatusResponse extends BedrockDataAutomationRuntimeResponse implements
        ToCopyableBuilder<GetDataAutomationStatusResponse.Builder, GetDataAutomationStatusResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetDataAutomationStatusResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> ERROR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorType").getter(getter(GetDataAutomationStatusResponse::errorType))
            .setter(setter(Builder::errorType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorType").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(GetDataAutomationStatusResponse::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final SdkField<OutputConfiguration> OUTPUT_CONFIGURATION_FIELD = SdkField
            .<OutputConfiguration> builder(MarshallingType.SDK_POJO).memberName("outputConfiguration")
            .getter(getter(GetDataAutomationStatusResponse::outputConfiguration)).setter(setter(Builder::outputConfiguration))
            .constructor(OutputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            ERROR_TYPE_FIELD, ERROR_MESSAGE_FIELD, OUTPUT_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String status;

    private final String errorType;

    private final String errorMessage;

    private final OutputConfiguration outputConfiguration;

    private GetDataAutomationStatusResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.errorType = builder.errorType;
        this.errorMessage = builder.errorMessage;
        this.outputConfiguration = builder.outputConfiguration;
    }

    /**
     * <p>
     * Job Status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AutomationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Job Status.
     * @see AutomationJobStatus
     */
    public final AutomationJobStatus status() {
        return AutomationJobStatus.fromValue(status);
    }

    /**
     * <p>
     * Job Status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AutomationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Job Status.
     * @see AutomationJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Error Type.
     * </p>
     * 
     * @return Error Type.
     */
    public final String errorType() {
        return errorType;
    }

    /**
     * <p>
     * Error Message.
     * </p>
     * 
     * @return Error Message.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * Output configuration.
     * </p>
     * 
     * @return Output configuration.
     */
    public final OutputConfiguration outputConfiguration() {
        return outputConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorType());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(outputConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataAutomationStatusResponse)) {
            return false;
        }
        GetDataAutomationStatusResponse other = (GetDataAutomationStatusResponse) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(errorType(), other.errorType())
                && Objects.equals(errorMessage(), other.errorMessage())
                && Objects.equals(outputConfiguration(), other.outputConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDataAutomationStatusResponse").add("Status", statusAsString()).add("ErrorType", errorType())
                .add("ErrorMessage", errorMessage()).add("OutputConfiguration", outputConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "errorType":
            return Optional.ofNullable(clazz.cast(errorType()));
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "outputConfiguration":
            return Optional.ofNullable(clazz.cast(outputConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("status", STATUS_FIELD);
        map.put("errorType", ERROR_TYPE_FIELD);
        map.put("errorMessage", ERROR_MESSAGE_FIELD);
        map.put("outputConfiguration", OUTPUT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDataAutomationStatusResponse, T> g) {
        return obj -> g.apply((GetDataAutomationStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockDataAutomationRuntimeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDataAutomationStatusResponse> {
        /**
         * <p>
         * Job Status.
         * </p>
         * 
         * @param status
         *        Job Status.
         * @see AutomationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomationJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Job Status.
         * </p>
         * 
         * @param status
         *        Job Status.
         * @see AutomationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomationJobStatus
         */
        Builder status(AutomationJobStatus status);

        /**
         * <p>
         * Error Type.
         * </p>
         * 
         * @param errorType
         *        Error Type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorType(String errorType);

        /**
         * <p>
         * Error Message.
         * </p>
         * 
         * @param errorMessage
         *        Error Message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * Output configuration.
         * </p>
         * 
         * @param outputConfiguration
         *        Output configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConfiguration(OutputConfiguration outputConfiguration);

        /**
         * <p>
         * Output configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link OutputConfiguration.Builder} avoiding the
         * need to create one manually via {@link OutputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OutputConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #outputConfiguration(OutputConfiguration)}.
         * 
         * @param outputConfiguration
         *        a consumer that will call methods on {@link OutputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConfiguration(OutputConfiguration)
         */
        default Builder outputConfiguration(Consumer<OutputConfiguration.Builder> outputConfiguration) {
            return outputConfiguration(OutputConfiguration.builder().applyMutation(outputConfiguration).build());
        }
    }

    static final class BuilderImpl extends BedrockDataAutomationRuntimeResponse.BuilderImpl implements Builder {
        private String status;

        private String errorType;

        private String errorMessage;

        private OutputConfiguration outputConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataAutomationStatusResponse model) {
            super(model);
            status(model.status);
            errorType(model.errorType);
            errorMessage(model.errorMessage);
            outputConfiguration(model.outputConfiguration);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AutomationJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getErrorType() {
            return errorType;
        }

        public final void setErrorType(String errorType) {
            this.errorType = errorType;
        }

        @Override
        public final Builder errorType(String errorType) {
            this.errorType = errorType;
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final OutputConfiguration.Builder getOutputConfiguration() {
            return outputConfiguration != null ? outputConfiguration.toBuilder() : null;
        }

        public final void setOutputConfiguration(OutputConfiguration.BuilderImpl outputConfiguration) {
            this.outputConfiguration = outputConfiguration != null ? outputConfiguration.build() : null;
        }

        @Override
        public final Builder outputConfiguration(OutputConfiguration outputConfiguration) {
            this.outputConfiguration = outputConfiguration;
            return this;
        }

        @Override
        public GetDataAutomationStatusResponse build() {
            return new GetDataAutomationStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
